/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.management;

import com.sun.messaging.jmq.management.DefaultTrustManager;
import java.io.IOException;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class MQRMIClientSocketFactory
extends SslRMIClientSocketFactory {
    boolean debug = false;
    boolean isBrokerHostTrusted = true;
    boolean useSSL = false;
    String hostname = null;

    public MQRMIClientSocketFactory(String hostname, boolean isBrokerHostTrusted, boolean useSSL) {
        this.isBrokerHostTrusted = isBrokerHostTrusted;
        this.hostname = hostname;
        this.useSSL = useSSL;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket s = null;
        String socketHost = this.hostname;
        if (socketHost == null || socketHost.equals("*")) {
            socketHost = host;
        }
        try {
            s = this.useSSL ? this.makeSSLSocket(socketHost, port) : RMISocketFactory.getDefaultSocketFactory().createSocket(socketHost, port);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return s;
    }

    public String toString() {
        return "hostname=" + this.hostname + ",isBrokerHostTrusted=" + this.isBrokerHostTrusted + ",useSSL=" + this.useSSL;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MQRMIClientSocketFactory)) {
            return false;
        }
        MQRMIClientSocketFactory that = (MQRMIClientSocketFactory)obj;
        if (this.hostname != null ? that.hostname == null || !that.hostname.equals(this.hostname) : that.hostname != null) {
            return false;
        }
        if (this.isBrokerHostTrusted != that.isBrokerHostTrusted) {
            return false;
        }
        return this.useSSL == that.useSSL;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    private SSLSocket makeSSLSocket(String host, int port) throws Exception {
        SSLSocketFactory sslFactory;
        if (this.isBrokerHostTrusted) {
            sslFactory = this.getTrustSocketFactory();
            if (this.debug) {
                System.err.println("Broker is trusted ...");
            }
        } else {
            sslFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if (this.debug) {
            System.err.println("Create connection using SSL protocol ...");
            System.err.println("Broker Host: " + host);
            System.err.println("Broker Port: " + port);
        }
        Socket socket = sslFactory.createSocket(host, port);
        SSLSocket sslSocket = null;
        if (socket instanceof SSLSocket) {
            sslSocket = (SSLSocket)socket;
            boolean tcpNoDelay = true;
            String prop = System.getProperty("imqTcpNoDelay", "true");
            if (prop.equals("false")) {
                tcpNoDelay = false;
            } else {
                sslSocket.setTcpNoDelay(tcpNoDelay);
            }
        }
        return sslSocket;
    }

    private SSLSocketFactory getTrustSocketFactory() throws Exception {
        SSLSocketFactory factory = null;
        SSLContext ctx = SSLContext.getInstance("TLS");
        TrustManager[] tm = new TrustManager[]{new DefaultTrustManager()};
        ctx.init(null, tm, null);
        factory = ctx.getSocketFactory();
        return factory;
    }
}

