/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.implementation.sun.javaee;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.deliverable.PropertyNotSetException;
import com.sun.ts.lib.implementation.sun.javaee.RuntimeInfo;
import com.sun.ts.lib.implementation.sun.javaee.runtime.appclient.EjbRef;
import com.sun.ts.lib.implementation.sun.javaee.runtime.appclient.SunApplicationClient;
import com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.Ejb;
import com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.ServiceRef;
import com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.SunEjbJar;
import com.sun.ts.lib.implementation.sun.javaee.runtime.web.SunWebApp;
import com.sun.ts.lib.implementation.sun.javaee.runtime.web.WebserviceDescription;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.porting.TSDeploymentInterface2;
import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.DeploymentFacilityFactory;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SunRIDeployment2
implements TSDeploymentInterface2,
EntityResolver {
    private static final String RESOURCE_ADAPTER_POOL_NAME = "cts-connector-pool-";
    private static final String DB_SCHEMA_FILENAME_EXT = "dbschema";
    private static final String DB_SCHEMA_FILENAME = "CtsSchema.dbschema";
    private static final String SUN_APP_NAME = "sun-application.xml";
    private static final String SUN_CMP_MAPPING_FILE = "sun-cmp-mappings.xml";
    private static final String SUN_EJB_NAME = "sun-ejb-jar.xml";
    private static final String WINDOWS_ASADMIN_CMD = "cts-asadmin";
    private static String newLine = System.getProperty("line.separator", "\n");
    private static final String TARGET_PLACE_HOLDER = "---TARGET_PLACE_HOLDER---";
    protected PrintWriter Log = null;
    protected PropertyManagerInterface propMgr = null;
    protected Hashtable htJNDIRefs = null;
    private String sHarnessTempDir = null;
    private File dbSchemaFile;
    private static final int THREAD_TIMEOUT = 300000;
    private String asadminCmd;
    private String s1asUser;
    private String s1asPassword;
    private String s1asHost;
    private String s1asPort;
    private String s1asServer;
    private String[] s1asTargets;

    private String replaceTarget(String command, String target) {
        String result = command;
        int index = command.indexOf(TARGET_PLACE_HOLDER);
        if (index != -1) {
            result = command.replaceAll(TARGET_PLACE_HOLDER, target);
        }
        return result;
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "").toUpperCase().startsWith("WIN");
    }

    private void runCommand(String cmd) throws Exception {
        this.runCommand(cmd, "S1AS Admin Command => ", false);
    }

    private void runCommand(String cmd, String display) throws Exception {
        this.runCommand(cmd, display, false);
    }

    private void runCommand(String cmd, String display, boolean returnResults) throws Exception {
        for (int i = 0; i < this.s1asTargets.length; ++i) {
            this.runCommand0(this.replaceTarget(cmd, this.s1asTargets[i]), display, returnResults);
        }
    }

    private StringBuffer runCommand0(String cmd, String display, boolean returnResults) throws Exception {
        StringBuffer buf = new StringBuffer();
        try {
            Runtime rt = Runtime.getRuntime();
            TestUtil.logHarnessDebug((String)(display + cmd));
            if (this.isWindows()) {
                cmd = "cmd /c " + cmd;
            }
            Process proc = rt.exec(cmd);
            StreamWatcher errThread = new StreamWatcher(proc.getErrorStream());
            errThread.start();
            StreamWatcher outThread = new StreamWatcher(proc.getInputStream());
            outThread.start();
            int pstat = proc.waitFor();
            TestUtil.logHarnessDebug((String)("=>Proc status:" + pstat));
            errThread.join(300000L);
            outThread.join(300000L);
            buf = outThread.getBuffer();
            if (outThread.getBuffer().length() > 0) {
                TestUtil.logHarnessDebug((String)("Exec'ed Process \"" + cmd + "\" returned on stdout " + outThread.getBuffer()));
            }
            if (errThread.getBuffer().length() > 0) {
                TestUtil.logHarnessDebug((String)("Exec'ed Process \"" + cmd + "\" returned on stderr " + errThread.getBuffer()));
            }
            if (pstat != 0) {
                throw new Exception("runCommand failed, command was \"" + cmd + "\"");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return buf;
    }

    private String buildCommand(String command, String[] args) throws Exception {
        String ctsHome = this.propMgr.getProperty("ts.home");
        String binDir = this.propMgr.getProperty("bin.dir");
        String passwordFile = binDir + File.separator + "password.txt";
        StringBuffer cmd = new StringBuffer(100);
        cmd.append(this.asadminCmd).append(" ").append(command).append(" --user ").append(this.s1asUser).append(" --passwordfile ").append(passwordFile).append(" --host ").append(this.s1asHost).append(" --port ").append(this.s1asPort);
        if (!command.equals("reconfig")) {
            cmd.append(" --target ").append(TARGET_PLACE_HOLDER);
        }
        int numArgs = args == null ? 0 : args.length;
        for (int i = 0; i < numArgs; ++i) {
            cmd.append(" ").append(args[i]);
        }
        return cmd.toString();
    }

    private void reconfigAppServer() throws Exception {
        String server = this.propMgr.getProperty("s1as.server");
        String command = this.buildCommand("reconfig", new String[]{server});
        this.runCommand(command);
    }

    private String removeColonFromJNDI(String value) {
        String val = null;
        if (value.startsWith("java:")) {
            val = value.replaceFirst("java:", "");
        }
        return val;
    }

    private String getJndiName(String rarFilename, Properties p) throws Exception {
        String rarPropName = null;
        String jndiName = "";
        if (rarFilename.endsWith(".rar")) {
            rarPropName = rarFilename.substring(0, rarFilename.lastIndexOf(".rar"));
            jndiName = this.propMgr.getProperty(rarPropName);
            if (jndiName.indexOf("java:comp/env/") != -1) {
                jndiName = jndiName.substring("java:comp/env/".length());
            }
        } else if (rarFilename.equals("ejb_Deployment.ear") && (jndiName = this.propMgr.getProperty(rarPropName = "whitebox-embed")).indexOf("java:comp/env/") != -1) {
            jndiName = jndiName.substring("java:comp/env/".length());
        }
        return jndiName;
    }

    @Override
    public void init(PrintWriter out) {
        try {
            this.Log = out;
            TestUtil.logHarnessDebug((String)"SunRIDeployment2:  in init");
            this.propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            String ctsHome = this.propMgr.getProperty("ts.home");
            this.dbSchemaFile = new File(ctsHome + File.separator + "sql" + File.separator + DB_SCHEMA_FILENAME);
            this.asadminCmd = this.propMgr.getProperty("s1as.admin");
            if (this.isWindows()) {
                int index = this.asadminCmd.lastIndexOf(47);
                if (index == -1) {
                    index = this.asadminCmd.lastIndexOf(92);
                }
                String path = this.asadminCmd.substring(0, index);
                this.asadminCmd = path + File.separator + WINDOWS_ASADMIN_CMD;
            }
            this.s1asUser = this.propMgr.getProperty("s1as.admin.user");
            this.s1asPassword = this.propMgr.getProperty("s1as.admin.passwd");
            this.s1asHost = this.propMgr.getProperty("s1as.admin.host");
            this.s1asPort = this.propMgr.getProperty("s1as.admin.port");
            this.s1asServer = this.propMgr.getProperty("s1as.server");
            String targets = this.propMgr.getProperty("s1as.targets", this.s1asServer);
            if (targets.equals(this.s1asServer)) {
                this.s1asTargets = new String[1];
                this.s1asTargets[0] = this.s1asServer;
            } else {
                StringTokenizer tokens = new StringTokenizer(targets, " \t\n\r\f,");
                int index = 0;
                this.s1asTargets = new String[tokens.countTokens()];
                while (tokens.hasMoreTokens()) {
                    this.s1asTargets[index++] = tokens.nextToken();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.sHarnessTempDir = this.propMgr.getProperty("harness.temp.directory");
        }
        catch (PropertyNotSetException pe) {
            this.Log.print(pe.getMessage());
            this.Log.print("error looking up property:  harness.temp.directory");
            pe.printStackTrace();
        }
    }

    @Override
    public String getClientClassPath(TargetModuleID[] targetIDs, DeploymentInfo info, DeploymentManager manager) throws TSDeploymentException {
        File ctsDeployDir;
        String sAppName = null;
        String sEarFile = info.getEarFile();
        String sTSDeploymentDir = sEarFile.substring(0, sEarFile.lastIndexOf(File.separator) + 1) + "ts_dep";
        if (sEarFile.endsWith(".ear")) {
            sAppName = this.getAppNameFromApplicationXML(sEarFile);
        }
        if (sAppName == null) {
            sAppName = sEarFile.substring(sEarFile.lastIndexOf(File.separator) + 1, sEarFile.lastIndexOf("."));
        }
        if (sAppName.startsWith("vi_built_")) {
            sAppName = sAppName.substring(9);
            sTSDeploymentDir = sEarFile.substring(0, sEarFile.lastIndexOf(File.separator) + 1) + "ts_dep_vi_built";
        }
        if (!(ctsDeployDir = new File(sTSDeploymentDir)).exists() && !ctsDeployDir.mkdir()) {
            throw new TSDeploymentException("Failed to create the RI deployment working directory:  " + sTSDeploymentDir);
        }
        String sStubJar = sTSDeploymentDir;
        TestUtil.logHarnessDebug((String)("$$$$$$$$$$$ getClientClassPath() sStubJar = \"" + sStubJar + "\""));
        try {
            String sDeploymentHost = info.getProperty("deployment_host");
            String sPropNum = info.getProperty("deployment.props.number");
            String sUname = this.propMgr.getProperty("deployManageruname." + sPropNum);
            String sPassword = this.propMgr.getProperty("deployManagerpasswd." + sPropNum);
            int iPort = Integer.parseInt(this.propMgr.getProperty("webServerPort"));
            if (sPropNum.equals("2")) {
                iPort = Integer.parseInt(this.propMgr.getProperty("webServerPort.2"));
            }
            iPort = 4848;
            DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
            ServerConnectionIdentifier sci = new ServerConnectionIdentifier();
            sci.setHostName(sDeploymentHost);
            sci.setHostPort(iPort);
            sci.setUserName(sUname);
            sci.setPassword(sPassword);
            TestUtil.logHarness((String)("V3Deployment sPropNum = " + sPropNum));
            TestUtil.logHarness((String)("V3Deployment uname:  " + sUname));
            TestUtil.logHarness((String)("V3Deployment passwd:  " + sPassword));
            TestUtil.logHarness((String)("V3Deployment host:  " + sDeploymentHost));
            TestUtil.logHarness((String)("V3Deployment port:  " + iPort));
            df.connect(sci);
            df.getClientStubs(sTSDeploymentDir, sAppName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public Target[] getTargetsToUse(Target[] targets, DeploymentInfo info) {
        ArrayList<Target> filteredTargets = new ArrayList<Target>();
        for (int jj = 0; jj < this.s1asTargets.length; ++jj) {
            boolean foundit = false;
            for (int ii = 0; ii < targets.length; ++ii) {
                if (!this.s1asTargets[jj].equals(targets[ii].getName())) continue;
                filteredTargets.add(targets[ii]);
                TestUtil.logHarnessDebug((String)("$$$ Target Found \"" + targets[ii].getName() + "\""));
                foundit = true;
            }
            if (foundit) continue;
            TestUtil.logHarness((String)("**** ERROR, Target \"" + this.s1asTargets[jj] + "\" NOT Found ****"));
        }
        return filteredTargets.toArray(new Target[filteredTargets.size()]);
    }

    private int getInsertPoint(Element elm) {
        Element resourcePrincipal;
        int index = 0;
        Element jndiName = elm.getChild("jndi-name");
        if (jndiName != null) {
            ++index;
        }
        if ((resourcePrincipal = elm.getChild("default-resource-principal")) != null) {
            ++index;
        }
        List props = elm.getChildren("property");
        return index += props.size();
    }

    private void createElement(List elms, Element parent, String name, String value, int index) {
        Element child = parent.getChild(name);
        if (child == null) {
            child = new Element(name).setText(value);
            elms.add(index, child);
        } else {
            child.setText(value);
        }
    }

    private File writeTempXMLFile(Document doc, String filename) throws Exception {
        String path = this.propMgr.getProperty("harness.temp.directory") + File.separator + filename;
        File pathFile = new File(path);
        FileOutputStream out = new FileOutputStream(pathFile);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, (OutputStream)out);
        return pathFile;
    }

    private String getDBResource(Element elm) throws TSDeploymentException {
        try {
            String resResult = elm.getChildText("jndi-name");
            String resName = resResult.equals("jdbc/DBTimer") ? this.propMgr.getProperty("sjsas.cts.timer.resource") : this.propMgr.getProperty("sjsas.cmp.backend");
            return resName;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in getDBResource", (Throwable)e);
            throw new TSDeploymentException("Exception caught in getDBResource");
        }
    }

    private File addCMPCreationElements(File aFile) throws TSDeploymentException {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            builder.setEntityResolver((EntityResolver)this);
            Document doc = builder.build(aFile);
            Element cmpResource = doc.getRootElement().getChild("enterprise-beans").getChild("cmp-resource");
            if (cmpResource == null) {
                return this.writeTempXMLFile(doc, aFile.getName());
            }
            String dbName = this.getDBResource(cmpResource);
            int insertPoint = this.getInsertPoint(cmpResource);
            List children = cmpResource.getChildren();
            this.createElement(children, cmpResource, "create-tables-at-deploy", "true", insertPoint++);
            this.createElement(children, cmpResource, "drop-tables-at-undeploy", "true", insertPoint++);
            this.createElement(children, cmpResource, "database-vendor-name", dbName, insertPoint++);
            if (Boolean.getBoolean("USE_UNIQUE_TABLES")) {
                Element schemaResource = cmpResource.getChild("schema-generator-properties");
                if (schemaResource == null) {
                    schemaResource = new Element("schema-generator-properties");
                    children.add(insertPoint++, schemaResource);
                }
                Element propResource = new Element("property");
                propResource.addContent((Content)new Element("name").setText("use-unique-table-names"));
                propResource.addContent((Content)new Element("value").setText("true"));
                schemaResource.addContent((Content)propResource);
            }
            return this.writeTempXMLFile(doc, aFile.getName());
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error in addCMPCreationElements", (Throwable)e);
            throw new TSDeploymentException("Error in addCMPCreationElements processing file \"" + aFile + "\"");
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        String s1asHome = this.propMgr.getProperty("javaee.home.ri", "/sun/appserver8");
        String schemaDir = s1asHome + File.separator + "lib";
        String dtds = schemaDir + File.separator + "dtds";
        String schemas = schemaDir + File.separator + "schemas";
        TestUtil.logHarnessDebug((String)("systemId \"" + systemId + "\""));
        String schemaName = systemId.substring(systemId.lastIndexOf("/") + 1);
        String resultFile = null;
        if (schemaName.endsWith(".xsd")) {
            resultFile = schemas + File.separator + schemaName;
        } else if (schemaName.endsWith(".dtd")) {
            resultFile = dtds + File.separator + schemaName;
        } else {
            TestUtil.logHarness((String)("Error, system ID not a valid schema \"" + schemaName + "\""));
        }
        TestUtil.logHarnessDebug((String)("Entity Resolver returning \"" + resultFile + "\""));
        return new InputSource(resultFile);
    }

    @Override
    public Object getDeploymentPlan(DeploymentInfo info) throws TSDeploymentException {
        int numFiles;
        String sArchive = info.getEarFile();
        if (sArchive.endsWith(".rar")) {
            return null;
        }
        String[] sRunTimeFileArray = info.getRuntimeFiles();
        int n = numFiles = sRunTimeFileArray == null ? 0 : sRunTimeFileArray.length;
        if (numFiles == 0) {
            return null;
        }
        boolean standAlone = sArchive.endsWith(".war") || sArchive.endsWith(".jar");
        File tempFile = null;
        JarOutputStream out = null;
        try {
            String userName = System.getProperty("user.name");
            tempFile = File.createTempFile(userName + "-ts-deployment-plan", ".jar");
            out = new JarOutputStream(new FileOutputStream(tempFile));
        }
        catch (Exception e) {
            throw new TSDeploymentException("ERROR creating jar output stream for archive \"" + sArchive + "\"");
        }
        TestUtil.logHarnessDebug((String)("&&&& RUNTIME FILES " + Arrays.asList(sRunTimeFileArray) + "&&&&&"));
        File fInput = null;
        File aFile = null;
        try {
            boolean cmpAlreadyCreated = Boolean.valueOf(this.propMgr.getProperty("create.cmp.tables", "true"));
            for (int i = 0; i < numFiles; ++i) {
                aFile = new File(sRunTimeFileArray[i]);
                String jarEntryName = aFile.getName();
                if (jarEntryName.endsWith(".ear.sun-application.xml")) {
                    jarEntryName = SUN_APP_NAME;
                }
                if (jarEntryName.endsWith(".jar.sun-ejb-jar.xml") && !cmpAlreadyCreated) {
                    aFile = this.addCMPCreationElements(aFile);
                    this.addFileToJar(aFile, out, jarEntryName, standAlone);
                    try {
                        aFile.delete();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (jarEntryName.endsWith(SUN_CMP_MAPPING_FILE)) {
                    if (!cmpAlreadyCreated) continue;
                    String jarName = jarEntryName.substring(0, jarEntryName.indexOf(SUN_CMP_MAPPING_FILE));
                    String entryName = jarName + DB_SCHEMA_FILENAME;
                    this.addFileToJar(aFile, out, jarEntryName, standAlone);
                    this.addFileToJar(this.dbSchemaFile, out, entryName, standAlone);
                    TestUtil.logHarness((String)("$$$$$$ Found CMP mapping file for EJB \"" + sArchive + "\" adding DB schema file \"" + entryName + "\""));
                    continue;
                }
                this.addFileToJar(aFile, out, jarEntryName, standAlone);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TSDeploymentException("ERROR: reading runtime file \"" + aFile + "\" while processing archive \"" + sArchive + "\"");
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        try {
            fInput = tempFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TSDeploymentException("FileNotFoundException trying to open DeploymentPlan: \"" + tempFile + "\"");
        }
        return fInput;
    }

    private void addFileToJar(File aFile, JarOutputStream out, String jarEntryName) throws Exception {
        this.addFileToJar(aFile, out, jarEntryName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToJar(File aFile, JarOutputStream out, String jarEntryName, boolean standAlone) throws Exception {
        if (standAlone) {
            int index = jarEntryName.indexOf(".jar.");
            if (index == -1) {
                index = jarEntryName.indexOf(".war.");
            }
            if (index == -1) {
                index = -5;
            }
            jarEntryName = jarEntryName.substring(index + 5);
        }
        FileInputStream in = null;
        byte[] buf = new byte[1024];
        try {
            int len;
            in = new FileInputStream(aFile);
            out.putNextEntry(new JarEntry(jarEntryName));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private String removeRarExt(String rarName) {
        String result = rarName;
        int index = rarName.indexOf(".");
        if (index != -1) {
            result = rarName.substring(0, index);
        }
        TestUtil.logHarness((String)("######## Adjusted RAR Filename: [" + rarName + " -> " + result + "]"));
        return result;
    }

    @Override
    public void createConnectionFactory(TargetModuleID[] targetIDs, Properties p) throws TSDeploymentException {
    }

    @Override
    public void removeConnectionFactory(TargetModuleID[] targetIDs, Properties p) throws TSDeploymentException {
    }

    @Override
    public String getAppClientArgs(Properties p) {
        String sAppName = null;
        String executeArgs = p.getProperty("executeArgs");
        String sApp = p.getProperty("ear_file");
        String sClientname = p.getProperty("client_name");
        if (sApp.endsWith(".ear")) {
            sAppName = this.getAppNameFromApplicationXML(sApp);
        }
        String sTSDeploymentDir = sApp.substring(0, sApp.lastIndexOf(File.separator) + 1) + "ts_dep";
        if (sAppName == null && (sAppName = sApp.substring(sApp.lastIndexOf(File.separator) + 1, sApp.lastIndexOf("."))).startsWith("vi_built_")) {
            sAppName = sAppName.substring(9);
            sTSDeploymentDir = sApp.substring(0, sApp.lastIndexOf(File.separator) + 1) + "ts_dep_vi_built";
            sClientname = sClientname.substring(9);
        }
        sApp = sTSDeploymentDir + File.separator + sAppName + "Client.jar";
        executeArgs = executeArgs == null ? sApp + ",arg=-name,arg=" + sClientname + " -jar " + sApp : sApp + ",arg=-name,arg=" + sClientname + " -jar " + sApp + " " + executeArgs;
        return executeArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppNameFromApplicationXML(String archivePathAndName) {
        String appName = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(archivePathAndName);
            JarEntry appEntry = jarFile.getJarEntry("META-INF/application.xml");
            if (appEntry != null) {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(jarFile.getInputStream(appEntry));
                Element root = doc.getRootElement();
                appName = root.getChildTextNormalize("application-name", root.getNamespace());
            }
        }
        catch (Exception e) {
            TestUtil.logHarness((String)"Error parsing application.xml looking for application-name, returning null");
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        TestUtil.logHarness((String)("getAppNameFromApplicationXML() returning \"" + appName + "\""));
        return appName;
    }

    @Override
    public Hashtable getDependentValues(DeploymentInfo[] infoArray) {
        Hashtable htWsdlLocations = this.getInteropJNDINames(infoArray);
        if (TestUtil.harnessDebug) {
            for (int ii = 0; ii < infoArray.length; ++ii) {
                int i;
                List<Ejb> resources = infoArray[ii].getAppClientRuntimeDDs();
                for (i = 0; i < resources.size(); ++i) {
                    SunApplicationClient appResource = (SunApplicationClient)resources.get(i);
                    this.checkLocations(appResource.getServiceRef(), htWsdlLocations);
                }
                resources = infoArray[ii].getWebRuntimeDDs();
                for (i = 0; i < resources.size(); ++i) {
                    SunWebApp webResource = (SunWebApp)resources.get(i);
                    this.checkLocations(webResource.getServiceRef(), htWsdlLocations);
                    this.checkLocations(webResource.getWebserviceDescription(), htWsdlLocations);
                }
                List ejbJars = infoArray[ii].getEjbRuntimeDDs();
                for (int y = 0; y < ejbJars.size(); ++y) {
                    SunEjbJar ejbJar = (SunEjbJar)ejbJars.get(y);
                    this.checkLocations(ejbJar.getEnterpriseBeans().getWebserviceDescription(), htWsdlLocations);
                    resources = ejbJar.getEnterpriseBeans().getEjb();
                    for (int i2 = 0; i2 < resources.size(); ++i2) {
                        Ejb ejbResource = resources.get(i2);
                        this.checkLocations(ejbResource.getServiceRef(), htWsdlLocations);
                    }
                }
                if (!htWsdlLocations.isEmpty()) {
                    StringBuffer buf = new StringBuffer("***** Returning the following Hashtable from SunRIDeployment2.getDependentValues *****" + newLine);
                    buf.append("***********************************" + newLine);
                    Enumeration e = htWsdlLocations.keys();
                    while (e.hasMoreElements()) {
                        String sKey = (String)e.nextElement();
                        buf.append("Original value:  " + sKey + newLine);
                        buf.append("Modified value:  " + (String)htWsdlLocations.get(sKey) + newLine);
                    }
                    buf.append("***********************************");
                    TestUtil.logHarness((String)buf.toString());
                    continue;
                }
                TestUtil.logHarness((String)("***** Returning the following Hashtable from SunRIDeployment2.getDependentValues *****" + newLine + "Hashtable is empty."));
            }
        }
        return htWsdlLocations;
    }

    private void checkLocations(List resources, Hashtable htChanges) {
        block7: {
            Object o;
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if (resources == null || resources.isEmpty()) {
                                return;
                            }
                            o = resources.get(0);
                            if (!(o instanceof com.sun.ts.lib.implementation.sun.javaee.runtime.appclient.ServiceRef)) break block6;
                            for (int j = 0; j < resources.size(); ++j) {
                                com.sun.ts.lib.implementation.sun.javaee.runtime.appclient.ServiceRef ref = (com.sun.ts.lib.implementation.sun.javaee.runtime.appclient.ServiceRef)resources.get(j);
                                String newLocation = ref.getWsdlOverride();
                                htChanges.put(ref.getWsdlOverride(), newLocation);
                                TestUtil.logHarnessDebug((String)("******** original override \"" + ref.getWsdlOverride() + "\"   new override \"" + newLocation + "\""));
                            }
                            break block7;
                        }
                        if (!(o instanceof ServiceRef)) break block8;
                        for (int j = 0; j < resources.size(); ++j) {
                            ServiceRef ref = (ServiceRef)resources.get(j);
                            String newLocation = ref.getWsdlOverride();
                            htChanges.put(ref.getWsdlOverride(), newLocation);
                            TestUtil.logHarnessDebug((String)("******** original override \"" + ref.getWsdlOverride() + "\"   new override \"" + newLocation + "\""));
                        }
                        break block7;
                    }
                    if (!(o instanceof com.sun.ts.lib.implementation.sun.javaee.runtime.web.ServiceRef)) break block9;
                    for (int j = 0; j < resources.size(); ++j) {
                        com.sun.ts.lib.implementation.sun.javaee.runtime.web.ServiceRef ref = (com.sun.ts.lib.implementation.sun.javaee.runtime.web.ServiceRef)resources.get(j);
                        String newLocation = ref.getWsdlOverride();
                        htChanges.put(ref.getWsdlOverride(), newLocation);
                        TestUtil.logHarnessDebug((String)("******** original override \"" + ref.getWsdlOverride() + "\"   new override \"" + newLocation + "\""));
                    }
                    break block7;
                }
                if (!(o instanceof WebserviceDescription)) break block10;
                for (int j = 0; j < resources.size(); ++j) {
                    WebserviceDescription desc = (WebserviceDescription)resources.get(j);
                    String newLocation = desc.getWsdlPublishLocation();
                    htChanges.put(desc.getWsdlPublishLocation(), newLocation);
                    TestUtil.logHarnessDebug((String)("********\noriginal override" + desc.getWsdlPublishLocation() + ", new override" + newLocation));
                }
                break block7;
            }
            if (!(o instanceof com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.WebserviceDescription)) break block7;
            for (int j = 0; j < resources.size(); ++j) {
                com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.WebserviceDescription desc = (com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.WebserviceDescription)resources.get(j);
                String newLocation = desc.getWsdlPublishLocation();
                htChanges.put(desc.getWsdlPublishLocation(), newLocation);
                TestUtil.logHarnessDebug((String)("********\noriginal override" + desc.getWsdlPublishLocation() + ", new override" + newLocation));
            }
        }
    }

    protected String chooseValidStub(String earName, String clientcp) {
        if (clientcp == null) {
            return "";
        }
        int pos = earName.lastIndexOf(".ear");
        String earBaseName = null;
        earBaseName = pos != -1 ? earName.substring(0, pos) : earName;
        StringTokenizer st = new StringTokenizer(clientcp, File.pathSeparator);
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.lastIndexOf(earBaseName) == -1) continue;
            return token;
        }
        StringBuffer msgBuffer = new StringBuffer(600);
        msgBuffer.append("Could not choose a valid stub jar for ear: ").append(earName);
        msgBuffer.append(" from existing clientClasspath: ").append(clientcp);
        msgBuffer.append(". Will use the existing one.");
        TestUtil.logHarness((String)msgBuffer.toString());
        return clientcp;
    }

    public Hashtable getInteropJNDINames(DeploymentInfo[] infoArray) {
        this.htJNDIRefs = new Hashtable();
        StringBuffer buf = null;
        if (TestUtil.harnessDebug) {
            for (int ii = 0; ii < infoArray.length; ++ii) {
                Hashtable jndiChanges;
                int i;
                buf = new StringBuffer("**** ii=" + ii + " ********************************************" + newLine);
                buf.append("***************************************************************************************" + newLine);
                buf.append("***************************************************************************************" + newLine);
                buf.append(new RuntimeInfo().getRuntimeInfo(infoArray[ii]) + newLine);
                buf.append("***************************************************************************************" + newLine);
                buf.append("***************************************************************************************" + newLine);
                buf.append("***************************************************************************************" + newLine);
                TestUtil.logHarnessDebug((String)buf.toString());
                List<Ejb> resources = infoArray[ii].getAppClientRuntimeDDs();
                for (i = 0; i < resources.size(); ++i) {
                    SunApplicationClient appResource = (SunApplicationClient)resources.get(i);
                    jndiChanges = this.checkJNDINames(appResource.getEjbRef());
                    if (jndiChanges.isEmpty()) continue;
                    this.htJNDIRefs.putAll(jndiChanges);
                }
                resources = infoArray[ii].getWebRuntimeDDs();
                for (i = 0; i < resources.size(); ++i) {
                    SunWebApp webResource = (SunWebApp)resources.get(i);
                    jndiChanges = this.checkJNDINames(webResource.getEjbRef());
                    if (jndiChanges.isEmpty()) continue;
                    this.htJNDIRefs.putAll(jndiChanges);
                }
                List ejbJars = infoArray[ii].getEjbRuntimeDDs();
                for (int y = 0; y < ejbJars.size(); ++y) {
                    SunEjbJar ejbJar = (SunEjbJar)ejbJars.get(y);
                    resources = ejbJar.getEnterpriseBeans().getEjb();
                    for (int i2 = 0; i2 < resources.size(); ++i2) {
                        Ejb ejbResource = resources.get(i2);
                        Hashtable jndiChanges2 = this.checkJNDINames(ejbResource.getEjbRef());
                        if (jndiChanges2.isEmpty()) continue;
                        this.htJNDIRefs.putAll(jndiChanges2);
                    }
                }
            }
        }
        buf = new StringBuffer("***** Returning the following Hashtable from SunRIDeployment.getInteropJNDINames *****" + newLine);
        buf.append("***************************************************************************************" + newLine);
        Enumeration e = this.htJNDIRefs.keys();
        while (e.hasMoreElements()) {
            String sKey = (String)e.nextElement();
            buf.append("Original value:  " + sKey + newLine);
            buf.append("Modified value:  " + (String)this.htJNDIRefs.get(sKey) + newLine);
        }
        buf.append("***************************************************************************************" + newLine);
        TestUtil.logHarnessDebug((String)buf.toString());
        return this.htJNDIRefs;
    }

    private void addJNDIName(String jndiName, Hashtable jndiChanges) {
        if (jndiName.startsWith("corbaname")) {
            int endPos = jndiName.lastIndexOf("#");
            String newJNDI = jndiName.substring(0, endPos) + "#" + jndiName.substring(endPos + 1);
            jndiChanges.put(jndiName, newJNDI);
            TestUtil.logHarnessDebug((String)("******** old JNDI name \"" + jndiName + "\", new JNDI name \"" + newJNDI + "\""));
        }
    }

    private Hashtable checkJNDINames(List ejbRefs) {
        Hashtable jndiChanges;
        block5: {
            Object o;
            block6: {
                block4: {
                    jndiChanges = new Hashtable();
                    if (ejbRefs == null || ejbRefs.size() == 0) {
                        return jndiChanges;
                    }
                    o = ejbRefs.get(0);
                    if (!(o instanceof com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.EjbRef)) break block4;
                    for (int j = 0; j < ejbRefs.size(); ++j) {
                        com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.EjbRef ref = (com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.EjbRef)ejbRefs.get(j);
                        String jndiName = ref.getJndiName();
                        this.addJNDIName(jndiName, jndiChanges);
                    }
                    break block5;
                }
                if (!(o instanceof com.sun.ts.lib.implementation.sun.javaee.runtime.web.EjbRef)) break block6;
                for (int j = 0; j < ejbRefs.size(); ++j) {
                    com.sun.ts.lib.implementation.sun.javaee.runtime.web.EjbRef ref = (com.sun.ts.lib.implementation.sun.javaee.runtime.web.EjbRef)ejbRefs.get(j);
                    String jndiName = ref.getJndiName();
                    this.addJNDIName(jndiName, jndiChanges);
                }
                break block5;
            }
            if (!(o instanceof EjbRef)) break block5;
            for (int j = 0; j < ejbRefs.size(); ++j) {
                EjbRef ref = (EjbRef)ejbRefs.get(j);
                String jndiName = ref.getJndiName();
                this.addJNDIName(jndiName, jndiChanges);
            }
        }
        return jndiChanges;
    }

    @Override
    public void postDistribute(ProgressObject po) {
        TestUtil.logHarnessDebug((String)"***** SunRIDeployment2.postDistribute()");
    }

    @Override
    public void postStart(ProgressObject po) {
        TestUtil.logHarnessDebug((String)"***** SunRIDeployment2.postStart()");
    }

    @Override
    public void postStop(ProgressObject po) {
        TestUtil.logHarnessDebug((String)"***** SunRIDeployment2.postStop()");
    }

    @Override
    public void postUndeploy(ProgressObject po) {
        TestUtil.logHarnessDebug((String)"***** SunRIDeployment2.postUndeploy()");
    }

    class StreamWatcher
    extends Thread {
        private StringBuffer buf = new StringBuffer();
        private InputStream in;

        public StreamWatcher(InputStream in) {
            this.in = in;
        }

        public StringBuffer getBuffer() {
            return this.buf;
        }

        @Override
        public void run() {
            BufferedReader breader = null;
            try {
                breader = new BufferedReader(new InputStreamReader(this.in));
                String line = breader.readLine();
                while (line != null) {
                    this.buf.append(line);
                    line = breader.readLine();
                }
            }
            catch (Exception e) {
                TestUtil.logHarness((String)("StreamWatcher error is " + e));
            }
            finally {
                try {
                    this.in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

