/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.message;

import com.sun.xml.security.core.dsig.KeyInfoType;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.message.jaxb.JAXBHeader;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.api.reference.DirectReference;
import com.sun.xml.ws.security.opt.api.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.api.reference.Reference;
import com.sun.xml.ws.security.opt.crypto.StreamWriterData;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.attachment.AttachmentSetImpl;
import com.sun.xml.ws.security.opt.impl.attachment.EncryptedAttachment;
import com.sun.xml.ws.security.opt.impl.crypto.JAXBDataImpl;
import com.sun.xml.ws.security.opt.impl.crypto.SSBData;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.crypto.StreamHeaderData;
import com.sun.xml.ws.security.opt.impl.dsig.SignedMessageHeader;
import com.sun.xml.ws.security.opt.impl.message.EncryptedSignedMessageHeader;
import com.sun.xml.ws.security.opt.impl.message.Header;
import com.sun.xml.ws.security.opt.impl.message.SOAPBody;
import com.sun.xml.ws.security.opt.impl.message.SecuredMessage;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.ws.security.opt.impl.util.WSSNSPrefixWrapper;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.logging.impl.crypto.LogStringsMessages;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.namespace.QName;

public class ETHandler {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    private WSSElementFactory wsf = null;
    private HashMap props = new HashMap();

    public ETHandler(SOAPVersion soapVersion) {
        this.wsf = new WSSElementFactory(soapVersion);
        if (soapVersion == SOAPVersion.SOAP_11) {
            this.props.put("com.sun.xml.bind.namespacePrefixMapper", new WSSNSPrefixWrapper(JAXBUtil.prefixMapper11));
        } else {
            this.props.put("com.sun.xml.bind.namespacePrefixMapper", new WSSNSPrefixWrapper(JAXBUtil.prefixMapper12));
        }
    }

    public List buildEDList(EncryptionPolicy policy, Target target, JAXBFilterProcessingContext context, Key key, KeyInfo ki) throws XWSSecurityException {
        SecuredMessage message = context.getSecuredMessage();
        ArrayList<SecurityHeaderElement> edList = new ArrayList<SecurityHeaderElement>();
        if (target.getType() == "qname") {
            QName name = target.getQName();
            if (name == Target.BODY_QNAME) {
                Object obj = message.getBody();
                String dataEncAlg = SecurityUtil.getDataEncryptionAlgo(context);
                if (dataEncAlg.length() == 0 && context.getAlgorithmSuite() != null) {
                    dataEncAlg = context.getAlgorithmSuite().getEncryptionAlgorithm();
                }
                StreamWriterData data = null;
                if (obj instanceof SOAPBody) {
                    data = new SSBData((SOAPBody)obj, true, context.getNamespaceContext());
                    SecurityHeaderElement ed = (SecurityHeaderElement)((Object)this.wsf.createEncryptedData(context.generateID(), data, dataEncAlg, (KeyInfoType)ki, key, true));
                    edList.add(ed);
                    SOAPBody sb = (SOAPBody)message.getBody();
                    SOAPBody nsb = new SOAPBody(ed, context.getSOAPVersion());
                    nsb.setId(sb.getId());
                    message.replaceBody(nsb);
                } else if (obj instanceof SecurityElement) {
                    data = new SSEData((SecurityElement)obj, true, context.getNamespaceContext(), this.props);
                    SecurityHeaderElement ed = (SecurityHeaderElement)((Object)this.wsf.createEncryptedData(context.generateID(), data, dataEncAlg, (KeyInfoType)ki, key, true));
                    edList.add(ed);
                    SOAPBody nsb = new SOAPBody(ed, context.getSOAPVersion());
                    nsb.setId(((SecurityElement)obj).getId());
                    message.replaceBody(nsb);
                }
                return edList;
            }
            Iterator headers = null;
            if (name.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") || name.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) {
                if (!"".equals(name.getLocalPart())) {
                    headers = message.getHeaders(name.getLocalPart(), null);
                } else {
                    headers = message.getHeaders("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                    if (!headers.hasNext()) {
                        headers = message.getHeaders("http://www.w3.org/2005/08/addressing");
                    }
                }
            } else {
                headers = !"".equals(name.getLocalPart()) ? message.getHeaders(name.getLocalPart(), name.getNamespaceURI()) : message.getHeaders(name.getNamespaceURI());
            }
            while (headers.hasNext()) {
                Object header = headers.next();
                SecurityHeaderElement ed = this.toMessageHeader(policy, target, context, key, header, ki, true);
                edList.add(ed);
            }
            if (!edList.isEmpty()) {
                return edList;
            }
            SecurityHeader sh = context.getSecurityHeader();
            Iterator itr = sh.getHeaders(name.getLocalPart(), name.getNamespaceURI());
            while (itr.hasNext()) {
                SecurityHeaderElement hdr2 = (SecurityHeaderElement)itr.next();
                if (hdr2 == null) continue;
                SecurityHeaderElement ed = this.toMessageHeader(policy, target, context, key, hdr2, ki, false);
                edList.add(ed);
            }
            return edList;
        }
        if (target.getType() == "uri") {
            if ("cid:*".equals(target.getValue())) {
                this.handleAttachments(context, edList, key, ki, target);
            } else {
                SecurityHeaderElement se = this.handleURI(policy, target, context, key, ki);
                edList.add(se);
            }
            return edList;
        }
        throw new UnsupportedOperationException("Target Type " + target.getType() + " is not supported by EncryptionProcessor");
    }

    protected SecurityHeaderElement handleURI(EncryptionPolicy policy, Target target, JAXBFilterProcessingContext context, Key key, KeyInfo ki) throws XWSSecurityException {
        String dataEncAlg = SecurityUtil.getDataEncryptionAlgo(context);
        boolean contentOnly = target.getContentOnly();
        Object header = context.getSecurityHeader().getChildElement(target.getValue());
        if (header != null) {
            if (header instanceof SecurityTokenReference) {
                SecurityTokenReference str = (SecurityTokenReference)header;
                Reference reference = str.getReference();
                String refValue = null;
                if ("Identifier".equals(reference.getType())) {
                    refValue = ((KeyIdentifier)reference).getReferenceValue();
                } else if ("Direct".equals(reference.getType())) {
                    refValue = ((DirectReference)reference).getURI();
                }
                if (refValue != null) {
                    if (refValue.startsWith("#")) {
                        refValue = refValue.substring(1);
                    }
                    header = context.getSecurityHeader().getChildElement(refValue);
                }
            }
            Data data = this.toData(header, contentOnly, context);
            SecurityHeaderElement ed = (SecurityHeaderElement)((Object)this.wsf.createEncryptedData(context.generateID(), data, dataEncAlg, (KeyInfoType)ki, key, target.getContentOnly()));
            context.getSecurityHeader().replace((SecurityHeaderElement)header, ed);
            return ed;
        }
        header = context.getSecuredMessage().getHeader(target.getValue());
        return this.toMessageHeader(policy, target, context, key, header, ki, true);
    }

    protected SecurityHeaderElement toMessageHeader(EncryptionPolicy policy, Target target, JAXBFilterProcessingContext context, Key key, Object header, KeyInfo ki, boolean isEncryptedHeaders) throws XWSSecurityException {
        SecuredMessage message = context.getSecuredMessage();
        String dataEncAlg = SecurityUtil.getDataEncryptionAlgo(context);
        boolean contentOnly = target.getContentOnly();
        boolean encHeaderContent = context.getEncHeaderContent();
        if (encHeaderContent && !"true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"))) {
            contentOnly = true;
        }
        Data data = this.toData(header, contentOnly, context);
        SecurityHeaderElement ed = null;
        if (contentOnly) {
            ed = (SecurityHeaderElement)((Object)this.wsf.createEncryptedData(context.generateID(), data, dataEncAlg, (KeyInfoType)ki, key, contentOnly));
            if (header instanceof Header) {
                throw new XWSSecurityException("Implementation does not support encrypting content which is already encrypted ");
            }
            if (header instanceof SignedMessageHeader) {
                EncryptedSignedMessageHeader encHdr = new EncryptedSignedMessageHeader((SignedMessageHeader)header, ed);
                message.replaceHeader(header, encHdr);
            } else {
                Header hdr2 = new Header((com.sun.xml.ws.api.message.Header)header, ed);
                message.replaceHeader(header, hdr2);
            }
        } else {
            if (isEncryptedHeaders && "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"))) {
                ed = this.wsf.createEncryptedHeader(context.generateID(), context.generateID(), data, dataEncAlg, ki, key, contentOnly);
                ((NamespaceContextEx)context.getNamespaceContext()).addWSS11NS();
            } else {
                ed = (SecurityHeaderElement)((Object)this.wsf.createEncryptedData(context.generateID(), data, dataEncAlg, (KeyInfoType)ki, key, contentOnly));
            }
            if (!message.replaceHeader(header, ed)) {
                context.getSecurityHeader().replace((SecurityHeaderElement)header, ed);
            }
        }
        return ed;
    }

    protected Data toData(Object header, boolean contentOnly, JAXBFilterProcessingContext context) throws XWSSecurityException {
        if (header instanceof SecurityElement) {
            return new SSEData((SecurityElement)header, contentOnly, context.getNamespaceContext(), this.props);
        }
        if (header instanceof JAXBHeader) {
            return new JAXBDataImpl((com.sun.xml.ws.api.message.Header)header, contentOnly, context.getNamespaceContext(), JAXBUtil.getSEIJAXBContext());
        }
        if (header instanceof com.sun.xml.ws.api.message.Header) {
            return new StreamHeaderData((com.sun.xml.ws.api.message.Header)header, contentOnly, context.getNamespaceContext());
        }
        throw new XWSSecurityException("Unsupported Header type");
    }

    private void handleAttachments(JAXBFilterProcessingContext context, ArrayList edList, Key key, KeyInfo ki, Target target) throws XWSSecurityException {
        SecuredMessage message = context.getSecuredMessage();
        AttachmentSet as = message.getAttachments();
        if (as != null && as.isEmpty()) {
            logger.log(Level.WARNING, LogStringsMessages.WSS_1244_NO_ATTACHMENT_FOUND());
            return;
        }
        String dataEncAlg = SecurityUtil.getDataEncryptionAlgo(context);
        AttachmentSetImpl newAttachmentSet = new AttachmentSetImpl();
        for (Attachment attachment : as) {
            SecurityHeaderElement ed = (SecurityHeaderElement)((Object)this.wsf.createEncryptedData(context.generateID(), attachment, dataEncAlg, (KeyInfoType)ki, key, (EncryptionTarget)target));
            context.getSecurityHeader().add(ed);
            edList.add(ed);
            EncryptedAttachment encryptedAttachment = new EncryptedAttachment(attachment, dataEncAlg, key);
            newAttachmentSet.add(encryptedAttachment);
        }
        message.setAttachments(newAttachmentSet);
    }
}

