/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.DBschemaDataObject;
import org.netbeans.modules.dbschema.nodes.DBElementNodeFactory;
import org.netbeans.modules.dbschema.nodes.SchemaElementFilter;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SchemaRootChildren
extends Children.Keys {
    static final Object NOT_KEY = new Object();
    static final Object ERROR_KEY = new Object();
    protected SchemaElement element;
    protected DBElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private DBElementListener propL;
    private boolean nodesInited = false;
    private boolean parseStatus = false;
    private final Object parseLock = new Object();
    private DBschemaDataObject obj;
    private RequestProcessor RP = new RequestProcessor(SchemaRootChildren.class);

    public SchemaRootChildren(DBElementNodeFactory factory, DBschemaDataObject obj) {
        this.factory = factory;
        this.obj = obj;
    }

    @Override
    protected void addNotify() {
        SchemaElement el = this.getElement();
        if (el != null) {
            if (this.wPropL == null) {
                this.propL = new DBElementListener();
                this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)el);
            }
            el.addPropertyChangeListener(this.wPropL);
        }
        this.refreshKeys();
    }

    @Override
    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof SchemaElement) {
            return new Node[]{this.factory.createSchemaNode((SchemaElement)key)};
        }
        if (NOT_KEY.equals(key)) {
            return new Node[]{this.factory.createWaitNode()};
        }
        Logger.getLogger("global").log(Level.INFO, null, new Exception("DbSchema: Error node created for object " + key + " (class " + (key == null ? "null" : key.getClass().getName()) + ")"));
        return new Node[]{this.factory.createErrorNode()};
    }

    public SchemaElement getElement() {
        if (this.element == null && !this.parseStatus) {
            this.refreshKeys2();
            this.RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = SchemaRootChildren.this.parseLock;
                    synchronized (object) {
                        if (!SchemaRootChildren.this.parseStatus) {
                            SchemaRootChildren.this.nodesInited = true;
                            SchemaRootChildren.this.setElement(SchemaRootChildren.this.obj.getSchema());
                            SchemaRootChildren.this.parseStatus = true;
                        }
                    }
                }
            }, 0);
        }
        return this.element;
    }

    public void setElement(SchemaElement element) {
        if (this.element != null) {
            this.element.removePropertyChangeListener(this.wPropL);
        }
        this.element = element;
        if (this.element != null) {
            if (this.wPropL == null) {
                this.propL = new DBElementListener();
                this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
            } else {
                this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
            }
            this.element.addPropertyChangeListener(this.wPropL);
        }
        if (this.nodesInited) {
            this.refreshKeys();
        }
    }

    public void refreshKeys() {
        SchemaElement el = this.getElement();
        int status = this.parseStatus ? (el == null ? 1 : el.getStatus()) : (el == null ? 0 : el.getStatus());
        switch (status) {
            case 0: {
                this.setKeys(new Object[]{NOT_KEY});
                break;
            }
            case 1: {
                this.setKeys(new Object[]{ERROR_KEY});
                break;
            }
            case 2: 
            case 3: {
                this.refreshAllKeys();
            }
        }
    }

    private void refreshKeys2() {
        this.setKeys(new Object[]{NOT_KEY});
    }

    private void refreshAllKeys() {
        int[] order = SchemaElementFilter.DEFAULT_ORDER;
        final LinkedList keys = new LinkedList();
        for (int i = 0; i < order.length; ++i) {
            this.addKeysOfType(keys, order[i]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SchemaRootChildren.this.setKeys2(Collections.EMPTY_SET);
                SchemaRootChildren.this.setKeys2(keys);
            }
        });
    }

    private void addKeysOfType(Collection keys, int elementType) {
        SchemaElement schemaElement = this.getElement();
        if (elementType != 0) {
            keys.add(schemaElement);
        }
    }

    private void setKeys2(Collection c) {
        this.setKeys(c);
    }

    private final class DBElementListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean refresh = "schema".equals(evt.getPropertyName());
            if (!refresh && "status".equals(evt.getPropertyName())) {
                Integer val = (Integer)evt.getNewValue();
                boolean bl = refresh = val == null || val != 0;
            }
            if (refresh) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SchemaRootChildren.this.refreshKeys();
                    }
                });
            }
        }
    }
}

