/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator.client;

import com.sun.appserv.server.util.Version;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.client.ClientClassWriter;
import org.glassfish.admin.rest.generator.client.ClientGenerator;
import org.glassfish.admin.rest.generator.client.PythonClientClassWriter;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigModel;

public class PythonClientGenerator
extends ClientGenerator {
    private File baseDirectory = Util.createTempDirectory();
    private static String MSG_INSTALL = "To install the egg into your Python environment:  sudo easy_install rest-client-wrapper-VERSION-egg.zip";

    public PythonClientGenerator(ServiceLocator habitat) {
        super(habitat);
        this.messages.add(MSG_INSTALL.replace("VERSION", this.versionString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, URI> getArtifact() {
        ZipOutputStream zip = null;
        HashMap<String, URI> artifacts = new HashMap<String, URI>();
        try {
            String ZIP_BASE_DIR = "glassfish-rest-client-VERSION".replace("VERSION", Version.getVersionNumber());
            String ZIP_GF_PACKAGE_DIR = ZIP_BASE_DIR + "/glassfish";
            String ZIP_REST_PACKAGE_DIR = ZIP_GF_PACKAGE_DIR + "/rest";
            File zipDir = Util.createTempDirectory();
            File zipFile = new File(zipDir, "rest-client-wrapper-" + this.versionString + "-egg.zip");
            if (!zipFile.createNewFile()) {
                throw new RuntimeException("Unable to create new file");
            }
            zipFile.deleteOnExit();
            zip = new ZipOutputStream(new FileOutputStream(zipFile));
            this.add(ZIP_GF_PACKAGE_DIR, "__init__.py", new ByteArrayInputStream("".getBytes()), zip);
            this.add(ZIP_BASE_DIR, "setup.py", new ByteArrayInputStream(this.getFileContents("setup.py").getBytes()), zip);
            this.addFileFromClasspath(ZIP_REST_PACKAGE_DIR, "__init__.py", zip);
            this.addFileFromClasspath(ZIP_REST_PACKAGE_DIR, "connection.py", zip);
            this.addFileFromClasspath(ZIP_REST_PACKAGE_DIR, "restclient.py", zip);
            this.addFileFromClasspath(ZIP_REST_PACKAGE_DIR, "restresponse.py", zip);
            this.addFileFromClasspath(ZIP_REST_PACKAGE_DIR, "restclientbase.py", zip);
            File[] files = this.baseDirectory.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.add(ZIP_REST_PACKAGE_DIR, file, zip);
                }
            }
            artifacts.put(zipFile.getName(), zipFile.toURI());
            Util.deleteDirectory(this.baseDirectory);
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return artifacts;
    }

    @Override
    public ClientClassWriter getClassWriter(ConfigModel model, String className, Class parent) {
        return new PythonClientClassWriter(model, className, parent, this.baseDirectory);
    }

    private String getFileContents(String fileName) {
        String contents = new Scanner(this.getClass().getClassLoader().getResourceAsStream("/client/python/" + fileName)).useDelimiter("\\Z").next();
        return contents.replace("VERSION", Version.getVersionNumber());
    }

    private void addFileFromClasspath(String targetDir, String fileName, ZipOutputStream zip) throws IOException {
        this.add(targetDir, fileName, this.getClass().getClassLoader().getResourceAsStream("/client/python/" + fileName), zip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String dirInZip, String nameInZip, InputStream source, ZipOutputStream target) throws IOException {
        try {
            int count;
            String sourcePath = dirInZip + "/" + nameInZip;
            ZipEntry entry = new ZipEntry(sourcePath);
            target.putNextEntry(entry);
            byte[] buffer = new byte[1024];
            while ((count = source.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
    }

    private void add(String dirInZip, File source, ZipOutputStream target) throws IOException {
        this.add(dirInZip, source.getName(), new BufferedInputStream(new FileInputStream(source)), target);
    }
}

