/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.helper;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.RankingComparator;
import org.apache.felix.cm.impl.helper.ConfigurationMap;
import org.apache.felix.cm.impl.helper.TargetedPID;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseTracker<S>
extends ServiceTracker<S, ConfigurationMap<?>> {
    protected final ConfigurationManager cm;
    private final boolean managedServiceFactory;

    protected BaseTracker(ConfigurationManager cm, boolean managedServiceFactory) {
        super(cm.getBundleContext(), managedServiceFactory ? ManagedServiceFactory.class.getName() : ManagedService.class.getName(), null);
        this.cm = cm;
        this.managedServiceFactory = managedServiceFactory;
        this.open();
    }

    @Override
    public ConfigurationMap<?> addingService(ServiceReference<S> reference) {
        this.cm.log(4, "Registering service {0}", new String[]{ConfigurationManager.toString(reference)});
        String[] pids = BaseTracker.getServicePid(reference);
        ConfigurationMap<?> configurations = this.createConfigurationMap(pids);
        this.configure(reference, pids, configurations);
        return configurations;
    }

    @Override
    public void modifiedService(ServiceReference<S> reference, ConfigurationMap<?> service) {
        this.cm.log(4, "Modified service {0}", new String[]{ConfigurationManager.toString(reference)});
        String[] pids = BaseTracker.getServicePid(reference);
        if (service.isDifferentPids(pids)) {
            service.setConfiguredPids(pids);
            this.configure(reference, pids, service);
        }
    }

    @Override
    public void removedService(ServiceReference<S> reference, ConfigurationMap<?> service) {
        this.cm.log(4, "Unregistering service {0}", new String[]{ConfigurationManager.toString(reference)});
    }

    private void configure(ServiceReference<S> reference, String[] pids, ConfigurationMap<?> configurations) {
        if (pids != null) {
            this.cm.configure(pids, reference, this.managedServiceFactory, configurations);
        }
    }

    public final List<ServiceReference<S>> getServices(TargetedPID pid) {
        ServiceReference<S>[] refs = this.getServiceReferences();
        if (refs != null) {
            ArrayList<ServiceReference<S>> result = new ArrayList<ServiceReference<S>>(refs.length);
            for (ServiceReference ref : refs) {
                ConfigurationMap map = (ConfigurationMap)this.getService(ref);
                if (map == null || !map.accepts(pid.getRawPid()) && (!map.accepts(pid.getServicePid()) || !pid.matchesTarget(ref))) continue;
                result.add(ref);
            }
            if (result.size() > 1) {
                Collections.sort(result, RankingComparator.SRV_RANKING);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected abstract ConfigurationMap<?> createConfigurationMap(String[] var1);

    public abstract String getServicePid(ServiceReference<S> var1, TargetedPID var2);

    public abstract void provideConfiguration(ServiceReference<S> var1, TargetedPID var2, TargetedPID var3, Dictionary<String, ?> var4, long var5, ConfigurationMap<?> var7);

    public abstract void removeConfiguration(ServiceReference<S> var1, TargetedPID var2, TargetedPID var3);

    protected final S getRealService(ServiceReference<S> reference) {
        return (S)this.context.getService(reference);
    }

    protected final void ungetRealService(ServiceReference<S> reference) {
        this.context.ungetService(reference);
    }

    protected final Dictionary getProperties(Dictionary<String, ?> rawProperties, ServiceReference service, String configPid, String factoryPid) {
        CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(rawProperties);
        this.cm.callPlugins(props, service, configPid, factoryPid);
        return props;
    }

    protected final void handleCallBackError(Throwable error, ServiceReference target, TargetedPID pid) {
        if (error instanceof ConfigurationException) {
            ConfigurationException ce = (ConfigurationException)error;
            if (ce.getProperty() != null) {
                this.cm.log(1, "{0}: Updating property {1} of configuration {2} caused a problem: {3}", new Object[]{ConfigurationManager.toString(target), ce.getProperty(), pid, ce.getReason(), ce});
            } else {
                this.cm.log(1, "{0}: Updating configuration {1} caused a problem: {2}", new Object[]{ConfigurationManager.toString(target), pid, ce.getReason(), ce});
            }
        } else {
            this.cm.log(1, "{0}: Unexpected problem updating configuration {1}", new Object[]{ConfigurationManager.toString(target), pid, error});
        }
    }

    private static String[] getServicePid(ServiceReference reference) {
        Object pidObj = reference.getProperty("service.pid");
        if (pidObj instanceof String) {
            return new String[]{(String)pidObj};
        }
        if (pidObj instanceof String[]) {
            return (String[])pidObj;
        }
        if (pidObj instanceof Collection) {
            Collection pidCollection = (Collection)pidObj;
            return pidCollection.toArray(new String[pidCollection.size()]);
        }
        return null;
    }

    AccessControlContext getAccessControlContext(Bundle bundle) {
        return new AccessControlContext(AccessController.getContext(), new CMDomainCombiner(bundle));
    }

    private static class CMProtectionDomain
    extends ProtectionDomain {
        private final Bundle bundle;

        CMProtectionDomain(Bundle bundle) {
            super(null, null);
            this.bundle = bundle;
        }

        @Override
        public boolean implies(Permission permission) {
            try {
                return this.bundle.hasPermission((Object)permission);
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
    }

    private static class CMDomainCombiner
    implements DomainCombiner {
        private final Bundle bundle;

        CMDomainCombiner(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public ProtectionDomain[] combine(ProtectionDomain[] arg0, ProtectionDomain[] arg1) {
            return new ProtectionDomain[]{new CMProtectionDomain(this.bundle)};
        }
    }
}

