/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.language;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Country;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Client2
extends Util {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest2() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute findAllCustomers");
            List result = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer AS c").getResultList();
            String[] expectedPKs = new String[this.customerRef.length];
            for (int i = 0; i < this.customerRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + this.customerRef.length + " references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest2 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest4() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"3");
            this.logTrace("find Customer with Home Address in Swansea");
            Query q = this.getEntityManager().createQuery("SELECT c from Customer c WHERE c.home.street = :street AND c.home.city = :city AND c.home.state = :state and c.home.zip = :zip").setParameter("street", (Object)"125 Moxy Lane").setParameter("city", (Object)"Swansea").setParameter("state", (Object)"MA").setParameter("zip", (Object)"11345");
            Customer c = (Customer)q.getSingleResult();
            if (expected == c) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest4 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest6() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find Customers with Home Address Information");
            List c = this.getEntityManager().createQuery("SELECT DISTINCT c from Customer c WHERE c.home.street = :street OR c.home.city = :city OR c.home.state = :state or c.home.zip = :zip").setParameter("street", (Object)"47 Skyline Drive").setParameter("city", (Object)"Chelmsford").setParameter("state", (Object)"VT").setParameter("zip", (Object)"02155").getResultList();
            String[] expectedPKs = new String[]{"1", "10", "11", "13"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 4 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest6 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest15() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"5");
            this.logTrace("find customer with name: Stephen S. D'Milla");
            Query q = this.getEntityManager().createQuery("sElEcT c FROM Customer c Where c.name = :cName").setParameter("cName", (Object)"Stephen S. D'Milla");
            Customer c = (Customer)q.getSingleResult();
            if (expected == c) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest15 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest16() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers IN home city: Lexington");
            List c = this.getEntityManager().createQuery("select distinct c FROM Customer c WHERE c.home.city IN ('Lexington')").getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest16 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest17() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers NOT IN home city: Swansea or Brookline");
            List c = this.getEntityManager().createQuery("SELECT DISTINCT Object(c) FROM Customer c Left Outer Join c.home h WHERE  h.city Not iN ('Swansea', 'Brookline')").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6", "7", "8", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest17 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest18() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers with home ZIP CODE that ends in 77");
            List c = this.getEntityManager().createQuery("select distinct Object(c) FROM Customer c WHERE c.home.zip LIKE '%77'").getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest18 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest19() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers with a home zip code that does not contain 44 in the third and fourth position");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c WHERE c.home.zip not like '%44_'").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest19 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest22() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers who have a null work zip code");
            List c = this.getEntityManager().createQuery("sELEct dIsTiNcT oBjEcT(c) FROM Customer c WHERE c.work.zip IS NULL").getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest22 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest23() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers who do not have null work zip code entry");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c WHERE c.work.zip IS NOT NULL").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 17 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest23 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest36() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers who lives in city Attleboro");
            List c = this.getEntityManager().createQuery("SELECT c From Customer c where c.home.city IN(:city)").setParameter("city", (Object)"Attleboro").getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest36 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest37() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute two queries composed differently and verify results");
            List c1 = this.getEntityManager().createQuery("SELECT DISTINCT Object(c) from Customer c where c.home.state IN('NH', 'RI')").getResultList();
            String[] expectedPKs = new String[]{"5", "6", "12", "14", "16"};
            List c2 = this.getEntityManager().createQuery("SELECT DISTINCT Object(c) from Customer c WHERE (c.home.state = 'NH') OR (c.home.state = 'RI')").getResultList();
            String[] expectedPKs2 = new String[]{"5", "6", "12", "14", "16"};
            if (!this.checkEntityPK(c1, expectedPKs)) {
                this.logErr("Did not get expected results for first query.  Expected 5 reference, got: " + c1.size());
            } else {
                this.logTrace("Expected results received for first query");
                pass1 = true;
            }
            if (!this.checkEntityPK(c2, expectedPKs2)) {
                this.logErr("Did not get expected results for second query.  Expected 5 reference, got: " + c2.size());
            } else {
                this.logTrace("Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest37 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest45() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find customers whose id is greater than 1 OR where the relationship is NOT EMPTY");
            List c = this.getEntityManager().createQuery("Select Object(c) from Customer c where c.aliasesNoop IS NOT EMPTY or c.id <> '1'").getResultList();
            String[] expectedPKs = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 19 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logTrace("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest45 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest47() throws Exception {
        boolean pass = false;
        Object[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find work zip codes that are not null");
            List c = this.getEntityManager().createQuery("Select c.work.zip from Customer c where c.work.zip IS NOT NULL ORDER BY c.work.zip ASC").getResultList();
            Object[] result = c.toArray(new String[c.size()]);
            this.logTrace("Compare results of work zip codes");
            pass = Arrays.equals(expectedZips, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest47 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest51() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers who do not have null relationship");
            List c = this.getEntityManager().createQuery("sElEcT Distinct oBJeCt(c) FROM Customer c, IN(c.aliases) a WHERE a.customerNoop IS NOT NULL").getResultList();
            if (c.size() != 0) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest51 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest54() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("determine if customers have a NULL relationship");
            List c = this.getEntityManager().createQuery("SELECT DISTINCT Object(c) from Customer c, in(c.aliases) a where NOT a.customerNoop IS NULL").getResultList();
            if (c.size() != 0) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest54 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest56() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        String[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all work zip codes");
            List c = this.getEntityManager().createQuery("Select c.work.zip from Customer c").getResultList();
            if (c.size() != 18) {
                this.logErr("Did not get expected results.  Expected 18 references, got: " + c.size());
            } else {
                Iterator i = c.iterator();
                int numOfNull = 0;
                int foundZip = 0;
                block2: while (i.hasNext()) {
                    pass1 = true;
                    this.logTrace("Check contents of List for null");
                    Object o = i.next();
                    if (o == null) {
                        ++numOfNull;
                        continue;
                    }
                    this.logTrace("Check List for expected zip codes");
                    for (int l = 0; l < 17; ++l) {
                        if (!expectedZips[l].equals(o)) continue;
                        ++foundZip;
                        continue block2;
                    }
                }
                if (numOfNull != 1 || foundZip != 17) {
                    this.logErr("Did not get expected results");
                    pass2 = false;
                } else {
                    this.logTrace("Expected results received");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest56 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest58() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find home zip codes");
            Object s = this.getEntityManager().createQuery("Select c.name from Customer c where c.home.street = '212 Edgewood Drive'").getSingleResult();
            if (s != null) {
                this.logErr("Did not get expected results.  Expected null.");
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest58 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest59() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("determine which customers have an null name");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) from Customer c where c.name is null").getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest59 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest61() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List c = this.getEntityManager().createQuery("select Distinct c FROM Customer c LEFT OUTER JOIN c.work workAddress where workAddress.zip IS NULL").getResultList();
            String[] expectedPKs = new String[]{"13", "19", "20"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest61 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest64() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List c = this.getEntityManager().createQuery("SELECT NEW ee.jakarta.tck.persistence.common.schema30.Customer (c.id, c.name, c.country, c.work) FROM Customer c where  c.work.city = :workcity").setParameter("workcity", (Object)"Burlington").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 18 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest64 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest69() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Long expectedResult1 = 17L;
        Long expectedResult2 = 16L;
        try {
            this.logTrace("Execute two queries composed differently and verify results");
            Query q1 = this.getEntityManager().createQuery("Select Count(c.home.city) from Customer c");
            Long result1 = (Long)q1.getSingleResult();
            if (!result1.equals(expectedResult1)) {
                this.logErr("Query1 in queryTest69 returned:" + result1 + " expected: " + expectedResult1);
            } else {
                this.logTrace("pass:  Query1 in queryTest69 returned expected results");
                pass1 = true;
            }
            Query q2 = this.getEntityManager().createQuery("Select Count(Distinct c.home.city) from Customer c");
            Long result2 = (Long)q2.getSingleResult();
            if (!result2.equals(expectedResult2)) {
                this.logErr("Query 2 in queryTest69 returned:" + result2 + " expected: " + expectedResult2);
            } else {
                this.logTrace("pass:  Query 2 in queryTest69 returned expected results");
                pass2 = true;
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest69 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest71() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Check if a spouse is related to a customer");
            this.getEntityManager().createQuery("Select s.customer from Spouse s where s.id = '7'").getSingleResult();
            this.getEntityTransaction().commit();
        }
        catch (NoResultException e) {
            this.logTrace("queryTest71: NoResultException caught as expected : " + String.valueOf((Object)e));
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception caught in queryTest71: " + String.valueOf(e));
        }
        if (!pass) {
            throw new Exception("queryTest71 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_leftouterjoin_1xM() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c from Customer c LEFT OUTER JOIN c.creditCards cc where c.name LIKE '%Caruso'").getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_leftouterjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_groupBy() throws Exception {
        boolean pass = false;
        Object[] expected = new String[]{"CHA", "GBR", "IRE", "JPN", "USA"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select c.country.code FROM Customer c GROUP BY c.country.code").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                this.logErr("Did not get expected results");
                for (Object s : expected) {
                    this.logErr("Expected:" + (String)s);
                }
                for (Object s : output) {
                    this.logErr("Actual:" + (String)s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_groupBy failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_innerjoin_1x1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c from Customer c INNER JOIN c.spouse s").getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_fetchjoin_1x1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c from Customer c JOIN FETCH c.spouse ").getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results. Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_groupByHaving() throws Exception {
        boolean pass = false;
        Long expectedGBR = 2L;
        Long expectedCHA = 4L;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Count(c) FROM Customer c GROUP BY c.country.code HAVING c.country.code IN ('GBR', 'CHA') ").getResultList();
            Iterator i = result.iterator();
            int numOfExpected = 0;
            while (i.hasNext()) {
                this.logTrace("Check result received . . . ");
                Long l = (Long)i.next();
                if (!l.equals(expectedGBR) && !l.equals(expectedCHA)) continue;
                ++numOfExpected;
            }
            if (numOfExpected != 2) {
                this.logErr("Did not get expected results.  Expected 2 Values returned : 2 with Country Code GBR and 4 with Country Code CHA. Received: " + result.size());
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    this.logTrace("count of Codes Returned: " + String.valueOf(it.next()));
                }
            } else {
                this.logTrace("Expected results received.");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_groupByHaving failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_concatHavingClause() throws Exception {
        boolean pass = false;
        String expectedCustomer = "Margaret Mills";
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("select c.name FROM Customer c Group By c.name HAVING c.name = concat(:fmname, :lname) ").setParameter("fmname", (Object)"Margaret ").setParameter("lname", (Object)"Mills");
            String result = (String)q.getSingleResult();
            if (result.equals("Margaret Mills")) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logTrace("test_concatHavingClause:  Did not get expected results. Expected: Margaret Mills, got: " + result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_concatHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_lowerHavingClause() throws Exception {
        boolean pass = false;
        Long expectedCount = 2L;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select count(c.country.code) FROM Customer c GROUP BY c.country.code  HAVING LOWER(c.country.code) = 'gbr' ").getResultList();
            for (Long l : result) {
                if (l.equals(expectedCount)) {
                    pass = true;
                    this.logTrace("Expected results received");
                    pass = true;
                    continue;
                }
                this.logErr("Did not get expected results. Expected 2 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_lowerHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_upperHavingClause() throws Exception {
        boolean pass = false;
        Long expectedCount = 2L;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select count(c.country.country) FROM Customer c GROUP BY c.country.country HAVING UPPER(c.country.country) = 'ENGLAND' ").getResultList();
            for (Long l : result) {
                if (l.equals(expectedCount)) {
                    pass = true;
                    this.logTrace("Expected results received");
                    pass = true;
                    continue;
                }
                this.logErr("Did not get expected results. Expected 2 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_upperHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_lengthHavingClause() throws Exception {
        boolean pass = false;
        Object[] expected = new String[]{"Burlington", "Chelmsford", "Roslindale"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select a.city  FROM Customer c JOIN c.home a GROUP BY a.city HAVING LENGTH(a.city) = 10 ").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                this.logErr("Did not get expected result:");
                for (Object s : expected) {
                    this.logTrace("expected:" + (String)s);
                }
                for (Object s : output) {
                    this.logTrace("actual:" + (String)s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_lengthHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_locateHavingClause() throws Exception {
        boolean pass = false;
        Object[] expected = new String[]{"Alan E. Frechette", "Arthur D. Frechette"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select c.name FROM Customer c GROUP BY c.name HAVING LOCATE('Frechette', c.name) > 0 ").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                this.logErr("Did not get expected result:");
                for (Object s : expected) {
                    this.logTrace("expected:" + (String)s);
                }
                for (Object s : output) {
                    this.logTrace("actual:" + (String)s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_locateHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_subquery_in() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("Select DISTINCT c from Customer c WHERE c.home.state IN(Select distinct w.state from c.work w where w.state = :state ) ").setParameter("state", (Object)"MA").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_in failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fetchStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c INNER JOIN fetch c.spouse").getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("fetchStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void embeddableNotManagedTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("SELECT c, c.country FROM Customer c where c.home.city = :homecity").setParameter("homecity", (Object)"Bedford").getResultList();
            if (q.size() == 1) {
                for (Object[] o : q) {
                    this.logMsg("Testing initial values");
                    Customer cust = (Customer)o[0];
                    Country country = (Country)o[1];
                    this.logTrace("Customer:" + cust.toString());
                    this.logTrace("Country:" + country.toString());
                    if (cust.getCountry() != country) {
                        this.logTrace("Customer country object does not equal Country from query as expected");
                        pass1 = true;
                    } else {
                        this.logErr("Customer country object equals Country from query");
                    }
                    this.logMsg("Change values of country");
                    country.setCode("CHA");
                    country.setCountry("China");
                    this.logTrace("Customer:" + cust.toString());
                    this.logTrace("Country:" + country.toString());
                    this.logTrace("Flush and refresh");
                    this.getEntityManager().flush();
                    this.getEntityManager().refresh((Object)cust);
                    this.logMsg("Test values again");
                    this.logTrace("Customer:" + cust.toString());
                    this.logTrace("Country:" + country.toString());
                    if (cust.getCountry() != country) {
                        if (!cust.getCountry().getCountry().equals("China") && !cust.getCountry().getCode().equals("CHA")) {
                            this.logTrace("Customer.country does not contain the modifications made to the Country object");
                            pass2 = true;
                            continue;
                        }
                        this.logErr("Customer.country contains the modifications made to the Country object");
                        continue;
                    }
                    this.logErr("Customer country object equals Country from query");
                }
            } else {
                this.logErr("Did not get 1 result back:" + q.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("embeddableNotManagedTest failed");
        }
    }
}

