/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManager.Employee;
import ee.jakarta.tck.persistence.core.entityManager.Order;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Client1
extends PMClientBase {
    List<Employee> empRef = new ArrayList<Employee>();
    Employee emp0 = null;
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        this.logTrace("in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                this.logTrace("Processing set:" + rsnum);
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    this.logTrace("Getting result set: " + rsnum + ", size:" + list.size());
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            this.logTrace("Saving:" + String.valueOf(e));
                            empList.add(e);
                            continue;
                        }
                        this.logErr("Did not get instance of Employee, instead got:" + o.getClass().getName());
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    this.logErr("Result set[" + rsnum + "] returned was null");
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    this.logTrace("rowsAffected:" + rowsAffected);
                }
            }
            results = spq.hasMoreResults();
            this.logTrace("Results:" + results);
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    public boolean verifyListOfListEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    this.logTrace("Received expected result:");
                    for (Integer n : actual) {
                        this.logTrace("id:" + n);
                    }
                    ++count;
                    continue;
                }
                this.logErr("Did not receive expected result:");
                for (Integer n : expected) {
                    this.logErr(" Expected id:" + n);
                }
                for (Integer n : actual) {
                    this.logErr("Actual id:" + n);
                }
                continue;
            }
            this.logErr("Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            this.logErr("Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                this.logTrace("Received expected result:" + String.valueOf(e));
            }
            result = true;
        } else {
            this.logErr("Did not receive expected result:");
            for (Employee e : expected) {
                this.logErr("expected employee:" + String.valueOf(e));
            }
            for (Employee e : actual) {
                this.logErr("actual employee :" + String.valueOf(e));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void autoCloseableTest() throws Exception {
        EntityManager em = null;
        try (EntityManagerFactory emfLocal = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.getPersistenceUnitProperties());){
            try {
                block18: {
                    try (EntityManager emLocal = emfLocal.createEntityManager();){
                        em = emLocal;
                        if (em == null) {
                            throw new Exception("autoCloseableTest failed: createEntityManager() returned null");
                        }
                        if (!em.isOpen()) {
                            throw new Exception("autoCloseableTest failed: EntityManager isOpen() returned false in try block");
                        }
                        if (emLocal == null) break block18;
                    }
                }
            }
            finally {
                if (em == null) return;
                if (!em.isOpen()) return;
                throw new Exception("autoCloseableTest failed: EntityManager isOpen() returned true outside try block");
            }
        }
        catch (Exception f) {
            throw f;
        }
        catch (Throwable t) {
            throw new Exception("autoCloseableTest failed with Exception", t);
        }
    }

    public void mergeTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Order o1 = (Order)this.getEntityManager().merge((Object)new Order(9, 999, "desc999"));
            this.getEntityTransaction().commit();
            this.clearCache();
            Order o2 = (Order)this.getEntityManager().find(Order.class, (Object)9);
            if (o1.equals(o2)) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Did not get expected results - expected:" + o1.toString() + ", actual:" + o2.toString());
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("mergeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeExceptionsTest() throws Exception {
        boolean pass = false;
        this.logMsg("Testing merge(Object");
        this.logMsg("Testing invalid object ");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().merge((Object)this);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Testing removed entity ");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().remove((Object)o);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            this.getEntityManager().merge((Object)o);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("mergeExceptionsTest failed");
        }
    }

    public void removeExceptionsTest() throws Exception {
        boolean pass = false;
        this.logMsg("Testing findClassObjectIllegalStateException");
        this.logMsg("Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove((Object)this);
            this.getEntityTransaction().commit();
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("removeExceptionsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        this.logMsg("Testing invalid object for lock(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock((Object)this, LockModeType.WRITE);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        this.logMsg("Testing invalid object for lock(Object, LockModeType, Map)");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock((Object)this, LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("lockIllegalStateExceptionTest failed");
        }
    }

    public void refreshInvalidObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshInvalidObjectIllegalArgumentExceptionTest failed");
        }
    }

    public void refreshNonManagedObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999));
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshNonManagedObjectIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshInvalidObjectMapIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshInvalidObjectMapIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNonManagedObjectMapIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshNonManagedObjectMapIllegalArgumentExceptionTest failed");
        }
    }

    public void refreshInvalidObjectLockModeTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, LockModeType.WRITE);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshInvalidObjectLockModeTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void refreshNonManagedObjectLockModeTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), LockModeType.WRITE);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshNonManagedObjectLockModeTypeIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshInvalidObjectLockModeTypeMapIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshInvalidObjectLockModeTypeMapIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNonManagedObjectLockModeTypeMapIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshNonManagedObjectLockModeTypeMapIllegalArgumentExceptionTest failed");
        }
    }

    public void containsIllegalArgumentException() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().contains((Object)"notanentity");
            this.logErr("IllegalArgumentException not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("containsIllegalArgumentException failed");
        }
    }

    public void createNamedQueryIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createNamedQuery("CTS NamedQuery");
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createNamedQuery("CTS NamedQuery", Order.class);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery with incorrect result type version");
        try {
            this.getEntityManager().createNamedQuery("SELECT o from ORDER o", String.class);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("createNamedQueryIllegalArgumentExceptionTest failed");
        }
    }

    public void createQueryIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        this.logTrace("Testing String version");
        try {
            Query q = this.getEntityManager().createQuery("CTS Query");
            this.logMsg("IllegalArgumentException was not thrown");
            try {
                q.getResultList();
                this.logErr("Neither IllegalArgumentException nor PersistenceException was thrown");
            }
            catch (PersistenceException e) {
                this.logTrace("PersistenceException Caught during execution.");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred during execution", e);
            }
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing String, Class version");
        try {
            this.getEntityManager().createQuery("SELECT o from ORDER o", String.class);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing CriteriaQuery version");
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(null);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            this.logMsg("IllegalArgumentException was not thrown");
            try {
                q.getResultList();
                this.logErr("Neither IllegalArgumentException nor PersistenceException was thrown");
            }
            catch (PersistenceException e) {
                this.logTrace("PersistenceException Caught during execution.");
                pass3 = true;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred during execution", e);
            }
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass3 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("createQueryIllegalArgumentExceptionTest failed");
        }
    }

    public void detachIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().detach(Client1.class);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception", re);
            }
        }
        if (!pass) {
            throw new Exception("detachIllegalArgumentExceptionTest failed");
        }
    }

    public void getEntityManagerFactoryTest() throws Exception {
        boolean pass = false;
        try {
            EntityManager em = this.getEntityManager();
            EntityManagerFactory emf = em.getEntityManagerFactory();
            if (emf == null) {
                this.logErr("getEntityManagerFactory() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("getEntityManagerFactoryTest failed");
        }
    }

    public void emGetMetamodelTest() throws Exception {
        boolean pass = false;
        try {
            EntityManager em = this.getEntityManager();
            Metamodel mm = em.getMetamodel();
            if (mm == null) {
                this.logErr("getMetamodel() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("emGetMetamodelTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyTest() throws Exception {
        boolean foundKey = false;
        boolean foundValue = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            t.begin();
            EntityManager em = this.getEntityManager();
            String expectedKey = "jakarta.persistence.cache.retrieveMode";
            CacheRetrieveMode expectedValue = CacheRetrieveMode.USE;
            this.logTrace("Setting property:" + expectedKey + "," + expectedValue.toString());
            em.setProperty(expectedKey, (Object)expectedValue);
            this.logTrace("Retrieve all EntityManger properties:");
            Map em_entry = em.getProperties();
            for (Map.Entry entry : em_entry.entrySet()) {
                String key = (String)entry.getKey();
                this.logMsg("Key = " + key);
                if (!key.contains(expectedKey)) continue;
                foundKey = true;
                Object oValue = entry.getValue();
                if (oValue instanceof CacheRetrieveMode) {
                    CacheRetrieveMode value = (CacheRetrieveMode)oValue;
                    if (value.equals((Object)expectedValue)) {
                        this.logMsg("Received expected value:" + value.toString());
                        foundValue = true;
                        continue;
                    }
                    this.logErr("Key:" + expectedKey + " -  expected value:" + expectedKey + ", actual value" + String.valueOf(value));
                    continue;
                }
                this.logErr("The value for Key:" + expectedKey + "was not an instance of String:" + String.valueOf(oValue));
            }
            if (!foundKey) {
                this.logErr("Property key:" + expectedKey + ", not found in EntityManager");
            }
            if (!foundValue) {
                this.logErr("The value for Key:" + expectedKey + ", was not found in EntityManager");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!foundKey || !foundValue) {
            throw new Exception("setPropertyTest failed");
        }
    }

    public void getCriteriaBuilderTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            if (cbuilder != null) {
                this.getEntityTransaction().begin();
                CriteriaQuery cquery = cbuilder.createQuery();
                if (cquery != null) {
                    this.logTrace("Obtained Non-null Criteria Query");
                    pass = true;
                } else {
                    this.logErr("Failed to get Non-null Criteria Query");
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("getCriteriaBuilder() returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("getCriteriaBuilderTest failed");
        }
    }

    public void isJoinedToTransactionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Test when no transaction active");
        if (!this.getEntityManager().isJoinedToTransaction()) {
            this.logTrace("Received expected result:false");
            pass1 = true;
        } else {
            this.logErr("Returned true when not in a transaction");
        }
        this.logMsg("Test when transaction active");
        this.getEntityTransaction().begin();
        if (this.getEntityManager().isJoinedToTransaction()) {
            this.logTrace("Received expected result:true");
            pass2 = true;
        } else {
            this.logErr("Returned false when in a transaction");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("isJoinedToTransactionTest failed");
        }
    }

    public void createStoredProcedureQueryStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        StringBuilder msg = new StringBuilder();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST");
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException from execute()");
            }
            catch (PersistenceException pe) {
                this.logTrace("Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception after execute()", e);
            }
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            this.logErr(msg.toString());
            throw new Exception("createStoredProcedureQueryStringIllegalArgumentExceptionTest failed");
        }
    }

    public void createStoredProcedureQueryStringClassArrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        Class[] cArray = new Class[]{Integer.class};
        StringBuilder msg = new StringBuilder();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST", cArray);
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException after execute()");
            }
            catch (PersistenceException pe) {
                this.logTrace("Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception from execute()", e);
            }
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            this.logErr(msg.toString());
            throw new Exception("createStoredProcedureQueryStringClassArrayIllegalArgumentExceptionTest failed");
        }
    }

    public void createStoredProcedureQueryStringStringArrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        StringBuilder msg = new StringBuilder();
        try {
            String[] sArray = new String[]{"doesnotexist"};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST", sArray);
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException from execute()");
            }
            catch (PersistenceException pe) {
                this.logTrace("Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception after execute()", e);
            }
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            this.logErr(msg.toString());
            throw new Exception("createStoredProcedureQueryStringStringArrayIllegalArgumentExceptionTest failed");
        }
    }

    public void createNamedStoredProcedureQueryStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            this.getEntityManager().createNamedStoredProcedureQuery("DOESNOTEXIST");
            this.logErr("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass = true;
        }
        this.getEntityTransaction().rollback();
        if (!pass) {
            throw new Exception("createNamedStoredProcedureQueryStringIllegalArgumentExceptionTest failed");
        }
    }
}

