/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt9;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class prepStmtClient9
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.prepStmt.prepStmt9";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private Properties props = null;
    private PreparedStatement pstmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        prepStmtClient9 theTests = new prepStmtClient9();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                this.props = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception: : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject103() throws Exception {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Decimal_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Decimal Table");
            String sminDecimalVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted Minimum value from Bit_Tab: " + sminDecimalVal);
            BigDecimal minDecimalVal = new BigDecimal(sminDecimalVal);
            Boolean oMinDecimalVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinDecimalVal, 3, 2);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            BigDecimal rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minDecimalVal, "" + rDecimalVal);
            if (rDecimalVal.compareTo(minDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject104() throws Exception {
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Boolean to be Updated in Numeric Table");
            String smaxNumericVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Bit_Tab: " + smaxNumericVal);
            BigDecimal maxNumericVal = new BigDecimal(smaxNumericVal);
            Boolean oMaxNumericVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxNumericVal, 2, 2);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            BigDecimal rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxNumericVal, "" + rNumericVal);
            if (rNumericVal.compareTo(maxNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject105() throws Exception {
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Numeric Table");
            String sminNumericVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted Minimum value from Bit_Tab: " + sminNumericVal);
            BigDecimal minNumericVal = new BigDecimal(sminNumericVal);
            Boolean oMinNumericVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinNumericVal, 2, 2);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            BigDecimal rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minNumericVal, "" + rNumericVal);
            if (rNumericVal.compareTo(minNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject108() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Boolean to be Updated in Char Table");
            String smaxBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Bit_Tab: " + smaxBooleanVal);
            Boolean oMaxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxBooleanVal, 1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMaxBooleanVal.toString()) || rStringVal.equals(smaxBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject109() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Char Table");
            String sminBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted Minimum value from Bit_Tab: " + sminBooleanVal);
            Boolean oMinBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinBooleanVal, 1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMinBooleanVal.toString()) || rStringVal.equals(sminBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject110() throws Exception {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Boolean to be Updated in Varchar Table");
            String smaxBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Bit_Tab: " + smaxBooleanVal);
            Boolean oMaxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxBooleanVal, 12);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMaxBooleanVal.toString()) || rStringVal.equals(smaxBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject111() throws Exception {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Varchar Table");
            String sminBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted Minimum value from Bit_Tab: " + sminBooleanVal);
            Boolean oMinBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinBooleanVal, 12);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMinBooleanVal.toString()) || rStringVal.equals(sminBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject112() throws Exception {
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Boolean to be Updated in Longvarchar Table");
            String smaxBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Bit_Tab: " + smaxBooleanVal);
            Boolean oMaxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxBooleanVal, -1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMaxBooleanVal.toString()) || rStringVal.equals(smaxBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject113() throws Exception {
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Longvarchar Table");
            String sminBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted Minimum value from Bit_Tab: " + sminBooleanVal);
            Boolean oMinBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinBooleanVal, -1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            String rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMinBooleanVal.toString()) || rStringVal.equals(sminBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject114() throws Exception {
        Integer maxIntegerVal = null;
        Integer rTinyintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Tinyint_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Tinyint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxIntegerVal, -6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Tinyint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orTinyintVal = this.rs.getObject(1);
            rTinyintVal = new Integer(orTinyintVal.toString());
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rTinyintVal);
            if (rTinyintVal.equals(maxIntegerVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject115() throws Exception {
        Integer minIntegerVal = null;
        Integer rTinyintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Tinyint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Tinyint to be Updated ");
            sminStringVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minIntegerVal, -6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orTinyintVal = this.rs.getObject(1);
            rTinyintVal = new Integer(orTinyintVal.toString());
            this.msg.addOutputMsg("" + minIntegerVal, "" + rTinyintVal);
            if (rTinyintVal.equals(minIntegerVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject116() throws Exception {
        Integer maxIntegerVal = null;
        Integer rSmallintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Smallint to be Updated ");
            smaxStringVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxIntegerVal, 5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Smallint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orSmallintVal = this.rs.getObject(1);
            rSmallintVal = new Integer(orSmallintVal.toString());
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rSmallintVal);
            if (rSmallintVal.equals(maxIntegerVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject117() throws Exception {
        Integer minIntegerVal = null;
        Integer rSmallintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Smallint to be Updated");
            sminStringVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minIntegerVal, 5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orSmallintVal = this.rs.getObject(1);
            rSmallintVal = new Integer(orSmallintVal.toString());
            this.msg.addOutputMsg("" + minIntegerVal, "" + rSmallintVal);
            if (rSmallintVal.equals(minIntegerVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject118() throws Exception {
        Integer maxIntegerVal = null;
        Integer rIntegerVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Integer to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxIntegerVal, 4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Integer_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orIntegerVal = this.rs.getObject(1);
            rIntegerVal = new Integer(orIntegerVal.toString());
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rIntegerVal);
            if (rIntegerVal.equals(maxIntegerVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject119() throws Exception {
        Integer minIntegerVal = null;
        Integer rIntegerVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Integer to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minIntegerVal, 4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orIntegerVal = this.rs.getObject(1);
            rIntegerVal = new Integer(orIntegerVal.toString());
            this.msg.addOutputMsg("" + minIntegerVal, "" + rIntegerVal);
            if (rIntegerVal.equals(minIntegerVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject120() throws Exception {
        Long maxBigintVal = null;
        Integer maxIntegerVal = null;
        Long rBigintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Bigint to be Updated ");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxBigintVal = new Long(smaxStringVal);
            maxIntegerVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxIntegerVal, -5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Bigint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orBigintVal = this.rs.getObject(1);
            rBigintVal = new Long(orBigintVal.toString());
            this.msg.addOutputMsg("" + maxBigintVal, "" + rBigintVal);
            if (rBigintVal.equals(maxBigintVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject121() throws Exception {
        Long minBigintVal = null;
        Integer minIntegerVal = null;
        Long rBigintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Bigint to be Updated ");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            minBigintVal = new Long(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minIntegerVal, -5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bigint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orBigintVal = this.rs.getObject(1);
            rBigintVal = new Long(orBigintVal.toString());
            this.msg.addOutputMsg("" + minBigintVal, "" + rBigintVal);
            if (rBigintVal.equals(minBigintVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject122() throws Exception {
        Float maxRealVal = null;
        Integer maxIntegerVal = null;
        Float rRealVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Real_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Float to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            maxRealVal = new Float(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxIntegerVal, 7);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Real_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orRealVal = this.rs.getObject(1);
            rRealVal = new Float(orRealVal.toString());
            this.msg.addOutputMsg("" + maxRealVal, "" + rRealVal);
            if (rRealVal.equals(maxRealVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

