/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.packaging.appclient.descriptor;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import ee.jakarta.tck.persistence.ee.packaging.appclient.descriptor.Coffee;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public class Client
extends EETest {
    private static final Coffee[] cRef = new Coffee[5];
    private EntityManagerFactory emf;
    private EntityManager em;
    private EntityTransaction et;
    private TSNamingContext nctx = null;
    private static final String emfRef = "java:comp/env/persistence/MyPersistenceUnit";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.logTrace("Obtain naming context");
            this.nctx = new TSNamingContext();
            if (this.nctx == null) {
                this.logErr("NCTX is null");
                throw new Exception("Setup Failed!");
            }
            this.emf = (EntityManagerFactory)this.nctx.lookup(emfRef);
            if (this.emf == null) {
                this.logErr("EMF is null");
                throw new Exception("Setup Failed!");
            }
            this.em = this.emf.createEntityManager();
            if (this.em == null) {
                this.logErr("EM is null");
                throw new Exception("Setup Failed!");
            }
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1() throws Exception {
        this.logTrace("Begin test1");
        boolean pass = true;
        try {
            this.logTrace("getEntityTransaction");
            if (null != this.em) {
                this.et = this.em.getTransaction();
                if (this.et != null) {
                    this.logTrace("createTestData");
                    this.et.begin();
                    this.logTrace("Create 5 Coffees");
                    Client.cRef[0] = new Coffee(1, "hazelnut", 1.0f);
                    Client.cRef[1] = new Coffee(2, "vanilla creme", 2.0f);
                    Client.cRef[2] = new Coffee(3, "decaf", 3.0f);
                    Client.cRef[3] = new Coffee(4, "breakfast blend", 4.0f);
                    Client.cRef[4] = new Coffee(5, "mocha", 5.0f);
                    this.logTrace("Start to persist coffees ");
                    for (Coffee c : cRef) {
                        if (c == null) continue;
                        this.em.persist((Object)c);
                        this.logTrace("persisted coffee " + c);
                    }
                    this.et.commit();
                    this.logTrace("Clearing the persistence context");
                    this.em.clear();
                    this.et.begin();
                    for (Coffee c : cRef) {
                        if (c == null) continue;
                        Coffee newcoffee = (Coffee)this.em.find(Coffee.class, (Object)c.getId());
                        if (newcoffee != null) {
                            this.em.remove((Object)newcoffee);
                            this.logTrace("removed coffee " + newcoffee);
                            continue;
                        }
                        this.logErr("find of coffee[" + c.getId() + "] returned null");
                        pass = false;
                    }
                    this.et.commit();
                } else {
                    this.logErr("EntityTransaction is null");
                    pass = false;
                }
            } else {
                this.logErr("EntityManager is null");
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected while creating test data:", e);
            pass = false;
        }
        finally {
            try {
                if (this.et.isActive()) {
                    this.et.rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("test1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("Clearing cache");
        this.emf.getCache().evictAll();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (null == this.em) {
            this.em = this.emf.createEntityManager();
        }
        if (null == this.et) {
            this.et = this.em.getTransaction();
        }
        if (this.et.isActive()) {
            this.et.rollback();
        }
        try {
            this.et.begin();
            this.em.createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.et.commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.et.isActive()) {
                    this.et.rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

