/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.queueMsgProperties;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class QueuePropertyTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.queueMsgProperties.QueuePropertyTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        QueuePropertyTests theTests = new QueuePropertyTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(3);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void msgPropertiesQTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        Object jmsxDefined = null;
        int numPropertyNames = 18;
        String testMessageBody = "Testing...";
        try {
            short aShort;
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            messageSent.setByteProperty("TESTBYTE", bValue);
            messageSent.setShortProperty("TESTSHORT", nShort);
            messageSent.setIntProperty("TESTINT", nInt);
            messageSent.setFloatProperty("TESTFLOAT", nFloat);
            messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            messageSent.setStringProperty("TESTSTRING", "test");
            messageSent.setLongProperty("TESTLONG", nLong);
            messageSent.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
            messageSent.setObjectProperty("OBJTESTBYTE", (Object)bValue);
            messageSent.setObjectProperty("OBJTESTSHORT", (Object)nShort);
            messageSent.setObjectProperty("OBJTESTINT", (Object)nInt);
            messageSent.setObjectProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            messageSent.setObjectProperty("OBJTESTDOUBLE", (Object)nDouble);
            messageSent.setObjectProperty("OBJTESTSTRING", (Object)"test");
            messageSent.setObjectProperty("OBJTESTLONG", (Object)nLong);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesQTest");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                messageSent.setObjectProperty("OBJTESTLONG", new Object());
                this.logMsg("Error: expected MessageFormatException from invalid ");
                this.logMsg("call to setObjectProperty did not occur!");
                pass = false;
            }
            catch (MessageFormatException fe) {
                this.logTrace("Pass: ");
                this.logTrace("      MessageFormatException as expected from invalid setObjectProperty call");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("from call to setObjectProperty!");
                this.logMsg(ee.getMessage());
                pass = false;
            }
            int i = 0;
            propertyNames = messageReceived.getPropertyNames();
            do {
                String tmp = (String)propertyNames.nextElement();
                this.logTrace("+++++++   Property Name is: " + tmp);
                if (tmp.indexOf("JMS") != 0) {
                    ++i;
                    continue;
                }
                if (!tmp.equals("JMSXDeliveryCount")) continue;
                ++i;
            } while (propertyNames.hasMoreElements());
            if (i == numPropertyNames) {
                this.logTrace("Pass: # of properties is " + numPropertyNames + " as expected");
            } else {
                this.logMsg("Error: expected " + numPropertyNames + " property names, but returned " + i);
                pass = false;
            }
            try {
                messageReceived.setBooleanProperty("TESTBOOLEAN", bool);
                this.logMsg("Error: exception should have occurred for setBooleanProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setBooleanProperty ");
            }
            try {
                messageReceived.setByteProperty("TESTBYTE", bValue);
                this.logMsg("Error: exception should have occurred for setByteProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setByteProperty ");
            }
            try {
                messageReceived.setShortProperty("TESTSHORT", nShort);
                pass = false;
                this.logMsg("Error: exception should have occurred for setShortProperty");
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setShortProperty ");
            }
            try {
                messageReceived.setIntProperty("TESTINT", nInt);
                this.logMsg("Error: exception should have occurred for setIntProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setIntProperty ");
            }
            try {
                messageReceived.setFloatProperty("TESTFLOAT", nFloat);
                this.logMsg("Error: exception should have occurred for setFloatProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setFloatProperty ");
            }
            try {
                messageReceived.setDoubleProperty("TESTDOUBLE", nDouble);
                this.logMsg("Error: exception should have occurred for setDoubleProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setDoubleProperty ");
            }
            try {
                messageReceived.setStringProperty("TESTSTRING", testString);
                this.logMsg("Error: exception should have occurred for setStringProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setStringProperty ");
            }
            try {
                messageReceived.setLongProperty("TESTLONG", nLong);
                this.logMsg("Error: exception should have occurred for setLongProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setLongProperty ");
            }
            try {
                messageReceived.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
                this.logMsg("Error: exception should have occurred for setObjectProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                this.logTrace("Pass: exception as expected for setObjectProperty ");
            }
            if (messageReceived.getBooleanProperty("TESTBOOLEAN") == bool) {
                this.logTrace("Pass: getBooleanProperty returned correct value");
            } else {
                this.logMsg("Error: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTBYTE") == bValue) {
                this.logTrace("Pass: getByteProperty returned correct value");
            } else {
                this.logMsg("Error: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTLONG") == nLong) {
                this.logTrace("Pass: getLongProperty returned correct value");
            } else {
                this.logMsg("Error: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TESTSTRING").equals(testString)) {
                this.logTrace("Pass: getStringProperty returned correct value");
            } else {
                this.logMsg("Error: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTDOUBLE") == nDouble) {
                this.logTrace("Pass: getDoubleProperty returned correct value");
            } else {
                this.logMsg("Error: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTFLOAT") == nFloat) {
                this.logTrace("Pass: getFloatProperty returned correct value");
            } else {
                this.logMsg("Error: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTINT") == nInt) {
                this.logTrace("Pass: getIntProperty returned correct value");
            } else {
                this.logMsg("Error: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSHORT") == nShort) {
                this.logTrace("Pass: getShortProperty returned correct value");
            } else {
                this.logMsg("Error: incorrect value returned from getShortProperty");
                pass = false;
            }
            try {
                boolean b = messageReceived.getBooleanProperty("TESTDUMMY");
                if (b) {
                    this.logMsg("Error: should havereceived false for getBooleanProperty");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            try {
                byte value = messageReceived.getByteProperty("TESTDUMMY");
                this.logMsg("Error: NumberFormatException should have occurred for getByteProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logTrace("Pass: NumberFormatException as expected ");
            }
            try {
                short value = messageReceived.getShortProperty("TESTDUMMY");
                this.logMsg("Error: NumberFormatException should have occurred for getShortProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logTrace("Pass: NumberFormatException as expected ");
            }
            try {
                int value = messageReceived.getIntProperty("TESTDUMMY");
                this.logMsg("Error: NumberFormatException should have occurred for getIntProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logTrace("Pass: NumberFormatException as expected ");
            }
            try {
                long value = messageReceived.getLongProperty("TESTDUMMY");
                this.logMsg("Error: NumberFormatException should have occurred for getLongProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logTrace("Pass: NumberFormatException as expected ");
            }
            try {
                float value = messageReceived.getFloatProperty("TESTDUMMY");
                this.logMsg("Error: NullPointerException should have occurred for getFloatProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                this.logTrace("Pass: NullPointerException as expected ");
            }
            try {
                double value = messageReceived.getDoubleProperty("TESTDUMMY");
                this.logMsg("Error: NullPointerException should have occurred for getDoubleProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                this.logTrace("Pass: NullPointerException as expected ");
            }
            String value = messageReceived.getStringProperty("TESTDUMMY");
            if (value == null) {
                this.logTrace("Pass: getStringProperty returned correct value");
            } else {
                this.logMsg("Error: expected a null return from getStringProperty for invalid property");
                pass = false;
            }
            Boolean aBool = (Boolean)messageReceived.getObjectProperty("TESTDUMMY");
            if (aBool == null) {
                this.logTrace("Pass: getObjectProperty returned correct value for Boolean");
            } else {
                this.logMsg("Error: expected a null return from getObjectProperty for invalid property");
                pass = false;
            }
            Boolean boolValue = (Boolean)messageReceived.getObjectProperty("OBJTESTBOOLEAN");
            if (boolValue == bool) {
                this.logTrace("Pass: getObjectProperty returned correct value for Boolean");
            } else {
                this.logMsg("Error: incorrect value returned for Boolean");
                pass = false;
            }
            Byte byteValue = (Byte)messageReceived.getObjectProperty("OBJTESTBYTE");
            if (byteValue == bValue) {
                this.logTrace("Pass: getObjectProperty returned correct Byte value");
            } else {
                this.logMsg("Error: incorrect value returned from Byte");
                pass = false;
            }
            Long lValue = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (lValue == nLong) {
                this.logTrace("Pass: getObjectProperty returned correct value for Long");
            } else {
                this.logMsg("Error: getObjectProperty returned incorrect value returned for Long");
                pass = false;
            }
            if (messageReceived.getObjectProperty("OBJTESTSTRING").equals(testString)) {
                this.logTrace("Pass: getObjectProperty returned correct value for String");
            } else {
                this.logMsg("Error: getObjectProperty returned incorrect value for String");
                pass = false;
            }
            Double dValue = (Double)messageReceived.getObjectProperty("OBJTESTDOUBLE");
            if (dValue == nDouble) {
                this.logTrace("Pass: getObjectProperty returned correct value for Double");
            } else {
                this.logMsg("Error: getObjectProperty returned incorrect value for Double");
                pass = false;
            }
            Float fValue = (Float)messageReceived.getObjectProperty("OBJTESTFLOAT");
            if (fValue.floatValue() == nFloat) {
                this.logTrace("Pass: getObjectProperty returned correct value for Float");
            } else {
                this.logMsg("Error: getObjectProperty returned incorrect value for Float");
                pass = false;
            }
            Integer iValue = (Integer)messageReceived.getObjectProperty("OBJTESTINT");
            if (iValue == nInt) {
                this.logTrace("Pass: getObjectProperty returned correct value for Integer");
            } else {
                this.logMsg("Error: getObjectProperty returned incorrect value for Integer");
                pass = false;
            }
            Short sValue = (Short)messageReceived.getObjectProperty("OBJTESTSHORT");
            if (sValue == nShort) {
                this.logTrace("Pass: getObjectProperty returned correct value for Short");
            } else {
                this.logMsg("Error: getObjectProperty returned incorrect value for Short");
                pass = false;
            }
            messageReceived.clearProperties();
            Long aLong = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (aLong == null) {
                this.logTrace("Pass: property was cleared");
            } else {
                this.logMsg("Error: getObjectProperty should have returned null for cleared property");
                pass = false;
            }
            try {
                aShort = messageReceived.getShortProperty("TESTSHORT");
                this.logMsg("Error: NumberFormatException should have occurred for getShortProperty");
                this.logMsg("Properties have been cleared!");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logTrace("Pass: NumberFormatException as expected ");
            }
            aLong = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (aLong == null) {
                this.logTrace("Pass: property was cleared");
            } else {
                this.logMsg("Error: getObjectProperty should have returned null for cleared property");
                pass = false;
            }
            try {
                aShort = messageReceived.getShortProperty("TESTSHORT");
                this.logMsg("Error: NumberFormatException should have occurred for getShortProperty");
                this.logMsg("Properties have been cleared!");
                pass = false;
            }
            catch (NumberFormatException np) {
                this.logTrace("Pass: NumberFormatException as expected ");
            }
            this.logMsg("Message body is : " + messageReceived.getText());
            if (messageReceived.getText().equals(testMessageBody)) {
                this.logTrace("Pass: able to read message body after clearProperties");
            } else {
                this.logMsg("Error: unable to read message body after clearProperties");
                pass = false;
            }
            try {
                ConnectionMetaData data = this.tool.getDefaultQueueConnection().getMetaData();
                Enumeration cmd = data.getJMSXPropertyNames();
                if (cmd == null) {
                    this.logMsg("Error: no JMSX property names were returned!");
                    this.logMsg("expected JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount at a miniumum");
                    pass = false;
                } else {
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        this.logTrace(propName);
                        if (!propName.equals("JMSXGroupID") && !propName.equals("JMSXGroupSeq") && !propName.equals("JMSXDeliveryCount")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 1) {
                        this.logTrace("Pass:");
                    } else {
                        this.logMsg("Error: Expected property names not returned");
                        pass = false;
                    }
                }
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg("attempting to read JMSX property names.");
                this.logMsg("Error: unexpected exception: " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during property tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgPropertiesQTest failed");
        }
    }

    public void msgPropertiesConversionQTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            messageSent.setByteProperty("TESTBYTE", bValue);
            messageSent.setShortProperty("TESTSHORT", nShort);
            messageSent.setIntProperty("TESTINT", nInt);
            messageSent.setFloatProperty("TESTFLOAT", nFloat);
            messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            messageSent.setStringProperty("TESTSTRING", "test");
            messageSent.setLongProperty("TESTLONG", nLong);
            messageSent.setStringProperty("TESTSTRINGTRUE", "true");
            messageSent.setStringProperty("TESTSTRINGFALSE", "false");
            messageSent.setStringProperty("TESTSTRING1", "1");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesConversionQTest");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            String myBool = messageReceived.getStringProperty("TESTBOOLEAN");
            if (Boolean.valueOf(myBool) == bool) {
                this.logTrace("Pass: conversion from boolean to string - ok");
            } else {
                this.logMsg("Error: conversion from boolean to string failed");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTBOOLEAN");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: boolean to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: did not catch expected Exception -- boolean to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTBOOLEAN");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: boolean to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- boolean to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTBOOLEAN");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: boolean to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception --boolean to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTBOOLEAN");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: boolean to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- boolean to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBOOLEAN");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: boolean to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- boolean to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBOOLEAN");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: boolean to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- boolean to double");
                pass = false;
            }
            String myByte = messageReceived.getStringProperty("TESTBYTE");
            if (Byte.valueOf(myByte) == bValue) {
                this.logTrace("Pass: conversion from byte to string - ok");
            } else {
                this.logMsg("Error: conversion from byte to string failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTBYTE") == bValue) {
                this.logTrace("Pass: conversion from byte to short - ok");
            } else {
                this.logMsg("Error: conversion from byte to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTBYTE") == bValue) {
                this.logTrace("Pass: conversion from byte to int - ok");
            } else {
                this.logMsg("Error: conversion from byte to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTBYTE") == (long)bValue) {
                this.logTrace("Pass: conversion from byte to long - ok");
            } else {
                this.logMsg("Error: conversion from byte to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTBYTE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: byte to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- byte to boolean");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBYTE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: byte to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception --byte to float ");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBYTE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: byte to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- byte to double");
                pass = false;
            }
            String myshort = messageReceived.getStringProperty("TESTSHORT");
            if (Short.valueOf(myshort) == nShort) {
                this.logTrace("Pass: conversion from short to string - ok");
            } else {
                this.logMsg("Error: conversion from short to string failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSHORT") == nShort) {
                this.logTrace("Pass: conversion from short to int - ok");
            } else {
                this.logMsg("Error: conversion from short to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSHORT") == (long)nShort) {
                this.logTrace("Pass: conversion from short to long - ok");
            } else {
                this.logMsg("Error: conversion from short to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTSHORT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: short to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- short to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTSHORT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: short to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- short to byte");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTSHORT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: short to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- short to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTSHORT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: short to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- short to double");
                pass = false;
            }
            if (Integer.valueOf(messageReceived.getStringProperty("TESTINT")) == nInt) {
                this.logTrace("Pass: conversion from int to string - ok");
            } else {
                this.logMsg("Error: conversion from int to string failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTINT") == (long)nInt) {
                this.logTrace("Pass: conversion from int to long - ok");
            } else {
                this.logMsg("Error: conversion from int to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTINT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: int to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- int to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTINT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: int to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception --  int to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTINT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: int to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected -- int to short ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception ");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTINT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: int to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- int to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTINT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: int to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- int to double");
                pass = false;
            }
            if (Long.valueOf(messageReceived.getStringProperty("TESTLONG")) == nLong) {
                this.logTrace("Pass: conversion from long to string - ok");
            } else {
                this.logMsg("Error: conversion from long to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTLONG");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: long to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- long to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTLONG");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: long to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- long to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTLONG");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: long to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- long to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTLONG");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: long to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- long to int");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTLONG");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: long to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- long to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTLONG");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: long to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- long to double");
                pass = false;
            }
            if (Float.valueOf(messageReceived.getStringProperty("TESTFLOAT")).floatValue() == nFloat) {
                this.logTrace("Pass: conversion from float to string - ok");
            } else {
                this.logMsg("Error: conversion from float to string failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTFLOAT") == (double)nFloat) {
                this.logTrace("Pass: conversion from long to double - ok");
            } else {
                this.logMsg("Error: conversion from long to double failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTFLOAT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: float to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- float to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTFLOAT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: float to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- float to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTFLOAT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: float to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception - float to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTFLOAT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: float to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception --- float to int");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTFLOAT");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: float to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception --  float to long");
                pass = false;
            }
            if (Double.valueOf(messageReceived.getStringProperty("TESTDOUBLE")) == nDouble) {
                this.logTrace("Pass: conversion from double to string - ok");
            } else {
                this.logMsg("Error: conversion from double to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTDOUBLE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: double to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- double to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTDOUBLE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: double to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- double to byte ");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTDOUBLE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: double to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- double to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTDOUBLE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: double to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception --- double to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTDOUBLE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: double to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- double to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTDOUBLE");
                this.logMsg("Error: MessageFormatException should have occurred for type conversion error");
                this.logMsg("unsupported conversion: double to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                this.logTrace("Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg(ee.getMessage());
                this.logMsg("Error: unexpected error " + ee.getClass().getName() + " was thrown");
                this.logMsg("Error: did not catch expected Exception -- double to float");
                pass = false;
            }
            if (messageReceived.getBooleanProperty("TESTSTRINGTRUE")) {
                this.logTrace("Pass: conversion from string to boolean - expect true - ok");
            } else {
                this.logMsg("Error: conversion from string to boolean - expect true  - failed");
                pass = false;
            }
            if (!messageReceived.getBooleanProperty("TESTSTRINGFALSE")) {
                this.logTrace("Pass: conversion from string to boolean expect false - ok");
            } else {
                this.logMsg("Error: conversion from string to boolean expect false - failed");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTSTRING1") == 1) {
                this.logTrace("Pass: conversion from string to byte - ok");
            } else {
                this.logMsg("Error: conversion from string to byte failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSTRING1") == 1) {
                this.logTrace("Pass: conversion from string to short - ok");
            } else {
                this.logMsg("Error: conversion from string to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSTRING1") == 1) {
                this.logTrace("Pass: conversion from string to int - ok");
            } else {
                this.logMsg("Error: conversion from string to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSTRING1") == 1L) {
                this.logTrace("Pass: conversion from string to long - ok");
            } else {
                this.logMsg("Error: conversion from string to long failed");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTSTRING1") == 1.0f) {
                this.logTrace("Pass: conversion from string to float - ok");
            } else {
                this.logMsg("Error: conversion from string to float failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTSTRING1") == 1.0) {
                this.logTrace("Pass: conversion from string to double - ok");
            } else {
                this.logMsg("Error: conversion from string to double failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during property conversion tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgPropertiesConversionQTest failed");
        }
    }

    public void msgPropertyExistTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        String testMessageBody = "Testing msgPropertyExistTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            messageSent.setByteProperty("TESTBYTE", bValue);
            messageSent.setShortProperty("TESTSHORT", nShort);
            messageSent.setIntProperty("TESTINT", nInt);
            messageSent.setFloatProperty("TESTFLOAT", nFloat);
            messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            messageSent.setStringProperty("TESTSTRING", "test");
            messageSent.setLongProperty("TESTLONG", nLong);
            messageSent.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            int i = 0;
            propertyNames = messageReceived.getPropertyNames();
            do {
                String tmp;
                if ((tmp = (String)propertyNames.nextElement()).indexOf("JMS") != 0) {
                    ++i;
                    if (tmp.equals("TESTBOOLEAN") || tmp.equals("TESTBYTE") || tmp.equals("TESTINT") || tmp.equals("TESTSHORT") || tmp.equals("TESTFLOAT") || tmp.equals("TESTDOUBLE") || tmp.equals("TESTSTRING") || tmp.equals("TESTLONG") || tmp.equals("OBJTESTBOOLEAN")) {
                        this.logTrace("+++++++Appclication Property set by client is: " + tmp);
                        if (!messageReceived.propertyExists(tmp)) {
                            pass = messageReceived.propertyExists(tmp);
                            this.logErr("Positive propertyExists test failed for " + tmp);
                            continue;
                        }
                        if (!messageReceived.propertyExists(tmp + "1")) continue;
                        pass = false;
                        this.logErr("Negative propertyExists test failed for " + tmp + "1");
                        continue;
                    }
                    this.logErr("+++++++Appclication Property not set by client: " + tmp);
                    pass = false;
                    continue;
                }
                this.logTrace("+++++++   JMSProperty Name is: " + tmp);
            } while (propertyNames.hasMoreElements());
            if (!pass) {
                throw new Exception("Error: failures occurred during propertyExists tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgPropertyExistTest failed");
        }
    }
}

