/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.biginteger;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.biginteger.A;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest1() throws Exception {
        this.logTrace("Begin persistBasicTest1");
        boolean pass = false;
        try {
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("1", "a1", 1, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityTransaction().begin();
            if (!this.getInstanceStatus(aRef)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest2() throws Exception {
        this.logTrace("Begin persistBasicTest2");
        boolean pass = false;
        try {
            this.logTrace("new A");
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("2", "a2", 2, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.createA(aRef);
            A newA = this.findA(bigInteger);
            if (newA != null) {
                this.logTrace("A IS NOT NULL");
            }
            this.getEntityTransaction().begin();
            pass = this.getInstanceStatus(this.findA(bigInteger));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest3() throws Exception {
        this.logTrace("Begin persistBasicTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A a1 = new A("3", "a3", 3, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.logTrace("Persist Instance");
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            this.logTrace("find By Name");
            A result = (A)this.findByName("a3");
            this.logTrace("Check to see that the entities are identical");
            if (result == a1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back transaction", fe);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest4() throws Exception {
        this.logTrace("Begin persistBasicTest4");
        boolean pass = false;
        try {
            this.logTrace("Persist Instance");
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("4", "a4", 4, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.createA(aRef);
            this.getEntityTransaction().begin();
            this.logTrace("get Instance Status ");
            if (this.getInstanceStatus(this.findA(bigInteger))) {
                try {
                    this.logTrace("entity is managed, try to persist again ");
                    A newA = this.findA(bigInteger);
                    this.getEntityManager().persist((Object)newA);
                    this.logTrace("Persist ignored on an already persisted entity as expected");
                    pass = true;
                }
                catch (Exception ee) {
                    this.logErr("Unexpected exception trying to persist an already persisted entity", ee);
                    pass = false;
                }
            } else {
                this.logTrace("Instance is not managed. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected exception rolling back transaction", re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest5() throws Exception {
        this.logTrace("Begin persistBasicTest5");
        boolean pass = false;
        try {
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("5", "a5", 5, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.logTrace("Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            this.logTrace("get Instance Status ");
            if (this.getInstanceStatus(this.findA(bigInteger))) {
                try {
                    this.logTrace("entity is managed, try to change name and flush ");
                    A a2 = this.findA(bigInteger);
                    a2.setName("a2");
                    this.getEntityManager().flush();
                    if (a2.getName().equals("a2")) {
                        this.logTrace("sync to database successful");
                        pass = true;
                    }
                }
                catch (Exception ee) {
                    this.logErr("Unexpected exception trying to flush apersisted entity", ee);
                    pass = false;
                }
            } else {
                this.logTrace("Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected exception rolling back transaction", re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest5 failed");
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(BigInteger id) {
        this.logTrace("Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private Object findByName(String name) {
        this.logTrace("Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getSingleResult();
    }

    private boolean getInstanceStatus(Object o) {
        this.logTrace("Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BIGINTEGER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

