ALTER TABLE PHONE_TABLE DROP CONSTRAINT FK_FOR_ADDRESS ;
ALTER TABLE CUSTOMER_TABLE DROP CONSTRAINT FK5_FOR_CUST ;
ALTER TABLE CUSTOMER_TABLE DROP CONSTRAINT FK6_FOR_CUST ;
ALTER TABLE ORDER_TABLE DROP CONSTRAINT FK4_FOR_CUST ;
ALTER TABLE ORDER_TABLE DROP CONSTRAINT FK0_FOR_LINEITEM ;
ALTER TABLE LINEITEM_TABLE DROP CONSTRAINT FK1_FOR_ORDER ;
ALTER TABLE LINEITEM_TABLE DROP CONSTRAINT FK_FOR_PRODUCT ;
ALTER TABLE SPOUSE_TABLE DROP CONSTRAINT FK_INFOTAB ;
ALTER TABLE SPOUSE_TABLE DROP CONSTRAINT FK7_CUSTOMERTAB ;
ALTER TABLE INFO_TABLE DROP CONSTRAINT FK_SPOUSETAB ;
ALTER TABLE FKS_ANOOP_CNOOP DROP CONSTRAINT FK2_ALIAS ;
ALTER TABLE FKS_ANOOP_CNOOP DROP CONSTRAINT FK8_CUSTOMER ;
ALTER TABLE FKS_ALIAS_CUSTOMER DROP CONSTRAINT FK_FOR_CUSTOMER ;
ALTER TABLE FKS_ALIAS_CUSTOMER DROP CONSTRAINT FK_FOR_ALIAS ;
ALTER TABLE ALIAS_TABLE DROP CONSTRAINT FK1_FOR_CUSTOMER ;
ALTER TABLE ALIAS_TABLE DROP CONSTRAINT FK2_FOR_CUSTOMER ;
ALTER TABLE CREDITCARD_TABLE DROP CONSTRAINT FK3_FOR_CUST ;
ALTER TABLE CREDITCARD_TABLE DROP CONSTRAINT FK_FOR_ORDER ;
ALTER TABLE EMPLOYEE DROP CONSTRAINT FK_MGR ;
ALTER TABLE EMPLOYEE DROP CONSTRAINT FK_DEPT ;
ALTER TABLE EMPLOYEE DROP CONSTRAINT FK_PROJECT ;
ALTER TABLE EMPLOYEE DROP CONSTRAINT FK_INS ;

ALTER TABLE STUDENT_COURSE DROP CONSTRAINT STDNTCOURSEStdntID ;
ALTER TABLE STUDENT_COURSE DROP CONSTRAINT STDNTCOURSEcrsesID ;
ALTER TABLE ENROLLMENTS DROP CONSTRAINT ENROLLMENTSSTUDENT ;
ALTER TABLE ENROLLMENTS DROP CONSTRAINT NROLLMENTSSEMESTER ;
ALTER TABLE COURSE_STUDENT DROP CONSTRAINT CRSESTUDENTCurseID ;
ALTER TABLE COURSE_STUDENT DROP CONSTRAINT CRSSTUDENTstdntsID ;

ALTER TABLE PARTTIMEEMPLOYEE DROP CONSTRAINT FK_ADDR ;
ALTER TABLE PARTTIMEEMPLOYEE DROP CONSTRAINT FK_DEPT2 ;
ALTER TABLE TEAM DROP CONSTRAINT COMPANY_COMPANYID ;
ALTER TABLE COMPANY DROP CONSTRAINT FK_ADDRESS ;
ALTER TABLE PERSON DROP CONSTRAINT INSURANCE_INSID ;
ALTER TABLE PERSON DROP CONSTRAINT TEAM_TEAMID ;
ALTER TABLE PERSON DROP CONSTRAINT PROJECT_PROJID ;
ALTER TABLE PERSON_ANNUALREVIEW DROP CONSTRAINT ANNUALREVIEWS_AID ;
ALTER TABLE PERSON_ANNUALREVIEW DROP CONSTRAINT PERSON_PERSONID;
ALTER TABLE PROJECT_PERSON DROP CONSTRAINT PROJ_PROJID;
ALTER TABLE PROJECT_PERSON DROP CONSTRAINT PERSONS_PERSONID;
ALTER TABLE PERSON_INSURANCE DROP CONSTRAINT P_PERSONID ;
ALTER TABLE PERSON_INSURANCE DROP CONSTRAINT INS_INSID ;
ALTER TABLE ORDER1 DROP CONSTRAINT FK1_FOR_ITEM ;
ALTER TABLE ORDER2 DROP CONSTRAINT FK2_FOR_ITEM ;
ALTER TABLE ORDER3 DROP CONSTRAINT FK3_FOR_ITEM ;
ALTER TABLE RETAILORDER2 DROP CONSTRAINT FK_FOR_CUST;
ALTER TABLE EMP_MAPKEYCOL DROP CONSTRAINT FK_DEPT1 ;
ALTER TABLE EMP_MAPKEYCOL DROP CONSTRAINT FK_DEPT3 ;
ALTER TABLE EMP_MAPKEYCOL DROP CONSTRAINT FK_DEPT4 ;
ALTER TABLE EMP_MAPKEYCOL2 DROP CONSTRAINT FK_DEPT5 ;

DROP TABLE PHONE_TABLE;
CREATE TABLE PHONE_TABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, AREA VARCHAR(255) , PHONE_NUMBER VARCHAR(255) , FK_FOR_ADDRESS VARCHAR(255) );

DROP TABLE ADDRESS;
CREATE TABLE ADDRESS ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, STREET VARCHAR(255) , CITY VARCHAR(255) , STATE VARCHAR(255) , ZIP VARCHAR(255) );

DROP TABLE CUSTOMER_TABLE;
CREATE TABLE CUSTOMER_TABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255), COUNTRY VARCHAR(255), CODE VARCHAR(255), FK5_FOR_CUSTOMER_TABLE VARCHAR(255) , FK6_FOR_CUSTOMER_TABLE VARCHAR(255));

ALTER TABLE PHONES DROP CONSTRAINT FK_FOR_PHONES ;
ALTER TABLE EMPLOYEES DROP CONSTRAINT FK_FOR_EMPLOYEES ;

DROP TABLE CUST_TABLE;
CREATE TABLE CUST_TABLE ( CUST_ID VARCHAR(255) PRIMARY KEY NOT NULL, NAME VARCHAR(255), COUNTRY VARCHAR(255), CODE VARCHAR(255));

DROP TABLE PHONES;
CREATE TABLE PHONES (ID VARCHAR(255), PHONE_NUMBER VARCHAR(255), FK_FOR_PHONES VARCHAR(255));
ALTER TABLE PHONES ADD CONSTRAINT FK_FOR_PHONES FOREIGN KEY (FK_FOR_PHONES) REFERENCES CUST_TABLE (CUST_ID) ;

DROP TABLE EMPLOYEES ;
CREATE TABLE EMPLOYEES (ID VARCHAR(255), LASTNAMEEMPLOYEES VARCHAR(255), FK_FOR_EMPLOYEES VARCHAR(255));
ALTER TABLE EMPLOYEES ADD CONSTRAINT FK_FOR_EMPLOYEES FOREIGN KEY (FK_FOR_EMPLOYEES) REFERENCES CUST_TABLE (CUST_ID) ;

DROP TABLE TRIM_TABLE;
CREATE TABLE TRIM_TABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME CHAR(30) NOT NULL);

DROP TABLE ALIAS_TABLE;
CREATE TABLE ALIAS_TABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, ALIAS VARCHAR(255) , FK1_FOR_CUSTOMER_TABLE VARCHAR(255) , FK2_FOR_CUSTOMER_TABLE VARCHAR(255) );

DROP TABLE FKS_ALIAS_CUSTOMER;
CREATE TABLE FKS_ALIAS_CUSTOMER ( FK_FOR_CUSTOMER_TABLE VARCHAR(255)  NOT NULL, FK_FOR_ALIAS_TABLE VARCHAR(255) );

DROP table FKS_ANOOP_CNOOP ;
CREATE TABLE FKS_ANOOP_CNOOP( FK8_FOR_CUSTOMER_TABLE VARCHAR(255) , FK2_FOR_ALIAS_TABLE VARCHAR(255));

DROP TABLE CREDITCARD_TABLE;
CREATE TABLE CREDITCARD_TABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, TYPE VARCHAR(255) , EXPIRES VARCHAR(255) , APPROVED BOOLEAN , CREDITCARD_NUMBER VARCHAR(255) , BALANCE DOUBLE, FK3_FOR_CUSTOMER_TABLE VARCHAR(255) , FK_FOR_ORDER_TABLE VARCHAR(255) );

DROP TABLE ORDER_TABLE;
CREATE TABLE ORDER_TABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, TOTALPRICE DOUBLE , FK4_FOR_CUSTOMER_TABLE VARCHAR(255) , FK0_FOR_LINEITEM_TABLE VARCHAR(255) );

DROP TABLE PRODUCT_DETAILS;
CREATE TABLE PRODUCT_DETAILS ( ID VARCHAR(255)  PRIMARY KEY NOT NULL, WHOUSE VARCHAR(255) , LICENSE_KEY INT);

DROP TABLE PRODUCT_TABLE;
CREATE TABLE PRODUCT_TABLE ( ID VARCHAR(255) PRIMARY KEY NOT NULL, NAME VARCHAR(255) , PRICE DOUBLE, QUANTITY INT, PNUM INT, PRODUCT_TYPE VARCHAR(255), INCEPTION DATE, SOLD DATE, MODEL INT, REV DOUBLE);

DROP TABLE PRODUCT_TABLE_DISCRIMINATOR;
CREATE TABLE PRODUCT_TABLE_DISCRIMINATOR ( ID VARCHAR(255) PRIMARY KEY NOT NULL, NAME VARCHAR(255), QUANTITY INT, PNUM INT, PRICE DOUBLE, PRODUCT_TYPE INT);

DROP TABLE PRICED_PRODUCT_TABLE ;
CREATE TABLE PRICED_PRODUCT_TABLE (ID VARCHAR(255) PRIMARY KEY NOT NULL, NAME VARCHAR(255), PRICE DOUBLE, QUANTITY INT, PNUM INT) ;

DROP table INFO_TABLE ;
CREATE TABLE INFO_TABLE (ID VARCHAR(255) PRIMARY KEY NOT NULL, INFOSTREET VARCHAR(255), INFOCITY VARCHAR(255), INFOSTATE VARCHAR(255), INFOZIP VARCHAR(255), FK_FOR_SPOUSE_TABLE VARCHAR(255) ) ;

DROP table SPOUSE_TABLE ;
CREATE TABLE SPOUSE_TABLE (ID VARCHAR(255) PRIMARY KEY NOT NULL,  FIRSTNAME VARCHAR(255), MAIDENNAME VARCHAR(255), LASTNAME VARCHAR(255), SOCSECNUM VARCHAR(255), FK7_FOR_CUSTOMER_TABLE VARCHAR(255), FK_FOR_INFO_TABLE VARCHAR(255) );

DROP TABLE LINEITEM_TABLE;
CREATE TABLE LINEITEM_TABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, QUANTITY INT , FK_FOR_PRODUCT_TABLE VARCHAR(255) , FK1_FOR_ORDER_TABLE VARCHAR(255) );

ALTER TABLE PHONE_TABLE ADD CONSTRAINT FK_FOR_ADDRESS FOREIGN KEY (FK_FOR_ADDRESS) REFERENCES ADDRESS (ID) ;

ALTER TABLE ALIAS_TABLE ADD CONSTRAINT FK1_FOR_CUSTOMER FOREIGN KEY (FK1_FOR_CUSTOMER_TABLE) REFERENCES CUSTOMER_TABLE (ID) ;

ALTER TABLE ALIAS_TABLE ADD CONSTRAINT FK2_FOR_CUSTOMER FOREIGN KEY (FK2_FOR_CUSTOMER_TABLE) REFERENCES CUSTOMER_TABLE (ID) ;

ALTER TABLE CUSTOMER_TABLE ADD CONSTRAINT FK5_FOR_CUST FOREIGN KEY (FK5_FOR_CUSTOMER_TABLE) REFERENCES ADDRESS (ID) ;

ALTER TABLE CUSTOMER_TABLE ADD CONSTRAINT FK6_FOR_CUST FOREIGN KEY (FK6_FOR_CUSTOMER_TABLE) REFERENCES ADDRESS (ID) ;

ALTER TABLE FKS_ALIAS_CUSTOMER ADD CONSTRAINT FK_FOR_CUSTOMER FOREIGN KEY (FK_FOR_CUSTOMER_TABLE) REFERENCES CUSTOMER_TABLE (ID) ;

ALTER TABLE FKS_ALIAS_CUSTOMER ADD CONSTRAINT FK_FOR_ALIAS FOREIGN KEY (FK_FOR_ALIAS_TABLE) REFERENCES ALIAS_TABLE (ID) ;

ALTER TABLE FKS_ANOOP_CNOOP  add constraint FK2_ALIAS Foreign Key (FK2_FOR_ALIAS_TABLE) references ALIAS_TABLE(id) ;

ALTER TABLE FKS_ANOOP_CNOOP  add constraint FK8_CUSTOMER Foreign Key (FK8_FOR_CUSTOMER_TABLE) references CUSTOMER_TABLE(id) ; 

ALTER TABLE CREDITCARD_TABLE ADD CONSTRAINT FK3_FOR_CUST FOREIGN KEY (FK3_FOR_CUSTOMER_TABLE) REFERENCES CUSTOMER_TABLE (ID) ;

ALTER TABLE CREDITCARD_TABLE ADD CONSTRAINT FK_FOR_ORDER FOREIGN KEY (FK_FOR_ORDER_TABLE) REFERENCES ORDER_TABLE (ID) ;

ALTER TABLE ORDER_TABLE ADD CONSTRAINT FK4_FOR_CUST FOREIGN KEY (FK4_FOR_CUSTOMER_TABLE) REFERENCES CUSTOMER_TABLE (ID) ;

ALTER TABLE ORDER_TABLE ADD CONSTRAINT FK0_FOR_LINEITEM FOREIGN KEY (FK0_FOR_LINEITEM_TABLE) REFERENCES LINEITEM_TABLE (ID) ;

ALTER TABLE LINEITEM_TABLE ADD CONSTRAINT FK_FOR_PRODUCT FOREIGN KEY (FK_FOR_PRODUCT_TABLE) REFERENCES PRODUCT_TABLE (ID) ;

ALTER TABLE LINEITEM_TABLE ADD CONSTRAINT FK1_FOR_ORDER FOREIGN KEY (FK1_FOR_ORDER_TABLE) REFERENCES ORDER_TABLE (ID) ;

ALTER TABLE SPOUSE_TABLE add constraint FK7_CUSTOMERTAB Foreign Key (FK7_FOR_CUSTOMER_TABLE) references CUSTOMER_TABLE(ID) ;

ALTER TABLE SPOUSE_TABLE add constraint FK_INFOTAB Foreign Key (FK_FOR_INFO_TABLE) references INFO_TABLE(ID) ; 

ALTER TABLE INFO_TABLE add constraint FK_SPOUSETAB Foreign Key (FK_FOR_SPOUSE_TABLE) references SPOUSE_TABLE(ID) ; 

DROP TABLE EMPLOYEE;
CREATE TABLE EMPLOYEE (ID INT NOT NULL, FIRSTNAME VARCHAR(255) , LASTNAME VARCHAR(255), HIREDATE DATE, SALARY REAL NOT NULL, STATUS VARCHAR(255), THEORDERCOLUMN INT, EMPLOYEES_ORDER INT, FK_MGR INT, FK_DEPT INT, FK_PROJECT INT , FK_INS INT, CONSTRAINT PK_EMPLOYEE PRIMARY KEY (ID)) ;

DROP TABLE DEPARTMENT ;
CREATE TABLE DEPARTMENT (NAME VARCHAR(255) , ID INT NOT NULL, COMPANY_COMPANYID INT, CONSTRAINT PK_DEPARTMENT PRIMARY KEY (ID)) ;

DROP TABLE PARTTIMEEMPLOYEE;
CREATE TABLE PARTTIMEEMPLOYEE (ID INT NOT NULL, FIRSTNAME VARCHAR(255) , LASTNAME VARCHAR(255), HIREDATE DATE, SALARY REAL NOT NULL,  ADDRESS_ID VARCHAR(255), STATUS VARCHAR(255), FK_DEPT2 INT , FK_PROJECT INT, CONSTRAINT PK_PARTTIMEEMPLOYEE PRIMARY KEY (ID)) ;
ALTER TABLE PARTTIMEEMPLOYEE ADD CONSTRAINT FK_ADDR FOREIGN KEY (ADDRESS_ID) REFERENCES ADDRESS (ID) ;

ALTER TABLE PARTTIMEEMPLOYEE ADD CONSTRAINT FK_DEPT2 FOREIGN KEY (FK_DEPT2) REFERENCES DEPARTMENT (ID) ;

DROP TABLE INSURANCE ;
CREATE TABLE INSURANCE (INSID INT NOT NULL, CARRIER VARCHAR(255) , CONSTRAINT PK_INSURANCE PRIMARY KEY (INSID)) ;

DROP TABLE COFFEE;
CREATE TABLE COFFEE (ID INT NOT NULL, BRANDNAME VARCHAR(25), PRICE REAL, CONSTRAINT PK_COFFEE PRIMARY KEY (ID));

DROP TABLE COMPANY;
CREATE TABLE COMPANY (COMPANYID INT NOT NULL, NAME VARCHAR(25), ADDRESS_ID VARCHAR(255), CONSTRAINT PK_COMPANY PRIMARY KEY (COMPANYID));

ALTER TABLE COMPANY ADD CONSTRAINT FK_ADDRESS FOREIGN KEY (ADDRESS_ID) REFERENCES ADDRESS (ID) ;

ALTER TABLE DEPARTMENT ADD CONSTRAINT FK_COMPANY FOREIGN KEY (COMPANY_COMPANYID) REFERENCES COMPANY (COMPANYID) ;

DROP TABLE DEPARTMENT2 ;
CREATE TABLE DEPARTMENT2 (ID INT NOT NULL, NAME VARCHAR(255), CONSTRAINT PK_DEPARTMENT2 PRIMARY KEY (ID)) ;

DROP TABLE TEAM;
CREATE TABLE TEAM (NAME VARCHAR(255) NOT NULL, TEAMID INT NOT NULL,  COMPANY_COMPANYID INT, CONSTRAINT PK_TEAM PRIMARY KEY (TEAMID));

ALTER TABLE TEAM ADD CONSTRAINT COMPANY_COMPANYID FOREIGN KEY (COMPANY_COMPANYID) REFERENCES COMPANY(COMPANYID);

DROP TABLE ANNUALREVIEW ;
CREATE TABLE ANNUALREVIEW (AID INT NOT NULL, SERVICE INT, CONSTRAINT PK_ANNUAL PRIMARY KEY (AID));

DROP TABLE PERSON ;
CREATE TABLE PERSON (PERSONID INT NOT NULL, FIRSTNAME VARCHAR(255) , LASTNAME VARCHAR(255) , PROJECT_PROJID INT , INSURANCE_INSID INT , TEAM_TEAMID INT , CONSTRAINT PK_PERSON PRIMARY KEY (PERSONID)) ;

DROP TABLE PROJECT;
CREATE TABLE PROJECT (PROJID INT NOT NULL, NAME VARCHAR(25), BUDGET DECIMAL(18,0), CONSTRAINT PK_PROJECT PRIMARY KEY (PROJID));

DROP TABLE PROJECT_PERSON;
CREATE TABLE PROJECT_PERSON (PROJECTS_PROJID INT , PERSONS_PERSONID INT );

DROP TABLE PERSON_INSURANCE;
CREATE TABLE PERSON_INSURANCE (PERSON_PERSONID INT, INSURANCE_INSID INT );

DROP TABLE PERSON_ANNUALREVIEW;
CREATE TABLE PERSON_ANNUALREVIEW (PERSON_PERSONID INT, ANNUALREVIEWS_AID INT );

ALTER TABLE EMPLOYEE ADD CONSTRAINT FK_MGR FOREIGN KEY (FK_MGR) REFERENCES EMPLOYEE (ID) ;
ALTER TABLE EMPLOYEE ADD CONSTRAINT FK_DEPT FOREIGN KEY (FK_DEPT) REFERENCES DEPARTMENT (ID) ;
ALTER TABLE EMPLOYEE ADD CONSTRAINT FK_PROJECT FOREIGN KEY (FK_PROJECT) REFERENCES PROJECT (PROJID) ;
ALTER TABLE EMPLOYEE ADD CONSTRAINT FK_INS FOREIGN KEY (FK_INS) REFERENCES INSURANCE (INSID) ;

ALTER TABLE PERSON ADD CONSTRAINT TEAM_TEAMID FOREIGN KEY (TEAM_TEAMID) REFERENCES TEAM(TEAMID);
ALTER TABLE PERSON ADD CONSTRAINT PROJECT_PROJID FOREIGN KEY (PROJECT_PROJID) REFERENCES PROJECT(PROJID); 
ALTER TABLE PERSON ADD CONSTRAINT INSURANCE_INSID FOREIGN KEY (INSURANCE_INSID) REFERENCES INSURANCE(INSID); 

ALTER TABLE PROJECT_PERSON ADD CONSTRAINT PROJ_PROJID Foreign Key (PROJECTS_PROJID) references PROJECT(PROJID); 
ALTER TABLE PROJECT_PERSON ADD CONSTRAINT PERSONS_PERSONID Foreign Key (PERSONS_PERSONID) references PERSON(PERSONID); 


ALTER TABLE PERSON_ANNUALREVIEW ADD CONSTRAINT ANNUALREVIEWS_AID Foreign Key (ANNUALREVIEWS_AID) references ANNUALREVIEW(AID);
ALTER TABLE PERSON_ANNUALREVIEW ADD CONSTRAINT PERSON_PERSONID Foreign Key (PERSON_PERSONID) references PERSON(PERSONID);

ALTER TABLE PERSON_INSURANCE ADD CONSTRAINT P_PERSONID Foreign Key (PERSON_PERSONID) references PERSON(PERSONID); 
ALTER TABLE PERSON_INSURANCE ADD CONSTRAINT INS_INSID Foreign Key (INSURANCE_INSID) references INSURANCE(INSID);

DROP TABLE BEANEJB_1X1_BI_BTOB;
CREATE TABLE BEANEJB_1X1_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_1X1_BI_BTOB VARCHAR(255) , FK2_FOR_AEJB_1X1_BI_BTOB VARCHAR(255) , FK1_FOR_BEJB_1X1_BI_BTOB VARCHAR(255) , FK2_FOR_BEJB_1X1_BI_BTOB VARCHAR(255) );

DROP TABLE BEJB_1X1_BI_BTOB;
CREATE TABLE BEJB_1X1_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_1X1_BI_BTOB VARCHAR(255) );

DROP TABLE AEJB_1X1_BI_BTOB;
CREATE TABLE AEJB_1X1_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE DATES_TABLE DROP CONSTRAINT FK_FOR_DATES_TABLE ;

DROP TABLE A_BASIC;
CREATE TABLE A_BASIC ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE INT, BASICINTEGER INT, BASICSHORT SMALLINT, BASICBIGSHORT SMALLINT, BASICFLOAT FLOAT, BASICBIGFLOAT FLOAT, BASICLONG BIGINT, BASICBIGLONG BIGINT, BASICDOUBLE DOUBLE, BASICBIGDOUBLE DOUBLE, BASICCHAR CHAR, BASICCHARARRAY VARCHAR(448), BASICBIGCHARARRAY VARCHAR(448), BASICBYTEARRAY  LONG VARCHAR FOR BIT DATA, BASICBIGBYTEARRAY LONG VARCHAR FOR BIT DATA, BASICBIGINTEGER DECIMAL(18,0), BASICBIGDECIMAL DECIMAL(18,0), BASICDATE DATE, BASICTIME TIME, BASICCALENDAR DATE, BASICTIMESTAMP TIMESTAMP ); 

DROP TABLE DATES_TABLE;
CREATE TABLE DATES_TABLE (ID VARCHAR(255), DATES VARCHAR(255), FK_FOR_DATES_TABLE VARCHAR(255));
ALTER TABLE DATES_TABLE ADD CONSTRAINT FK_FOR_DATES_TABLE FOREIGN KEY (FK_FOR_DATES_TABLE) REFERENCES A_BASIC (ID) ;

DROP TABLE DATE_TABLE ;
CREATE TABLE DATE_TABLE (ID DATE, STRINGVERSION VARCHAR(255)) ;

DROP TABLE A_BIGINTEGER;
CREATE TABLE A_BIGINTEGER ( ID VARCHAR(255), NAME VARCHAR(255) , VALUE INT, BASICINTEGER INT, BASICSHORT SMALLINT, BASICBIGSHORT SMALLINT, BASICFLOAT FLOAT, BASICBIGFLOAT FLOAT, BASICLONG BIGINT, BASICBIGLONG BIGINT, BASICDOUBLE DOUBLE, BASICBIGDOUBLE DOUBLE, BASICCHAR CHAR, BASICCHARARRAY VARCHAR(448), BASICBIGCHARARRAY VARCHAR(448), BASICBYTEARRAY  LONG VARCHAR FOR BIT DATA, BASICBIGBYTEARRAY LONG VARCHAR FOR BIT DATA, BASICBIGINTEGER DECIMAL(18,0) PRIMARY KEY NOT NULL, BASICBIGDECIMAL DECIMAL(18,0), BASICDATE DATE, BASICTIME TIME, BASICCALENDAR DATE, BASICTIMESTAMP TIMESTAMP ); 

DROP TABLE A_BIGDECIMAL;
CREATE TABLE A_BIGDECIMAL ( ID VARCHAR(255), NAME VARCHAR(255) , VALUE INT, BASICINTEGER INT, BASICSHORT SMALLINT, BASICBIGSHORT SMALLINT, BASICFLOAT FLOAT, BASICBIGFLOAT FLOAT, BASICLONG BIGINT, BASICBIGLONG BIGINT, BASICDOUBLE DOUBLE, BASICBIGDOUBLE DOUBLE, BASICCHAR CHAR, BASICCHARARRAY VARCHAR(448), BASICBIGCHARARRAY VARCHAR(448), BASICBYTEARRAY  LONG VARCHAR FOR BIT DATA, BASICBIGBYTEARRAY LONG VARCHAR FOR BIT DATA, BASICBIGINTEGER DECIMAL(18,0), BASICBIGDECIMAL DECIMAL(18,0) PRIMARY KEY NOT NULL, BASICDATE DATE, BASICTIME TIME, BASICCALENDAR DATE, BASICTIMESTAMP TIMESTAMP ); 

ALTER TABLE BEANEJB_1X1_BI_BTOB ADD CONSTRAINT FK1_FOR_AEJB_1X1_B FOREIGN KEY (FK1_FOR_AEJB_1X1_BI_BTOB) REFERENCES AEJB_1X1_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_1X1_BI_BTOB ADD CONSTRAINT FK2_FOR_AEJB_1X1_B FOREIGN KEY (FK2_FOR_AEJB_1X1_BI_BTOB) REFERENCES AEJB_1X1_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_1X1_BI_BTOB ADD CONSTRAINT FK1_FOR_BEJB_1X1_B FOREIGN KEY (FK1_FOR_BEJB_1X1_BI_BTOB) REFERENCES BEJB_1X1_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_1X1_BI_BTOB ADD CONSTRAINT FK2_FOR_BEJB_1X1_B FOREIGN KEY (FK2_FOR_BEJB_1X1_BI_BTOB) REFERENCES BEJB_1X1_BI_BTOB (ID) ;

ALTER TABLE BEJB_1X1_BI_BTOB ADD CONSTRAINT FK_FOR_AEJB_1X1_BI FOREIGN KEY (FK_FOR_AEJB_1X1_BI_BTOB) REFERENCES AEJB_1X1_BI_BTOB (ID) ;

DROP TABLE BEANEJB_1X1_BI_CASCADE;
CREATE TABLE BEANEJB_1X1_BI_CASCADE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_1X1_BI_CASCADE VARCHAR(255) , FK2_FOR_AEJB_1X1_BI_CASCADE VARCHAR(255) , FK1_FOR_BEJB_1X1_BI_CASCADE VARCHAR(255) , FK2_FOR_BEJB_1X1_BI_CASCADE VARCHAR(255) );

DROP TABLE BEJB_1X1_BI_CASCADE;
CREATE TABLE BEJB_1X1_BI_CASCADE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_1X1_BI_CASCADE VARCHAR(255) );

DROP TABLE AEJB_1X1_BI_CASCADE;
CREATE TABLE AEJB_1X1_BI_CASCADE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE BEANEJB_1X1_BI_CASCADE ADD CONSTRAINT FK1_FOR_AEJB_1X1_1 FOREIGN KEY (FK1_FOR_AEJB_1X1_BI_CASCADE) REFERENCES AEJB_1X1_BI_CASCADE (ID) ;

ALTER TABLE BEANEJB_1X1_BI_CASCADE ADD CONSTRAINT FK2_FOR_AEJB_1X1_1 FOREIGN KEY (FK2_FOR_AEJB_1X1_BI_CASCADE) REFERENCES AEJB_1X1_BI_CASCADE (ID) ;

ALTER TABLE BEANEJB_1X1_BI_CASCADE ADD CONSTRAINT FK1_FOR_BEJB_1X1_1 FOREIGN KEY (FK1_FOR_BEJB_1X1_BI_CASCADE) REFERENCES BEJB_1X1_BI_CASCADE (ID) ;

ALTER TABLE BEANEJB_1X1_BI_CASCADE ADD CONSTRAINT FK2_FOR_BEJB_1X1_1 FOREIGN KEY (FK2_FOR_BEJB_1X1_BI_CASCADE) REFERENCES BEJB_1X1_BI_CASCADE (ID) ;

ALTER TABLE BEJB_1X1_BI_CASCADE ADD CONSTRAINT FK_FOR_AEJB_1X1_B1 FOREIGN KEY (FK_FOR_AEJB_1X1_BI_CASCADE) REFERENCES AEJB_1X1_BI_CASCADE (ID) ;

DROP TABLE BEANEJB_1X1_UNI_BTOB;
CREATE TABLE BEANEJB_1X1_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_1X1_UNI_BTOB VARCHAR(255) , FK2_FOR_AEJB_1X1_UNI_BTOB VARCHAR(255) , FK1_FOR_BEJB_1X1_UNI_BTOB VARCHAR(255) , FK2_FOR_BEJB_1X1_UNI_BTOB VARCHAR(255) );

DROP TABLE BEJB_1X1_UNI_BTOB;
CREATE TABLE BEJB_1X1_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_1X1_UNI_BTOB VARCHAR(255) );

DROP TABLE AEJB_1X1_UNI_BTOB;
CREATE TABLE AEJB_1X1_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE BEANEJB_1X1_UNI_BTOB ADD CONSTRAINT FK1_FOR_AEJB_1X1_U FOREIGN KEY (FK1_FOR_AEJB_1X1_UNI_BTOB) REFERENCES AEJB_1X1_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_1X1_UNI_BTOB ADD CONSTRAINT FK2_FOR_AEJB_1X1_U FOREIGN KEY (FK2_FOR_AEJB_1X1_UNI_BTOB) REFERENCES AEJB_1X1_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_1X1_UNI_BTOB ADD CONSTRAINT FK1_FOR_BEJB_1X1_U FOREIGN KEY (FK1_FOR_BEJB_1X1_UNI_BTOB) REFERENCES BEJB_1X1_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_1X1_UNI_BTOB ADD CONSTRAINT FK2_FOR_BEJB_1X1_U FOREIGN KEY (FK2_FOR_BEJB_1X1_UNI_BTOB) REFERENCES BEJB_1X1_UNI_BTOB (ID) ;

ALTER TABLE BEJB_1X1_UNI_BTOB ADD CONSTRAINT FK_FOR_AEJB_1X1_UN FOREIGN KEY (FK_FOR_AEJB_1X1_UNI_BTOB) REFERENCES AEJB_1X1_UNI_BTOB (ID) ;

DROP TABLE BEANEJB_1XM_BI_BTOB;
CREATE TABLE BEANEJB_1XM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_1XM_BI_BTOB VARCHAR(255) , FK2_FOR_AEJB_1XM_BI_BTOB VARCHAR(255) , FK1_FOR_BEJB_1XM_BI_BTOB VARCHAR(255) , FK2_FOR_BEJB_1XM_BI_BTOB VARCHAR(255) , FK3_FOR_BEJB_1XM_BI_BTOB VARCHAR(255) , FK4_FOR_BEJB_1XM_BI_BTOB VARCHAR(255) );

DROP TABLE BEJB_1XM_BI_BTOB;
CREATE TABLE BEJB_1XM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_1XM_BI_BTOB VARCHAR(255) );

DROP TABLE BNE_1XM_BI_BTOB;
CREATE TABLE BNE_1XM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, STREET VARCHAR(255), CITY VARCHAR(255), STATE VARCHAR(255), ZIP VARCHAR(255), PLUSFOUR VARCHAR(255), FK_FOR_ANE_1XM_BI_BTOB VARCHAR(255) );

DROP TABLE B_EMBEDDABLE;
CREATE TABLE B_EMBEDDABLE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, STREET VARCHAR(255), CITY VARCHAR(255), STATE VARCHAR(255), ZIP VARCHAR(255), PLUSFOUR VARCHAR(255));

DROP TABLE AEJB_1XM_BI_BTOB;
CREATE TABLE AEJB_1XM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

DROP TABLE ANE_1XM_BI_BTOB;
CREATE TABLE ANE_1XM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL );

DROP TABLE A_ADDRESS;
CREATE TABLE A_ADDRESS ( A_ID VARCHAR(255) NOT NULL,  STREET VARCHAR(30), CITY VARCHAR(30), STATE VARCHAR(2), ZIP VARCHAR(10) );

DROP TABLE COLTAB_ADDRESS;
CREATE TABLE COLTAB_ADDRESS ( A_ID VARCHAR(255) NOT NULL,  STREET VARCHAR(30), CITY VARCHAR(30), STATE VARCHAR(2), ZIP VARCHAR(10) );

DROP TABLE AEC;
CREATE TABLE AEC ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) );

DROP TABLE COLTAB;
CREATE TABLE COLTAB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) );


ALTER TABLE BEANEJB_1XM_BI_BTOB ADD CONSTRAINT FK1_FOR_AEJB_1XM_B FOREIGN KEY (FK1_FOR_AEJB_1XM_BI_BTOB) REFERENCES AEJB_1XM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_BI_BTOB ADD CONSTRAINT FK2_FOR_AEJB_1XM_B FOREIGN KEY (FK2_FOR_AEJB_1XM_BI_BTOB) REFERENCES AEJB_1XM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_BI_BTOB ADD CONSTRAINT FK1_FOR_BEJB_1XM_B FOREIGN KEY (FK1_FOR_BEJB_1XM_BI_BTOB) REFERENCES BEJB_1XM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_BI_BTOB ADD CONSTRAINT FK2_FOR_BEJB_1XM_B FOREIGN KEY (FK2_FOR_BEJB_1XM_BI_BTOB) REFERENCES BEJB_1XM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_BI_BTOB ADD CONSTRAINT FK3_FOR_BEJB_1XM_B FOREIGN KEY (FK3_FOR_BEJB_1XM_BI_BTOB) REFERENCES BEJB_1XM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_BI_BTOB ADD CONSTRAINT FK4_FOR_BEJB_1XM_B FOREIGN KEY (FK4_FOR_BEJB_1XM_BI_BTOB) REFERENCES BEJB_1XM_BI_BTOB (ID) ;

ALTER TABLE BEJB_1XM_BI_BTOB ADD CONSTRAINT FK_FOR_AEJB_1XM_BI FOREIGN KEY (FK_FOR_AEJB_1XM_BI_BTOB) REFERENCES AEJB_1XM_BI_BTOB (ID) ;

ALTER TABLE BNE_1XM_BI_BTOB ADD CONSTRAINT FK_FOR_ANE_1XM_BI FOREIGN KEY (FK_FOR_ANE_1XM_BI_BTOB) REFERENCES ANE_1XM_BI_BTOB (ID) ;

DROP TABLE BEANEJB_1XM_BI_CASCADE;
CREATE TABLE BEANEJB_1XM_BI_CASCADE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_1XM_BI_CASCADE VARCHAR(255) , FK2_FOR_AEJB_1XM_BI_CASCADE VARCHAR(255) , FK1_FOR_BEJB_1XM_BI_CASCADE VARCHAR(255) , FK2_FOR_BEJB_1XM_BI_CASCADE VARCHAR(255) );

DROP TABLE BEJB_1XM_BI_CASCADE;
CREATE TABLE BEJB_1XM_BI_CASCADE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_1XM_BI_CASCADE VARCHAR(255) );

DROP TABLE AEJB_1XM_BI_CASCADE;
CREATE TABLE AEJB_1XM_BI_CASCADE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE BEANEJB_1XM_BI_CASCADE ADD CONSTRAINT FK1_FOR_AEJB_1XM_1 FOREIGN KEY (FK1_FOR_AEJB_1XM_BI_CASCADE) REFERENCES AEJB_1XM_BI_CASCADE (ID) ;

ALTER TABLE BEANEJB_1XM_BI_CASCADE ADD CONSTRAINT FK2_FOR_AEJB_1XM_1 FOREIGN KEY (FK2_FOR_AEJB_1XM_BI_CASCADE) REFERENCES AEJB_1XM_BI_CASCADE (ID) ;

ALTER TABLE BEANEJB_1XM_BI_CASCADE ADD CONSTRAINT FK1_FOR_BEJB_1XM_1 FOREIGN KEY (FK1_FOR_BEJB_1XM_BI_CASCADE) REFERENCES BEJB_1XM_BI_CASCADE (ID) ;

ALTER TABLE BEANEJB_1XM_BI_CASCADE ADD CONSTRAINT FK2_FOR_BEJB_1XM_1 FOREIGN KEY (FK2_FOR_BEJB_1XM_BI_CASCADE) REFERENCES BEJB_1XM_BI_CASCADE (ID) ;

ALTER TABLE BEJB_1XM_BI_CASCADE ADD CONSTRAINT FK_FOR_AEJB_1XM_B1 FOREIGN KEY (FK_FOR_AEJB_1XM_BI_CASCADE) REFERENCES AEJB_1XM_BI_CASCADE (ID) ;

DROP TABLE BEANEJB_1XM_BI_DELETE;
CREATE TABLE BEANEJB_1XM_BI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_1XM_BI_DELETE VARCHAR(255) , FK2_FOR_AEJB_1XM_BI_DELETE VARCHAR(255) , FK1_FOR_BEJB_1XM_BI_DELETE VARCHAR(255) , FK2_FOR_BEJB_1XM_BI_DELETE VARCHAR(255) );

DROP TABLE BEJB_1XM_BI_DELETE;
CREATE TABLE BEJB_1XM_BI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_1XM_BI_DELETE VARCHAR(255) );

DROP TABLE AEJB_1XM_BI_DELETE;
CREATE TABLE AEJB_1XM_BI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE BEANEJB_1XM_BI_DELETE ADD CONSTRAINT FK1_FOR_AEJB_1XM_2 FOREIGN KEY (FK1_FOR_AEJB_1XM_BI_DELETE) REFERENCES AEJB_1XM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_1XM_BI_DELETE ADD CONSTRAINT FK2_FOR_AEJB_1XM_2 FOREIGN KEY (FK2_FOR_AEJB_1XM_BI_DELETE) REFERENCES AEJB_1XM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_1XM_BI_DELETE ADD CONSTRAINT FK1_FOR_BEJB_1XM_2 FOREIGN KEY (FK1_FOR_BEJB_1XM_BI_DELETE) REFERENCES BEJB_1XM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_1XM_BI_DELETE ADD CONSTRAINT FK2_FOR_BEJB_1XM_2 FOREIGN KEY (FK2_FOR_BEJB_1XM_BI_DELETE) REFERENCES BEJB_1XM_BI_DELETE (ID) ;

ALTER TABLE BEJB_1XM_BI_DELETE ADD CONSTRAINT FK_FOR_AEJB_1XM_B2 FOREIGN KEY (FK_FOR_AEJB_1XM_BI_DELETE) REFERENCES AEJB_1XM_BI_DELETE (ID) ;

DROP TABLE BEANEJB_1XM_UNI_BTOB;
CREATE TABLE BEANEJB_1XM_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_1XM_UNI_BTOB VARCHAR(255) , FK2_FOR_AEJB_1XM_UNI_BTOB VARCHAR(255) , FK1_FOR_BEJB_1XM_UNI_BTOB VARCHAR(255) , FK2_FOR_BEJB_1XM_UNI_BTOB VARCHAR(255), FK3_FOR_BEJB_1XM_UNI_BTOB VARCHAR(255) , FK4_FOR_BEJB_1XM_UNI_BTOB VARCHAR(255) );

DROP TABLE BEJB_1XM_UNI_BTOB;
CREATE TABLE BEJB_1XM_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_1XM_UNI_BTOB VARCHAR(255) );

DROP TABLE AEJB_1XM_UNI_BTOB;
CREATE TABLE AEJB_1XM_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE BEANEJB_1XM_UNI_BTOB ADD CONSTRAINT FK1_FOR_AEJB_1XM_U FOREIGN KEY (FK1_FOR_AEJB_1XM_UNI_BTOB) REFERENCES AEJB_1XM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_UNI_BTOB ADD CONSTRAINT FK2_FOR_AEJB_1XM_U FOREIGN KEY (FK2_FOR_AEJB_1XM_UNI_BTOB) REFERENCES AEJB_1XM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_UNI_BTOB ADD CONSTRAINT FK1_FOR_BEJB_1XM_U FOREIGN KEY (FK1_FOR_BEJB_1XM_UNI_BTOB) REFERENCES BEJB_1XM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_UNI_BTOB ADD CONSTRAINT FK2_FOR_BEJB_1XM_U FOREIGN KEY (FK2_FOR_BEJB_1XM_UNI_BTOB) REFERENCES BEJB_1XM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_UNI_BTOB ADD CONSTRAINT FK3_FOR_BEJB_1XM_U FOREIGN KEY (FK3_FOR_BEJB_1XM_UNI_BTOB) REFERENCES BEJB_1XM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_1XM_UNI_BTOB ADD CONSTRAINT FK4_FOR_BEJB_1XM_U FOREIGN KEY (FK4_FOR_BEJB_1XM_UNI_BTOB) REFERENCES BEJB_1XM_UNI_BTOB (ID) ;

DROP TABLE BEANEJB_MX1_UNI_BTOB;
CREATE TABLE BEANEJB_MX1_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_MX1_UNI_BTOB VARCHAR(255) , FK2_FOR_AEJB_MX1_UNI_BTOB VARCHAR(255) , FK1_FOR_BEJB_MX1_UNI_BTOB VARCHAR(255) , FK2_FOR_BEJB_MX1_UNI_BTOB VARCHAR(255) ,
FK3_FOR_BEJB_MX1_UNI_BTOB VARCHAR(255) , FK4_FOR_BEJB_MX1_UNI_BTOB VARCHAR(255) );

DROP TABLE BEJB_MX1_UNI_BTOB;
CREATE TABLE BEJB_MX1_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_MX1_UNI_BTOB VARCHAR(255) );

DROP TABLE AEJB_MX1_UNI_BTOB;
CREATE TABLE AEJB_MX1_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE BEANEJB_MX1_UNI_BTOB ADD CONSTRAINT FK1_FOR_AEJB_MX1_U FOREIGN KEY (FK1_FOR_AEJB_MX1_UNI_BTOB) REFERENCES AEJB_MX1_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_BTOB ADD CONSTRAINT FK2_FOR_AEJB_MX1_U FOREIGN KEY (FK2_FOR_AEJB_MX1_UNI_BTOB) REFERENCES AEJB_MX1_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_BTOB ADD CONSTRAINT FK1_FOR_BEJB_MX1_U FOREIGN KEY (FK1_FOR_BEJB_MX1_UNI_BTOB) REFERENCES BEJB_MX1_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_BTOB ADD CONSTRAINT FK2_FOR_BEJB_MX1_U FOREIGN KEY (FK2_FOR_BEJB_MX1_UNI_BTOB) REFERENCES BEJB_MX1_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_BTOB ADD CONSTRAINT FK3_FOR_BEJB_MX1_U FOREIGN KEY (FK3_FOR_BEJB_MX1_UNI_BTOB) REFERENCES BEJB_MX1_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_BTOB ADD CONSTRAINT FK4_FOR_BEJB_MX1_U FOREIGN KEY (FK4_FOR_BEJB_MX1_UNI_BTOB) REFERENCES BEJB_MX1_UNI_BTOB (ID) ;

ALTER TABLE BEJB_MX1_UNI_BTOB ADD CONSTRAINT FK_FOR_AEJB_MX1_UN FOREIGN KEY (FK_FOR_AEJB_MX1_UNI_BTOB) REFERENCES AEJB_MX1_UNI_BTOB (ID) ;

DROP TABLE BEANEJB_MX1_UNI_DELETE;
CREATE TABLE BEANEJB_MX1_UNI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_MX1_UNI_DELETE VARCHAR(255) , FK2_FOR_AEJB_MX1_UNI_DELETE VARCHAR(255) , FK1_FOR_BEJB_MX1_UNI_DELETE VARCHAR(255) , FK2_FOR_BEJB_MX1_UNI_DELETE VARCHAR(255) , FK3_FOR_BEJB_MX1_UNI_DELETE VARCHAR(255) , FK4_FOR_BEJB_MX1_UNI_DELETE VARCHAR(255) );

DROP TABLE BEJB_MX1_UNI_DELETE;
CREATE TABLE BEJB_MX1_UNI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK_FOR_AEJB_MX1_UNI_DELETE VARCHAR(255) );

DROP TABLE AEJB_MX1_UNI_DELETE;
CREATE TABLE AEJB_MX1_UNI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE BEANEJB_MX1_UNI_DELETE ADD CONSTRAINT FK1_FOR_AEJB_MX1_1 FOREIGN KEY (FK1_FOR_AEJB_MX1_UNI_DELETE) REFERENCES AEJB_MX1_UNI_DELETE (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_DELETE ADD CONSTRAINT FK2_FOR_AEJB_MX1_1 FOREIGN KEY (FK2_FOR_AEJB_MX1_UNI_DELETE) REFERENCES AEJB_MX1_UNI_DELETE (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_DELETE ADD CONSTRAINT FK1_FOR_BEJB_MX1_1 FOREIGN KEY (FK1_FOR_BEJB_MX1_UNI_DELETE) REFERENCES BEJB_MX1_UNI_DELETE (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_DELETE ADD CONSTRAINT FK2_FOR_BEJB_MX1_1 FOREIGN KEY (FK2_FOR_BEJB_MX1_UNI_DELETE) REFERENCES BEJB_MX1_UNI_DELETE (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_DELETE ADD CONSTRAINT FK3_FOR_BEJB_MX1_1 FOREIGN KEY (FK3_FOR_BEJB_MX1_UNI_DELETE) REFERENCES BEJB_MX1_UNI_DELETE (ID) ;

ALTER TABLE BEANEJB_MX1_UNI_DELETE ADD CONSTRAINT FK4_FOR_BEJB_MX1_1 FOREIGN KEY (FK4_FOR_BEJB_MX1_UNI_DELETE) REFERENCES BEJB_MX1_UNI_DELETE (ID) ;

ALTER TABLE BEJB_MX1_UNI_DELETE ADD CONSTRAINT FK_FOR_AEJB_MX1_U1 FOREIGN KEY (FK_FOR_AEJB_MX1_UNI_DELETE) REFERENCES AEJB_MX1_UNI_DELETE (ID) ;

DROP TABLE FKEYS_MXM_BI_BTOB;
CREATE TABLE FKEYS_MXM_BI_BTOB ( FK_FOR_AEJB_MXM_BI_BTOB VARCHAR(255)  NOT NULL, FK_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) );

DROP TABLE BEANEJB_MXM_BI_BTOB;
CREATE TABLE BEANEJB_MXM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_MXM_BI_BTOB VARCHAR(255) , FK2_FOR_AEJB_MXM_BI_BTOB VARCHAR(255) , FK3_FOR_AEJB_MXM_BI_BTOB VARCHAR(255) , FK4_FOR_AEJB_MXM_BI_BTOB VARCHAR(255) , FK1_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) , FK2_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) , FK3_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) , FK4_FOR_BEJB_MXM_BI_BTOB VARCHAR(255) );

DROP TABLE AEJB_MXM_BI_BTOB;
CREATE TABLE AEJB_MXM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

DROP TABLE BEJB_MXM_BI_BTOB;
CREATE TABLE BEJB_MXM_BI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

ALTER TABLE BEANEJB_MXM_BI_BTOB ADD CONSTRAINT FK1_FOR_AEJB_MXM_B FOREIGN KEY (FK1_FOR_AEJB_MXM_BI_BTOB) REFERENCES AEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_BI_BTOB ADD CONSTRAINT FK2_FOR_AEJB_MXM_B FOREIGN KEY (FK2_FOR_AEJB_MXM_BI_BTOB) REFERENCES AEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_BI_BTOB ADD CONSTRAINT FK3_FOR_AEJB_MXM_B FOREIGN KEY (FK3_FOR_AEJB_MXM_BI_BTOB) REFERENCES AEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_BI_BTOB ADD CONSTRAINT FK4_FOR_AEJB_MXM_B FOREIGN KEY (FK4_FOR_AEJB_MXM_BI_BTOB) REFERENCES AEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_BI_BTOB ADD CONSTRAINT FK1_FOR_BEJB_MXM_B FOREIGN KEY (FK1_FOR_BEJB_MXM_BI_BTOB) REFERENCES BEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_BI_BTOB ADD CONSTRAINT FK2_FOR_BEJB_MXM_B FOREIGN KEY (FK2_FOR_BEJB_MXM_BI_BTOB) REFERENCES BEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_BI_BTOB ADD CONSTRAINT FK3_FOR_BEJB_MXM_B FOREIGN KEY (FK3_FOR_BEJB_MXM_BI_BTOB) REFERENCES BEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_BI_BTOB ADD CONSTRAINT FK4_FOR_BEJB_MXM_B FOREIGN KEY (FK4_FOR_BEJB_MXM_BI_BTOB) REFERENCES BEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE FKEYS_MXM_BI_BTOB ADD CONSTRAINT FK_FOR_AEJB_MXM_BI FOREIGN KEY (FK_FOR_AEJB_MXM_BI_BTOB) REFERENCES AEJB_MXM_BI_BTOB (ID) ;

ALTER TABLE FKEYS_MXM_BI_BTOB ADD CONSTRAINT FK_FOR_BEJB_MXM_BI FOREIGN KEY (FK_FOR_BEJB_MXM_BI_BTOB) REFERENCES BEJB_MXM_BI_BTOB (ID) ;

DROP TABLE BEANEJB_MXM_BI_DELETE;
CREATE TABLE BEANEJB_MXM_BI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_MXM_BI_DELETE VARCHAR(255) , FK2_FOR_AEJB_MXM_BI_DELETE VARCHAR(255) , FK3_FOR_AEJB_MXM_BI_DELETE VARCHAR(255) , FK4_FOR_AEJB_MXM_BI_DELETE VARCHAR(255) , FK1_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) , FK2_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) , FK3_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) , FK4_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) );

DROP TABLE FKEYS_MXM_BI_DELETE;
CREATE TABLE FKEYS_MXM_BI_DELETE ( FK_FOR_AEJB_MXM_BI_DELETE VARCHAR(255)  NOT NULL, FK_FOR_BEJB_MXM_BI_DELETE VARCHAR(255) );

DROP TABLE AEJB_MXM_BI_DELETE;
CREATE TABLE AEJB_MXM_BI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

DROP TABLE BEJB_MXM_BI_DELETE;
CREATE TABLE BEJB_MXM_BI_DELETE ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);


ALTER TABLE BEANEJB_MXM_BI_DELETE ADD CONSTRAINT FK1_FOR_AEJB_MXM_1 FOREIGN KEY (FK1_FOR_AEJB_MXM_BI_DELETE) REFERENCES AEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_MXM_BI_DELETE ADD CONSTRAINT FK2_FOR_AEJB_MXM_1 FOREIGN KEY (FK2_FOR_AEJB_MXM_BI_DELETE) REFERENCES AEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_MXM_BI_DELETE ADD CONSTRAINT FK3_FOR_AEJB_MXM_1 FOREIGN KEY (FK3_FOR_AEJB_MXM_BI_DELETE) REFERENCES AEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_MXM_BI_DELETE ADD CONSTRAINT FK4_FOR_AEJB_MXM_1 FOREIGN KEY (FK4_FOR_AEJB_MXM_BI_DELETE) REFERENCES AEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_MXM_BI_DELETE ADD CONSTRAINT FK1_FOR_BEJB_MXM_1 FOREIGN KEY (FK1_FOR_BEJB_MXM_BI_DELETE) REFERENCES BEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_MXM_BI_DELETE ADD CONSTRAINT FK2_FOR_BEJB_MXM_1 FOREIGN KEY (FK2_FOR_BEJB_MXM_BI_DELETE) REFERENCES BEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_MXM_BI_DELETE ADD CONSTRAINT FK3_FOR_BEJB_MXM_1 FOREIGN KEY (FK3_FOR_BEJB_MXM_BI_DELETE) REFERENCES BEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE BEANEJB_MXM_BI_DELETE ADD CONSTRAINT FK4_FOR_BEJB_MXM_1 FOREIGN KEY (FK4_FOR_BEJB_MXM_BI_DELETE) REFERENCES BEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE FKEYS_MXM_BI_DELETE ADD CONSTRAINT FK_FOR_AEJB_MXM_B1 FOREIGN KEY (FK_FOR_AEJB_MXM_BI_DELETE) REFERENCES AEJB_MXM_BI_DELETE (ID) ;

ALTER TABLE FKEYS_MXM_BI_DELETE ADD CONSTRAINT FK_FOR_BEJB_MXM_B1 FOREIGN KEY (FK_FOR_BEJB_MXM_BI_DELETE) REFERENCES BEJB_MXM_BI_DELETE (ID) ;

DROP TABLE FKEYS_MXM_UNI_BTOB;
CREATE TABLE FKEYS_MXM_UNI_BTOB ( FK_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255)  NOT NULL, FK_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) );

DROP TABLE BEANEJB_MXM_UNI_BTOB;
CREATE TABLE BEANEJB_MXM_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL, FK1_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255) , FK2_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255) , FK3_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255) , FK4_FOR_AEJB_MXM_UNI_BTOB VARCHAR(255) , FK1_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) , FK2_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) , FK3_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) , FK4_FOR_BEJB_MXM_UNI_BTOB VARCHAR(255) );

DROP TABLE AEJB_MXM_UNI_BTOB;
CREATE TABLE AEJB_MXM_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0) NOT NULL);

DROP TABLE BEJB_MXM_UNI_BTOB;
CREATE TABLE BEJB_MXM_UNI_BTOB ( ID VARCHAR(255)   PRIMARY KEY NOT NULL, NAME VARCHAR(255) , VALUE DECIMAL(18,0)  NOT NULL );

ALTER TABLE BEANEJB_MXM_UNI_BTOB ADD CONSTRAINT FK1_FOR_AEJB_MXM_U FOREIGN KEY (FK1_FOR_AEJB_MXM_UNI_BTOB) REFERENCES AEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_UNI_BTOB ADD CONSTRAINT FK2_FOR_AEJB_MXM_U FOREIGN KEY (FK2_FOR_AEJB_MXM_UNI_BTOB) REFERENCES AEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_UNI_BTOB ADD CONSTRAINT FK3_FOR_AEJB_MXM_U FOREIGN KEY (FK3_FOR_AEJB_MXM_UNI_BTOB) REFERENCES AEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_UNI_BTOB ADD CONSTRAINT FK4_FOR_AEJB_MXM_U FOREIGN KEY (FK4_FOR_AEJB_MXM_UNI_BTOB) REFERENCES AEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_UNI_BTOB ADD CONSTRAINT FK1_FOR_BEJB_MXM_U FOREIGN KEY (FK1_FOR_BEJB_MXM_UNI_BTOB) REFERENCES BEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_UNI_BTOB ADD CONSTRAINT FK2_FOR_BEJB_MXM_U FOREIGN KEY (FK2_FOR_BEJB_MXM_UNI_BTOB) REFERENCES BEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_UNI_BTOB ADD CONSTRAINT FK3_FOR_BEJB_MXM_U FOREIGN KEY (FK3_FOR_BEJB_MXM_UNI_BTOB) REFERENCES BEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE BEANEJB_MXM_UNI_BTOB ADD CONSTRAINT FK4_FOR_BEJB_MXM_U FOREIGN KEY (FK4_FOR_BEJB_MXM_UNI_BTOB) REFERENCES BEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE FKEYS_MXM_UNI_BTOB ADD CONSTRAINT FK_FOR_AEJB_MXM_UN FOREIGN KEY (FK_FOR_AEJB_MXM_UNI_BTOB) REFERENCES AEJB_MXM_UNI_BTOB (ID) ;

ALTER TABLE FKEYS_MXM_UNI_BTOB ADD CONSTRAINT FK_FOR_BEJB_MXM_UN FOREIGN KEY (FK_FOR_BEJB_MXM_UNI_BTOB) REFERENCES BEJB_MXM_UNI_BTOB (ID) ;

DROP TABLE PKEY;
CREATE TABLE PKEY ( PMIDINTEGER INT  NOT NULL, PMIDSTRING VARCHAR(25) NOT NULL, PMIDFLOAT REAL NOT NULL, BRANDNAME VARCHAR(25) , PRICE REAL , CONSTRAINT PK_PKEY PRIMARY KEY (PMIDINTEGER, PMIDSTRING, PMIDFLOAT));

DROP TABLE DATATYPES;
CREATE TABLE DATATYPES ( ID INT NOT NULL, BOOLEANDATA BOOLEAN, CHARDATA CHAR, SHORTDATA SMALLINT, INTDATA INT, INTDATA2 INT, LONGDATA BIGINT, DBLDATA DOUBLE, FLOATDATA FLOAT, ENUMODATA INT, ENUMSDATA VARCHAR(25), BYTEDATA SMALLINT, TRANS SMALLINT , BYTEARRAYDATA BLOB(6M), CHARARRAYDATA VARCHAR(448), CONSTRAINT PK_DATATYPES PRIMARY KEY (ID));

DROP TABLE DATATYPES2;
CREATE TABLE DATATYPES2 ( DATATYPES2_ID DATE NOT NULL, DATEDATA DATE, TIMEDATA TIME, TSDATA TIMESTAMP, CONSTRAINT PK_DATATYPES2 PRIMARY KEY (DATATYPES2_ID));

DROP TABLE DATATYPES3;
CREATE TABLE DATATYPES3 ( ID DECIMAL(18,0) NOT NULL, THEVALUE DECIMAL(18,0), CONSTRAINT PK_DATATYPES3 PRIMARY KEY (ID));

DROP TABLE PURCHASE_ORDER;
CREATE TABLE PURCHASE_ORDER (ID INT NOT NULL, TOTAL INT, DESCRIPTION VARCHAR(50), CONSTRAINT PK_PURCHASE_ORDER PRIMARY KEY (ID));

DROP TABLE GENERATOR_TABLE;
CREATE TABLE GENERATOR_TABLE (PK_COL VARCHAR(10), VAL_COL INT, CONSTRAINT GENERATOR_TABLE_PK PRIMARY KEY (PK_COL) );
INSERT into GENERATOR_TABLE(PK_COL, VAL_COL) values ('DT_ID', 1) ;
INSERT into GENERATOR_TABLE(PK_COL, VAL_COL) values ('DT1_ID', 1) ;
INSERT into GENERATOR_TABLE(PK_COL, VAL_COL) values ('DT2_ID', 100) ;
INSERT into GENERATOR_TABLE(PK_COL, VAL_COL) values ('DT3_ID', 1000) ;

DROP TABLE SEQUENCE;
CREATE TABLE SEQUENCE (SEQ_NAME VARCHAR(10), SEQ_COUNT INT, CONSTRAINT SEQUENCE_PK PRIMARY KEY (SEQ_NAME) );
INSERT into SEQUENCE(SEQ_NAME, SEQ_COUNT) values ('SEQ_GEN', 0) ;

DROP TABLE ORDER1;
CREATE TABLE ORDER1 (ID INT PRIMARY KEY NOT NULL, TOTALPRICE DOUBLE , FK1_FOR_ITEM INT);

DROP TABLE ORDER2;
CREATE TABLE ORDER2 (ID INT PRIMARY KEY NOT NULL, TOTALPRICE DOUBLE , FK2_FOR_ITEM INT);

DROP TABLE ORDER3;
CREATE TABLE ORDER3 (ID INT PRIMARY KEY NOT NULL, TOTALPRICE DOUBLE , FK3_FOR_ITEM INT);


DROP TABLE ITEM ;
CREATE TABLE ITEM (ID INT PRIMARY KEY, ITEMNAME VARCHAR(255)) ;

ALTER TABLE ORDER1 add constraint FK1_FOR_ITEM Foreign Key (FK1_FOR_ITEM) references ITEM(ID) ;
ALTER TABLE ORDER2 add constraint FK2_FOR_ITEM Foreign Key (FK2_FOR_ITEM) references ITEM(ID) ;
ALTER TABLE ORDER3 add constraint FK3_FOR_ITEM Foreign Key (FK3_FOR_ITEM) references ITEM(ID) ;

DROP TABLE MEMBER ;
CREATE TABLE MEMBER (MEMBER_ID INT NOT NULL, MEMBER_NAME VARCHAR(255), DUES SMALLINT, VERSION INT, DONATION DECIMAL(18,0), CONSTRAINT PK_MEMBER PRIMARY KEY (MEMBER_ID)) ;

DROP TABLE ACCOUNT ;
CREATE TABLE ACCOUNT (ID INT NOT NULL, BALANCE DOUBLE, DEPOSIT DOUBLE, WITHDRAW DOUBLE, CONSTRAINT PK_ACCOUNT PRIMARY KEY (ID)) ;

DROP TABLE SEMESTER ;
CREATE TABLE SEMESTER (ID INTEGER NOT NULL, PRIMARY KEY (ID)) ;

DROP TABLE STUDENT_COURSE ;
CREATE TABLE STUDENT_COURSE (Student_ID INTEGER NOT NULL, courses_ID INTEGER NOT NULL, PRIMARY KEY (Student_ID, courses_ID)) ;

DROP TABLE STUDENT ;
CREATE TABLE STUDENT (ID INTEGER NOT NULL, STUDENTNAME VARCHAR(255), PRIMARY KEY (ID)) ;

DROP TABLE COURSE ;
CREATE TABLE COURSE (ID INTEGER NOT NULL, COURSENAME VARCHAR(255), PRIMARY KEY (ID)) ;

DROP TABLE ENROLLMENTS ;
CREATE TABLE ENROLLMENTS (STUDENT INTEGER NOT NULL, ENROLLMENT_KEY INTEGER NOT NULL, SEMESTER INTEGER NOT NULL, PRIMARY KEY (STUDENT, ENROLLMENT_KEY, SEMESTER));

DROP TABLE COURSE_STUDENT ;
CREATE TABLE COURSE_STUDENT (COURSE_ID INTEGER NOT NULL, STUDENT_ID INTEGER NOT NULL, STUDENTS_ORDER INTEGER, PRIMARY KEY (COURSE_ID , STUDENT_ID)); 

ALTER TABLE STUDENT_COURSE ADD CONSTRAINT STDNTCOURSEStdntID FOREIGN KEY (Student_ID) REFERENCES STUDENT (ID) ;
ALTER TABLE STUDENT_COURSE ADD CONSTRAINT STDNTCOURSEcrsesID FOREIGN KEY (courses_ID) REFERENCES COURSE (ID) ;
ALTER TABLE ENROLLMENTS ADD CONSTRAINT ENROLLMENTSSTUDENT FOREIGN KEY (STUDENT) REFERENCES STUDENT (ID) ;
ALTER TABLE ENROLLMENTS ADD CONSTRAINT NROLLMENTSSEMESTER FOREIGN KEY (SEMESTER) REFERENCES SEMESTER (ID) ;
ALTER TABLE COURSE_STUDENT ADD CONSTRAINT CRSESTUDENTCurseID FOREIGN KEY (COURSE_ID) REFERENCES COURSE (ID) ;
ALTER TABLE COURSE_STUDENT ADD CONSTRAINT CRSSTUDENTstdntsID FOREIGN KEY (STUDENT_ID) REFERENCES STUDENT (ID) ;

DROP TABLE NOENTITYLISTENER_TABLE;
CREATE TABLE NOENTITYLISTENER_TABLE(ID BIGINT  PRIMARY KEY NOT NULL);

DROP TABLE COURSE_2;
CREATE TABLE COURSE_2(ID BIGINT NOT NULL,NAME VARCHAR(255));

DROP TABLE STUDENT_2;
CREATE TABLE STUDENT_2(ID BIGINT NOT NULL,NAME VARCHAR(255));

DROP TABLE STUDENT_2_COURSE_2;
CREATE TABLE STUDENT_2_COURSE_2(COURSES_ID BIGINT,STUDENTS_ID BIGINT);

DROP TABLE NAMEONLYINXML;
CREATE TABLE NAMEONLYINXML(ID BIGINT);

DROP TABLE NAMEONLYINANNOTATION;
CREATE TABLE NAMEONLYINANNOTATION(ID BIGINT);

DROP TABLE NAMEOVERRIDE;
CREATE TABLE NAMEOVERRIDE (ID BIGINT);

DROP TABLE NOENTITYANNOTATION;
CREATE TABLE  NOENTITYANNOTATION(ID BIGINT);

DROP TABLE BOOKSTORE;
CREATE TABLE BOOKSTORE(ID BIGINT NOT NULL,NAME VARCHAR(255),LOCATION VARCHAR(255));

DROP TABLE COMPLAINT;
CREATE TABLE COMPLAINT(ID BIGINT NOT NULL, COMPLAINTNUMBER INT, NAME VARCHAR(255), ADDRESS VARCHAR(255));

DROP TABLE MOVIETICKET;
CREATE TABLE MOVIETICKET(ID BIGINT NOT NULL, FILMNAME VARCHAR(255), FILMCODE VARCHAR(255));

DROP TABLE BOOK;
CREATE TABLE BOOK(ID BIGINT NOT NULL, NAME VARCHAR(255), STATEOFUSA VARCHAR(255));

DROP TABLE LAWBOOK;
CREATE TABLE LAWBOOK(ID BIGINT NOT NULL, BOOK_NAME VARCHAR(255), CATEGORY VARCHAR(255),PUBLISHER VARCHAR(255),COST INT);

DROP TABLE EMPLOYEE_2;
CREATE TABLE EMPLOYEE_2(ID BIGINT NOT NULL, CODE  VARCHAR(255), DEPARTMENT_ID BIGINT);

DROP TABLE DEPARTMENT_2;
CREATE TABLE DEPARTMENT_2(ID BIGINT NOT NULL,NAME  VARCHAR(255));

DROP TABLE THEATRELOCATION;
CREATE TABLE THEATRELOCATION(ID BIGINT NOT NULL, CODE  VARCHAR(255));

DROP TABLE THEATRECOMPANY;
CREATE TABLE THEATRECOMPANY(ID BIGINT NOT NULL,NAME  VARCHAR(255));

DROP TABLE THEATRELOCATION_THEATRECOMPANY;
CREATE TABLE THEATRELOCATION_THEATRECOMPANY(COMPANIES_ID BIGINT, LOCATIONS_ID BIGINT);

DROP TABLE STORE;
CREATE TABLE STORE(ID BIGINT NOT NULL, NAME VARCHAR(255));

DROP TABLE CUSTOMERS;
CREATE TABLE CUSTOMERS(ID BIGINT NOT NULL, CUSTNAME VARCHAR(255), STORE_ID BIGINT);

DROP TABLE CONSUMER;
CREATE TABLE CONSUMER(ID BIGINT NOT NULL);

DROP TABLE RETAILORDER;
CREATE TABLE RETAILORDER(ID BIGINT NOT NULL, COST DOUBLE);

DROP TABLE RETAILORDER_CONSUMER;
CREATE TABLE RETAILORDER_CONSUMER(CONSUMERS_ID  BIGINT NOT NULL,ORDERS_ID  BIGINT NOT NULL);

DROP TABLE THEATRELOCATION1;
CREATE TABLE THEATRELOCATION1(ID BIGINT NOT NULL, CODE  VARCHAR(255),TCOMP_ID BIGINT);

DROP TABLE THEATRECOMPANY1;
CREATE TABLE THEATRECOMPANY1(ID BIGINT NOT NULL,NAME  VARCHAR(255));

DROP TABLE CUBICLE;
CREATE TABLE CUBICLE(ID BIGINT NOT NULL , LOCATION VARCHAR(255), PRIMARY KEY(ID,LOCATION));

DROP TABLE HARDWARE;
CREATE TABLE HARDWARE(ID BIGINT NOT NULL, CODE VARCHAR(255),CUBE_ID BIGINT NOT NULL, CUBE_LOCATION VARCHAR(255));

DROP TABLE CUSTOMER1;
CREATE TABLE CUSTOMER1(ID BIGINT NOT NULL, NAME VARCHAR(255), CONSTRAINT PK_CUSTOMER1 PRIMARY KEY (ID));

DROP TABLE RETAILORDER1;
CREATE  TABLE RETAILORDER1(ID BIGINT NOT NULL, COST DOUBLE);

DROP TABLE CUST_ORDER;
CREATE TABLE  CUST_ORDER(CUSTID BIGINT NOT NULL,ORDERID BIGINT NOT NULL);


DROP TABLE RETAILORDER2;
CREATE  TABLE RETAILORDER2(ID BIGINT NOT NULL, COST DOUBLE, FK_FOR_CUSTOMER1 BIGINT );

ALTER TABLE RETAILORDER2 ADD CONSTRAINT FK_FOR_CUST FOREIGN KEY(FK_FOR_CUSTOMER1) REFERENCES CUSTOMER1(ID);

ALTER TABLE UNI1X1PERSON DROP CONSTRAINT N1X1PRSNPRJCTPRJID;
DROP TABLE UNI1X1PROJECT;
DROP TABLE UNI1X1PERSON;


CREATE TABLE UNI1X1PROJECT (PROJID BIGINT NOT NULL, BUDGET FLOAT, NAME VARCHAR(255), PRIMARY KEY (PROJID));
CREATE TABLE UNI1X1PERSON (ID BIGINT NOT NULL, NAME VARCHAR(255), PROJECT_PROJID BIGINT, PRIMARY KEY (ID));
ALTER TABLE UNI1X1PERSON ADD CONSTRAINT N1X1PRSNPRJCTPRJID FOREIGN KEY (PROJECT_PROJID) REFERENCES UNI1X1PROJECT (PROJID);


ALTER TABLE UNI1XMPERSON_UNI1XMPROJECT DROP CONSTRAINT N1XMPRSNNn1XMPrsnD;
ALTER TABLE UNI1XMPERSON_UNI1XMPROJECT DROP CONSTRAINT N1XMPRSNN1XprjctsD;
DROP TABLE UNI1XMPERSON_UNI1XMPROJECT;
DROP TABLE UNI1XMPROJECT;
DROP TABLE UNI1XMPERSON;

CREATE TABLE UNI1XMPERSON_UNI1XMPROJECT (Uni1XMPerson_ID BIGINT NOT NULL, projects_ID BIGINT NOT NULL, PRIMARY KEY (Uni1XMPerson_ID, projects_ID));
CREATE TABLE UNI1XMPROJECT (ID BIGINT NOT NULL, NAME VARCHAR(255), BUDGET FLOAT, PRIMARY KEY (ID));
CREATE TABLE UNI1XMPERSON (ID BIGINT NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID));
ALTER TABLE UNI1XMPERSON_UNI1XMPROJECT ADD CONSTRAINT N1XMPRSNNn1XMPrsnD FOREIGN KEY (Uni1XMPerson_ID) REFERENCES UNI1XMPERSON (ID);
ALTER TABLE UNI1XMPERSON_UNI1XMPROJECT ADD CONSTRAINT N1XMPRSNN1XprjctsD FOREIGN KEY (projects_ID) REFERENCES UNI1XMPROJECT (ID);


ALTER TABLE UNIMX1PERSON DROP CONSTRAINT NMX1PRSNNMX1PRJCTD;
DROP TABLE UNIMX1PROJECT;
DROP TABLE UNIMX1PERSON;

CREATE TABLE UNIMX1PROJECT (ID BIGINT NOT NULL, NAME VARCHAR(255), BUDGET FLOAT, PRIMARY KEY (ID));
CREATE TABLE UNIMX1PERSON (ID BIGINT NOT NULL, NAME VARCHAR(255), UNIMX1PROJECT_ID BIGINT, PRIMARY KEY (ID));
ALTER TABLE UNIMX1PERSON ADD CONSTRAINT NMX1PRSNNMX1PRJCTD FOREIGN KEY (UNIMX1PROJECT_ID) REFERENCES UNIMX1PROJECT (ID);


ALTER TABLE UNIMXMPERSON_UNIMXMPROJECT DROP CONSTRAINT NMXMPRSNNnMXMPrsnD;
ALTER TABLE UNIMXMPERSON_UNIMXMPROJECT DROP CONSTRAINT NMXMPRSNnMXMPrjctD;
DROP TABLE UNIMXMPERSON;
DROP TABLE UNIMXMPROJECT;
DROP TABLE UNIMXMPERSON_UNIMXMPROJECT;

CREATE TABLE UNIMXMPERSON (ID BIGINT NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID));
CREATE TABLE UNIMXMPROJECT (ID BIGINT NOT NULL, NAME VARCHAR(255), BUDGET FLOAT, PRIMARY KEY (ID));
CREATE TABLE UNIMXMPERSON_UNIMXMPROJECT (UniMXMPerson_ID BIGINT NOT NULL, UniMXMProject_ID BIGINT NOT NULL, PRIMARY KEY (UniMXMPerson_ID, UniMXMProject_ID));
ALTER TABLE UNIMXMPERSON_UNIMXMPROJECT ADD CONSTRAINT NMXMPRSNNnMXMPrsnD FOREIGN KEY (UniMXMPerson_ID) REFERENCES UNIMXMPERSON (ID);
ALTER TABLE UNIMXMPERSON_UNIMXMPROJECT ADD CONSTRAINT NMXMPRSNnMXMPrjctD FOREIGN KEY (UniMXMProject_ID) REFERENCES UNIMXMPROJECT (ID);


ALTER TABLE BIDIR1X1PERSON DROP CONSTRAINT BDR1X1PRSPRJCTPRJD;
DROP TABLE BIDIR1X1PERSON;
DROP TABLE BIDIR1X1PROJECT;

CREATE TABLE BIDIR1X1PERSON (ID BIGINT NOT NULL, NAME VARCHAR(255), PROJECT_PROJID BIGINT, PRIMARY KEY (ID));
CREATE TABLE BIDIR1X1PROJECT (PROJID BIGINT NOT NULL, BUDGET FLOAT, NAME VARCHAR(255), PRIMARY KEY (PROJID));
ALTER TABLE BIDIR1X1PERSON ADD CONSTRAINT BDR1X1PRSPRJCTPRJD FOREIGN KEY (PROJECT_PROJID) REFERENCES BIDIR1X1PROJECT (PROJID);


ALTER TABLE BIDIR1XMPROJECT DROP CONSTRAINT BDR1XMPBDR1XMPRSND;
DROP TABLE BIDIR1XMPERSON;
DROP TABLE BIDIR1XMPROJECT;

CREATE TABLE BIDIR1XMPERSON (ID BIGINT NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID));
CREATE TABLE BIDIR1XMPROJECT (ID BIGINT NOT NULL, NAME VARCHAR(255), BUDGET FLOAT, BIDIR1XMPERSON_ID BIGINT, PRIMARY KEY (ID));
ALTER TABLE BIDIR1XMPROJECT ADD CONSTRAINT BDR1XMPBDR1XMPRSND FOREIGN KEY (BIDIR1XMPERSON_ID) REFERENCES BIDIR1XMPERSON (ID);


ALTER TABLE BIDIRMX1PERSON DROP CONSTRAINT BDRMX1PRNMX1PRJCTD;
DROP TABLE BIDIRMX1PROJECT;
DROP TABLE BIDIRMX1PERSON;

CREATE TABLE BIDIRMX1PROJECT (ID BIGINT NOT NULL, NAME VARCHAR(255), BUDGET FLOAT, PRIMARY KEY (ID));
CREATE TABLE BIDIRMX1PERSON (ID BIGINT NOT NULL, NAME VARCHAR(255), UNIMX1PROJECT_ID BIGINT, PRIMARY KEY (ID));
ALTER TABLE BIDIRMX1PERSON ADD CONSTRAINT BDRMX1PRNMX1PRJCTD FOREIGN KEY (UNIMX1PROJECT_ID) REFERENCES BIDIRMX1PROJECT (ID);


ALTER TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT DROP CONSTRAINT BDRMXMPBDRMXMPrsnD;
ALTER TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT DROP CONSTRAINT BDRMXMBDRMXMPrjctD;
DROP TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT;
DROP TABLE BIDIRMXMPERSON;
DROP TABLE BIDIRMXMPROJECT;

CREATE TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT (BIDIRMXMPerson_ID BIGINT NOT NULL, BIDIRMXMProject_ID BIGINT NOT NULL, PRIMARY KEY (BIDIRMXMPerson_ID, BIDIRMXMProject_ID));
CREATE TABLE BIDIRMXMPERSON (ID BIGINT NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID));
CREATE TABLE BIDIRMXMPROJECT (ID BIGINT NOT NULL, NAME VARCHAR(255), BUDGET FLOAT, PRIMARY KEY (ID));
ALTER TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT ADD CONSTRAINT BDRMXMPBDRMXMPrsnD FOREIGN KEY (BIDIRMXMPerson_ID) REFERENCES BIDIRMXMPERSON (ID);
ALTER TABLE BIDIRMXMPERSON_BIDIRMXMPROJECT ADD CONSTRAINT BDRMXMBDRMXMPrjctD FOREIGN KEY (BIDIRMXMProject_ID) REFERENCES BIDIRMXMPROJECT (ID);


ALTER TABLE DID1DEPENDENT DROP CONSTRAINT DID1DEPENDENTEMPID;
DROP TABLE DID1DEPENDENT;
DROP TABLE DID1EMPLOYEE;

CREATE TABLE DID1DEPENDENT (NAME VARCHAR(255) NOT NULL, EMP_ID BIGINT NOT NULL, PRIMARY KEY (NAME, EMP_ID));
CREATE TABLE DID1EMPLOYEE (ID BIGINT NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID));
ALTER TABLE DID1DEPENDENT ADD CONSTRAINT DID1DEPENDENTEMPID FOREIGN KEY (EMP_ID) REFERENCES DID1EMPLOYEE (ID);


ALTER TABLE DID1BDEPENDENT DROP CONSTRAINT DID1BDEPENDENTMPID;
DROP TABLE DID1BDEPENDENT;
DROP TABLE DID1BEMPLOYEE;

CREATE TABLE DID1BDEPENDENT (NAME VARCHAR(255) NOT NULL, EMP_ID BIGINT, PRIMARY KEY (NAME, EMP_ID));
CREATE TABLE DID1BEMPLOYEE (ID BIGINT NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID));
ALTER TABLE DID1BDEPENDENT ADD CONSTRAINT DID1BDEPENDENTMPID FOREIGN KEY (EMP_ID) REFERENCES DID1BEMPLOYEE (ID);


ALTER TABLE DID2DEPENDENT DROP CONSTRAINT DD2DPENDENTFRSTNME;
DROP TABLE DID2EMPLOYEE;
DROP TABLE DID2DEPENDENT;

CREATE TABLE DID2EMPLOYEE (FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, EMPNO INTEGER, PRIMARY KEY (FIRSTNAME, LASTNAME));
CREATE TABLE DID2DEPENDENT (NAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (NAME, FIRSTNAME, LASTNAME));
ALTER TABLE DID2DEPENDENT ADD CONSTRAINT DD2DPENDENTFRSTNME FOREIGN KEY (FIRSTNAME, LASTNAME) REFERENCES DID2EMPLOYEE (FIRSTNAME, LASTNAME);


ALTER TABLE DID2BDEPENDENT DROP CONSTRAINT DD2BDPENDENTLSTNME;
DROP TABLE DID2BEMPLOYEE;
DROP TABLE DID2BDEPENDENT;

CREATE TABLE DID2BEMPLOYEE (LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, EMPNO INTEGER, PRIMARY KEY (LASTNAME, FIRSTNAME));
CREATE TABLE DID2BDEPENDENT (NAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (NAME, LASTNAME, FIRSTNAME));
ALTER TABLE DID2BDEPENDENT ADD CONSTRAINT DD2BDPENDENTLSTNME FOREIGN KEY (LASTNAME, FIRSTNAME) REFERENCES DID2BEMPLOYEE (LASTNAME, FIRSTNAME);


ALTER TABLE DID3DEPENDENT DROP CONSTRAINT DD3DPENDENTFRSTNME;
DROP TABLE DID3EMPLOYEE;
DROP TABLE DID3DEPENDENT;

CREATE TABLE DID3EMPLOYEE (FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (FIRSTNAME, LASTNAME));
CREATE TABLE DID3DEPENDENT (NAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (NAME, FIRSTNAME, LASTNAME));
ALTER TABLE DID3DEPENDENT ADD CONSTRAINT DD3DPENDENTFRSTNME FOREIGN KEY (FIRSTNAME, LASTNAME) REFERENCES DID3EMPLOYEE (FIRSTNAME, LASTNAME);


ALTER TABLE DID3BDEPENDENT DROP CONSTRAINT DD3BDPENDENTLSTNME;
DROP TABLE DID3BEMPLOYEE;
DROP TABLE DID3BDEPENDENT;

CREATE TABLE DID3BEMPLOYEE (LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (LASTNAME, FIRSTNAME));
CREATE TABLE DID3BDEPENDENT (NAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (NAME, LASTNAME, FIRSTNAME));
ALTER TABLE DID3BDEPENDENT ADD CONSTRAINT DD3BDPENDENTLSTNME FOREIGN KEY (LASTNAME, FIRSTNAME) REFERENCES DID3BEMPLOYEE (LASTNAME, FIRSTNAME);


ALTER TABLE DID4MEDICALHISTORY DROP CONSTRAINT DD4MDCLHSTRPTNTSSN;
DROP TABLE DID4MEDICALHISTORY;
DROP TABLE DID4PERSON;

CREATE TABLE DID4MEDICALHISTORY (DOCTORNAME VARCHAR(255), PATIENT_SSN VARCHAR(255) NOT NULL, PRIMARY KEY (PATIENT_SSN));
CREATE TABLE DID4PERSON (SSN VARCHAR(255) NOT NULL, NAME VARCHAR(255), PRIMARY KEY (SSN));
ALTER TABLE DID4MEDICALHISTORY ADD CONSTRAINT DD4MDCLHSTRPTNTSSN FOREIGN KEY (PATIENT_SSN) REFERENCES DID4PERSON (SSN);


ALTER TABLE DID4BMEDICALHISTORY DROP CONSTRAINT DD4BMDCLHSTPTNTSSN;
DROP TABLE DID4BMEDICALHISTORY;
DROP TABLE DID4BPERSON;

CREATE TABLE DID4BMEDICALHISTORY (ID VARCHAR(255) NOT NULL, DOCTORNAME VARCHAR(255), PRIMARY KEY (ID));
CREATE TABLE DID4BPERSON (SSN VARCHAR(255) NOT NULL, NAME VARCHAR(255), PRIMARY KEY (SSN));
ALTER TABLE DID4BMEDICALHISTORY ADD CONSTRAINT DD4BMDCLHSTPTNTSSN FOREIGN KEY (ID) REFERENCES DID4BPERSON (SSN);


ALTER TABLE DID5MEDICALHISTORY DROP CONSTRAINT DD5MDCLHSTRYFRSTNM;
DROP TABLE DID5PERSON;
DROP TABLE DID5MEDICALHISTORY;

CREATE TABLE DID5PERSON (FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, SSN VARCHAR(255), PRIMARY KEY (FIRSTNAME, LASTNAME));
CREATE TABLE DID5MEDICALHISTORY (DOCTORNAME VARCHAR(255), FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (FIRSTNAME, LASTNAME));
ALTER TABLE DID5MEDICALHISTORY ADD CONSTRAINT DD5MDCLHSTRYFRSTNM FOREIGN KEY (FIRSTNAME, LASTNAME) REFERENCES DID5PERSON (FIRSTNAME, LASTNAME);


ALTER TABLE DID5BMEDICALHISTORY DROP CONSTRAINT DD5BMDCLHSTRYLSTNM;
DROP TABLE DID5BMEDICALHISTORY;
DROP TABLE DID5BPERSON;

CREATE TABLE DID5BMEDICALHISTORY (DOCTORNAME VARCHAR(255), LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (LASTNAME, FIRSTNAME));
CREATE TABLE DID5BPERSON (LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, SSN VARCHAR(255), PRIMARY KEY (LASTNAME, FIRSTNAME));
ALTER TABLE DID5BMEDICALHISTORY ADD CONSTRAINT DD5BMDCLHSTRYLSTNM FOREIGN KEY (LASTNAME, FIRSTNAME) REFERENCES DID5BPERSON (LASTNAME, FIRSTNAME);


ALTER TABLE DID6MEDICALHISTORY DROP CONSTRAINT DD6MDCLHSTRYFRSTNM;
DROP TABLE DID6MEDICALHISTORY;
DROP TABLE DID6PERSON;

CREATE TABLE DID6MEDICALHISTORY (DOCTORNAME VARCHAR(255), FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (FIRSTNAME, LASTNAME));
CREATE TABLE DID6PERSON (SSN VARCHAR(255), FIRSTNAME VARCHAR(255) NOT NULL, LASTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (FIRSTNAME, LASTNAME));
ALTER TABLE DID6MEDICALHISTORY ADD CONSTRAINT DD6MDCLHSTRYFRSTNM FOREIGN KEY (FIRSTNAME, LASTNAME) REFERENCES DID6PERSON (FIRSTNAME, LASTNAME);

ALTER TABLE DID6BMEDICALHISTORY DROP CONSTRAINT DD6BMDCLHSTRYLSTNM;
DROP TABLE DID6BPERSON;
DROP TABLE DID6BMEDICALHISTORY;

CREATE TABLE DID6BPERSON (SSN VARCHAR(255), LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (LASTNAME, FIRSTNAME));
CREATE TABLE DID6BMEDICALHISTORY (DOCTORNAME VARCHAR(255), LASTNAME VARCHAR(255) NOT NULL, FIRSTNAME VARCHAR(255) NOT NULL, PRIMARY KEY (LASTNAME, FIRSTNAME));
ALTER TABLE DID6BMEDICALHISTORY ADD CONSTRAINT DD6BMDCLHSTRYLSTNM FOREIGN KEY (LASTNAME, FIRSTNAME) REFERENCES DID6BPERSON (LASTNAME, FIRSTNAME);


DROP TABLE EMP_MAPKEYCOL;
CREATE TABLE EMP_MAPKEYCOL(ID INT NOT NULL, FIRSTNAME VARCHAR(255) , LASTNAME VARCHAR(255), HIREDATE DATE, SALARY REAL NOT NULL, STATUS VARCHAR(255),  FK_MGR INT, FK_DEPT INT, FK_DEPT3 INT, FK_DEPT4 INT, FK_PROJECT INT , FK_INS INT, OFFICE_ID VARCHAR(255), LASTNAMEEMPLOYEES_KEY VARCHAR(255), CONSTRAINT PK_EMP PRIMARY KEY (ID)) ;
ALTER TABLE EMP_MAPKEYCOL ADD CONSTRAINT FK_DEPT1 FOREIGN KEY (FK_DEPT) REFERENCES DEPARTMENT (ID) ;
ALTER TABLE EMP_MAPKEYCOL ADD CONSTRAINT FK_DEPT3 FOREIGN KEY (FK_DEPT3) REFERENCES DEPARTMENT (ID) ;
ALTER TABLE EMP_MAPKEYCOL ADD CONSTRAINT FK_DEPT4 FOREIGN KEY (FK_DEPT4) REFERENCES DEPARTMENT (ID) ;

DROP TABLE EMP_MAPKEYCOL2 ;
CREATE TABLE EMP_MAPKEYCOL2(ID INT NOT NULL, LASTNAME VARCHAR(255), THEDATE DATE ,FK_DEPT5 INT,  CONSTRAINT PK_EMP2 PRIMARY KEY (ID)) ;
ALTER TABLE EMP_MAPKEYCOL2 ADD CONSTRAINT FK_DEPT5 FOREIGN KEY (FK_DEPT5) REFERENCES DEPARTMENT2 (ID) ;

ALTER TABLE COLTAB_EMP_EMBEDED_ADDRESS DROP CONSTRAINT FK_EMPEMBADDRID ;
DROP TABLE COLTAB_EMP_EMBEDED_ADDRESS;
DROP TABLE EMPLOYEE_EMBEDED_ADDRESS;
CREATE TABLE EMPLOYEE_EMBEDED_ADDRESS (ID INTEGER NOT NULL, FIRSTNAME VARCHAR(255), LASTNAME VARCHAR(255), PRIMARY KEY (ID));
CREATE TABLE COLTAB_EMP_EMBEDED_ADDRESS (ADDRESS_LOCATION VARCHAR(255), STREET VARCHAR(255), STATE VARCHAR(255), ZIP VARCHAR(255), CITY VARCHAR(255), ID VARCHAR(255), EMPEMBADDRID INTEGER);
ALTER TABLE COLTAB_EMP_EMBEDED_ADDRESS ADD CONSTRAINT FK_EMPEMBADDRID FOREIGN KEY (EMPEMBADDRID) REFERENCES EMPLOYEE_EMBEDED_ADDRESS (ID) ;


DROP SEQUENCE SEQGENERATOR RESTRICT;
CREATE SEQUENCE SEQGENERATOR AS INT START WITH 10;

DROP TABLE UUIDTYPE;
CREATE TABLE UUIDTYPE (ID char(16) for bit data NOT NULL, NAME VARCHAR(255), PRIMARY KEY (ID));

DROP TABLE CRITERIA_TEST_COLTABLE;
DROP TABLE CRITERIA_TEST_TABLE;
CREATE TABLE CRITERIA_TEST_TABLE (ID INTEGER PRIMARY KEY NOT NULL, DATE_VAL DATE, INT_VAL INTEGER, STR_VAL_1 VARCHAR(255), STR_VAL_2 VARCHAR(255), TIME_VAL TIME);
CREATE TABLE CRITERIA_TEST_COLTABLE(ENT_ID INTEGER NOT NULL, COLVAL VARCHAR(255), CONSTRAINT FK_CRITERIA_TEST_COLTABLE_ENT_ID FOREIGN KEY (ENT_ID) REFERENCES CRITERIA_TEST_TABLE (ID));

DROP SEQUENCE DATATYPES_SEQ RESTRICT;
CREATE SEQUENCE DATATYPES_SEQ START WITH 1 INCREMENT by 50;
