/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.usertransaction.getstatus;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.jta.ee.common.Transact;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Properties;

public class UserGetStatusClient
extends ServiceEETest
implements Serializable {
    private static final int SLEEPTIME = 2000;
    private static final String testName = "jta.ee.usertransaction.begin";
    private UserTransaction userTransaction = null;

    public void setup(String[] args, Properties p) throws Exception {
        try {
            Transact.init();
            this.logTrace("Test environment initialized");
            this.userTransaction = (UserTransaction)Transact.nctx.lookup("java:comp/UserTransaction");
            this.logMsg("User Transaction object is Obtained");
            if (this.userTransaction == null) {
                this.logErr("Unable to get User Transaction Instance : Could not proceed with tests");
                throw new Exception("couldnt proceed further");
            }
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.rollback();
            }
        }
        catch (Exception exception) {
            this.logErr("Setup Failed!");
            this.logTrace("Unable to get User Transaction Instance : Could not proceed with tests");
            throw new Exception("Setup Failed", exception);
        }
    }

    public static void main(String[] args) {
        UserGetStatusClient userGetStatusClientInst = new UserGetStatusClient();
        Status s = userGetStatusClientInst.run(args, System.out, System.err);
        s.exit();
    }

    public void testUserGetStatus001() throws Exception {
        try {
            if (this.userTransaction.getStatus() != 6) {
                throw new Exception("Failed to return the statusSTATUS_NO_TRANSACTION");
            }
            this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", exception);
        }
    }

    public void testUserGetStatus002() throws Exception {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() != 0) {
                throw new Exception("Failed to return the status STATUS_ACTIVE");
            }
            this.logMsg("UserTransaction Status is STATUS_ACTIVE");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", exception);
        }
    }

    public void testUserGetStatus003() throws Exception {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                this.userTransaction.commit();
            }
            if (this.userTransaction.getStatus() != 6) {
                throw new Exception("Failed to return the status STATUS_NO_TRANSACTION");
            }
            this.logMsg("UserTransaction Committed");
            this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", exception);
        }
    }

    public void testUserGetStatus004() throws Exception {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            if (this.userTransaction.getStatus() == 0) {
                this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                this.userTransaction.rollback();
            }
            if (this.userTransaction.getStatus() != 6) {
                throw new Exception("Failed to return the status STATUS_NO_TRANSACTION");
            }
            this.logMsg("UserTransaction Rolled back");
            this.logMsg("UserTransaction Status is STATUS_NO_TRANSACTION");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new Exception("UnExpected Exception was caught: Failed", exception);
        }
    }

    public void testUserGetStatus005() throws Exception {
        block10: {
            try {
                int status;
                this.userTransaction.begin();
                this.logMsg("UserTransaction Started");
                if (this.userTransaction.getStatus() == 0) {
                    this.logMsg("UserTransaction Status is STATUS_ACTIVE");
                    this.userTransaction.setRollbackOnly();
                }
                if ((status = this.userTransaction.getStatus()) == 5) {
                    int count = 0;
                    do {
                        this.logTrace("Received STATUS_UNKNOWN. Checking status again.");
                        ++count;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception e) {
                            throw new Exception(e.getCause());
                        }
                    } while ((status = this.userTransaction.getStatus()) == 5 && count < 5);
                }
                if (status == 1) {
                    this.logMsg("UserTransaction marked for Rollback");
                    this.logMsg("UserTransaction Status is STATUS_MARKED_ROLLBACK");
                    break block10;
                }
                if (status == 9 || status == 4 || status == 6) {
                    this.logMsg("UserTransaction marked for Rollback");
                    this.logMsg("UserTransaction is rolling/rolled back");
                    break block10;
                }
                throw new Exception("Failed to return valid status");
            }
            catch (SystemException system) {
                this.logErr("Exception " + system.toString() + " was caught");
                throw new Exception("UnExpected Exception was caught: Failed", system);
            }
            catch (Exception exception) {
                this.logErr("Exception " + exception.toString() + " was caught");
                throw new Exception("UnExpected Exception was caught: Failed", exception);
            }
        }
    }

    public void cleanup() throws Exception {
        block8: {
            try {
                if (this.userTransaction.getStatus() == 0) {
                    Transact.free();
                    try {
                        this.userTransaction.rollback();
                    }
                    catch (Exception exception) {
                        throw new Exception(exception.getCause());
                    }
                    for (int retries = 1; this.userTransaction.getStatus() != 6 && retries <= 5; ++retries) {
                        this.logMsg("cleanup(): retry # " + retries);
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception e) {
                            throw new Exception(e.getCause());
                        }
                    }
                    this.logMsg("Cleanup ok;");
                    break block8;
                }
                this.logMsg("CleanUp not required as Transaction is not in Active state.");
            }
            catch (Exception exception) {
                this.logErr("Cleanup Failed", exception);
                this.logTrace("Could not clean the environment");
            }
        }
    }
}

