/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.war.webinflib;

import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteJsfClientBase;
import com.sun.ts.tests.ejb30.lite.packaging.war.webinflib.BeanBase;
import com.sun.ts.tests.ejb30.lite.packaging.war.webinflib.OneBean;
import com.sun.ts.tests.ejb30.lite.packaging.war.webinflib.ThreeBean;
import com.sun.ts.tests.ejb30.lite.packaging.war.webinflib.TwoBean;
import jakarta.annotation.Resource;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;

@Named(value="client")
@RequestScoped
public class JsfClient
extends EJBLiteJsfClientBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CLIENT_REF_NAME_PREFIX = JsfClient.class.getName();
    private BeanBase one;
    private BeanBase two;
    private BeanBase three;
    @Resource
    private UserTransaction ut;
    private List<BeanBase> beans;

    @Override
    public void setup(String[] args, Properties p) {
        super.setup(args, p);
        this.beans = new ArrayList<BeanBase>();
        this.one = (BeanBase)ServiceLocator.lookupNoTry("java:global/" + this.getModuleName() + "/OneBean", new Context[0]);
        this.two = (BeanBase)ServiceLocator.lookupNoTry("java:global/" + this.getModuleName() + "/TwoBean", new Context[0]);
        this.three = (BeanBase)ServiceLocator.lookupNoTry("java:global/" + this.getModuleName() + "/ThreeBean", new Context[0]);
        this.beans.add(this.one);
        this.beans.add(this.two);
        this.beans.add(this.three);
    }

    public void circularInjection() {
        for (BeanBase b : this.beans) {
            this.assertEquals(b.getInjectionRecords(), true, b.getInjectionStatus());
        }
    }

    public void sameClassLoader() {
        int expected = System.identityHashCode(this.getClass().getClassLoader());
        for (BeanBase b : this.beans) {
            this.assertEquals(null, expected, b.getClassLoaderId());
        }
    }

    public void clientToBeanClassLookup() {
        for (BeanBase b : this.beans) {
            OneBean b1 = (OneBean)ServiceLocator.lookupByShortNameNoTry(b.getRefNamePrefix() + "/one");
            TwoBean b2 = (TwoBean)ServiceLocator.lookupByShortNameNoTry(b.getRefNamePrefix() + "/two");
            ThreeBean b3 = (ThreeBean)ServiceLocator.lookupByShortNameNoTry(b.getRefNamePrefix() + "/three");
            this.verifyBeans(b1, b2, b3);
        }
        UserTransaction u = (UserTransaction)ServiceLocator.lookupByShortNameNoTry(BeanBase.class.getName() + "/ut");
        this.assertNotEquals(null, u, null);
    }

    public void beanClassToClientLookup() {
        for (BeanBase b : this.beans) {
            UserTransaction u = (UserTransaction)b.beanClassToClientLookup(CLIENT_REF_NAME_PREFIX + "/ut");
            this.assertNotEquals(null, u, null);
        }
    }

    public void crossEJBLookup() {
        for (BeanBase lookupFrom : this.beans) {
            for (BeanBase lookupDest : this.beans) {
                OneBean b1 = (OneBean)lookupFrom.lookupWithEJBContext(lookupDest.getRefNamePrefix() + "/one");
                TwoBean b2 = (TwoBean)lookupFrom.lookupWithEJBContext(lookupDest.getRefNamePrefix() + "/two");
                ThreeBean b3 = (ThreeBean)lookupFrom.lookupWithEJBContext(lookupDest.getRefNamePrefix() + "/three");
                this.verifyBeans(b1, b2, b3);
            }
        }
    }

    private void verifyBeans(Object b1, Object b2, Object b3) {
        this.assertEquals(null, this.one, b1);
        this.assertEquals(null, this.two, b2);
        this.assertEquals(null, this.three, b3);
    }
}

