/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.core.urlresource.redirect;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() {
        this.setContextRoot("/jstl_core_url_redirect_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_core_url_redirect_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_core_url_redirect_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeRedirectContextUrlInvalidValueTest.jsp")), "negativeRedirectContextUrlInvalidValueTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeRedirectExcBodyContentTest.jsp")), "negativeRedirectExcBodyContentTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveRedirectParamsBodyTest.jsp")), "positiveRedirectParamsBodyTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveRedirectTest.jsp")), "positiveRedirectTest.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveRedirectTest() throws Exception {
        TEST_PROPS.setProperty("testname", "positiveRedirectTest");
        TEST_PROPS.setProperty("ignore_body", "true");
        TEST_PROPS.setProperty("request", "positiveRedirectTest.jsp?rt1=true");
        TEST_PROPS.setProperty("expected_headers", "Location:  http://" + this._hostname + ":" + this._port + "/jstl_core_url_redirect_web/urlresource/param/import.jsp");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveRedirectTest");
        TEST_PROPS.setProperty("ignore_body", "true");
        TEST_PROPS.setProperty("request", "positiveRedirectTest.jsp?rt2=true");
        TEST_PROPS.setProperty("expected_headers", "Location:  http://" + this._hostname + ":" + this._port + "/jstl_core_url_redirect_web/urlresource/param/import.jsp");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveRedirectTest");
        TEST_PROPS.setProperty("ignore_body", "true");
        TEST_PROPS.setProperty("request", "positiveRedirectTest.jsp?rt3=true");
        TEST_PROPS.setProperty("expected_headers", "Location:  http://" + this._hostname + ":" + this._port + "/jstl_core_url_redirect_web/import.jsp");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveRedirectTest");
        TEST_PROPS.setProperty("ignore_body", "true");
        TEST_PROPS.setProperty("request", "positiveRedirectTest.jsp?rt4=true");
        TEST_PROPS.setProperty("expected_headers", "Location:  http://" + this._hostname + ":" + this._port + "/jstl_core_url_redirect_web/import.jsp");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveRedirectTest");
        TEST_PROPS.setProperty("ignore_body", "true");
        TEST_PROPS.setProperty("request", "positiveRedirectTest.jsp?rt5=true");
        TEST_PROPS.setProperty("expected_headers", "Location:  http://" + this._hostname + ":" + this._port + "/jstl_core_web/urlresource/param/import.jsp");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveRedirectTest");
        TEST_PROPS.setProperty("ignore_body", "true");
        TEST_PROPS.setProperty("request", "positiveRedirectTest.jsp?rt6=true");
        TEST_PROPS.setProperty("expected_headers", "Location:  http://" + this._hostname + ":" + this._port + "/jstl_core_web/urlresource/param/import.jsp");
        this.invoke();
    }

    @Test
    public void positiveRedirectParamsBodyTest() throws Exception {
        TEST_PROPS.setProperty("testname", "positiveRedirectParamsBodyTest");
        TEST_PROPS.setProperty("ignore_body", "true");
        TEST_PROPS.setProperty("request", "positiveRedirectParamsBodyTest.jsp?rt1=true");
        TEST_PROPS.setProperty("expected_headers", "Location:  http://" + this._hostname + ":" + this._port + "/jstl_core_url_redirect_web/urlresource/param/import.jsp?testparm=testval");
        this.invoke();
        TEST_PROPS.setProperty("testname", "positiveRedirectParamsTest");
        TEST_PROPS.setProperty("ignore_body", "true");
        TEST_PROPS.setProperty("request", "positiveRedirectParamsBodyTest.jsp?rt2=true");
        TEST_PROPS.setProperty("expected_headers", "Location:  http://" + this._hostname + ":" + this._port + "/jstl_core_web/urlresource/param/import.jsp?testparm=testval");
        this.invoke();
    }

    @Test
    public void negativeRedirectExcBodyContentTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeRedirectExcBodyContentTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "negativeRedirectExcBodyContentTest");
        TEST_PROPS.setProperty("request", "negativeRedirectExcBodyContentTest.jsp?el=true");
        this.invoke();
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", "negativeRedirectExcBodyContentTest");
        TEST_PROPS.setProperty("request", "negativeRedirectExcBodyContentTest.jsp?rt=true");
        this.invoke();
    }

    @Test
    public void negativeRedirectContextUrlInvalidValueTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeRedirectContextUrlInvalidValueTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "negativeRedirectContextUrlInvalidValueTest");
        this.invoke();
    }
}

