/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.provider.jsonp;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;
import com.sun.ts.tests.jaxrs.common.provider.PrintingErrorHandler;
import com.sun.ts.tests.jaxrs.platform.provider.jsonp.Resource;
import com.sun.ts.tests.jaxrs.platform.provider.jsonp.TSAppConfig;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 7441792527287072853L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_platform_provider_jsonp_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/jaxrs/platform/provider/jsonp/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_platform_provider_jsonp_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, PrintingErrorHandler.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void serverJsonArrayReturnTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "toarray"));
        this.bufferEntity(true);
        this.invoke();
        this.assertResponseContainsRow(0);
        this.assertResponseContainsRow(1);
    }

    @Test
    public void serverJsonStructureReturnTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tostructure"));
        this.bufferEntity(true);
        this.invoke();
        this.assertResponseContainsRow(0);
        this.assertResponseContainsRow(1);
    }

    @Test
    public void serverJsonObjectReturnTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "toobject"));
        this.bufferEntity(true);
        this.invoke();
        this.assertResponseContainsRow(0);
    }

    @Test
    public void serverJsonArrayArgumentTest() throws Exception {
        String entity = Resource.createArray().toString();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "fromarray"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(JAXRSClientIT.getJsonType()));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.invoke();
    }

    @Test
    public void serverJsonStructureArgumentTest() throws Exception {
        String entity = Resource.createArray().toString();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "fromstructure"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(JAXRSClientIT.getJsonType()));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.invoke();
    }

    @Test
    public void serverJsonObjectArgumentTest() throws Exception {
        String entity = Resource.createObject(1).toString();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "fromobject"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(JAXRSClientIT.getJsonType()));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.invoke();
    }

    private void assertResponseContainsRow(int id) throws Exception {
        String content = this.getResponseBody();
        JAXRSClientIT.assertContains(content, Resource.LABEL[0]);
        JAXRSClientIT.assertContains(content, Resource.TYPE[id]);
        JAXRSClientIT.assertContains(content, Resource.LABEL[1]);
        JAXRSClientIT.assertContains(content, Resource.PHONE[id]);
        JAXRSClientIT.logMsg("Found", Resource.createObject(id).toString(), "as expected");
    }

    private static void assertContains(String where, String what) throws Exception {
        JAXRSClientIT.assertContains(where, what, new Object[]{what, "has not been found in", where});
    }

    private static MediaType getJsonType() {
        return new MediaType("application", "json");
    }
}

