/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta8;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dbMetaClient8
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta8";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient8 theTests = new dbMetaClient8();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private boolean columnCompare(String[] sColumnNames, ResultSet rs) throws SQLException, EETest.Fault {
        ResultSetMetaData rsmd = null;
        boolean test_status = false;
        boolean statusColumnCount = true;
        boolean statusColumnMatch = true;
        int iColumnNamesLength = sColumnNames.length;
        rsmd = rs.getMetaData();
        int iCount = rsmd.getColumnCount();
        this.msg.setMsg("iCount - number of columns in this ResultSet " + iCount);
        this.msg.setMsg("Minimum Column Count is:" + iColumnNamesLength);
        if (iColumnNamesLength <= iCount) {
            this.msg.setMsg("Setting iCount to " + iColumnNamesLength);
            iCount = iColumnNamesLength;
        } else {
            statusColumnCount = false;
        }
        this.msg.setMsg("Comparing Column Names...");
        while (iColumnNamesLength > 0) {
            this.msg.setMsg("sColumnNames[iColumnNamesLength-1] " + sColumnNames[iColumnNamesLength - 1] + " and iColumnNamesLength " + iColumnNamesLength);
            this.msg.setMsg("rsmd.getColumnName(iCount) " + rsmd.getColumnName(iCount));
            if (!sColumnNames[iColumnNamesLength - 1].equalsIgnoreCase(rsmd.getColumnName(iCount))) {
                statusColumnMatch = false;
                this.msg.setMsg("*** Error Expected Column name:" + sColumnNames[iColumnNamesLength - 1] + ", Received column:" + rsmd.getColumnName(iCount));
            }
            --iCount;
            --iColumnNamesLength;
        }
        this.msg.setMsg("statusColumnCount " + statusColumnCount + " and statusColumnMatch " + statusColumnMatch);
        if (statusColumnCount && statusColumnMatch) {
            test_status = true;
        }
        return test_status;
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbUser.length() == 0) {
                    throw new Exception("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new Exception("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new Exception("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testDoesMaxRowSizeIncludeBlobs() throws Exception {
        try {
            this.msg.setMsg("Calling  DatabaseMetaData.doesMaxRowSizeIncludeBlobs");
            boolean retValue = this.dbmd.doesMaxRowSizeIncludeBlobs();
            if (retValue) {
                this.msg.setMsg("MaxRowSize includes blobs");
            } else {
                this.msg.setMsg("MaxRowSize does not include blobs");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to doesMaxRowSizeIncludeBlobs is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to doesMaxRowSizeIncludeBlobs is Failed!");
        }
    }

    public void testGetMaxStatementLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxStatementLength");
            int nRetval = this.dbmd.getMaxStatementLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxStatementLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxStatementLength returns " + nRetval);
            }
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxStatementLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxStatementLength is Failed!");
        }
    }

    public void testGetMaxStatements() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxStatements");
            int nRetval = this.dbmd.getMaxStatements();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxStatements returns a negative value");
            } else {
                this.msg.setMsg("getMaxStatements returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxStatements is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxStatements is Failed!");
        }
    }

    public void testGetMaxTableNameLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxTableNameLength");
            int nRetval = this.dbmd.getMaxTableNameLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxTableNameLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxTableNameLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxTableNameLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxTableNameLength is Failed!");
        }
    }

    public void testGetMaxTablesInSelect() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxTablesInSelect");
            int nRetval = this.dbmd.getMaxTablesInSelect();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxTablesInSelect returns a negative value");
            } else {
                this.msg.setMsg("getMaxTablesInSelect returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxTablesInSelect is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxTablesInSelect is Failed!");
        }
    }

    public void testGetMaxUserNameLength() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getMaxUserNameLength");
            int nRetval = this.dbmd.getMaxUserNameLength();
            if (nRetval < 0) {
                this.msg.setMsg("getMaxUserNameLength returns a negative value");
            } else {
                this.msg.setMsg("getMaxUserNameLength returns " + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxUserNameLength is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxUserNameLength is Failed!");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void testGetDefaultTransactionIsolation() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getDefaultTransactionIsolation");
            nRetval = this.dbmd.getDefaultTransactionIsolation();
            if (nRetval == 0) ** GOTO lbl-1000
            if (nRetval == 1) ** GOTO lbl-1000
            if (nRetval == 2) ** GOTO lbl-1000
            if (nRetval == 4) ** GOTO lbl-1000
            if (nRetval != 8) {
                this.msg.printTestError("getDefaultTransactionIsolation returns an invalid value", "Call to getDefaultTransactionIsolation is Failed!");
            } else lbl-1000:
            // 5 sources

            {
                this.msg.setMsg("getDefaultTransactionIsolation returns a valid Isolation level" + nRetval);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDefaultTransactionIsolation is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDefaultTransactionIsolation is Failed!");
        }
    }

    public void testSupportsTransactions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsTransactions");
            boolean retValue = this.dbmd.supportsTransactions();
            if (retValue) {
                this.msg.setMsg("supportsTransactions is supported");
            } else {
                this.msg.setMsg("supportsTransactions is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsTransactions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsTransactions is Failed!");
        }
    }

    public void testSupportsBatchUpdates() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsBatchUpdates");
            boolean retValue = this.dbmd.supportsBatchUpdates();
            if (retValue) {
                this.msg.setMsg("supportsBatchUpdates is supported");
            } else {
                this.msg.setMsg("supportsBatchUpdates is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsBatchUpdates is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsBatchUpdates is Failed!");
        }
    }

    public void testSupportsDataDefinitionAndDataManipulationTransactions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions");
            boolean retValue = this.dbmd.supportsDataDefinitionAndDataManipulationTransactions();
            if (retValue) {
                this.msg.setMsg("supportsDataDefinitionAndDataManipulationTransactions is supported");
            } else {
                this.msg.setMsg("supportsDataDefinitionAndDataManipulationTransactions is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsDataDefinitionAndDataManipulationTransactions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsDataDefinitionAndDataManipulationTransactions is Failed!");
        }
    }

    public void testSupportsDataManipulationTransactionsOnly() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsDataManipulationTransactionsOnly");
            boolean retValue = this.dbmd.supportsDataManipulationTransactionsOnly();
            if (retValue) {
                this.msg.setMsg("supportsDataManipulationTransactionsOnly is supported");
            } else {
                this.msg.setMsg("supportsDataManipulationTransactionsOnly is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsDataManipulationTransactionsOnly is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsDataManipulationTransactionsOnly is Failed!");
        }
    }

    public void testDataDefinitionCausesTransactionCommit() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.dataDefinitionCausesTransactionCommit");
            boolean retValue = this.dbmd.dataDefinitionCausesTransactionCommit();
            if (retValue) {
                this.msg.setMsg("Data definition statement forces the transaction to commit");
            } else {
                this.msg.setMsg("Data definition statement does not forces the transaction to commit");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to dataDefinitionCausesTransactionCommit is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to dataDefinitionCausesTransactionCommit is Failed!");
        }
    }

    public void testDataDefinitionIgnoredInTransactions() throws Exception {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.dataDefinitionIgnoredInTransactions");
            boolean retValue = this.dbmd.dataDefinitionIgnoredInTransactions();
            if (retValue) {
                this.msg.setMsg("Data definition statement is ignored in a transaction");
            } else {
                this.msg.setMsg("Data definition statement is not ignored in a transaction");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to dataDefinitionIgnoredInTransactions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to dataDefinitionIgnoredInTransactions is Failed!");
        }
    }

    public void testGetProcedures() throws Exception {
        try {
            String[] sColumnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "RESERVED1", "RESERVED2", "RESERVED3", "REMARKS", "PROCEDURE_TYPE"};
            ResultSetMetaData rsmd = null;
            boolean statusColumnCount = true;
            boolean statusColumnMatch = true;
            int iColumnNamesLength = sColumnNames.length;
            this.msg.setMsg("Calling DatabaseMetaData.getProcedures");
            ResultSet oRet_ResultSet = this.dbmd.getProcedures(this.sCatalogName, this.sSchemaName, "%");
            Object sRetStr = new String();
            this.msg.setMsg("Store all the procedure names returned");
            sRetStr = "";
            rsmd = oRet_ResultSet.getMetaData();
            int iCount = rsmd.getColumnCount();
            this.msg.setMsg("Minimum Column Count is:" + iColumnNamesLength);
            this.msg.setMsg("Comparing Column Lengths");
            if (iColumnNamesLength <= iCount) {
                iCount = iColumnNamesLength;
                statusColumnCount = true;
            } else {
                statusColumnCount = false;
            }
            this.msg.setMsg("Comparing Column Names...");
            while (iColumnNamesLength > 0) {
                if (iCount < 4 || iCount > 6) {
                    if (sColumnNames[iColumnNamesLength - 1].equalsIgnoreCase(rsmd.getColumnName(iCount))) {
                        statusColumnMatch = true;
                    } else {
                        statusColumnMatch = false;
                        break;
                    }
                }
                --iCount;
                --iColumnNamesLength;
            }
            if (!statusColumnCount || !statusColumnMatch) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getProcedures Failed!");
            }
            while (oRet_ResultSet.next()) {
                sRetStr = (String)sRetStr + oRet_ResultSet.getString(3) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getProcedures did not return any procedure names");
            } else {
                this.msg.setMsg("The Procedure names returned are : " + ((String)sRetStr).substring(0, ((String)sRetStr).length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getProcedures is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getProcedures is Failed!");
        }
    }

    public void testGetProcedureColumns() throws Exception {
        try {
            String[] sColumnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getProcedureColumns");
            ResultSet oRet_ResultSet = this.dbmd.getProcedureColumns(this.sCatalogName, this.sSchemaName, "%", "%");
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getProcedureColumns Failed!");
            }
            if (oRet_ResultSet.next()) {
                this.msg.setMsg("getProcedureColumns returned some column names");
            } else {
                this.msg.setMsg("getProcedureColumns did not return any column names");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getProcedureColumns is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getProcedureColumns is Failed!");
        }
    }

    public void testGetTables() throws Exception {
        try {
            String[] sColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getTables");
            ResultSet oRet_ResultSet = this.dbmd.getTables(this.sCatalogName, this.sSchemaName, "%", null);
            Object sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getTables Failed!");
            }
            this.msg.setMsg("Store all the table names returned");
            while (oRet_ResultSet.next()) {
                sRetStr = (String)sRetStr + oRet_ResultSet.getString(3) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getTables did not return any table names");
            } else {
                this.msg.setMsg("The Table names returned are : " + ((String)sRetStr).substring(0, ((String)sRetStr).length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTables is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTables is Failed!");
        }
    }

    public void testGetSchemas() throws Exception {
        try {
            String[] sColumnNames = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getSchemas");
            ResultSet oRet_ResultSet = this.dbmd.getSchemas();
            Object sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getSchemas Failed!");
            }
            this.msg.setMsg("Store all the Schema names returned");
            while (oRet_ResultSet.next()) {
                sRetStr = (String)sRetStr + oRet_ResultSet.getString(1) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getSchemas did not return any schema names");
            } else {
                this.msg.setMsg("The Schema names returned Are : " + ((String)sRetStr).substring(0, ((String)sRetStr).length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getSchemas is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getSchemas is Failed!");
        }
    }

    public void testGetCatalogs() throws Exception {
        try {
            String[] sColumnNames = new String[]{"TABLE_CAT"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getCatalogs");
            ResultSet oRet_ResultSet = this.dbmd.getCatalogs();
            Object sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getCatalogs Failed!");
            }
            this.msg.setMsg("Store all the Catalog names returned");
            while (oRet_ResultSet.next()) {
                sRetStr = (String)sRetStr + oRet_ResultSet.getString(1) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getCatalogs did not return any catalog names");
            } else {
                this.msg.setMsg("The Catalog names returned Are : " + ((String)sRetStr).substring(0, ((String)sRetStr).length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getCatalogs is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getCatalogs is Failed!");
        }
    }

    public void testGetTableTypes() throws Exception {
        try {
            String[] sColumnNames = new String[]{"TABLE_TYPE"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getTableTypes");
            ResultSet oRet_ResultSet = this.dbmd.getTableTypes();
            Object sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getTableTypes Failed!");
            }
            this.msg.setMsg("Store all the Table Types returned");
            while (oRet_ResultSet.next()) {
                sRetStr = (String)sRetStr + oRet_ResultSet.getString(1) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getTableTypes did not return any table types");
            } else {
                this.msg.setMsg("The Table Types returned Are : " + ((String)sRetStr).substring(0, ((String)sRetStr).length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTableTypes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTableTypes is Failed!");
        }
    }

    public void testGetColumns() throws Exception {
        try {
            String[] sColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getColumns");
            this.msg.setMsg("Catalog Name " + this.sCatalogName);
            this.msg.setMsg("Schema Name " + this.sSchemaName);
            ResultSet oRet_ResultSet = this.dbmd.getColumns(this.sCatalogName, this.sSchemaName, "%", "%");
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getColumns Failed!");
            }
            if (oRet_ResultSet.next()) {
                this.msg.setMsg("getColumns returned some column names");
            } else {
                this.msg.setMsg("getColumns did not return any column names");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumns is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumns is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

