/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta5;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class dbMetaClient5
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta5";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient5 theTests = new dbMetaClient5();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new Exception("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new Exception("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new Exception("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new Exception("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sCatalogName = this.dbName.substring(nLocdbname + 1);
                this.sCatalogName = this.sCatalogName.trim();
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSupportsGroupByUnrelated() throws Exception {
        try {
            this.msg.setMsg("Calling supportsGroupByUnrelated on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsGroupByUnrelated();
            if (retValue) {
                this.msg.setMsg("supportsGroupByUnrelated method is supported");
            } else {
                this.msg.setMsg("supportsGroupByUnrelated method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsGroupByUnrelated is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsGroupByUnrelated is Failed!");
        }
    }

    public void testSupportsGroupByBeyondSelect() throws Exception {
        try {
            this.msg.setMsg("Calling supportsGroupByBeyondSelect on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsGroupByBeyondSelect();
            if (retValue) {
                this.msg.setMsg("supportsGroupByBeyondSelect method is supported");
            } else {
                this.msg.setMsg("supportsGroupByBeyondSelect method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsGroupByBeyondSelect is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsGroupByBeyondSelect is Failed!");
        }
    }

    public void testSupportsLikeEscapeClause() throws Exception {
        try {
            this.msg.setMsg("Calling supportsLikeEscapeClause on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsLikeEscapeClause();
            if (retValue) {
                this.msg.setMsg("supportsLikeEscapeClause method is supported");
            } else {
                this.msg.setMsg("supportsLikeEscapeClause method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsLikeEscapeClause is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsLikeEscapeClause is Failed!");
        }
    }

    public void testSupportsMultipleResultSets() throws Exception {
        try {
            this.msg.setMsg("Calling supportsMultipleResultSets on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsMultipleResultSets();
            if (retValue) {
                this.msg.setMsg("supportsMultipleResultSets method is supported");
            } else {
                this.msg.setMsg("supportsMultipleResultSets method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsMultipleResultSets is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsMultipleResultSets is Failed!");
        }
    }

    public void testSupportsMultipleTransactions() throws Exception {
        try {
            this.msg.setMsg("Calling supportsMultipleTransactions on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsMultipleTransactions();
            if (retValue) {
                this.msg.setMsg("supportsMultipleTransactions method is supported");
            } else {
                this.msg.setMsg("supportsMultipleTransactions method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsMultipleTransactions is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsMultipleTransactions is Failed!");
        }
    }

    public void testSupportsNonNullableColumns() throws Exception {
        try {
            this.msg.setMsg("Calling supportsNonNullableColumns on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsNonNullableColumns();
            if (retValue) {
                this.msg.setMsg("supportsNonNullableColumns method is supported");
            } else {
                this.msg.setMsg("supportsNonNullableColumns method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsNonNullableColumns is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsNonNullableColumns is Failed!");
        }
    }

    public void testSupportsMinimumSQLGrammar() throws Exception {
        try {
            this.msg.setMsg("Calling supportsMinimumSQLGrammar on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsMinimumSQLGrammar();
            if (retValue) {
                this.msg.setMsg("supportsMinimumSQLGrammar method is supported");
            } else {
                this.msg.setMsg("supportsMinimumSQLGrammar method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsMinimumSQLGrammar is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsMinimumSQLGrammar is Failed!");
        }
    }

    public void testSupportsCoreSQLGrammar() throws Exception {
        try {
            this.msg.setMsg("Calling supportsCoreSQLGrammar on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsCoreSQLGrammar();
            if (retValue) {
                this.msg.setMsg("supportsCoreSQLGrammar method is supported");
            } else {
                this.msg.setMsg("supportsCoreSQLGrammar method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsCoreSQLGrammar is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsCoreSQLGrammar is Failed!");
        }
    }

    public void testSupportsExtendedSQLGrammar() throws Exception {
        try {
            this.msg.setMsg("Calling supportsExtendedSQLGrammar on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsExtendedSQLGrammar();
            if (retValue) {
                this.msg.setMsg("supportsExtendedSQLGrammar method is supported");
            } else {
                this.msg.setMsg("supportsExtendedSQLGrammar method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsExtendedSQLGrammar is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsExtendedSQLGrammar is Failed!");
        }
    }

    public void testSupportsANSI92EntryLevelSQL() throws Exception {
        try {
            this.msg.setMsg("Calling supportsANSI92EntryLevelSQL on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsANSI92EntryLevelSQL();
            if (retValue) {
                this.msg.setMsg("supportsANSI92EntryLevelSQL method is supported");
            } else {
                this.msg.setMsg("supportsANSI92EntryLevelSQL method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsANSI92EntryLevelSQL is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsANSI92EntryLevelSQL is Failed!");
        }
    }

    public void testSupportsANSI92IntermediateSQL() throws Exception {
        try {
            this.msg.setMsg("Calling supportsANSI92IntermediateSQL on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsANSI92IntermediateSQL();
            if (retValue) {
                this.msg.setMsg("supportsANSI92IntermediateSQL method is supported");
            } else {
                this.msg.setMsg("supportsANSI92IntermediateSQL method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsANSI92IntermediateSQL is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsANSI92IntermediateSQL is Failed!");
        }
    }

    public void testSupportsANSI92FullSQL() throws Exception {
        try {
            boolean retValue = this.dbmd.supportsANSI92FullSQL();
            this.msg.setMsg("Calling supportsANSI92FullSQL on DatabaseMetaData");
            if (retValue) {
                this.msg.setMsg("supportsANSI92FullSQL method is supported");
            } else {
                this.msg.setMsg("supportsANSI92FullSQL method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsANSI92FullSQL is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsANSI92FullSQL is Failed!");
        }
    }

    public void testSupportsIntegrityEnhancementFacility() throws Exception {
        try {
            this.msg.setMsg("Calling supportsIntegrityEnhancementFacility on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsIntegrityEnhancementFacility();
            if (retValue) {
                this.msg.setMsg("supportsIntegrityEnhancementFacility method is supported");
            } else {
                this.msg.setMsg("supportsIntegrityEnhancementFacility method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsIntegrityEnhancementFacility is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsIntegrityEnhancementFacility is Failed!");
        }
    }

    public void testSupportsOuterJoins() throws Exception {
        try {
            this.msg.setMsg("Calling supportsOuterJoins on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsOuterJoins();
            if (retValue) {
                this.msg.setMsg("supportsOuterJoins method is supported");
            } else {
                this.msg.setMsg("supportsOuterJoins method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsOuterJoins is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsOuterJoins is Failed!");
        }
    }

    public void testSupportsFullOuterJoins() throws Exception {
        try {
            this.msg.setMsg("Calling supportsFullOuterJoins on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsFullOuterJoins();
            if (retValue) {
                this.msg.setMsg("supportsFullOuterJoins method is supported");
                if (!this.dbmd.supportsLimitedOuterJoins()) {
                    throw new Exception("supportsLimitedOuterJoins() must be true if supportsFullOuterJoins() is true!");
                }
            } else {
                this.msg.setMsg("supportsFullOuterJoins method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsFullOuterJoins is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsFullOuterJoins is Failed!");
        }
    }

    public void testSupportsLimitedOuterJoins() throws Exception {
        try {
            this.msg.setMsg("Calling supportsLimitedOuterJoins on DatabaseMetaData");
            boolean retValue = this.dbmd.supportsLimitedOuterJoins();
            if (retValue) {
                this.msg.setMsg("supportsLimitedOuterJoins method is supported");
            } else {
                this.msg.setMsg("supportsLimitedOuterJoins method is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsLimitedOuterJoins is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsLimitedOuterJoins is Failed!");
        }
    }

    public void testGetSchemaTerm() throws Exception {
        try {
            this.msg.setMsg("Calling getSchemaTerm on DatabaseMetaData");
            String sRetValue = this.dbmd.getSchemaTerm();
            if (sRetValue == null) {
                this.msg.setMsg("getSchemaTerm method does not returns the vendor's preferred term for schema ");
            } else {
                this.msg.setMsg("getSchemaTerm method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getSchemaTerm is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getSchemaTerm is Failed!");
        }
    }

    public void testGetProcedureTerm() throws Exception {
        try {
            this.msg.setMsg("Calling getProcedureTerm on DatabaseMetaData");
            String sRetValue = this.dbmd.getProcedureTerm();
            if (sRetValue == null) {
                this.msg.setMsg("getProcedureTerm method does not returns the vendor's preferred term for procedure ");
            } else {
                this.msg.setMsg("getProcedureTerm method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getProcedureTerm is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getProcedureTerm is Failed!");
        }
    }

    public void testGetCatalogTerm() throws Exception {
        try {
            this.msg.setMsg("Calling getCatalogTerm on DatabaseMetaData");
            String sRetValue = this.dbmd.getCatalogTerm();
            if (sRetValue == null) {
                this.msg.setMsg("getCatalogTerm method does not returns the vendor's preferred term for catalog ");
            } else {
                this.msg.setMsg("getCatalogTerm method returns:  " + sRetValue);
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getCatalogTerm is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getCatalogTerm is Failed!");
        }
    }

    public void testIsCatalogAtStart() throws Exception {
        try {
            this.msg.setMsg("Calling isCatalogAtStart on DatabaseMetaData");
            boolean retValue = this.dbmd.isCatalogAtStart();
            if (retValue) {
                this.msg.setMsg("isCatalogAtStart metohd returns catalog appear at the start");
            } else {
                this.msg.setMsg("isCatalogAtStart metohd returns catalog appear at the end");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isCatalogAtStart is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isCatalogAtStart is Failed!");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

