/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient;

import com.sun.ts.lib.util.BASE64Encoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Util {
    private static final String ZEROS = "00000000";
    private static final int SHORTPADSIZE = 4;
    private static final int BYTEPADSIZE = 2;

    private Util() {
    }

    public static String getBase64EncodedString(String value) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(value.getBytes());
    }

    public static String getEncodedStringFromStream(InputStream in, String enc) throws IOException {
        BufferedReader bin = new BufferedReader(new InputStreamReader(in, enc));
        StringBuffer sb = new StringBuffer(128);
        int ch = bin.read();
        while (ch != -1) {
            sb.append((char)ch);
            ch = bin.read();
        }
        return sb.toString();
    }

    public static String getHexValue(byte[] bytes, int pos, int len) {
        StringBuffer outBuf = new StringBuffer(bytes.length * 2);
        int bytesPerLine = 36;
        int cnt = 1;
        int groups = 4;
        int curPos = pos;
        int linePos = 1;
        boolean displayOffset = true;
        while (len-- > 0) {
            if (displayOffset) {
                outBuf.append("\n" + Util.paddedHexString(pos, 4, true) + ": ");
                displayOffset = false;
            }
            outBuf.append(Util.paddedHexString(bytes[pos], 2, false));
            linePos += 2;
            if (cnt % 4 == 0) {
                outBuf.append(" ");
                ++linePos;
            }
            if (cnt % (groups * 4) == 0) {
                outBuf.append(" ");
                while (curPos <= pos) {
                    if (!Character.isWhitespace((char)bytes[curPos])) {
                        outBuf.append((char)bytes[curPos]);
                    } else {
                        outBuf.append(".");
                    }
                    ++curPos;
                }
                curPos = pos + 1;
                linePos = 1;
                displayOffset = true;
            }
            ++cnt;
            ++pos;
        }
        while (linePos++ <= bytesPerLine) {
            outBuf.append(" ");
        }
        outBuf.append(" ");
        while (curPos < pos) {
            if (!Character.isWhitespace((char)bytes[curPos])) {
                outBuf.append((char)bytes[curPos]);
            } else {
                outBuf.append(".");
            }
            ++curPos;
        }
        return outBuf.toString();
    }

    private static String paddedHexString(int val, int wordsize, boolean prefixFlag) {
        String prefix = prefixFlag ? "0x" : "";
        String hexVal = Integer.toHexString(val);
        if (hexVal.length() > wordsize) {
            hexVal = hexVal.substring(hexVal.length() - wordsize);
        }
        return prefix + (wordsize > hexVal.length() ? ZEROS.substring(0, wordsize - hexVal.length()) : "") + hexVal;
    }
}

