/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.spec.application.lifecycle;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.spec.application.lifecycle.InnerEndpoint;
import com.sun.ts.tests.websocket.spec.application.lifecycle.OuterEndpoint;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 7108001387006240382L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_spec_application_lifecycle_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.spec.application.lifecycle"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_spec_application_lifecycle_web");
    }

    @Test
    public void serverLifeCycleTest() throws Exception {
        CountDownLatch innerLatch = new CountDownLatch(1);
        CountDownLatch outerLatch = new CountDownLatch(1);
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        InnerEndpoint inner = new InnerEndpoint(innerLatch);
        OuterEndpoint outer = new OuterEndpoint(inner, outerLatch);
        ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
        try {
            String path = this.getAbsoluteUrl() + "/lifecycle";
            URI uri = new URI(path);
            WSCClientIT.logMsg("connecting to", path);
            Session innerSession = container.connectToServer((Endpoint)inner, cec, uri);
            Session outerSession = container.connectToServer((Endpoint)outer, cec, uri);
            outerSession.getBasicRemote().sendText("anything");
            outerLatch.await(this._ws_wait, TimeUnit.SECONDS);
            innerSession.close();
            outerSession.close();
        }
        catch (Exception e) {
            new Exception(e);
        }
        WSCClientIT.assertEquals("0", outer.getReceivedMessage(), "Server Endpoint has not been created per connection, got", outer.getReceivedMessage());
        WSCClientIT.assertEquals("0", inner.getReceivedMessage(), "Server Endpoint has not been created per connection; got", inner.getReceivedMessage());
        WSCClientIT.logMsg("The server endpoint has been created one per application as expected");
    }
}

