/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;

@ClientEndpoint
public class WSByteBufferPartialClientEndpoint
extends AnnotatedStringClientEndpoint {
    protected Session session;
    private StringBuilder sb = new StringBuilder();

    @OnMessage
    public void echo(ByteBuffer buf, boolean finito) throws IOException {
        this.sb.append(IOUtil.byteBufferToString(buf)).append("(").append(finito).append(")");
        if (finito) {
            super.onMessage(this.sb.toString());
            this.session.getBasicRemote().sendText(this.sb.toString().replaceAll("[(][a-z]*[)]", ""));
            this.sb = new StringBuilder();
        }
    }

    @Override
    @OnError
    public void onError(Session session, Throwable t) {
        this.session = session;
        super.onError(session, t);
    }

    @Override
    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
    }

    @Override
    @OnOpen
    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        super.onOpen(session, config);
    }
}

