/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.elcontext;

import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ELManager;
import jakarta.el.EvaluationListener;
import jakarta.el.StandardELContext;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elContextPutGetContextTest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        String testStr = "TCKContext";
        elc.putContext(String.class, (Object)testStr);
        String result = elc.getContext(String.class).toString();
        if (!testStr.equals(result)) {
            throw new Exception("Test FAILED Unexpected Context Returned!" + ELTestUtil.NL + "Expected: " + testStr + ELTestUtil.NL + "Received: " + result);
        }
    }

    @Test
    public void elContextGetSetLocaleTest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        String disName = "english";
        Locale en = new Locale(disName);
        elc.setLocale(en);
        String result = elc.getLocale().getDisplayName();
        if (!result.equalsIgnoreCase(disName)) {
            throw new Exception("Test FAILED Unexpected Locale Returned!" + ELTestUtil.NL + "Expected: " + disName + ELTestUtil.NL + "Received: " + result);
        }
    }

    @Test
    public void elContextIsSetPropertyResolvedTest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        boolean isProp = elc.isPropertyResolved();
        if (isProp) {
            throw new Exception("Test FAILED Unexpected result from isPropertyResolved()!" + ELTestUtil.NL + "Should have been false!");
        }
        elc.setPropertyResolved(true);
        isProp = elc.isPropertyResolved();
        if (!isProp) {
            throw new Exception("Test FAILED Unexpected result from isPropertyResolved()!" + ELTestUtil.NL + "Should have been true!");
        }
    }

    @Test
    public void elContextPutContextNPETest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        logger.log(System.Logger.Level.INFO, "Testing: ELContext.putContext(String.class, null)");
        ELTestUtil.checkForNPE(elc, "putContext", new Class[]{Class.class, Object.class}, new Object[]{String.class, null});
        logger.log(System.Logger.Level.INFO, "Testing: ELContext.putContext(null, testStrg)");
        ELTestUtil.checkForNPE(elc, "putContext", new Class[]{Class.class, Object.class}, new Object[]{String.class, null});
    }

    @Test
    public void elContextGetContextNPETest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        logger.log(System.Logger.Level.INFO, "Testing: ELContext.getContext(null)");
        ELTestUtil.checkForNPE(elc, "getContext", new Class[]{Class.class}, new Object[]{null});
    }

    @Test
    public void elContextAddGetListenersTest() throws Exception {
        ELManager elm = new ELManager();
        StandardELContext elc = elm.getELContext();
        TCKEvalListener listenerOne = new TCKEvalListener();
        TCKEvalListener listenerTwo = new TCKEvalListener();
        elc.addEvaluationListener((EvaluationListener)listenerOne);
        elc.addEvaluationListener((EvaluationListener)listenerTwo);
        List listeners = elc.getEvaluationListeners();
        if (!listeners.contains((Object)listenerOne) || !listeners.contains((Object)listenerTwo)) {
            throw new Exception("Test FAILED Was unable to find test listeners in List returned form ElContext.getListeners()!");
        }
    }

    private static class TCKEvalListener
    extends EvaluationListener {
        private TCKEvalListener() {
        }
    }
}

