/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout;

import com.sun.ts.tests.ejb30.common.lite.EJBLiteJsfClientBase;
import com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout.AccessTimeoutIF;
import com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout.CallbackAccessTimeoutBeanBase;
import com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout.ClassLevelCallbackAccessTimeoutBean;
import com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout.MethodLevelCallbackAccessTimeoutBean;
import com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout.TimeUnitBean;
import jakarta.ejb.ConcurrentAccessException;
import jakarta.ejb.ConcurrentAccessTimeoutException;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

@Named(value="client")
@RequestScoped
public class JsfClient
extends EJBLiteJsfClientBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NUM_OF_THREADS = 100;
    private static final int NUM_OF_READS = 1;
    private static final int NUM_OF_WRITES = 1;
    private static final long LESS_THAN_TIMEOUT_DURATION_MILLIS = 500L;
    private static final long READ_WRITE_DURATION_MILLIS = 2000L;
    private static final Vector<Integer> readResults = new Vector();
    private static final int READ_VAL = 1;
    private static final Vector<Throwable> writeErrors = new Vector();
    private static final Vector<Throwable> readErrors = new Vector();
    @EJB(beanName="ClassLevelCallbackAccessTimeoutBean")
    protected ClassLevelCallbackAccessTimeoutBean classLevelCallbackAccessTimeoutBean;
    @EJB(beanName="MethodLevelCallbackAccessTimeoutBean")
    protected MethodLevelCallbackAccessTimeoutBean methodLevelCallbackAccessTimeoutBean;
    @EJB(name="TimeUnit", beanName="TimeUnit")
    protected TimeUnitBean timeUnitBean;
    @EJB(beanName="ClassLevel")
    protected AccessTimeoutIF classLevelAccessTimeoutBean;
    @EJB(beanName="InheritAccessTimeoutBean")
    protected AccessTimeoutIF inheritAccessTimeoutBean;
    @EJB(beanName="MethodLevelAccessTimeoutBean")
    protected AccessTimeoutIF methodLevelAccessTimeoutBean;
    @EJB(beanName="KeepWaitOrNotAllowedBean")
    protected AccessTimeoutIF keepWaitOrNotAllowedBean;

    @Override
    public void setup(String[] args, Properties p) {
        super.setup(args, p);
        readResults.clear();
        readErrors.clear();
        writeErrors.clear();
    }

    public void longReadsClassLevel() {
        this.longReads(this.classLevelAccessTimeoutBean);
    }

    public void longReadsInherit() {
        this.longReads(this.inheritAccessTimeoutBean);
    }

    public void longReadsMethodLevel() {
        this.longReads(this.methodLevelAccessTimeoutBean);
    }

    public void longReadsLongRead2sClassLevel() {
        this.longReadsLongRead2s(this.classLevelAccessTimeoutBean);
    }

    public void longReadsLongRead2sInherit() {
        this.longReadsLongRead2s(this.inheritAccessTimeoutBean);
    }

    public void longReadsLongRead2sMethodLevel() {
        this.longReadsLongRead2s(this.methodLevelAccessTimeoutBean);
    }

    public void longWritesClassLevel() {
        this.longWrites(this.classLevelAccessTimeoutBean, new boolean[0]);
    }

    public void concurrencyNotAllowed() {
        boolean expectingConcurrentAccessException = true;
        this.longWrites(this.keepWaitOrNotAllowedBean, expectingConcurrentAccessException);
    }

    public void keepWaiting() {
        this.longReads(this.keepWaitOrNotAllowedBean);
    }

    public void longWritesInherit() {
        this.longWrites(this.inheritAccessTimeoutBean, new boolean[0]);
    }

    public void longWritesMethodLevel() {
        this.longWrites(this.methodLevelAccessTimeoutBean, new boolean[0]);
    }

    public void timeoutInterceptor() {
        try {
            this.timeUnitBean.timeoutInterceptor(2000L, 1);
        }
        catch (ConcurrentAccessTimeoutException e) {
            this.appendReason("Got expected " + String.valueOf((Object)e));
        }
    }

    public void timeUnits() {
        int result = this.timeUnitBean.days(2000L, 1);
        this.assertEquals("days ", 1, result);
        result = this.timeUnitBean.hours(2000L, 1);
        this.assertEquals("hours", 1, result);
        result = this.timeUnitBean.minutes(2000L, 1);
        this.assertEquals("minutes", 1, result);
        result = this.timeUnitBean.defaults(2000L, 1);
        this.assertEquals("defaults", 1, result);
        result = this.timeUnitBean.seconds(2000L, 1);
        this.assertEquals("seconds", 1, result);
        result = this.timeUnitBean.microseconds(2000L, 1);
        this.assertEquals("microseconds", 1, result);
        result = this.timeUnitBean.nanoseconds(2000L, 1);
        this.assertEquals("nanoseconds", 1, result);
        result = this.timeUnitBean.zero(2000L, 1);
        this.assertEquals("zero value", 1, result);
        result = this.timeUnitBean.minus1(2000L, 1);
        this.assertEquals("-1 value", 1, result);
    }

    public void classLevelCallbackAccessTimeout() throws Exception {
        this.callbackAccessTimeout(this.classLevelCallbackAccessTimeoutBean);
    }

    public void methodLevelCallbackAccessTimeout() throws Exception {
        this.callbackAccessTimeout(this.methodLevelCallbackAccessTimeoutBean);
    }

    private void callbackAccessTimeout(CallbackAccessTimeoutBeanBase b) throws Exception {
        this.assertEquals(null, 1, b.postConstructWait(1));
        b.postConstruct();
        b.preDestroy();
        b.intercept(null);
    }

    private void longReads(AccessTimeoutIF b) {
        int i;
        Thread[] threads = new Thread[100];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new ReadTask(b));
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.assertEquals("Count readResults ", 100, readResults.size());
        for (int i2 : readResults) {
            this.assertEquals(null, 1, i2);
        }
    }

    private void longReadsLongRead2s(AccessTimeoutIF b) {
        int i;
        Thread[] threads = new Thread[100];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = i % 2 == 0 ? new Thread(new ReadTask(b)) : new Thread(new Read2Task(b));
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.assertEquals("Count readResults ", 100, readResults.size());
        for (int i2 : readResults) {
            if (i2 == 1 || i2 == 2) continue;
            throw new RuntimeException("Expecting 1, or 2, but got " + i2);
        }
        this.appendReason(readResults);
    }

    private void longWrites(AccessTimeoutIF b, boolean ... expectingConcurrentAccessExceptions) {
        int i;
        Thread[] threads = new Thread[100];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new WriteTask(b));
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.assertNotEquals("Count writeErrors ", 0, writeErrors.size());
        this.verifyConcurrentAccessTimeoutException(writeErrors, expectingConcurrentAccessExceptions);
    }

    private void longWritesLongRead(AccessTimeoutIF b) {
        int i;
        Thread[] threads = new Thread[101];
        for (i = 0; i < 100; ++i) {
            threads[i] = new Thread(new WriteTask(b));
            threads[i].start();
        }
        threads[threads.length - 1] = new Thread(new ReadTask(b));
        threads[threads.length - 1].start();
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.assertNotEquals("Count writeErrors ", 0, writeErrors.size());
        this.verifyConcurrentAccessTimeoutException(writeErrors, new boolean[0]);
        this.assertEquals("Count readErrors ", 1, readErrors.size());
        this.verifyConcurrentAccessTimeoutException(readErrors, new boolean[0]);
    }

    private void verifyConcurrentAccessTimeoutException(Vector<Throwable> errors, boolean ... expectingConcurrentAccessExceptions) {
        boolean expectingConcurrentAccessException = expectingConcurrentAccessExceptions.length == 0 ? false : expectingConcurrentAccessExceptions[0];
        for (Throwable th : errors) {
            if (expectingConcurrentAccessException) {
                if (th instanceof ConcurrentAccessException) {
                    this.appendReason("Got expected " + String.valueOf(th));
                    continue;
                }
                throw new RuntimeException("Expecting ConcurrentAccessException, but got " + String.valueOf(th));
            }
            if (th instanceof ConcurrentAccessTimeoutException) {
                this.appendReason("Got expected " + String.valueOf(th));
                continue;
            }
            throw new RuntimeException("Expecting ConcurrentAccessTimeoutException, but got " + String.valueOf(th));
        }
    }

    public static class ReadTask
    implements Runnable {
        private AccessTimeoutIF readBean;

        public ReadTask(AccessTimeoutIF b) {
            this.readBean = b;
        }

        @Override
        public void run() {
            for (int i = 0; i < 1; ++i) {
                try {
                    readResults.add(this.readBean.longRead(500L, 1));
                    continue;
                }
                catch (ConcurrentAccessTimeoutException e) {
                    readErrors.add(e);
                }
            }
        }
    }

    public static class Read2Task
    implements Runnable {
        private AccessTimeoutIF read2Bean;

        public Read2Task(AccessTimeoutIF b) {
            this.read2Bean = b;
        }

        @Override
        public void run() {
            for (int i = 0; i < 1; ++i) {
                try {
                    readResults.add(this.read2Bean.longRead2(500L, 2));
                    continue;
                }
                catch (ConcurrentAccessTimeoutException e) {
                    readErrors.add(e);
                }
            }
        }
    }

    public static class WriteTask
    implements Runnable {
        private AccessTimeoutIF writeBean;

        public WriteTask(AccessTimeoutIF b) {
            this.writeBean = b;
        }

        @Override
        public void run() {
            for (int i = 0; i < 1; ++i) {
                try {
                    this.writeBean.longWrite(500L);
                    continue;
                }
                catch (Throwable th) {
                    writeErrors.add(th);
                }
            }
        }
    }
}

