/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.tx;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb32.lite.timer.schedule.tx.ScheduleTxBeanBase;
import jakarta.annotation.Resource;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.List;

public abstract class ClientBase
extends com.sun.ts.tests.ejb30.timer.common.ClientBase {
    protected ScheduleTxBeanBase scheduleBean;
    protected ScheduleTxBeanBase scheduleBMTBean;
    @Resource
    private UserTransaction ut;

    protected TimerConfig getTimerConfig() {
        TimerConfig timerConfig = new TimerConfig((Serializable)new TimerInfo(this.getTestName()), false);
        return timerConfig;
    }

    public void createRollback() {
        this.createRollback(this.scheduleBean);
    }

    public void createRollbackBMT() {
        this.createRollback(this.scheduleBMTBean);
    }

    public void createRollbackTxPropagation() throws Exception {
        this.ut.begin();
        Timer timer = this.scheduleBean.createSecondLaterTimer(this.getTimerConfig(), 2);
        TestUtil.sleep((int)3000);
        this.ut.rollback();
        this.assertEquals("contains the timer? " + String.valueOf(timer), false, this.scheduleBean.getTimers().contains(timer));
        this.passIfNoTimeout(new long[0]);
    }

    public void createRollbackTxPropagationBMT() throws Exception {
        this.ut.begin();
        this.scheduleBMTBean.createSecondLaterTimer(this.getTimerConfig(), 2);
        TestUtil.sleep((int)3000);
        this.ut.rollback();
        this.passIfTimeout(new long[0]);
    }

    public void cancelRollback() {
        this.cancelRollback(this.scheduleBean);
    }

    public void cancelRollbackBMT() {
        this.cancelRollback(this.scheduleBMTBean);
    }

    public void cancelRollbackPropagation() throws Exception {
        Timer timer = this.scheduleBean.createFarFutureTimer(this.getTimerConfig());
        String result = "This timer must still be present, since the tx within which cancellation occurs is rolled back: " + String.valueOf(timer);
        this.ut.begin();
        this.scheduleBean.cancelTimer(new Timer[]{timer});
        this.ut.rollback();
        this.assertEquals(result, true, this.scheduleBean.getTimers().contains(timer));
        this.scheduleBean.cancelTimer(new Timer[]{timer});
        this.assertEquals("contains the timer? " + String.valueOf(timer), false, this.scheduleBean.getTimers().contains(timer));
    }

    public void cancelRollbackPropagationBMT() throws Exception {
        Timer timer = this.scheduleBMTBean.createSecondLaterTimer(this.getTimerConfig());
        String result = "This timer must not be present, since the tx is not propagated to BMT bean: " + String.valueOf(timer);
        this.ut.begin();
        this.scheduleBMTBean.cancelTimer(new Timer[]{timer});
        this.ut.rollback();
        this.assertEquals(result, false, this.scheduleBMTBean.getTimers().contains(timer));
    }

    public void timeoutRollback() {
        this.timeoutRollback(this.scheduleBean);
    }

    public void timeoutSystemException() {
        this.timeoutRollback();
    }

    public void timeoutSystemExceptionBMT() {
        this.timeoutRollback(this.scheduleBMTBean);
    }

    public void createTimerWithoutTx() {
        this.scheduleBMTBean.createSecondLaterTimer(this.getTimerConfig(), 2);
        this.passIfTimeout(new long[0]);
    }

    public void createTimerWithoutTxHavingClientTx() throws Exception {
        this.ut.begin();
        this.scheduleBMTBean.createSecondLaterTimer(this.getTimerConfig(), 2);
        this.ut.commit();
        this.passIfTimeout(new long[0]);
    }

    private void createRollback(ScheduleTxBeanBase b) {
        String result = b.createRollback(this.getTimerConfig());
        this.appendReason(new Object[]{result});
        this.passIfNoTimeout(new long[0]);
    }

    private void cancelRollback(ScheduleTxBeanBase b) {
        Timer timer = b.createFarFutureTimer(this.getTimerConfig());
        String result = b.cancelRollback(this.getTestName());
        this.assertEquals(result, true, b.getTimers().contains(timer));
        b.cancelTimer(new Timer[]{timer});
        this.passIfNoTimeout(new long[0]);
    }

    private void timeoutRollback(ScheduleTxBeanBase b) {
        this.appendReason(new Object[]{"If the transaction rolls back in timeout method, must retry at least once."});
        Timer timer = b.createSecondLaterTimer(this.getTimerConfig(), 2);
        TestUtil.sleep((int)60000);
        List a = this.statusSingleton.getRecords(this.getTestName());
        this.appendReason(new Object[]{"timeout callback result: ", a});
        this.assertGreaterThan(null, a.size(), 1L);
    }
}

