/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InterceptionType;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.BallBindingLiteral;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.BasketBindingLiteral;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.ComplicatedInterceptor;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.ComplicatedLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.LoggedBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.MessageBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.MessageService;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.MonitorService;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.PingBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.PongBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.RemoteMessageService;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ejb.TransactionalBinding;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="interceptors", version="1.2")
public class EnterpriseInterceptorBindingResolutionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseInterceptorBindingResolutionTest.class)).withBeansXml(new BeansXml().interceptors(new Class[]{ComplicatedInterceptor.class, ComplicatedLifecycleInterceptor.class}))).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="binding_int_to_component", id="e"), @SpecAssertion(section="int_resolution", id="ca"), @SpecAssertion(section="int_resolution", id="da"), @SpecAssertion(section="int_resolution", id="db"), @SpecAssertion(section="int_resolution", id="dc")})
    public void testBusinessMethodInterceptorBindings(MessageService messageService, MonitorService monitorService) {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new MessageBinding.Literal(), new LoggedBinding.Literal(), new TransactionalBinding.Literal(), new PingBinding.Literal(), new PongBinding.Literal(), new BallBindingLiteral(true, true)}).size(), (int)1);
        Assert.assertNotNull((Object)messageService);
        ComplicatedInterceptor.reset();
        messageService.ping();
        Assert.assertTrue((boolean)ComplicatedInterceptor.intercepted);
        Assert.assertNotNull((Object)monitorService);
        ComplicatedInterceptor.reset();
        monitorService.ping();
        Assert.assertFalse((boolean)ComplicatedInterceptor.intercepted);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="int_resolution", id="cb")
    public void testTimeoutMethodInterceptorBindings(MessageService messageService) throws Exception {
        Assert.assertNotNull((Object)messageService);
        ComplicatedInterceptor.reset();
        messageService.start();
        Timer.StopCondition condition = new Timer.StopCondition(){

            public boolean isSatisfied() {
                return ComplicatedInterceptor.intercepted;
            }
        };
        Timer timer = new Timer().setDelay(3L, TimeUnit.SECONDS).addStopCondition(condition).start();
        Assert.assertTrue((timer.isStopConditionsSatisfiedBeforeTimeout() || condition.isSatisfied() ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertion(section="int_resolution", id="b")
    public void testLifecycleInterceptorBindings() throws Exception {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.POST_CONSTRUCT, new Annotation[]{new MessageBinding.Literal(), new LoggedBinding.Literal(), new TransactionalBinding.Literal(), new BasketBindingLiteral(true, true)}).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.PRE_DESTROY, new Annotation[]{new MessageBinding.Literal(), new LoggedBinding.Literal(), new TransactionalBinding.Literal(), new BasketBindingLiteral(true, true)}).size(), (int)1);
        ComplicatedLifecycleInterceptor.reset();
        Bean bean = this.getUniqueBean(RemoteMessageService.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext((Contextual)bean);
        RemoteMessageService remoteMessageService = (RemoteMessageService)bean.create(ctx);
        remoteMessageService.ping();
        bean.destroy((Object)remoteMessageService, ctx);
        Assert.assertTrue((boolean)ComplicatedLifecycleInterceptor.postConstructCalled);
        Assert.assertTrue((boolean)ComplicatedLifecycleInterceptor.preDestroyCalled);
    }
}

