/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate;

import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ClassloaderServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionFromEJBServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.JNDIServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.JSPSecurityServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.SecurityServlet;
import ee.jakarta.tck.concurrent.spi.context.IntContextProvider;
import ee.jakarta.tck.concurrent.spi.context.StringContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

@Test(groups={"eefull"})
public class ContextPropagationTests
extends TestClient {
    public static final String LimitedBeanAppJNDI = "java:app/ContextPropagationTests_ejb/LimitedBean";
    @ArquillianResource(value=JNDIServlet.class)
    URL jndiURL;
    @ArquillianResource(value=JSPSecurityServlet.class)
    URL jspURL;
    @ArquillianResource(value=ClassloaderServlet.class)
    URL classloaderURL;
    @ArquillianResource(value=SecurityServlet.class)
    URL securityURL;
    @ArquillianResource(value=ContextServiceDefinitionServlet.class)
    URL contextURL;
    @ArquillianResource(value=ContextServiceDefinitionFromEJBServlet.class)
    URL ejbContextURL;

    @Deployment(name="ContextPropagationTests", testable=false)
    public static EnterpriseArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationTests_web.war")).addPackages(true, new Package[]{ContextPropagationTests.getFrameworkPackage(), ContextPropagationTests.getContextPackage(), ContextPropagationTests.getContextProvidersPackage()})).addClasses(new Class[]{ContextServiceDefinitionServlet.class, ClassloaderServlet.class, JNDIServlet.class, SecurityServlet.class, JSPSecurityServlet.class, ContextServiceDefinitionFromEJBServlet.class})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()})).addAsWebInfResource(ContextPropagationTests.class.getPackage(), "web.xml", "web.xml")).addAsWebResource(ContextPropagationTests.class.getPackage(), "jspTests.jsp", "jspTests.jsp");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ContextPropagationTests_ejb.jar")).addPackages(true, new Package[]{ContextPropagationTests.getFrameworkPackage(), ContextPropagationTests.class.getPackage()})).deleteClasses(new Class[]{ContextServiceDefinitionServlet.class, ClassloaderServlet.class, JNDIServlet.class, SecurityServlet.class, JSPSecurityServlet.class, ContextServiceDefinitionFromEJBServlet.class})).addAsManifestResource(ContextPropagationTests.class.getPackage(), "ejb-jar.xml", "ejb-jar.xml");
        EnterpriseArchive ear = (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"ContextPropagationTests.ear")).addAsModules(new Archive[]{war, jar});
        return ear;
    }

    @Test(enabled=false)
    public void testSecurityClearedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test(enabled=false)
    public void testSecurityUnchangedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testSecurityPropagatedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testJNDIContextAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jndiURL).withPaths("JNDIServlet").withTestName(this.testName);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testName + "failed to get correct result.", "JNDIContextWeb", resp);
    }

    @Test
    public void testJNDIContextAndCreateProxyInEJB() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jndiURL).withPaths("JNDIServlet").withTestName(this.testName);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testName + "failed to get correct result.", "JNDIContextEJB", resp);
    }

    @Test
    public void testClassloaderAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.securityURL).withPaths("ClassloaderServlet").withTestName(this.testName);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testName + "failed to get correct result.", "ConcurrentResultOkay", resp);
    }

    @Test
    public void testSecurityAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.classloaderURL).withPaths("SecurityServlet").withTestName(this.testName);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testName + "failed to get correct result.", "ConcurrentResultOkay", resp);
    }

    @Test
    public void testContextServiceDefinitionAllAttributes() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextServiceDefinitionFromEJBAllAttributes() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextServiceDefinitionDefaults() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextServiceDefinitionFromEJBDefaults() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextServiceDefinitionWithThirdPartyContext() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextualConsumer() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextualFunction() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testContextualSupplier() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
        requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }

    @Test
    public void testCopyWithContextCapture() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testName);
        this.runTest(requestURL);
    }
}

