/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestSuite;
import com.sun.javatest.services.ServiceManager;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestPath {
    private final Set<String> services;
    protected ServiceManager mgr;
    protected Pattern p;
    protected TDMatcher tdm;

    public TestPath(TestSuite ts, String pathPattern, String tdMatcherClassName) {
        if (pathPattern != null) {
            this.p = Pattern.compile(pathPattern);
        }
        if (tdMatcherClassName != null && !tdMatcherClassName.isEmpty()) {
            try {
                Class tdMatcherClass = ts.loadClass(tdMatcherClassName);
                this.tdm = (TDMatcher)tdMatcherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                Logger.getLogger(TestPath.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.services = new TreeSet<String>();
    }

    public boolean matches(String path) {
        boolean res = true;
        if (this.p != null) {
            Matcher m = this.p.matcher(path);
            res &= m.matches();
        }
        return res;
    }

    public boolean matches(TestDescription td) {
        boolean res = true;
        res &= this.matches(td.getRootRelativePath());
        if (this.tdm != null) {
            res &= this.tdm.matches(td);
        }
        return res;
    }

    public Set<String> getServices() {
        return this.services;
    }

    public void addService(String sID) {
        this.services.add(sID);
    }

    void setServiceManager(ServiceManager mgr) {
        this.mgr = mgr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestPath  pattern='");
        sb.append(this.p);
        sb.append("' services={");
        for (String s : this.services) {
            sb.append(s).append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static interface TDMatcher {
        public boolean matches(TestDescription var1);
    }
}

