/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonvaluetests;

import ee.jakarta.tck.jsonp.api.common.JsonAssert;
import ee.jakarta.tck.jsonp.api.common.PointerRFCObject;
import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class Structure {
    private static final Logger LOGGER = Logger.getLogger(Structure.class.getName());

    Structure() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonStructure API methods added in JSON-P 1.1.");
        LOGGER.info("JsonStructure API methods added in JSON-P 1.1.");
        this.testResolveWholeDocument(result);
        this.testResolveEmptyName(result);
        this.testResolveSimpleArray(result);
        this.testResolveSimpleArrayItems(result);
        this.testResolvePathWithEncodedSlash(result);
        this.testResolvePathWithSlash(result);
        this.testResolvePathWithPercent(result);
        this.testResolvePathWithCaret(result);
        this.testResolvePathWithVerticalBar(result);
        this.testResolvePathWithBackSlash(result);
        this.testResolvePathWithDoubleQuotes(result);
        this.testResolvePathWithSpace(result);
        this.testResolvePathWithTilde(result);
        this.testResolvePathWithEncodedTilde(result);
        this.testResolvePathWithEncodedTildeOne(result);
        this.testResolveValidNumericIndexInArray(result);
        this.testResolveMemberAfterLastInArray(result);
        this.testResolveNonNumericIndexInArray(result);
        return result;
    }

    private void testResolveWholeDocument(TestResult result) {
        JsonObject value;
        JsonObject check = value = PointerRFCObject.createRFC6901Object();
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "");
    }

    private void testResolveEmptyName(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)0);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/");
    }

    private void testResolveSimpleArray(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonArray check = PointerRFCObject.RFC_VAL1;
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/foo");
    }

    private void testResolveSimpleArrayItems(TestResult result) {
        String[] itemPtrs = new String[]{"/foo/0", "/foo/1"};
        String[] itemVals = new String[]{"bar", "baz"};
        JsonObject value = PointerRFCObject.createRFC6901Object();
        for (int i = 0; i < itemPtrs.length; ++i) {
            JsonString check = Json.createValue((String)itemVals[i]);
            this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, itemPtrs[i]);
        }
    }

    private void testResolvePathWithEncodedSlash(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)1);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/a~1b");
    }

    private void testResolvePathWithSlash(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        this.verifyGetValueFail(result, (JsonStructure)value, "/a/b");
    }

    private void testResolvePathWithPercent(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)2);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/c%d");
    }

    private void testResolvePathWithCaret(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)3);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/e^f");
    }

    private void testResolvePathWithVerticalBar(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)4);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/g|h");
    }

    private void testResolvePathWithBackSlash(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)5);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/i\\j");
    }

    private void testResolvePathWithDoubleQuotes(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)6);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/k\"l");
    }

    private void testResolvePathWithSpace(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)7);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/ ");
    }

    private void testResolvePathWithTilde(TestResult result) {
        LOGGER.info(" - resolving of \"/m~n\" pointer (optional)");
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)8);
        boolean noError = true;
        try {
            JsonValue out = value.getValue("/m~n");
            if (this.operationFailed((JsonValue)check, out)) {
                noError = false;
                LOGGER.info("    - Pointer \"m~n\" did not return expected value");
            }
        }
        catch (JsonException e) {
            noError = false;
            LOGGER.info("    - Expected exception: " + e.getMessage());
        }
        if (noError) {
            LOGGER.info("    - Pointer resolving accepts '~' outside escape sequence");
        }
    }

    private void testResolvePathWithEncodedTilde(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)8);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/m~0n");
    }

    private void testResolvePathWithEncodedTildeOne(TestResult result) {
        JsonObject value = PointerRFCObject.createRFC6901Object();
        JsonNumber check = Json.createValue((int)9);
        this.verifyGetValue(result, (JsonValue)check, (JsonStructure)value, "/o~01p");
    }

    private void testResolveValidNumericIndexInArray(TestResult result) {
        LOGGER.info(" - getValue(String) resolving of pointer containing existing numeric array index");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createSimpleStringArray5(), SimpleValues.createSimpleIntArray5(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createSimpleObjectArray5()};
        JsonValue[] strings = new JsonValue[]{SimpleValues.toJsonValue("First value"), SimpleValues.toJsonValue("Second value"), SimpleValues.toJsonValue("Third value"), SimpleValues.toJsonValue("Fourth value"), SimpleValues.toJsonValue("Fifth value")};
        JsonValue[] ints = new JsonValue[]{SimpleValues.toJsonValue(1), SimpleValues.toJsonValue(2), SimpleValues.toJsonValue(3), SimpleValues.toJsonValue(4), SimpleValues.toJsonValue(5)};
        JsonValue[] bools = new JsonValue[]{SimpleValues.toJsonValue(false), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(false), SimpleValues.toJsonValue(true)};
        JsonValue[] objs = new JsonValue[]{SimpleValues.OBJ_VALUE_1, SimpleValues.OBJ_VALUE_2, SimpleValues.OBJ_VALUE_3, SimpleValues.OBJ_VALUE_4, SimpleValues.OBJ_VALUE_5};
        JsonValue[][] checks = new JsonValue[][]{strings, ints, bools, objs};
        for (int i = 0; i < arraysIn.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                String path = "/" + Integer.toString(j);
                try {
                    JsonValue out = arraysIn[i].getValue(path);
                    if (!this.operationFailed(checks[i][j], out)) continue;
                    result.fail("getValue(String)", "Failed for \"" + path + "\" path");
                    continue;
                }
                catch (JsonException e) {
                    result.fail("getValue(String)", "Exception: " + e.getMessage());
                }
            }
        }
    }

    private void testResolveMemberAfterLastInArray(TestResult result) {
        LOGGER.info(" - getValue(String) resolving of array \"/-\" pointer");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray(new String[0]), SimpleValues.createSimpleIntArray5(), SimpleValues.createBoolArray2(), SimpleValues.createSimpleObjectArray5()};
        for (int i = 0; i < arraysIn.length; ++i) {
            try {
                arraysIn[i].getValue("/-");
                result.fail("getValue(String)", "Call of getValue(String) on \"/-\" shall throw JsonException");
                continue;
            }
            catch (JsonException e) {
                LOGGER.info("    - Expected exception: " + e.getMessage());
            }
        }
    }

    private void testResolveNonNumericIndexInArray(TestResult result) {
        LOGGER.info(" - getValue(String) resolving of pointer containing non numeric array index");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray(new String[0]), SimpleValues.createSimpleIntArray5(), SimpleValues.createBoolArray2(), SimpleValues.createSimpleObjectArray5()};
        String[] typeNames = new String[]{"empty", "String", "int", "boolean", "JsonObject"};
        String wholeDocument = "";
        String[] paths = new String[]{"/", "/1a", "/b4", "/name"};
        for (int i = 0; i < arraysIn.length; ++i) {
            try {
                JsonValue wholeOut = arraysIn[i].getValue("");
                if (this.operationFailed(wholeOut, (JsonValue)arraysIn[i])) {
                    result.fail("getValue(String)", "Failed for \"\" path on " + typeNames[i] + " array");
                }
            }
            catch (JsonException e) {
                result.fail("getValue(String)", "Failed for \"\" path on " + typeNames[i] + " array: " + e.getMessage());
            }
            for (int j = 0; j < paths.length; ++j) {
                try {
                    JsonValue out = arraysIn[i].getValue(paths[j]);
                    result.fail("getValue(String)", "Succeeded for \"" + paths[j] + "\" path on " + typeNames[i] + " array");
                    continue;
                }
                catch (JsonException jsonException) {
                    // empty catch block
                }
            }
        }
    }

    private void verifyGetValue(TestResult result, JsonValue check, JsonStructure value, String path) {
        LOGGER.info(" - getValue(String) resolving of \"" + path + "\" pointer");
        try {
            JsonValue out = value.getValue(path);
            if (this.operationFailed(check, out)) {
                result.fail("getValue(String)", "Failed for \"" + path + "\" path");
            }
        }
        catch (JsonException e) {
            result.fail("getValue(String)", "Exception: " + e.getMessage());
        }
    }

    private void verifyGetValueFail(TestResult result, JsonStructure value, String path) {
        LOGGER.info(" - getValue(String) resolving of invalid \"" + path + "\" pointer");
        try {
            value.getValue(path);
            result.fail("getValue(String)", "Call of getValue(String) on \"" + path + "\" shall throw JsonException");
        }
        catch (JsonException e) {
            LOGGER.info("    - Expected exception: " + e.getMessage());
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

