/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsongeneratortests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsongeneratortests.Generator;
import ee.jakarta.tck.jsonp.common.JSONP_Util;
import ee.jakarta.tck.jsonp.common.MyBufferedWriter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    private void generateSimpleJsonObject(JsonGenerator generator) {
        try {
            generator.writeStartObject().writeStartObject("object").write("string", "string").write("number", 1).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeEnd().writeStartArray("array").write("string").write(1).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeEnd().writeEnd();
            generator.close();
        }
        catch (Exception e) {
            LOGGER.warning("Exception occurred: " + e);
        }
    }

    private void generateSimpleJsonArray(JsonGenerator generator) {
        try {
            generator.writeStartArray().writeStartObject().write("string", "string").write("number", 1).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeEnd().writeStartArray().write("string").write(1).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeEnd().writeEnd();
            generator.close();
        }
        catch (Exception e) {
            LOGGER.warning("Exception occurred: " + e);
        }
    }

    private String generateJsonObject() {
        try {
            LOGGER.info("Generate a JsonObject");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("intMin", Integer.MIN_VALUE).write("intMax", Integer.MAX_VALUE).write("longMin", Long.MIN_VALUE).write("longMax", Long.MAX_VALUE).write("doubleMin", Double.MIN_VALUE).write("doubleMax", Double.MAX_VALUE).write("bigInteger", new BigInteger(Integer.toString(Integer.MAX_VALUE))).write("bigDecimal", BigDecimal.valueOf(Integer.MIN_VALUE)).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("number", 100).write("true", true).write("false", false).writeNull("null").writeStartObject("object").write("name", "value").write("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).write("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar()).writeEnd().writeStartArray("array").write("one").write("two").write((JsonValue)JSONP_Util.buildJsonObjectFooBar()).write((JsonValue)JSONP_Util.buildJsonArrayFooBar()).writeEnd().writeEnd().writeStartArray("array").write("string").write(Integer.MAX_VALUE).write(Long.MAX_VALUE).write(Double.MAX_VALUE).write(new BigInteger(Integer.toString(Integer.MAX_VALUE))).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("name", "value").writeEnd().writeStartArray().write("one").write("two").writeEnd().writeEnd().write("asciiChars", "\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").writeEnd();
            generator.close();
            return sWriter.toString();
        }
        catch (Exception e) {
            LOGGER.warning("Exception occurred: " + e);
            return null;
        }
    }

    private JsonObject buildJsonObject() {
        try {
            LOGGER.info("Build a JsonObject");
            JsonObject jsonObject = Json.createObjectBuilder().add("emptyString", "").add("emptyArray", Json.createArrayBuilder()).add("emptyObject", Json.createObjectBuilder()).add("string", "string").add("intMin", Integer.MIN_VALUE).add("intMax", Integer.MAX_VALUE).add("longMin", Long.MIN_VALUE).add("longMax", Long.MAX_VALUE).add("doubleMin", Double.MIN_VALUE).add("doubleMax", Double.MAX_VALUE).add("bigInteger", new BigInteger(Integer.toString(Integer.MAX_VALUE))).add("bigDecimal", BigDecimal.valueOf(Integer.MIN_VALUE)).add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("object", Json.createObjectBuilder().add("emptyString", "").add("emptyArray", Json.createArrayBuilder()).add("emptyObject", Json.createObjectBuilder()).add("string", "string").add("number", 100).add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("object", Json.createObjectBuilder().add("name", "value").add("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).add("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar())).add("array", Json.createArrayBuilder().add("one").add("two").add((JsonValue)JSONP_Util.buildJsonObjectFooBar()).add((JsonValue)JSONP_Util.buildJsonArrayFooBar()))).add("array", Json.createArrayBuilder().add("string").add(Integer.MAX_VALUE).add(Long.MAX_VALUE).add(Double.MAX_VALUE).add(new BigInteger(Integer.toString(Integer.MAX_VALUE))).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add(Json.createObjectBuilder().add("name", "value")).add(Json.createArrayBuilder().add("one").add("two"))).add("asciiChars", "\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").build();
            return jsonObject;
        }
        catch (Exception e) {
            LOGGER.warning("Exception occurred: " + e);
            return null;
        }
    }

    private String generateJsonArray() {
        try {
            LOGGER.info("Generate a JsonArray");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("").writeStartArray().writeEnd().writeStartObject().writeEnd().write("string").write(Integer.MIN_VALUE).write(Integer.MAX_VALUE).write(Long.MIN_VALUE).write(Long.MAX_VALUE).write(Double.MIN_VALUE).write(Double.MAX_VALUE).write(new BigInteger(new Integer(Integer.MAX_VALUE).toString())).write(BigDecimal.valueOf(Integer.MIN_VALUE)).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("number", 100).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("name", "value").write("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).write("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar()).writeEnd().writeStartArray("array").write("one").write("two").write((JsonValue)JSONP_Util.buildJsonObjectFooBar()).write((JsonValue)JSONP_Util.buildJsonArrayFooBar()).writeEnd().writeEnd().writeStartArray().write("string").write(Integer.MAX_VALUE).write(Long.MAX_VALUE).write(Double.MAX_VALUE).write(new BigInteger(new Integer(Integer.MAX_VALUE).toString())).write(true).write(false).writeNull().writeStartObject().write("name", "value").writeEnd().writeStartArray().write("one").write("two").writeEnd().writeEnd().write("\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").writeEnd();
            generator.close();
            return sWriter.toString();
        }
        catch (Exception e) {
            LOGGER.warning("Exception occurred: " + e);
            return null;
        }
    }

    private JsonArray buildJsonArray() {
        try {
            LOGGER.info("Build a JsonArray");
            JsonArray jsonArray = Json.createArrayBuilder().add("").add(Json.createArrayBuilder()).add(Json.createObjectBuilder()).add("string").add(Integer.MIN_VALUE).add(Integer.MAX_VALUE).add(Long.MIN_VALUE).add(Long.MAX_VALUE).add(Double.MIN_VALUE).add(Double.MAX_VALUE).add(new BigInteger(new Integer(Integer.MAX_VALUE).toString())).add(BigDecimal.valueOf(Integer.MIN_VALUE)).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add(Json.createObjectBuilder().add("emptyString", "").add("emptyArray", Json.createArrayBuilder()).add("emptyObject", Json.createObjectBuilder()).add("string", "string").add("number", 100).add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("object", Json.createObjectBuilder().add("name", "value").add("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).add("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar())).add("array", Json.createArrayBuilder().add("one").add("two").add((JsonValue)JSONP_Util.buildJsonObjectFooBar()).add((JsonValue)JSONP_Util.buildJsonArrayFooBar()))).add(Json.createArrayBuilder().add("string").add(Integer.MAX_VALUE).add(Long.MAX_VALUE).add(Double.MAX_VALUE).add(new BigInteger(new Integer(Integer.MAX_VALUE).toString())).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add(Json.createObjectBuilder().add("name", "value")).add(Json.createArrayBuilder().add("one").add("two"))).add("\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").build();
            return jsonArray;
        }
        catch (Exception e) {
            LOGGER.warning("Exception occurred: " + e);
            return null;
        }
    }

    @Test
    public void jsonGeneratorObjectTest1() {
        try {
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            LOGGER.info("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)sWriter.toString());
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorObjectTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorObjectTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorObjectTest2() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGenerator((OutputStream)baos);
            generator.writeStartObject().write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("intMin", Integer.MIN_VALUE).write("intMax", Integer.MAX_VALUE).write("longMin", Long.MIN_VALUE).write("longMax", Long.MAX_VALUE).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("number", 100).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("name", "value").writeEnd().writeStartArray("array").write("one").write("two").writeEnd().writeEnd().writeStartArray("array").write("string").write(Integer.MAX_VALUE).write(Long.MAX_VALUE).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("name", "value").writeEnd().writeStartArray().write("one").write("two").writeEnd().writeEnd().write("asciiChars", "\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").writeEnd();
            generator.close();
            LOGGER.info("Dump of string: " + baos.toString("UTF-8"));
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "{\"emptyString\":\"\",\"emptyArray\":[],\"emptyObject\":{},\"string\":\"string\",\"intMin\":-2147483648,\"intMax\":2147483647,\"longMin\":-9223372036854775808,\"longMax\":9223372036854775807,\"true\":true,\"false\":false,\"null\":null,\"object\":{\"emptyString\":\"\",\"emptyArray\":[],\"emptyObject\":{},\"string\":\"string\",\"number\":100,\"true\":true,\"false\":false,\"null\":null,\"object\":{\"name\":\"value\"},\"array\":[\"one\",\"two\"]},\"array\":[\"string\",2147483647,9223372036854775807,true,false,null,{\"name\":\"value\"},[\"one\",\"two\"]],\"asciiChars\":\"\\\\\\\"\\\\\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"}";
            LOGGER.info("Read the JSON text back from OutputStream removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-8"));
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorObjectTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorObjectTest2 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorObjectTest3() {
        try {
            JsonObject expJsonObject = this.buildJsonObject();
            String jsonText = this.generateJsonObject();
            JsonReader reader = Json.createReader((Reader)new StringReader(jsonText));
            JsonObject actJsonObject = (JsonObject)reader.read();
            LOGGER.info("Compare expJsonObject and actJsonObject for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonObjects((JsonObject)expJsonObject, (JsonObject)actJsonObject), (String)"jsonGeneratorObjectTest3 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorObjectTest3 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorObjectTest4() {
        try {
            LOGGER.info("Create generator output in UTF-16BE encoding.");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16BE);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            LOGGER.info("Read the JSON text back encoding from OutputStream using UTF-16BE encoding removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16BE"));
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorObjectTest4 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorObjectTest4 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorObjectTest5() {
        JsonReader reader = null;
        String expUnicodeChars = "\u0000\u000f\u001f\u00ff\uff00\uffff";
        try {
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("unicodechars", "\u0000\u000f\u001f\u00ff\uff00\uffff").writeEnd();
            generator.close();
            sWriter.close();
            LOGGER.info("Testing read of " + sWriter.toString());
            reader = Json.createReader((Reader)new StringReader(sWriter.toString()));
            JsonObject jsonObject = reader.readObject();
            String actUnicodeChars = jsonObject.getJsonString("unicodechars").getString();
            reader.close();
            LOGGER.info("actUnicodeChars=" + actUnicodeChars);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expUnicodeChars, (String)actUnicodeChars), (String)"jsonGeneratorObjectTest5 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"Exception occurred: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorArrayTest1() {
        try {
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            this.generateSimpleJsonArray(generator);
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "[{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},[\"string\",1,true,false,null]]";
            LOGGER.info("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)sWriter.toString());
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorArrayTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorArrayTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorArrayTest2() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGenerator((OutputStream)baos);
            generator.writeStartArray().write("").writeStartArray().writeEnd().writeStartObject().writeEnd().write("string").write(Integer.MIN_VALUE).write(Integer.MAX_VALUE).write(Long.MIN_VALUE).write(Long.MAX_VALUE).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("number", 100).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("name", "value").writeEnd().writeStartArray("array").write("one").write("two").writeEnd().writeEnd().writeStartArray().write("string").write(Integer.MAX_VALUE).write(Long.MAX_VALUE).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("name", "value").writeEnd().writeStartArray().write("one").write("two").writeEnd().writeEnd().write("\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").writeEnd();
            generator.close();
            LOGGER.info("Dump of string: " + baos.toString("UTF-8"));
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "[\"\",[],{},\"string\",-2147483648,2147483647,-9223372036854775808,9223372036854775807,true,false,null,{\"emptyString\":\"\",\"emptyArray\":[],\"emptyObject\":{},\"string\":\"string\",\"number\":100,\"true\":true,\"false\":false,\"null\":null,\"object\":{\"name\":\"value\"},\"array\":[\"one\",\"two\"]},[\"string\",2147483647,9223372036854775807,true,false,null,{\"name\":\"value\"},[\"one\",\"two\"]],\"\\\\\\\"\\\\\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"]";
            LOGGER.info("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-8"));
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorArrayTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorArrayTest2 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorArrayTest3() {
        try {
            JsonArray expJsonArray = this.buildJsonArray();
            String jsonText = this.generateJsonArray();
            LOGGER.info("generator json text: " + jsonText);
            JsonReader reader = Json.createReader((Reader)new StringReader(jsonText));
            JsonArray actJsonArray = (JsonArray)reader.read();
            LOGGER.info("Compare expJsonArray and actJsonArray for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonArrays((JsonArray)expJsonArray, (JsonArray)actJsonArray), (String)"jsonGeneratorArrayTest3 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorArrayTest3 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorArrayTest4() {
        try {
            LOGGER.info("Create generator output in UTF-16BE encoding.");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16BE);
            this.generateSimpleJsonArray(generator);
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "[{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},[\"string\",1,true,false,null]]";
            LOGGER.info("Read the JSON text back from OutputStream using UTF-16BE encoding removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16BE"));
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorArrayTest4 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorArrayTest4 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorArrayTest5() {
        JsonReader reader = null;
        String expUnicodeChars = "\u0000\u000f\u001f\u00ff\uff00\uffff";
        try {
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("\u0000\u000f\u001f\u00ff\uff00\uffff").writeEnd();
            generator.close();
            sWriter.close();
            LOGGER.info("Testing read of " + sWriter.toString());
            reader = Json.createReader((Reader)new StringReader(sWriter.toString()));
            JsonArray jsonArray = reader.readArray();
            String actUnicodeChars = jsonArray.getJsonString(0).getString();
            reader.close();
            LOGGER.info("actUnicodeChars=" + actUnicodeChars);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expUnicodeChars, (String)actUnicodeChars), (String)"jsonGeneratorArrayTest5 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"JsonGeneratorArrayTest5 Failed. Exception occurred:", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorObjectConfigTest1() {
        try {
            LOGGER.info("Create JsonGenerator using configuration with PRETTY_PRINTING");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGeneratorFactory((Map)JSONP_Util.getPrettyPrintingConfig()).createGenerator((Writer)sWriter);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("PRETTY_PRINTING feature\n" + sWriter.toString());
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            LOGGER.info("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)sWriter.toString());
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorObjectConfigTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorObjectConfigTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorObjectConfigTest2() {
        try {
            LOGGER.info("Create JsonGenerator using configuration with PRETTY_PRINTING");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory((Map)JSONP_Util.getPrettyPrintingConfig()).createGenerator((OutputStream)baos);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("PRETTY_PRINTING feature\n" + baos.toString("UTF-8"));
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            LOGGER.info("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-8"));
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorObjectConfigTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorObjectConfigTest2 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorObjectEncodingTest1() {
        try {
            LOGGER.info("Create JsonGenerator using UTF-8 encoding");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_8);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Generator Output=" + baos.toString("UTF-8"));
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            LOGGER.info("Read the JSON text back from OutputStream using UTF-8 encoding removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-8"));
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorObjectEncodingTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorObjectEncodingTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorObjectEncodingTest2() {
        try {
            LOGGER.info("Create JsonGenerator using configuration with PRETTY_PRINTING using UTF-16BE encoding");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory((Map)JSONP_Util.getPrettyPrintingConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16BE);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("PRETTY_PRINTING feature\n" + baos.toString("UTF-16BE"));
            LOGGER.info("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            LOGGER.info("Read the JSON text back from OutputStream using UTF-16BE encoding removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16BE"));
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson), (String)"jsonGeneratorObjectEncodingTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorObjectEncodingTest2 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGeneratorUTFEncodedTests() {
        String actJson;
        JsonGenerator generator;
        ByteArrayOutputStream baos;
        boolean pass = true;
        LOGGER.info("Create expected JSON text with no whitespace for use with comparison");
        String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
        try {
            LOGGER.info("-----------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-8]");
            LOGGER.info("-----------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonGenerator using UTF-8 encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_8);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Generated Output=" + baos.toString("UTF-8"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-8 encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-8 encoding: " + e);
        }
        try {
            LOGGER.info("------------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-16]");
            LOGGER.info("------------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonGenerator using UTF-16 encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Generated Output=" + baos.toString("UTF-16"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-16 encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-16 encoding: " + e);
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-16LE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonGenerator using UTF-16LE encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16LE);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Generated Output=" + baos.toString("UTF-16LE"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-16LE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16LE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-16LE encoding: " + e);
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-16BE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonGenerator using UTF-16BE encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16BE);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Generated Output=" + baos.toString("UTF-16BE"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-16BE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16BE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-16BE encoding: " + e);
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-32LE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonGenerator using UTF-32LE encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_32LE);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Generated Output=" + baos.toString("UTF-32LE"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-32LE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-32LE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-32LE encoding: " + e);
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-32BE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonGenerator using UTF-32BE encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_32BE);
            this.generateSimpleJsonObject(generator);
            LOGGER.info("Generated Output=" + baos.toString("UTF-32BE"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-32BE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-32BE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-32BE encoding: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonGeneratorUTFEncodedTests Failed");
    }

    @Test
    public void jsonGeneratorExceptionTests() {
        JsonGenerator generator;
        StringWriter sWriter;
        boolean pass = true;
        try {
            LOGGER.info("Trip NumberFormatException for write(double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(Double.NaN);
            LOGGER.warning("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            LOGGER.info("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException for write(double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(Double.NEGATIVE_INFINITY);
            LOGGER.warning("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            LOGGER.info("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException for write(double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(Double.POSITIVE_INFINITY);
            LOGGER.warning("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            LOGGER.info("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException for write(String,double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("badnumber", Double.NaN);
            LOGGER.warning("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            LOGGER.info("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException for write(String,double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("badnumber", Double.NEGATIVE_INFINITY);
            LOGGER.warning("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            LOGGER.info("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException for write(String,double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("badnumber", Double.POSITIVE_INFINITY);
            LOGGER.warning("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            LOGGER.info("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationExceptipn if an incomplete JSON is generated.");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("name", "value");
            generator.close();
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationExceptipn if an incomplete JSON is generated.");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string");
            generator.close();
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(JsonValue) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(JsonValue.TRUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("name");
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(BigInteger) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(new BigInteger(new Integer(Integer.MAX_VALUE).toString()));
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(BigDecimal) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(BigDecimal.valueOf(Integer.MIN_VALUE));
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(int) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(Integer.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(long) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(Long.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(double) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(Double.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(boolean) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(true);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for writeNull() if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeNull();
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for writeStartArray() if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeStartArray();
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for writeStartObject() if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeStartObject();
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,JsonValue) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", JsonValue.TRUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,String) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", "name");
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,BigInteger) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", new BigInteger(new Integer(Integer.MAX_VALUE).toString()));
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,BigDecimal) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", BigDecimal.valueOf(Integer.MIN_VALUE));
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,int) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", Integer.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,long) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", Long.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,double) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", Double.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,boolean) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", true);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for writeNull(String) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeNull("string");
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for writeStartArray(String) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeStartArray("string");
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for writeStartObject(String) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeStartObject("string");
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,JsonValue) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", "value");
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for writeEnd() when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().writeEnd();
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,BigInteger) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", new BigInteger(new Integer(Integer.MAX_VALUE).toString()));
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,BigDecimal) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", BigDecimal.valueOf(Integer.MIN_VALUE));
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,int) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", Integer.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,long) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", Long.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,double) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", Double.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String,boolean) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", false);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for writeNull(String) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().writeNull("name");
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(JsonValue) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(JsonValue.TRUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(String) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(JsonValue.TRUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(BigDecimal) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(BigDecimal.valueOf(Integer.MIN_VALUE));
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(BigInteger) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(new BigInteger(new Integer(Integer.MAX_VALUE).toString()));
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(int) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(Integer.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(long) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(Long.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(double) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(Double.MAX_VALUE);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for write(boolean) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(true);
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonGenerationException for for writeNull() when invoked with no context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().writeNull();
            LOGGER.warning("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            LOGGER.info("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonGeneratorExceptionTests Failed");
    }

    @Test
    public void flushTest() {
        boolean pass = true;
        try {
            LOGGER.info("Generate some partial Json and flush output.");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeStartObject("object").writeEnd().flush();
            LOGGER.info("Create expected partial JSON text with no whitespace");
            String expJson = "{\"object\":{}";
            LOGGER.info("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace((String)sWriter.toString());
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
            LOGGER.info("Generate additional Json to complete and flush output.");
            generator.writeStartArray("array").writeEnd().writeEnd().flush();
            expJson = "{\"object\":{},\"array\":[]}";
            LOGGER.info("Read the JSON text back from Writer removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)sWriter.toString());
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
            generator.close();
        }
        catch (Exception e) {
            Assertions.fail((String)"flushTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"flushTest Failed");
    }

    @Test
    public void jsonGeneratorIOErrorTests() {
        JsonGenerator generator;
        MyBufferedWriter mbw;
        boolean pass = true;
        try {
            LOGGER.info("Trip JsonException if there is an i/o error on JsonGenerator.close().");
            mbw = new MyBufferedWriter((Writer)new StringWriter());
            generator = Json.createGenerator((Writer)mbw);
            generator.writeStartObject().writeEnd();
            mbw.setThrowIOException(true);
            LOGGER.info("Calling JsonGenerator.close()");
            generator.close();
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonException if there is an i/o error on JsonGenerator.flush().");
            mbw = new MyBufferedWriter((Writer)new StringWriter());
            generator = Json.createGenerator((Writer)mbw);
            generator.writeStartObject().writeEnd();
            mbw.setThrowIOException(true);
            LOGGER.info("Calling JsonGenerator.flush()");
            generator.flush();
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonGeneratorIOErrorTests Failed");
    }

    @Test
    public void jsonGeneratorDocumentRootTest() {
        Generator genTest = new Generator();
        TestResult result = genTest.test();
        result.eval();
    }

    @Test
    public void jsonGeneratorStreamNotClosedTest() {
        ByteArrayOutputStreamCloseChecker stream = new ByteArrayOutputStreamCloseChecker();
        JsonGenerator gen = Json.createGenerator((OutputStream)stream);
        try {
            gen.writeStartObject();
            gen.write("foo", "bar");
            gen.close();
            throw new AssertionFailedError("It is expected a JsonGenerationException");
        }
        catch (JsonGenerationException e) {
            if (stream.closed) {
                throw new AssertionFailedError("The underlying stream is closed but it shouldn't because JSON object was not completed");
            }
            return;
        }
    }

    @Test
    public void jsonGeneratorStreamClosedTest() {
        ByteArrayOutputStreamCloseChecker stream = new ByteArrayOutputStreamCloseChecker();
        JsonGenerator gen = Json.createGenerator((OutputStream)stream);
        gen.writeStartObject();
        gen.write("foo", "bar");
        gen.writeEnd();
        gen.close();
        if (!stream.closed) {
            throw new AssertionFailedError("The underlying stream has to be closed because JSON object was completed");
        }
    }

    private static class ByteArrayOutputStreamCloseChecker
    extends ByteArrayOutputStream {
        private boolean closed = false;

        private ByteArrayOutputStreamCloseChecker() {
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

