/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.client.webtarget;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.client.webtarget.IteratedList;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_client_webtarget_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void imutableWithRespectToUriMatrixPathTest() throws JAXRSCommonClient.Fault {
        IteratedList<WebTarget> targets = new IteratedList<WebTarget>(WebTarget.class);
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("");
        targets.add(target);
        targets.doWithAll("matrixParam", "", new String[]{""});
        this.assertFaultEqualWebTargets(targets);
        targets.doWithAll("matrixParam", "matrix", new String[]{"st"});
        this.assertFaultEqualWebTargets(targets);
        TestUtil.logMsg("checked matrixParam() method");
        targets.doWithAll("path", "");
        this.assertFaultEqualWebTargets(targets);
        targets.doWithAll("path", "/");
        this.assertFaultEqualWebTargets(targets);
        targets.doWithAll("path", "path");
        this.assertFaultEqualWebTargets(targets);
        targets.doWithAll("path", "path/path/path");
        this.assertFaultEqualWebTargets(targets);
        TestUtil.logMsg("checked path() method");
    }

    @Test
    public void imutableWithRespectToUriQueryResolveTemplateTest() throws JAXRSCommonClient.Fault {
        IteratedList<WebTarget> targets = new IteratedList<WebTarget>(WebTarget.class);
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("");
        targets.add(target);
        targets.doWithAll("queryParam", "", new String[]{""});
        this.assertFaultEqualWebTargets(targets);
        targets.doWithAll("queryParam", "path", new String[]{"xyz"});
        this.assertFaultEqualWebTargets(targets);
        targets.doWithAll("queryParam", "xyz", new String[]{"path"});
        this.assertFaultEqualWebTargets(targets);
        TestUtil.logMsg("checked queryParam() method");
        targets.doWithAll("resolveTemplateFromEncoded", "", "");
        this.assertFaultEqualWebTargets(targets);
        targets.doWithAll("resolveTemplateFromEncoded", "path", "xyz");
        this.assertFaultEqualWebTargets(targets);
        targets.doWithAll("resolveTemplateFromEncoded", "path/path/path", "");
        this.assertFaultEqualWebTargets(targets);
        TestUtil.logMsg("checked resolveTemplateFromEncoded() method");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("", "path");
        targets.doWithAll("resolveTemplates", params);
        this.assertFaultEqualWebTargets(targets);
        params = new HashMap();
        params.put("path", "xyz");
        targets.doWithAll("resolveTemplates", params);
        this.assertFaultEqualWebTargets(targets);
        TestUtil.logMsg("checked resolveTemplates() method");
        targets.doWithAll("resolveTemplatesFromEncoded", params);
        this.assertFaultEqualWebTargets(targets);
        params = new HashMap();
        params.put("path", "xyz");
        targets.doWithAll("resolveTemplatesFromEncoded", params);
        this.assertFaultEqualWebTargets(targets);
        TestUtil.logMsg("checked resolveTemplatesFromEncoded() method");
    }

    @Test
    public void mutableWithRespectToConfigTest() throws JAXRSCommonClient.Fault {
        for (Method m : Configuration.class.getMethods()) {
            Class<?> ret = m.getReturnType();
            if (!WebTarget.class.isAssignableFrom(ret)) continue;
            throw new JAXRSCommonClient.Fault("Webterget instance created from configuration");
        }
    }

    @Test
    public void deepCopyConfigWebTargetLevelTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        Configuration config = client.getConfiguration();
        int registeredInstances = config.getInstances().size();
        WebTarget target1 = client.target("");
        WebTarget target2 = client.target("");
        target1.register((Object)new StringBeanEntityProvider());
        config = target2.getConfiguration();
        Assertions.assertTrue((config.getInstances().size() == registeredInstances ? 1 : 0) != 0, (String)"configuration() does not perform deep copy");
    }

    @Test
    public void deepCopyConfigClientLevelTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        client.property("test", (Object)"test");
        Configuration conf2 = ClientBuilder.newClient().getConfiguration();
        Object o = conf2.getProperty("test");
        JAXRSClientIT.assertNull(o, "configuration() does not perform deep copy, o=", o);
    }

    @Test
    public void webTargetConfigNotImpactClientTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("resource");
        target.property("any", (Object)"some");
        Object property = client.getConfiguration().getProperty("any");
        Assertions.assertTrue((property == null ? 1 : 0) != 0, (String)"WebTarget config impacts Client config");
        client.property("some", (Object)"any");
        property = target.getConfiguration().getProperty("some");
        Assertions.assertTrue((property == null ? 1 : 0) != 0, (String)"Client config impacts WebTarget config");
    }

    void assertFaultEqualWebTargets(List<WebTarget> t) throws JAXRSCommonClient.Fault {
        TestUtil.logMsg("Testing " + t.size() + " WebTargets");
        for (int i = 0; i != t.size(); ++i) {
            for (int j = i + 1; j != t.size(); ++j) {
                Assertions.assertTrue((t.get(i) != t.get(j) ? 1 : 0) != 0, (String)("WebTargets" + t.get(i).toString() + "and" + t.get(j).toString() + "are equal!"));
            }
        }
    }
}

