/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.common.client;

import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.client.TextCaser;
import ee.jakarta.tck.ws.rs.common.webclient.http.HttpResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.httpclient.Header;

public class ApacheResponseAdapter
extends HttpResponse {
    private Response response;
    private String entity = null;
    private TextCaser caser = null;

    public ApacheResponseAdapter(Response response, String host, int port) {
        super(host, port, port == 443, null, null);
        this.response = response;
        this.caser = TextCaser.NONE;
    }

    public ApacheResponseAdapter(Response response, String host, int port, TextCaser caser) {
        this(response, host, port);
        this.caser = caser;
    }

    @Override
    public String getStatusCode() {
        return Integer.toString(this.response.getStatus());
    }

    @Override
    public String getResponseBodyAsString() throws IOException {
        if (this.entity == null) {
            this.entity = (String)this.response.readEntity(String.class);
        }
        return this.entity == null ? "" : this.caser.getCasedText(this.entity);
    }

    @Override
    public String getResponseBodyAsRawString() throws IOException {
        return this.getResponseBodyAsString();
    }

    @Override
    public String getReasonPhrase() {
        return this.response.toString();
    }

    @Override
    public Header[] getResponseHeaders() {
        String[] sHeaders;
        LinkedList<Header> headers = new LinkedList<Header>();
        MultivaluedMap mHeaders = this.response.getMetadata();
        for (String header : sHeaders = JaxrsCommonClient.getMetadata((MultivaluedMap<String, Object>)mHeaders)) {
            String[] split = header.split(":", 2);
            headers.add(new Header(split[0], split[1]));
        }
        return headers.toArray(new Header[headers.size()]);
    }

    @Override
    public Header getResponseHeader(String headerName) {
        for (Header header : this.getResponseHeaders()) {
            if (!header.getName().equals(headerName)) continue;
            return header;
        }
        return null;
    }

    @Override
    public String getResponseEncoding() {
        String headerVal;
        int idx;
        String encoding = null;
        Header header = this.getResponseHeader("Content-Type");
        if (header != null && (idx = (headerVal = header.getValue()).indexOf(";charset=")) > -1) {
            encoding = headerVal.substring(idx + 9);
        }
        return encoding;
    }
}

