/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.nullvalue;

import ee.jakarta.tck.json.bind.defaultmapping.nullvalue.model.NullArrayContainer;
import ee.jakarta.tck.json.bind.defaultmapping.nullvalue.model.NullValueContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class NullValueMappingTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testNullAttributeValue() {
        String jsonString = this.jsonb.toJson((Object)new NullValueContainer(){
            {
                this.setInstance(null);
            }
        });
        MatcherAssert.assertThat((String)"Failed to ignore displaying property with null value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        NullValueContainer unmarshalledObject = (NullValueContainer)this.jsonb.fromJson("{ }", NullValueContainer.class);
        MatcherAssert.assertThat((String)"Failed to ignore calling setter of absent property during unmarshalling.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)"Test String"));
        unmarshalledObject = (NullValueContainer)this.jsonb.fromJson("{ \"instance\" : null }", NullValueContainer.class);
        MatcherAssert.assertThat((String)"Failed to set property to null.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testNullArrayValue() {
        String jsonString = this.jsonb.toJson((Object)new NullArrayContainer(){
            {
                this.setInstance(new String[]{"Test 1", null, "Test 2"});
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly display null array value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test 1\"\\s*,\\s*null\\s*,\\s*\"Test 2\"\\s*\\]\\s*\\}"));
        NullArrayContainer unmarshalledObject = (NullArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", null, \"Test 2\" ] }", NullArrayContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly set null array value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"Test 1", null, "Test 2"}));
    }
}

