/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.instantiation;

import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.CreatorPlusFactoryContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.CreatorWithAdapterContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.CreatorWithDeserializerContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.IllegalInstanceFactoryCreatorContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.MultipleCreatorsContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.MultipleFactoryCreatorsContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.SimpleCreatorContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.SimpleCreatorPlusFieldsContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.SimpleCreatorRenameContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.SimpleFactoryCreatorContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InstantiationCustomizationTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testCustomConstructor() {
        String toDeserialize = "{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }";
        SimpleCreatorContainer unmarshalledObject = (SimpleCreatorContainer)this.jsonb.fromJson(toDeserialize, SimpleCreatorContainer.class);
        String validationMessage = "Failed to instantiate type using JsonbCreator annotated constructor during unmarshalling.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Constructor String"));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntegerInstance(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((String)validationMessage, (Object)Float.valueOf(unmarshalledObject.getFloatInstance()), (Matcher)Matchers.is((Object)Float.valueOf(2.0f)));
    }

    @Test
    public void testCustomConstructorPlusFields() {
        String toDeserialize = "{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }";
        SimpleCreatorPlusFieldsContainer unmarshalledObject = (SimpleCreatorPlusFieldsContainer)this.jsonb.fromJson(toDeserialize, SimpleCreatorPlusFieldsContainer.class);
        String validationMessage = "Failed to instantiate type using JsonbCreator annotated constructor and set remaining fields as normally during unmarshalling.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Constructor String"));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntegerInstance(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((String)validationMessage, (Object)Float.valueOf(unmarshalledObject.getFloatInstance()), (Matcher)Matchers.is((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void testFactoryMethod() {
        String toDeserialize = "{ \"constructorString\" : \"Test String\" }";
        SimpleFactoryCreatorContainer unmarshalledObject = (SimpleFactoryCreatorContainer)this.jsonb.fromJson(toDeserialize, SimpleFactoryCreatorContainer.class);
        String validationMessage = "Failed to instantiate type using JsonbCreator annotated method during unmarshalling.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Factory String"));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntegerInstance(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((String)validationMessage, (Object)Float.valueOf(unmarshalledObject.getFloatInstance()), (Matcher)Matchers.is((Object)Float.valueOf(3.0f)));
    }

    @Test
    public void testMultipleConstructors() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", MultipleCreatorsContainer.class), (String)"A JsonbException is expected when unmarshalling to a class with multiple constructors annotated with JsonbCreator.");
    }

    @Test
    public void testMultipleFactories() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", MultipleFactoryCreatorsContainer.class), (String)"A JsonbException is expected when unmarshalling to a class with multiple methods annotated with JsonbCreator.");
    }

    @Test
    public void testConstructorPlusFactory() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", CreatorPlusFactoryContainer.class), (String)"A JsonbException is expected when unmarshalling to a class with multiple JsonbCreator annotation instances.");
    }

    @Test
    public void testIllegalFactoryType() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"integerInstance\" : 1, \"floatInstance\" : 1.0 }", IllegalInstanceFactoryCreatorContainer.class), (String)"A JsonbException is expected when unmarshalling to a class with a method annotated with JsonbCreator returning a type different than the class type.");
    }

    @Test
    public void testRenamedProperty() {
        String toDeserialize = "{ \"stringInstance\" : \"Test String\", \"intInstance\" : 1, \"floatInstance\" : 1.0 }";
        SimpleCreatorRenameContainer unmarshalledObject = (SimpleCreatorRenameContainer)this.jsonb.fromJson(toDeserialize, SimpleCreatorRenameContainer.class);
        String validationMessage = "Failed to instantiate type using JsonbCreator annotated constructor having a JsonbProperty annotated argument during unmarshalling.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Constructor String"));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntegerInstance(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)validationMessage, (Object)Float.valueOf(unmarshalledObject.getFloatInstance()), (Matcher)Matchers.is((Object)Float.valueOf(2.0f)));
    }

    @Test
    public void testJsonbDeserializerOnCreatorParameter() {
        CreatorWithDeserializerContainer c = (CreatorWithDeserializerContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", CreatorWithDeserializerContainer.class);
        String expected = "Test String Deserialized";
        MatcherAssert.assertThat((String)"JsonbDeserializer on the JsonbCreator parameter was not executed.", (Object)c.getStringInstance(), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testJsonbAdapterOnCreatorParameter() {
        CreatorWithAdapterContainer c = (CreatorWithAdapterContainer)this.jsonb.fromJson("{ \"instance\" : \"string value\" }", CreatorWithAdapterContainer.class);
        String expected = "string value";
        MatcherAssert.assertThat((String)"JsonbAdapter on the JsonbCreator parameter was not executed.", (Object)c.getStringWrapper(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"JsonbAdapter on the JsonbCreator parameter was not executed.", (Object)expected, (Matcher)Matchers.is((Object)c.getStringWrapper().getWrapped()));
    }
}

