/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.ClientErrorExceptionMapper;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.ExceptionFromMappedException;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.ExceptionFromMappedExceptionMapper;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.FilterChainTestException;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.FilterChainTestExceptionMapper;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.PlainExceptionMapper;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.ResponseFilter;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.ThrowableMapper;
import ee.jakarta.tck.ws.rs.spec.provider.exceptionmapper.WebAppExceptionMapper;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_exceptionmapper_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/exceptionmapper/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_exceptionmapper_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, ClientErrorExceptionMapper.class, ExceptionFromMappedException.class, ExceptionFromMappedExceptionMapper.class, FilterChainTestException.class, FilterChainTestExceptionMapper.class, PlainExceptionMapper.class, ResponseFilter.class, RuntimeExceptionMapper.class, ThrowableMapper.class, WebAppExceptionMapper.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void throwableTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "throwable"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ThrowableMapper.class.getName());
        this.invoke();
    }

    @Test
    public void exceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "exception"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, PlainExceptionMapper.class.getName());
        this.invoke();
    }

    @Test
    public void runtimeExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "runtime"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, RuntimeExceptionMapper.class.getName());
        this.invoke();
    }

    @Test
    public void webapplicationExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "webapp"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, WebAppExceptionMapper.class.getName());
        this.invoke();
    }

    @Test
    public void clientErrorExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "clienterror"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ClientErrorExceptionMapper.class.getName());
        this.invoke();
    }

    @Test
    public void filterChainTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "chain"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ResponseFilter.class.getName());
        this.invoke();
    }

    @Test
    public void mappedExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "mapped"));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, WebAppExceptionMapper.class.getName());
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
    }
}

