/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.SecurityContextImpl;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.ContextOperation;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.RequestFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.SecondRequestFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.TemplateFilter;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 111355567568365703L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_container_requestcontext_web/resource");
        this.setPrintEntity(true);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/container/requestcontext/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_container_requestcontext_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, ContextOperation.class, RequestFilter.class, SecondRequestFilter.class, TemplateFilter.class, SecurityContextImpl.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void abortWithTest() throws JAXRSCommonClient.Fault {
        this.invokeRequestAndCheckResponse(ContextOperation.ABORTWITH);
    }

    @Test
    public void getAcceptableLanguagesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accpet-Language:en-us");
        this.invokeRequestAndCheckResponse(ContextOperation.GETACCEPTABLELANGUAGES);
    }

    @Test
    public void getAcceptableLanguagesIsSortedTest() throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("Check the #getAcceptableLanguages is sorted according to their q-value");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept-Language: da, en-gb;q=0.6, en-us;q=0.7");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "da");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "en-us");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "en-gb");
        this.invokeRequestAndCheckResponse(ContextOperation.GETACCEPTABLELANGUAGES);
    }

    @Test
    public void getAcceptableLanguagesIsReadOnlyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept-Language: da, en-gb;q=0.6, en-us;q=0.7");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "ca-fr");
        this.invokeRequestAndCheckResponse(ContextOperation.GETACCEPTABLELANGUAGESISREADONLY);
    }

    @Test
    public void getAcceptableMediaTypesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.APPLICATION_JSON_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/json");
        this.invokeRequestAndCheckResponse(ContextOperation.GETACCEPTABLEMEDIATYPES);
    }

    @Test
    public void getAcceptableMediaTypesIsSortedTest() throws JAXRSCommonClient.Fault {
        JAXRSClientIT.logMsg("Check the #getAcceptableMediaTypes is sorted according to their q-value");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/*;q=0.3, text/html;q=0.7, text/html;level=1,text/html;level=2;q=0.4, */*;q=0.5");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/html;level=1");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/html;q=0.7");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "*/*;q=0.5");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/html;level=2;q=0.4");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/*;q=0.3");
        this.invokeRequestAndCheckResponse(ContextOperation.GETACCEPTABLEMEDIATYPES);
    }

    @Test
    public void getAcceptableMediaTypesIsReadOnlyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "application/json");
        this.invokeRequestAndCheckResponse(ContextOperation.GETACCEPTABLEMEDIATYPESISREADONLY);
    }

    @Test
    public void getCookiesTest() throws JAXRSCommonClient.Fault {
        String[] cookies;
        for (String cookie : cookies = new String[]{"cookie1", "coookkkie99", "cookiiieee999"}) {
            String sCookie = "Cookie: $Version=1; " + cookie + "=" + cookie + ";";
            this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, sCookie);
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, cookie);
            this.invokeRequestAndCheckResponse(ContextOperation.GETCOOKIES);
        }
    }

    @Test
    public void getCookiesIsReadonlyTest() throws JAXRSCommonClient.Fault {
        this.setPrintEntity(true);
        this.invokeRequestAndCheckResponse(ContextOperation.GETCOOKIESISREADONLY);
    }

    @Test
    public void getDateTest() throws JAXRSCommonClient.Fault {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        Date date = calendar.getTime();
        String gmt = JaxrsUtil.createDateFormat(TimeZone.getTimeZone("GMT")).format(date);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Date:" + gmt);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(date.getTime()));
        this.invokeRequestAndCheckResponse(ContextOperation.GETDATE);
    }

    @Test
    public void getDateIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETDATE);
    }

    @Test
    public void getEntityStreamTest() throws JAXRSCommonClient.Fault {
        String entity = "EnTiTyStReAmTeSt";
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.POST, ContextOperation.GETENTITYSTREAM);
    }

    @Test
    public void getHeadersTest() throws JAXRSCommonClient.Fault {
        for (int i = 1; i != 5; ++i) {
            String header = "header" + i + ":header" + i;
            this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, header);
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, header);
        }
        this.invokeRequestAndCheckResponse(ContextOperation.GETHEADERS);
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        this.setPrintEntity(true);
        this.invokeRequestAndCheckResponse(ContextOperation.GETHEADERSISMUTABLE);
    }

    @Test
    public void getHeaderStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ContextOperation.GETHEADERSTRING2.name());
        this.invokeRequestAndCheckResponse(ContextOperation.GETHEADERSTRING2);
    }

    @Test
    public void getLanguageTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Language:en-gb");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "en-gb");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLANGUAGE);
    }

    @Test
    public void getLanguageIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLANGUAGE);
    }

    @Test
    public void getLengthTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "12345678901234567890");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "20");
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.POST, ContextOperation.GETLENGTH);
    }

    @Test
    public void getLengthWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "-1");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLENGTH);
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        this.addHeader("Content-Type", "application/svg+xml");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/svg+xml");
        this.invokeRequestAndCheckResponse(ContextOperation.GETMEDIATYPE);
    }

    @Test
    public void getMediaTypeIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETMEDIATYPE);
    }

    @Test
    public void getMethodTest() throws JAXRSCommonClient.Fault {
        String method = JAXRSCommonClient.Request.OPTIONS.name();
        String header = "OPERATION:" + ContextOperation.GETMETHOD.name();
        this.getTestCase().setRequestType(method);
        this.getTestCase().setUrlRequest(this.getContextRoot());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, method);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, header);
        this.invoke();
    }

    @Test
    public void getPropertyIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETPROPERTY);
    }

    @Test
    public void getPropertyNamesTest() throws JAXRSCommonClient.Fault {
        for (int i = 0; i != 5; ++i) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "getSetProperty".toLowerCase() + i);
        }
        this.invokeRequestAndCheckResponse(ContextOperation.GETPROPERTYNAMES);
    }

    @Test
    public void getPropertyNamesIsReadOnlyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "0");
        this.invokeRequestAndCheckResponse(ContextOperation.GETPROPERTYNAMESISREADONLY);
    }

    @Test
    public void getRequestTest() throws JAXRSCommonClient.Fault {
        String method = JAXRSCommonClient.Request.OPTIONS.name();
        String header = "OPERATION:" + ContextOperation.GETREQUEST.name();
        this.getTestCase().setRequestType(method);
        this.getTestCase().setUrlRequest(this.getContextRoot());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, method);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, header);
        this.invoke();
    }

    @Test
    public void getSecurityContextPrincipalIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETSECURITYCONTEXT);
    }

    @Test
    public void getUriInfoTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, this.getAbsoluteUrl());
        this.invokeRequestAndCheckResponse(ContextOperation.GETURIINFO);
    }

    @Test
    public void hasEntityTest() throws JAXRSCommonClient.Fault {
        this.setRequestContentEntity("entity");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "true");
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.POST, ContextOperation.HASENTITY);
    }

    @Test
    public void hasEntityWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "false");
        this.invokeRequestAndCheckResponse(ContextOperation.HASENTITY);
    }

    @Test
    public void removePropertyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.REMOVEPROPERTY);
    }

    @Test
    public void setEntityStreamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "SetEntityStreamEntity");
        this.invokeRequestAndCheckResponse(ContextOperation.SETENTITYSTREAM);
    }

    @Test
    public void setMethodTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, JAXRSCommonClient.Request.OPTIONS.name());
        this.invokeRequestAndCheckResponse(ContextOperation.SETMETHOD);
    }

    @Test
    public void setPropertyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "getSetProperty");
        this.invokeRequestAndCheckResponse(ContextOperation.SETPROPERTY);
    }

    @Test
    public void setPropertyNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.SETPROPERTYNULL);
    }

    @Test
    public void setPropertyIsReflectedInServletRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "getSetProperty");
        this.invokeRequestAndCheckResponse(ContextOperation.SETPROPERTYCONTEXT);
    }

    @Test
    public void setRequestUriOneUriTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "http://xx.yy:888/base/resource/sub");
        this.invokeRequestAndCheckResponse(ContextOperation.SETREQUESTURI1);
    }

    @Test
    public void setRequestUriTwoUrisTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "http://xx.yy:888/base/resource/sub");
        this.invokeRequestAndCheckResponse(ContextOperation.SETREQUESTURI2);
    }

    @Test
    public void setSecurityContextTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "PrincipalName");
        this.invokeRequestAndCheckResponse(ContextOperation.SETSECURITYCONTEXT);
    }

    protected void invokeRequestAndCheckResponse(ContextOperation contextOperation) throws JAXRSCommonClient.Fault {
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, contextOperation);
    }

    protected void invokeRequestAndCheckResponse(JAXRSCommonClient.Request req, ContextOperation contextOperation) throws JAXRSCommonClient.Fault {
        String operation = contextOperation.name();
        String request = this.buildRequest(req, operation.toLowerCase());
        String header = "OPERATION:" + operation;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, operation);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, header);
        this.invoke();
    }
}

