/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.arrays;

import ee.jakarta.tck.json.bind.defaultmapping.arrays.model.MultiDimensionalArrayContainer;
import ee.jakarta.tck.json.bind.defaultmapping.arrays.model.PrimitiveArrayContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ArraysMappingTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testPrimitiveArray() {
        final int[] instance = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        String jsonString = this.jsonb.toJson((Object)new PrimitiveArrayContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with int[] attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*-2147483648\\s*,\\s*2147483647\\s*\\]\\s*\\}"));
        PrimitiveArrayContainer unmarshalledObject = (PrimitiveArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ -2147483648, 2147483647 ] }", PrimitiveArrayContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with int[] attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testMultiDimensionalArray() {
        final Integer[][] instance = new Integer[][]{{1, null, 3}, {Integer.MIN_VALUE, Integer.MAX_VALUE}};
        String jsonString = this.jsonb.toJson((Object)new MultiDimensionalArrayContainer(){
            {
                this.setInstance(instance);
            }
        });
        String validationPattern = "\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*\\[\\s*1\\s*,\\s*null\\s*,\\s*3\\s*\\]\\s*,\\s*\\[\\s*-2147483648\\s*,\\s*2147483647\\s*\\]\\s*\\]\\s*\\}";
        MatcherAssert.assertThat((String)"Failed to marshal object with int[][] attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationPattern));
        String toDeserialize = "{ \"instance\" : [ [ 1, null, 3 ], [ -2147483648, 2147483647 ] ] }";
        MultiDimensionalArrayContainer unmarshalledObject = (MultiDimensionalArrayContainer)this.jsonb.fromJson(toDeserialize, MultiDimensionalArrayContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with int[][] attribute value.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }
}

