/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria;

import java.util.ArrayList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.soteria.DefaultService;

public class SoteriaServiceProviders {
    private static final Map<Class<? extends Object>, Object> SERVICE_PROVIDERS = new ConcurrentHashMap<Class<? extends Object>, Object>();

    public static <T> T getServiceProvider(Class<T> serviceProviderClass) {
        return serviceProviderClass.cast(SERVICE_PROVIDERS.computeIfAbsent(serviceProviderClass, e -> SoteriaServiceProviders.loadService(e)));
    }

    private static <T> T loadService(Class<T> serviceProviderClass) {
        ArrayList defaultService = new ArrayList(1);
        ArrayList nonDefaultServices = new ArrayList();
        ServiceLoader.load(serviceProviderClass).forEach(e -> {
            if (e instanceof DefaultService) {
                defaultService.add(e);
            } else {
                nonDefaultServices.add(e);
            }
        });
        if (nonDefaultServices.size() > 1) {
            throw new IllegalStateException("More than 1 implementation of " + serviceProviderClass + " found.");
        }
        if (defaultService.size() > 1) {
            throw new IllegalStateException("More than 1 implementation of default " + serviceProviderClass + " found.");
        }
        if (nonDefaultServices.size() == 1) {
            return (T)nonDefaultServices.get(0);
        }
        return (T)defaultService.get(0);
    }
}

