/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ResetMetricsHandler;
import com.sun.messaging.jmq.jmsserver.memory.MemoryManager;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ConsumerSpi;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SupportUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DebugHandler
extends AdminCmdHandler {
    private static boolean DEBUG = DebugHandler.getDEBUG();

    public DebugHandler(AdminDataHandler parent) {
        super(parent);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        block151: {
            status = 200;
            msg = null;
            logOnly = false;
            if (DebugHandler.DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": " + String.valueOf(cmd_props));
            }
            cmd = (String)cmd_props.get("JMQCommand");
            cmdarg = (String)cmd_props.get("JMQCommandArg");
            target = (String)cmd_props.get("JMQTarget");
            targetType = (String)cmd_props.get("JMQTargetType");
            p = (Properties)this.getBodyObject(cmd_msg);
            if (DebugHandler.DEBUG) {
                this.logger.log(4, "DEBUG message received:");
                this.logger.log(4, "\tJMQCommand: " + cmd);
                this.logger.log(4, "\tJMQCommandArg: " + cmdarg);
                this.logger.log(4, "\tJMQTarget: " + target);
                this.logger.log(4, "\tOptional Properties: " + String.valueOf(p));
            }
            debugHash = null;
            fileStr = p.getProperty("file");
            reply = new Packet(con.useDirectBuffers());
            reply.setPacketType(5);
            if (cmd == null || cmdarg == null) {
                status = 400;
                msg = "Null/Missing values for JMQCommand and/or JMQCommandArg properties.";
                DebugHandler.setProperties(reply, 73, status, (String)msg);
                this.parent.sendReply(con, cmd_msg, reply);
                return true;
            }
            if (cmd.equals("update") && cmdarg.equals("bkr")) {
                bcfg = Globals.getConfig();
                try {
                    bcfg.updateProperties(p, true);
                }
                catch (PropertyUpdateException e) {
                    status = 400;
                    msg = e.getMessage();
                    this.logger.log(16, (String)msg);
                }
                catch (IOException e) {
                    status = 500;
                    msg = e.toString();
                    this.logger.log(16, (String)msg);
                }
                DebugHandler.setProperties(reply, 73, status, (String)msg);
                this.parent.sendReply(con, cmd_msg, reply);
                return true;
            }
            if (cmd.equals("dump") || cmd.equals("query")) {
                if (cmd.equals("dump")) {
                    logOnly = true;
                    if (fileStr == null) {
                        fileStr = "dumpOutput";
                    }
                }
                try {
                    debugHash = this.getDebugInfo(cmdarg, target, targetType, p);
                }
                catch (Exception ex) {
                    status = 500;
                    msg = "Error " + cmd + "ing " + cmdarg + " because " + ex.getMessage();
                    this.logger.logStack(8, (String)msg, (Throwable)ex);
                }
            } else if (cmd.equals("list")) {
                debugHash = new Hashtable<String, Object>();
                if (cmdarg.equals("dst")) {
                    itrs = DestinationList.getAllDestinations(null);
                    itr = itrs[0];
                    while (itr.hasNext()) {
                        d = (Destination)itr.next();
                        debugHash.put(d.getDestinationUID().toString(), DestType.toString((int)d.getType()) + ":" + (d.isStored() != false ? "stored" : "not stored"));
                    }
                } else if (cmdarg.equals("con")) {
                    debugHash = new Hashtable<String, Object>();
                    if (target == null) {
                        itr = Consumer.getAllConsumers();
                        if (!itr.hasNext()) {
                            status = 500;
                            msg = "No consumers on the broker";
                        }
                        while (itr.hasNext()) {
                            c = (Consumer)itr.next();
                            if (c == null) continue;
                            cxn = (IMQConnection)Globals.getConnectionManager().getConnection(c.getConnectionUID());
                            cuid = c.getConsumerUID();
                            cxuid = c.getConnectionUID();
                            debugHash.put(String.valueOf(cuid == null ? 0L : cuid.longValue()), (cxn == null ? "none" : cxn.getRemoteConnectionString()) + " [" + (cxuid == null ? 0L : cxuid.longValue()) + "]");
                        }
                    } else if (targetType == null) {
                        msg = "Please supply targetType if you are supplying a target ";
                        status = 500;
                    } else if (targetType.equals("t") || targetType.equals("q")) {
                        try {
                            isQueue = false;
                            if (targetType.equals("q")) {
                                isQueue = true;
                            }
                            uid = null;
                            d = null;
                            if (status != 500) {
                                uid = DestinationUID.getUID(target, isQueue);
                                ds = DestinationList.getDestination(null, uid);
                                d = ds[0];
                            }
                            if (status != 500 && d == null) {
                                status = 500;
                                msg = "Error listing consumers on destination  " + target + " unknown destination";
                            }
                            if (status == 500) ** GOTO lbl469
                            itr = d.getConsumers();
                            if (!itr.hasNext()) {
                                status = 500;
                                msg = "No consumers on destination  " + target;
                            }
                            while (itr.hasNext()) {
                                c = (Consumer)itr.next();
                                cxn = (IMQConnection)Globals.getConnectionManager().getConnection(c.getConnectionUID());
                                debugHash.put(String.valueOf(c.getConsumerUID().longValue()), (cxn == null ? "" : cxn.getRemoteConnectionString()) + " [" + String.valueOf(c.getConnectionUID() == null ? "none" : Long.valueOf(c.getConnectionUID().longValue())) + "]");
                            }
                        }
                        catch (Exception ex) {
                            status = 500;
                            msg = "Error listing consumers on connection  " + target + " because " + ex.toString();
                            this.logger.logStack(8, (String)msg, (Throwable)ex);
                        }
                    } else if (targetType.equals("ses")) {
                        try {
                            uid = new SessionUID(Long.parseLong(target));
                            ses = Session.getSession(uid);
                            if (ses == null) {
                                status = 500;
                                msg = "Error listing consumers on session  " + target + " unknown sessionUID";
                            }
                            itr = ses.getConsumers();
                            if (!itr.hasNext()) {
                                status = 500;
                                msg = "No consumers on session  " + target;
                            }
                            while (itr.hasNext()) {
                                c = (ConsumerSpi)itr.next();
                                if (!uid.equals((Object)c.getConnectionUID())) continue;
                                debugHash.put(String.valueOf(c.getConsumerUID().longValue()), c.getDestinationUID().toString());
                            }
                        }
                        catch (Exception ex) {
                            status = 500;
                            msg = "Error listing consumers on connection  " + target + " because " + ex.toString();
                            this.logger.logStack(8, (String)msg, (Throwable)ex);
                        }
                    } else if (targetType.equals("cxn")) {
                        try {
                            uid = new ConnectionUID(Long.parseLong(target));
                            cxn = (IMQConnection)Globals.getConnectionManager().getConnection(uid);
                            if (cxn == null) {
                                status = 500;
                                msg = "Error listing consumers on connection  " + target + " unknown connectionUID";
                            }
                            itr = Consumer.getAllConsumers();
                            while (itr.hasNext()) {
                                c = (Consumer)itr.next();
                                if (!uid.equals((Object)c.getConnectionUID())) continue;
                                debugHash.put(String.valueOf(c.getConsumerUID().longValue()), c.getDestinationUID().toString());
                            }
                        }
                        catch (Exception ex) {
                            status = 500;
                            msg = "Error listing consumers on connection  " + target + " because " + ex.toString();
                            this.logger.logStack(8, (String)msg, (Throwable)ex);
                        }
                    } else {
                        status = 500;
                        msg = "Unknown targetType (-t) " + target + "\n Valid formats are of the form: [q|t|ses|cxn]";
                    }
                } else if (cmdarg.equals("prd")) {
                    debugHash = new Hashtable<K, V>();
                    if (target == null) {
                        itr = Producer.getAllProducers();
                        while (itr.hasNext()) {
                            c = (Producer)itr.next();
                            cxn = (IMQConnection)Globals.getConnectionManager().getConnection(c.getConnectionUID());
                            debugHash.put(String.valueOf(c.getProducerUID().longValue()), cxn.getRemoteConnectionString() + " [" + c.getConnectionUID().longValue() + "]");
                        }
                    } else if (targetType == null) {
                        msg = "Please supply targetType if you are supplying a target ";
                        status = 500;
                    } else if (targetType.equals("t") || targetType.equals("q")) {
                        isQueue = false;
                        if (targetType.equals("q")) {
                            isQueue = true;
                        }
                        try {
                            uid = DestinationUID.getUID(target, isQueue);
                            ds = DestinationList.getDestination(null, uid);
                            d = ds[0];
                            if (d == null) {
                                status = 500;
                                msg = "Error listing producers on destination  " + target + " unknown destination";
                            }
                            itr = d.getProducers();
                            while (itr.hasNext()) {
                                c = (Producer)itr.next();
                                cxn = (IMQConnection)Globals.getConnectionManager().getConnection(c.getConnectionUID());
                                debugHash.put(String.valueOf(c.getProducerUID().longValue()), cxn.getRemoteConnectionString() + " [" + c.getConnectionUID().longValue() + "]");
                            }
                        }
                        catch (Exception ex) {
                            status = 500;
                            msg = "Error listing producers on connection  " + target + " because " + ex.toString();
                            this.logger.logStack(8, (String)msg, (Throwable)ex);
                        }
                    } else if (targetType.equals("cxn")) {
                        try {
                            uid = new ConnectionUID(Long.parseLong(target));
                            cxn = (IMQConnection)Globals.getConnectionManager().getConnection(uid);
                            if (cxn == null) {
                                status = 500;
                                msg = "Error listing producers on connection  " + target + " unknown connectionUID";
                            }
                            itr = Producer.getAllProducers();
                            while (itr.hasNext()) {
                                c = (Producer)itr.next();
                                if (!uid.equals((Object)c.getConnectionUID())) continue;
                                debugHash.put(String.valueOf(c.getProducerUID().longValue()), c.getDestinationUID().toString());
                            }
                        }
                        catch (Exception ex) {
                            status = 500;
                            msg = "Error listing producers on connection  " + target + " because " + ex.toString();
                            this.logger.logStack(8, (String)msg, (Throwable)ex);
                        }
                    } else {
                        status = 500;
                        msg = "Unknown targetType (-t) " + targetType + "\n Valid formats are of the form: [t|q|cxn]";
                    }
                } else {
                    status = 500;
                    msg = "Unknown argument " + cmdarg;
                }
            } else if (cmd.equals("debug")) {
                debugStr = (String)p.get("enable");
                if (debugStr != null && !debugStr.equalsIgnoreCase("true") && !debugStr.equalsIgnoreCase("false")) {
                    status = 500;
                    msg = "bad enable flag setting " + debugStr + " defauling to false";
                }
                v0 = debugOn = debugStr == null || Boolean.parseBoolean(debugStr) != false;
                if (cmdarg.equals("reset")) {
                    if (targetType == null) {
                        msg = "Please supply targetType (-t)\n Valid formats are of the form: [metrics|jdbcconnpool]";
                        status = 500;
                    } else if (targetType.equalsIgnoreCase("jdbcconnpool")) {
                        try {
                            if (Globals.getStore().isJDBCStore()) {
                                Globals.getStore().resetConnectionPool();
                                break block151;
                            }
                            status = 500;
                            msg = "Operation is not applicable for a file-based data store.";
                        }
                        catch (Exception ex) {
                            status = 500;
                            msg = "Error resetting JDBC connection pool because " + ex.toString();
                            this.logger.logStack(8, (String)msg, (Throwable)ex);
                        }
                    } else if (targetType.equalsIgnoreCase("metrics")) {
                        ResetMetricsHandler.resetAllMetrics();
                    }
                } else if (cmdarg.equals("fault")) {
                    faultName = (String)p.get("name");
                    if (faultName == null) {
                        faultName = target;
                    }
                    faultSelector = (String)p.get("selector");
                    fi = FaultInjection.getInjection();
                    if (debugStr != null && debugStr.equalsIgnoreCase("false")) {
                        if (faultName == null) {
                            fi.setFaultInjection(false);
                        } else {
                            fi.unsetFault(faultName);
                        }
                    } else {
                        fi.setFaultInjection(true);
                        if (faultName != null) {
                            try {
                                fi.setFault(faultName, faultSelector, p);
                            }
                            catch (Exception ex) {
                                status = 500;
                                msg = "Bad Selector " + faultSelector;
                            }
                        }
                    }
                } else if (cmdarg.equals("gc")) {
                    this.logger.log(8, "GC'ing the system");
                    System.gc();
                    usedMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    msg = "Used memory is " + usedMem / 1024L + "k,  this is " + usedMem * 100L / Runtime.getRuntime().maxMemory() + "% of " + Runtime.getRuntime().maxMemory() / 1024L + "k";
                    this.logger.log(8, (String)msg);
                    debugHash = new Hashtable<K, V>();
                    debugHash.put("Memory", msg);
                    debugHash.put("Used", usedMem / 1024L + "k");
                    debugHash.put("Total", Runtime.getRuntime().totalMemory() / 1024L + "k");
                    debugHash.put("Free", Runtime.getRuntime().freeMemory() / 1024L + "k");
                    debugHash.put("Max", Runtime.getRuntime().maxMemory() / 1024L + "k");
                } else if (cmdarg.equals("threads")) {
                    try {
                        debugHash = new Hashtable<K, V>();
                        debugHash.put("threads", "dumped to log");
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Error " + cmd + "ing " + cmdarg + " because " + ex.getMessage();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                    this.logger.log(8, "Dumping threads:\n" + SupportUtil.getAllStackTraces((String)"\t"));
                } else if (cmdarg.equals("pkt")) {
                    IMQBasicConnection.dumpPacket(debugOn);
                } else if (cmdarg.equals("pktin")) {
                    IMQBasicConnection.dumpInPacket(debugOn);
                } else if (cmdarg.equals("pktout")) {
                    IMQBasicConnection.dumpOutPacket(debugOn);
                } else if (cmdarg.equals("class")) {
                    try {
                        cl = Class.forName(target);
                        fields = cl.getDeclaredFields();
                        found = false;
                        for (i = 0; i < fields.length; ++i) {
                            if (!fields[i].getName().equals("DEBUG")) continue;
                            this.logger.log(8, "Turn " + (debugOn != false ? "on" : "off") + " debug for class " + target);
                            f = fields[i];
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    f.setAccessible(true);
                                    return null;
                                }
                            });
                            fields[i].setBoolean(null, debugOn);
                            found = true;
                            break;
                        }
                        if (!found) {
                            throw new NoSuchFieldException("DEBUG");
                        }
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Unable to set DEBUG on class " + target + " because " + ex.toString();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                } else {
                    status = 500;
                    msg = "Unknown debug argument " + cmdarg;
                }
            } else if (cmd.equals("resume")) {
                if (cmdarg.equals("prd")) {
                    try {
                        pid = new ProducerUID(Long.parseLong(target));
                        pr = (Producer)Producer.getProducer(pid);
                        ds = DestinationList.getDestination(null, pr.getDestinationUID());
                        d = ds[0];
                        this.logger.log(8, "Resuming " + String.valueOf(pr));
                        d.forceResumeFlow(pr);
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Error resuming flow from producer  " + target + " because " + ex.toString();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                } else if (cmdarg.equals("cxn")) {
                    try {
                        uid = new ConnectionUID(Long.parseLong(target));
                        cxn = (IMQConnection)Globals.getConnectionManager().getConnection(uid);
                        cxn.resumeFlow(-1);
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Error resuming flow on connection  " + target + " because " + ex.toString();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                } else if (cmdarg.equals("con")) {
                    try {
                        cid = new ConsumerUID(Long.parseLong(target));
                        cxn = Consumer.getConsumer(cid);
                        cxn.resume("admin debug");
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Error resuming flow to consumer  " + target + " because " + ex.toString();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                } else if (cmdarg.equals("ses")) {
                    try {
                        sid = new SessionUID(Long.parseLong(target));
                        session = Session.getSession(sid);
                        session.resume("admin debug");
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Error resuming flow to session  " + target + " because " + ex.toString();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                } else {
                    status = 500;
                    msg = "Unknown resume argument " + cmdarg;
                }
            } else if (cmd.equals("send")) {
                if (cmdarg.equals("cxn")) {
                    try {
                        if (target == null) {
                            status = 500;
                            msg = "Missing connectionUID ";
                            break block151;
                        }
                        uid = new ConnectionUID(Long.parseLong(target));
                        cxn = (IMQConnection)Globals.getConnectionManager().getConnection(uid);
                        if (cxn == null) {
                            status = 500;
                            msg = "Unknown connectionUID " + String.valueOf((Object)uid);
                            break block151;
                        }
                        DebugHandler.sendClientDEBUG(cxn, cmd_props, p);
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Error notifying consumer  " + target + " because " + ex.toString();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                } else if (cmdarg.equals("bkr") || cmdarg.equals("svc")) {
                    s = null;
                    if (target != null && (s = Globals.getServiceManager().getService(target)) == null) {
                        msg = "Unknown service " + target;
                        status = 500;
                    }
                    itr = Globals.getConnectionManager().getConnectionList(s).iterator();
                    try {
                        while (itr.hasNext()) {
                            cxn = (IMQConnection)itr.next();
                            pkt = new Packet(false);
                            pkt.setPacketType(74);
                            hash = new Hashtable<K, V>(cmd_props);
                            bos = new ByteArrayOutputStream();
                            oos = new ObjectOutputStream(bos);
                            oos.writeObject(p);
                            oos.flush();
                            bos.flush();
                            pkt.setMessageBody(bos.toByteArray());
                            pkt.setProperties(hash);
                            cxn.sendControlMessage(pkt);
                        }
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Error notifying consumer  " + target + " because " + ex.toString();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                } else {
                    status = 500;
                    msg = "Unknown send argument " + cmdarg;
                }
            } else if (cmd.equals("kill")) {
                if (cmdarg.equals("cxn")) {
                    try {
                        uid = new ConnectionUID(Long.parseLong(target));
                        cxn = (IMQConnection)Globals.getConnectionManager().getConnection(uid);
                        cxn.destroyConnection(true, 3, "kill cnx");
                    }
                    catch (Exception ex) {
                        status = 500;
                        msg = "Error killing connection  " + target + " because " + ex.toString();
                        this.logger.logStack(8, (String)msg, (Throwable)ex);
                    }
                } else {
                    status = 500;
                    msg = "Unknown kill argument " + cmdarg;
                }
            }
        }
        if (fileStr != null && debugHash != null) {
            dbp = new DebugPrinter(2);
            dbp.setHashtable(debugHash);
            dbp.setFile(fileStr);
            dbp.println();
            dbp.close();
            if (status == 200) {
                msg = "Data logged at file " + fileStr;
            }
            if (logOnly) {
                debugHash = new Hashtable<K, V>();
                debugHash.put("logfile", fileStr);
            }
        }
        if (msg != null) {
            this.logger.log(8, (String)msg);
        }
        DebugHandler.setProperties(reply, 73, status, (String)msg);
        if (debugHash != null) {
            this.setBodyObject(reply, debugHash);
        }
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public static void sendClientDEBUG(IMQConnection cxn, Hashtable cmd_props, Properties p) throws IOException {
        Packet pkt = new Packet(false);
        pkt.setPacketType(74);
        Hashtable hash = new Hashtable(cmd_props);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(p);
        oos.flush();
        bos.flush();
        pkt.setMessageBody(bos.toByteArray());
        pkt.setProperties(hash);
        cxn.sendControlMessage(pkt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Hashtable getDebugInfo(String arg, String target, String targetType, Properties p) throws Exception {
        if (arg.equals("cxn")) {
            if (target == null) {
                return this.getAllCxnInfo(null);
            }
            ConnectionUID uid = new ConnectionUID(Long.parseLong(target));
            return this.getCxnInfo(uid);
        }
        if (arg.equals("config")) {
            return this.getConfig();
        }
        if (arg.equals("memory")) {
            return this.getMemory();
        }
        if (arg.equals("dst")) {
            if (target == null) {
                DebugHandler debugHandler = this;
                return debugHandler.DL.getAllDebugState();
            }
            boolean isQueue = false;
            if (targetType == null) {
                throw new Exception("topic or queue not specified with -t [t|q]");
            }
            if (targetType.equals("t")) {
                isQueue = false;
            } else {
                if (!targetType.equals("q")) throw new Exception("Unknown -t argument " + targetType + " expected t or q");
                isQueue = true;
            }
            DestinationUID uid = DestinationUID.getUID(target, isQueue);
            return this.getDestinationInfo(uid);
        }
        if (arg.equals("ses")) {
            if (target == null) {
                return Session.getAllDebugState();
            }
            SessionUID uid = new SessionUID(Long.parseLong(target));
            return this.getSession(uid);
        }
        if (arg.equals("prd")) {
            if (target == null) {
                return Producer.getAllDebugState();
            }
            ProducerUID uid = new ProducerUID(Long.parseLong(target));
            return this.getProducerInfo(uid);
        }
        if (arg.equals("con")) {
            if (target == null) {
                return Consumer.getAllDebugState();
            }
            ConsumerUID uid = new ConsumerUID(Long.parseLong(target));
            return this.getConInfo(uid);
        }
        if (arg.equals("svc")) {
            if (target != null) return this.getSvcInfo(target);
            this.logger.log(8, "XXX - target of null not implemented for " + arg);
        } else {
            if (arg.equals("db")) {
                return this.getDBInfo();
            }
            if (arg.equals("trans")) {
                if (target == null) {
                    return this.getTransactionInfo(null);
                }
                TransactionUID uid = new TransactionUID(Long.parseLong(target));
                return this.getTransactionInfo(uid);
            }
            if (arg.equals("pool")) {
                if (target != null) return this.getThreadPoolInfo(target);
                this.logger.log(8, "XXX - target of null not implemented for " + arg);
            } else {
                if (arg.equals("threads")) {
                    return SupportUtil.getAllStackTracesAsMap();
                }
                if (arg.equals("cls")) {
                    return this.getClusterInfo();
                }
                if (arg.equals("bkr")) {
                    return this.getBrokerInfo();
                }
                if (arg.equals("pkt")) {
                    String full = p.getProperty("full");
                    boolean fullDump = false;
                    if (full == null || !full.equalsIgnoreCase("True")) return this.getPktInfo(target, targetType, fullDump);
                    fullDump = true;
                    return this.getPktInfo(target, targetType, fullDump);
                }
            }
        }
        this.logger.log(8, "Unknown dump arg " + arg);
        return null;
    }

    private Hashtable getPktInfo(String target, String type, boolean full) throws Exception {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        if (type == null || type.length() == 0 || type.equals("bkr")) {
            Hashtable<String, Hashtable> dest = new Hashtable<String, Hashtable>();
            Iterator[] itrs = DestinationList.getAllDestinations(null);
            Iterator itr = itrs[0];
            while (itr.hasNext()) {
                Destination d = (Destination)itr.next();
                dest.put(d.getDestinationUID().toString(), d.getDebugMessages(full));
            }
            ht.put("Destinations", dest);
        } else if (type.equals("q") || type.equals("t")) {
            boolean isQueue = false;
            if (type.equals("t")) {
                isQueue = false;
            } else if (type.equals("q")) {
                isQueue = true;
            }
            DestinationUID uid = DestinationUID.getUID(target, isQueue);
            Destination[] ds = DestinationList.getDestination(null, uid);
            Destination d = ds[0];
            if (d == null) {
                throw new Exception("Unknown destination " + String.valueOf(uid));
            }
            ht.putAll(d.getDebugMessages(full));
        } else if (type.equals("con")) {
            if (target == null) {
                throw new Exception("Please specify consumerUID");
            }
            ConsumerUID uid = new ConsumerUID(Long.parseLong(target));
            Consumer c = Consumer.getConsumer(uid);
            if (c == null) {
                throw new Exception("Unknown consumer " + String.valueOf(uid));
            }
            ht.put(uid.toString(), c.getDebugMessages(full));
        } else if (type.equals("cxn")) {
            if (target == null) {
                throw new Exception("Please specify connectionUID");
            }
            ConnectionUID uid = new ConnectionUID(Long.parseLong(target));
            IMQConnection cxn = (IMQConnection)Globals.getConnectionManager().getConnection(uid);
            if (cxn == null) {
                throw new Exception("Can not find connection " + String.valueOf((Object)uid));
            }
            ht.put(target, cxn.getDebugMessages(full));
        } else if (type.equals("ses")) {
            ht.put("Dump acks ", target);
            if (target == null) {
                throw new Exception("Please specify SessionUID");
            }
            SessionUID uid = new SessionUID(Long.parseLong(target));
            Session sess = Session.getSession(uid);
            if (sess == null) {
                throw new Exception("Can not find session " + String.valueOf((Object)uid));
            }
            ht.put(target, sess.getDebugMessages(full));
        } else {
            ht.put("Error", "Unknown pkt type " + type);
        }
        return ht;
    }

    private Hashtable getAllCxnInfo(String svc) throws Exception {
        Service s = null;
        Hashtable<String, Object> debugHash = new Hashtable<String, Object>();
        if (svc != null) {
            s = Globals.getServiceManager().getService(svc);
            debugHash.put("threadPool", this.getThreadPoolInfo(svc));
            debugHash.put("threads", SupportUtil.getAllStackTraces((String)""));
        }
        for (IMQConnection iMQConnection : Globals.getConnectionManager().getConnectionList(s)) {
            debugHash.put(iMQConnection.getRemoteConnectionString(), iMQConnection.getDebugState());
        }
        return debugHash;
    }

    private Hashtable getCxnInfo(ConnectionUID uid) throws Exception {
        IMQConnection cxn = (IMQConnection)Globals.getConnectionManager().getConnection(uid);
        if (cxn == null) {
            throw new Exception("Can not find uid " + String.valueOf((Object)uid));
        }
        return cxn.getDebugState();
    }

    private Hashtable getConInfo(ConsumerUID uid) throws Exception {
        Consumer c = Consumer.getConsumer(uid);
        if (c == null) {
            throw new Exception("Can not find consumer " + String.valueOf(uid));
        }
        return c.getDebugState();
    }

    private Hashtable getSession(SessionUID uid) throws Exception {
        Session c = Session.getSession(uid);
        if (c == null) {
            throw new Exception("Can not find session " + String.valueOf((Object)uid));
        }
        return c.getDebugState();
    }

    private Hashtable getSvcInfo(String svcname) throws Exception {
        if (svcname == null) {
            Hashtable<String, Hashtable> ht = new Hashtable<String, Hashtable>();
            Globals.getServiceManager();
            List l = ServiceManager.getAllActiveServiceNames();
            for (String name : l) {
                ht.put(name, this.getSvcInfo(name));
            }
            return ht;
        }
        Service s = Globals.getServiceManager().getService(svcname);
        if (s == null) {
            throw new Exception("unknown service " + svcname);
        }
        return s.getDebugState();
    }

    private Hashtable getProducerInfo(ProducerUID uid) throws Exception {
        Producer p = (Producer)Producer.getProducer(uid);
        if (p == null) {
            throw new Exception("Can not find producer " + String.valueOf((Object)uid));
        }
        return p.getDebugState();
    }

    private Hashtable getDBInfo() throws Exception {
        return Globals.getStore().getDebugState();
    }

    private Hashtable getTransactionInfo(TransactionUID uid) {
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = tls[0];
        Hashtable ht = null;
        ht = uid == null ? tl.getDebugState() : tl.getDebugState(uid);
        return ht;
    }

    private Hashtable getDestinationInfo(DestinationUID uid) throws Exception {
        Destination[] ds = DestinationList.getDestination(null, uid);
        Destination d = ds[0];
        if (d == null) {
            throw new Exception("Can not find Destination " + String.valueOf(uid));
        }
        return d.getDebugState();
    }

    private Hashtable getThreadPoolInfo(String svcname) throws Exception {
        if (svcname == null) {
            Hashtable<String, Hashtable> ht = new Hashtable<String, Hashtable>();
            Globals.getServiceManager();
            List l = ServiceManager.getAllActiveServiceNames();
            for (String name : l) {
                ht.put(name, this.getThreadPoolInfo(name));
            }
            return ht;
        }
        Service s = Globals.getServiceManager().getService(svcname);
        if (s == null) {
            throw new Exception("unknown service " + svcname);
        }
        return ((IMQService)s).getPoolDebugState();
    }

    private Hashtable getClusterInfo() {
        Hashtable<String, Hashtable> debugHash = new Hashtable<String, Hashtable>();
        debugHash.put("Cluster Service", Globals.getClusterBroadcast().getAllDebugState());
        return debugHash;
    }

    private Hashtable getBrokerInfo() throws Exception {
        Hashtable<String, Object> debugHash = new Hashtable<String, Object>();
        try {
            DebugHandler debugHandler = this;
            debugHash.put("Destinations", debugHandler.DL.getAllDebugState());
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Destinations", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Producers", Producer.getAllDebugState());
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Producers", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Consumers", Consumer.getAllDebugState());
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Consumers", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Sessions", Session.getAllDebugState());
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Sessions", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Connections[jms]", this.getAllCxnInfo("jms"));
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Connections[jms]", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Connections[admin]", this.getAllCxnInfo("admin"));
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Connections[admin]", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Config", this.getConfig());
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Config", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Memory", this.getMemory());
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Memory", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("DB", this.getDBInfo());
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("DB", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Transactions", this.getTransactionInfo(null));
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Transactions", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Cluster", this.getClusterInfo());
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Cluster", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Service[jms]", this.getSvcInfo("jms"));
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Service[jms]", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("Service[admin]", this.getSvcInfo("admin"));
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("Service[admin]", "Error retrieving state " + String.valueOf(ex));
        }
        try {
            debugHash.put("threads", SupportUtil.getAllStackTraces((String)""));
        }
        catch (Exception ex) {
            this.logger.logStack(8, "getBrokerInfo:", (Throwable)ex);
            debugHash.put("threads", "Error retrieving state " + String.valueOf(ex));
        }
        return debugHash;
    }

    private Hashtable getMemory() {
        MemoryManager mm = Globals.getMemManager();
        if (mm != null) {
            return mm.getDebugState();
        }
        return new Hashtable();
    }

    private Hashtable getConfig() throws Exception {
        Hashtable<Object, String> debugHash = new Hashtable<Object, String>();
        for (Object key : Globals.getConfig().keySet()) {
            debugHash.put(key, Globals.getConfig().get(key).toString());
        }
        return debugHash;
    }
}

