/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.universal.process.KillNotPossibleException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.time.Duration;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-domain")
@PerLookup
public class StopDomainCommand
extends LocalDomainCommand {
    private static final System.Logger LOG = System.getLogger(StopDomainCommand.class.getName());
    @Param(name="domain_name", primary=true, optional=true)
    private String userArgDomainName;
    @Param(name="force", optional=true, defaultValue="true")
    private Boolean force;
    @Param(optional=true, defaultValue="false")
    private Boolean kill;
    @Param(optional=true)
    private Integer timeout;
    private HostAndPort addr;

    protected Duration getTimeout() {
        return this.timeout == null ? null : Duration.ofSeconds(this.timeout.intValue());
    }

    @Override
    protected void validate() throws CommandException {
        this.setDomainName(this.userArgDomainName);
        super.validate();
    }

    @Override
    protected void initDomain() throws CommandException {
        if (this.programOpts.getHost().equals("localhost")) {
            super.initDomain();
        } else if (this.userArgDomainName != null) {
            throw new CommandException(Strings.get("StopDomain.noDomainNameAllowed"));
        }
    }

    protected int executeCommand() throws CommandException {
        if (this.isLocal()) {
            if (this.getServerDirs().getLocalPassword() == null) {
                return this.dasNotRunning();
            }
            this.addr = this.getAdminAddress();
            this.programOpts.setHostAndPort(this.addr);
            LOG.log(System.Logger.Level.DEBUG, "Stopping local domain on port {0}", this.programOpts.getPort());
            this.programOpts.setInteractive(false);
            if (!this.isThisDAS(this.getDomainRootDir())) {
                return this.dasNotRunning();
            }
            LOG.log(System.Logger.Level.DEBUG, "It's the correct DAS");
        } else {
            if (!DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
                return this.dasNotRunning();
            }
            LOG.log(System.Logger.Level.DEBUG, "DAS is running");
            this.programOpts.setInteractive(false);
        }
        this.doCommand();
        return 0;
    }

    protected int dasNotRunning() throws CommandException {
        LOG.log(System.Logger.Level.DEBUG, "dasNotRunning()");
        if (this.kill.booleanValue()) {
            if (this.isLocal()) {
                try {
                    File prevPid = this.getServerDirs().getLastPidFile();
                    ProcessUtils.kill((File)prevPid, (Duration)this.getStopTimeout(), (!this.programOpts.isTerse() ? 1 : 0) != 0);
                }
                catch (KillNotPossibleException e) {
                    throw new CommandException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new CommandException(Strings.get("StopDomain.dasNotRunningRemotely"));
            }
        }
        if (this.isLocal()) {
            LOG.log(System.Logger.Level.WARNING, "CLI306: Warning - The server located at {0} is not running.", this.getDomainRootDir());
        } else {
            LOG.log(System.Logger.Level.WARNING, "CLI307: Warning - remote server is not running, unable to force it to stop.\nTry running stop-domain on the remote server.");
        }
        return 0;
    }

    protected void doCommand() throws CommandException {
        RemoteCLICommand cmd = new RemoteCLICommand(this.getName(), this.programOpts, this.env);
        Long oldPid = this.getServerPid();
        boolean printDots = !this.programOpts.isTerse();
        Duration stopTimeout = this.getStopTimeout();
        try {
            boolean dead;
            cmd.executeAndReturnOutput(new String[]{"stop-domain", "--force", this.force.toString()});
            if (printDots) {
                System.out.print(Strings.get("StopDomain.WaitDASDeath") + " ");
            }
            if (!(dead = this.isLocal() ? oldPid == null || ProcessUtils.waitWhileIsAlive((long)oldPid, (Duration)stopTimeout, (boolean)printDots) : ProcessUtils.waitWhileListening((HostAndPort)this.addr, (Duration)stopTimeout, (boolean)printDots))) {
                throw new CommandException(Strings.get("StopDomain.DASNotDead", stopTimeout.toSeconds()));
            }
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.DEBUG, "Remote stop-domain call failed.", (Throwable)e);
            if (this.kill.booleanValue() && this.isLocal()) {
                try {
                    File prevPid = this.getServerDirs().getLastPidFile();
                    ProcessUtils.kill((File)prevPid, (Duration)stopTimeout, (boolean)printDots);
                    return;
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }

    private Duration getStopTimeout() {
        Duration parameter = this.getTimeout();
        return parameter == null ? CLIConstants.DEATH_TIMEOUT_MS : parameter;
    }
}

