/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="__update-jmsdest")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="__update-jmsdest", description="Update JMS Destination", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="__update-jmsdest", description="Update JMS Destination", params={@RestParam(name="target", value="$parent")})})
public class UpdateJmsPhysicalDestinationCommand
extends JMSDestination
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UpdateJmsPhysicalDestinationCommand.class);
    @Param(name="desttype", shortName="t", optional=false)
    String destType;
    @Param(name="dest_name", primary=true)
    String destName;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    Domain domain;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        logger.entering(this.getClass().getName(), "__updateJmsPhysicalDestination", new Object[]{this.destName, this.destType});
        try {
            this.validateJMSDestName(this.destName);
            this.validateJMSDestType(this.destType);
            this.updateJMSDestination();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    protected void updateJMSDestination() throws Exception {
        logger.log(Level.FINE, "updateJMSDestination ...");
        try (MQJMXConnectorInfo mqInfo = this.createMQJMXConnectorInfo(this.target, this.config, this.serverContext, this.domain, this.connectorRuntime);){
            AttributeList destAttrs;
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            AttributeList attributeList = destAttrs = this.props == null ? null : this.convertProp2Attrs(this.props);
            if (this.destType.equalsIgnoreCase("topic")) {
                this.destType = "t";
            } else if (this.destType.equalsIgnoreCase("queue")) {
                this.destType = "q";
            }
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=Destination,subtype=Config,desttype=" + this.destType + ",name=\"" + this.destName + "\"");
            mbsc.setAttributes(on, destAttrs);
        }
        catch (Exception e) {
            throw this.logAndHandleException(e, "admin.mbeans.rmb.error_updating_jms_dest");
        }
    }
}

