/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;

public abstract class MarkupLanguageProvider {
    public final Set<MarkupLanguage> getMarkupLanguages() {
        ImmutableSet languages = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(this.loadMarkupLanguages(), (Object)"loadMarkupLanguages() must not return null")));
        this.assertLanguageNames((Set<MarkupLanguage>)languages);
        return languages;
    }

    private void assertLanguageNames(Set<MarkupLanguage> languages) {
        HashSet names = Sets.newHashSet();
        for (MarkupLanguage language : languages) {
            Preconditions.checkNotNull((Object)language.getName(), (Object)"Provided languages must have a name");
            Preconditions.checkState((boolean)names.add(language.getName()), (String)"Language name '%s' must not be provided more than once", (Object[])new Object[]{language.getName()});
        }
    }

    protected abstract Set<MarkupLanguage> loadMarkupLanguages();
}

