/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.project.EventMapping;
import org.eclipse.comma.project.project.FixedSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.RESTTask;
import org.eclipse.comma.project.project.Segment;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RequiredPortsWSServerGenerator {
    public static void generate(CommaFileSystemAccess fsa, List<Signature> signatures, RESTTask task) {
        boolean _not;
        Functions.Function1 _function = it -> it.getEventMappings();
        Functions.Function1 _function_1 = it -> {
            InterfaceEvent _event = it.getEvent();
            return _event instanceof Notification;
        };
        Iterable notificationEventMappings = IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(task.getPathMappings().getSignatureMappings(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)notificationEventMappings);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            fsa.generateFile(RequiredPortsWSServerGenerator.fileName(task), RequiredPortsWSServerGenerator.classContent(signatures, task));
        }
    }

    public static String fileName(RESTTask task) {
        String _apiName = ProjectUtility.getApiName(task);
        return String.valueOf(_apiName) + "WSServer.java";
    }

    public static CharSequence classContent(List<Signature> signatures, RESTTask task) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = it -> it.getEventMappings();
        Functions.Function1 _function_1 = it -> {
            InterfaceEvent _event = it.getEvent();
            return _event instanceof Notification;
        };
        Iterable notificationEventMappings = IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(task.getPathMappings().getSignatureMappings(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
        Path path = ((EventMapping[])Conversions.unwrapArray((Object)notificationEventMappings, EventMapping.class))[0].getPath();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package org.eclipse.comma.restadapter;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import java.io.IOException;");
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import jakarta.websocket.CloseReason;");
        _builder.newLine();
        _builder.append("import jakarta.websocket.OnClose;");
        _builder.newLine();
        _builder.append("import jakarta.websocket.OnMessage;");
        _builder.newLine();
        _builder.append("import jakarta.websocket.OnOpen;");
        _builder.newLine();
        _builder.append("import jakarta.websocket.Session;");
        _builder.newLine();
        _builder.append("import jakarta.websocket.server.ServerEndpoint;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@ServerEndpoint(value = \"");
        int _length = ((Object[])Conversions.unwrapArray(path.getSegments(), Object.class)).length;
        int _minus = _length - 3;
        IntegerRange _upTo = new IntegerRange(0, _minus);
        for (Integer i : _upTo) {
            _builder.append("/");
            Segment _get = (Segment)path.getSegments().get(i.intValue());
            String _name = ((FixedSegment)_get).getName();
            _builder.append(_name);
        }
        _builder.append("/{interface}/{notification}\") ");
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        String _apiName = ProjectUtility.getApiName(task);
        _builder.append(_apiName);
        _builder.append("WSServer {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("private Map<String, Session> sessions = new HashMap<String, Session>();");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public ");
        String _apiName_1 = ProjectUtility.getApiName(task);
        _builder.append(_apiName_1, "    ");
        _builder.append("WSServer() {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("new Thread(()-> {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("while(true) {");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("Thread.sleep(100);");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("} catch (InterruptedException e) {");
        _builder.newLine();
        _builder.append("                    ");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("}");
        _builder.newLine();
        for (Signature signature : signatures) {
            EList _notifications = signature.getNotifications();
            for (Notification notification : _notifications) {
                _builder.append("                ");
                _builder.append("if(");
                String _name_1 = signature.getName();
                _builder.append(_name_1, "                ");
                _builder.append("Worker.notification");
                String _name_2 = notification.getName();
                _builder.append(_name_2, "                ");
                _builder.append(" && sessions.containsKey(\"");
                String _name_3 = notification.getName();
                _builder.append(_name_3, "                ");
                _builder.append("\")) {");
                _builder.newLineIfNotEmpty();
                _builder.append("                ");
                _builder.append("    ");
                _builder.append("try {");
                _builder.newLine();
                _builder.append("                ");
                _builder.append("        ");
                _builder.append("sessions.get(\"");
                String _name_4 = notification.getName();
                _builder.append(_name_4, "                        ");
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("                ");
                _builder.append("                ");
                _builder.append(".getBasicRemote()");
                _builder.newLine();
                _builder.append("                ");
                _builder.append("                ");
                _builder.append(".sendText(");
                String _name_5 = signature.getName();
                _builder.append(_name_5, "                                ");
                _builder.append("Worker.");
                String _apiName_2 = ProjectUtility.getApiName(task);
                _builder.append(_apiName_2, "                                ");
                _builder.append("Results.get(\"");
                String _name_6 = notification.getName();
                _builder.append(_name_6, "                                ");
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
                _builder.append("                ");
                _builder.append("        ");
                String _name_7 = signature.getName();
                _builder.append(_name_7, "                        ");
                _builder.append("Worker.notification");
                String _name_8 = notification.getName();
                _builder.append(_name_8, "                        ");
                _builder.append(" = false;");
                _builder.newLineIfNotEmpty();
                _builder.append("                ");
                _builder.append("    ");
                _builder.append("} catch (IOException e) {");
                _builder.newLine();
                _builder.append("                ");
                _builder.append("        ");
                _builder.append("e.printStackTrace();");
                _builder.newLine();
                _builder.append("                ");
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("                ");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}).start();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@OnOpen");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public void onOpen(Session session) {");
        _builder.newLine();
        for (Signature sig : signatures) {
            EList _notifications_1 = sig.getNotifications();
            for (Notification notification_1 : _notifications_1) {
                _builder.append("        ");
                _builder.append("if(session.getRequestURI().getPath().endsWith(\"");
                String _name_9 = notification_1.getName();
                _builder.append(_name_9, "        ");
                _builder.append("\")) {");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("    ");
                _builder.append("sessions.put(\"");
                String _name_10 = notification_1.getName();
                _builder.append(_name_10, "            ");
                _builder.append("\", session);");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@OnMessage");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public void onMessage(String message, Session session) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@OnClose");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public void onClose(Session session, CloseReason closeReason) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("System.out.println(\"Session \" + session.getId() +");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("\" closed because \" + closeReason);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

