/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationFromTemplatePage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class NewPluginProjectFromTemplateWizard
extends NewWizard
implements IExecutableExtension {
    public static final String DEF_PROJECT_NAME = "project_name";
    public static final String PLUGIN_POINT = "pluginContent";
    public static final String TAG_WIZARD = "wizard";
    private AbstractFieldData fPluginData;
    private NewProjectCreationPage fProjectPage;
    private PluginContentPage fContentPage;
    private IPluginContentWizard fTemplateWizard;
    private IProjectProvider fProjectProvider;
    private IConfigurationElement fConfig;

    public NewPluginProjectFromTemplateWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEUIMessages.NewProjectWizard_title);
        this.setNeedsProgressMonitor(true);
        this.fPluginData = new PluginFieldData();
    }

    protected abstract String getTemplateID();

    public void addPages() {
        WizardElement templateWizardElement = this.getTemplateWizard();
        if (templateWizardElement == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)PDEUIMessages.NewPluginProjectFromTemplateWizard_1, (String)NLS.bind((String)PDEUIMessages.NewPluginProjectFromTemplateWizard_0, (Object)this.getTemplateID()));
            return;
        }
        this.fProjectPage = new NewProjectCreationFromTemplatePage("main", this.fPluginData, this.getSelection(), templateWizardElement);
        this.fProjectPage.setTitle(PDEUIMessages.NewProjectWizard_MainPage_title);
        this.fProjectPage.setDescription(PDEUIMessages.NewProjectWizard_MainPage_desc);
        String projectName = this.getDefaultValue(DEF_PROJECT_NAME);
        if (projectName != null) {
            this.fProjectPage.setInitialProjectName(projectName);
        }
        this.addPage((IWizardPage)this.fProjectPage);
        this.fProjectProvider = new IProjectProvider(){

            @Override
            public String getProjectName() {
                return NewPluginProjectFromTemplateWizard.this.fProjectPage.getProjectName();
            }

            @Override
            public IProject getProject() {
                return NewPluginProjectFromTemplateWizard.this.fProjectPage.getProjectHandle();
            }

            @Override
            public IPath getLocationPath() {
                return NewPluginProjectFromTemplateWizard.this.fProjectPage.getLocationPath();
            }
        };
        this.fContentPage = new PluginContentPage("page2", this.fProjectProvider, this.fProjectPage, this.fPluginData);
        this.addPage((IWizardPage)this.fContentPage);
        try {
            IWizardPage[] pages;
            this.fTemplateWizard = (IPluginContentWizard)templateWizardElement.createExecutableExtension();
            this.fTemplateWizard.init(this.fPluginData);
            this.fTemplateWizard.addPages();
            IWizardPage[] iWizardPageArray = pages = this.fTemplateWizard.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                this.addPage(page);
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getShell(), (String)PDEUIMessages.NewPluginProjectFromTemplateWizard_1, (String)NLS.bind((String)PDEUIMessages.NewPluginProjectFromTemplateWizard_0, (Object)this.getTemplateID()));
        }
    }

    public boolean canFinish() {
        return super.canFinish() && !this.getContainer().getCurrentPage().equals((Object)this.fProjectPage) && (this.fTemplateWizard == null || this.fTemplateWizard.canFinish());
    }

    @Override
    public boolean performFinish() {
        block8: {
            this.fProjectPage.updateData();
            this.fContentPage.updateData();
            IDialogSettings settings = this.getDialogSettings();
            if (settings != null) {
                this.fProjectPage.saveSettings(settings);
                this.fContentPage.saveSettings(settings);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            if (PDECore.getDefault().areModelsInitialized()) break block8;
            try {
                this.getContainer().run(true, true, monitor -> {
                    PDECore.getDefault().getModelManager().targetReloaded(monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new NewProjectCreationOperation(this.fPluginData, this.fProjectProvider, this.fTemplateWizard));
            IWorkingSet[] workingSets = this.fProjectPage.getSelectedWorkingSets();
            if (workingSets.length > 0) {
                this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)this.fProjectProvider.getProject(), workingSets);
            }
            return true;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfig = config;
    }

    private WizardElement getTemplateWizard() {
        IExtension[] extensions;
        String templateID = this.getTemplateID();
        if (templateID == null) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PDEPlugin.getPluginId(), PLUGIN_POINT);
        if (point == null) {
            return null;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(TAG_WIZARD) && templateID.equals(element.getAttribute("id"))) {
                    return WizardElement.create(element);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

