/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleVersionHeader;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;

public class UpdateBundleVersionOperation {
    IMarker fMarker;
    String fVersion;

    public UpdateBundleVersionOperation(IMarker marker, String version) {
        this.fMarker = marker;
        this.fVersion = version;
    }

    public IStatus run(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (monitor != null) {
            monitor.beginTask(MarkerMessages.UpdateVersionNumberingOperation_title, 2);
        }
        try {
            IResource resource;
            IProject project;
            if (monitor != null) {
                monitor.worked(1);
            }
            if (!(project = (resource = this.fMarker.getResource()).getProject()).isAccessible()) {
                System.err.println("Project " + project.getName() + " doesn't exist");
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                ModelModification mod = new ModelModification(file){

                    protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                        if (!(model instanceof IBundlePluginModelBase)) {
                            return;
                        }
                        IBundlePluginModelBase modelBase = (IBundlePluginModelBase)model;
                        IBundle bundle = modelBase.getBundleModel().getBundle();
                        IManifestHeader header = bundle.getManifestHeader("Bundle-Version");
                        if (header instanceof BundleVersionHeader) {
                            BundleVersionHeader versionHeader = (BundleVersionHeader)header;
                            versionHeader.setValue(UpdateBundleVersionOperation.this.fVersion);
                        }
                    }
                };
                PDEModelUtility.modifyModel((ModelModification)mod, null);
            }
            Util.getBuildJob((IProject[])new IProject[]{project}, (int)10).schedule();
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }
}

