/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.project.formatting2.MultiLineFormatter;
import org.eclipse.comma.project.project.CompoundInterface;
import org.eclipse.comma.project.project.CompoundInterfaceBlock;
import org.eclipse.comma.project.project.DocumentationGenerationBlock;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.GeneratorBlock;
import org.eclipse.comma.project.project.InterfaceMappings;
import org.eclipse.comma.project.project.InterfaceModel;
import org.eclipse.comma.project.project.InterfaceReference;
import org.eclipse.comma.project.project.ModelQualityChecksGenerationBlock;
import org.eclipse.comma.project.project.ModelQualityChecksGenerationTask;
import org.eclipse.comma.project.project.MonitoringBlock;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.Policy;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.project.ProjectDescription;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationBlock;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationTask;
import org.eclipse.comma.project.project.ResetCommand;
import org.eclipse.comma.project.project.SimulatorGenerationBlock;
import org.eclipse.comma.project.project.SimulatorGenerationTask;
import org.eclipse.comma.project.project.TestCasesGenerationBlock;
import org.eclipse.comma.project.project.TestCasesGenerationTask;
import org.eclipse.comma.project.project.TestClientGenerationBlock;
import org.eclipse.comma.project.project.TestClientGenerationTask;
import org.eclipse.comma.project.project.TraceSource;
import org.eclipse.comma.project.project.TypeMapping;
import org.eclipse.comma.project.project.TypeMappings;
import org.eclipse.comma.project.project.TypeMappingsBlock;
import org.eclipse.comma.project.project.UMLBlock;
import org.eclipse.comma.project.project.UMLTask;
import org.eclipse.comma.project.services.ProjectGrammarAccess;
import org.eclipse.comma.types.types.Import;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ProjectFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private ProjectGrammarAccess _projectGrammarAccess;
    public static final Procedures.Procedure1<IHiddenRegionFormatter> oneSpaceWrap = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.oneSpace();
            p.autowrap();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> oneSpace = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.oneSpace();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> noSpace = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.noSpace();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> newLine = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.newLine();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> emptyLine = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.setNewLines(2);
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> indent = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.indent();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> doubleIndent = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.indent();
            p.indent();
        }
    };

    public ITextReplacer createCommentReplacer(IComment comment) {
        String ruleName;
        boolean _startsWith;
        ITextReplacer _xblockexpression = null;
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule && (_startsWith = (ruleName = ((AbstractRule)grammarElement).getName()).startsWith("ML"))) {
            return new MultiLineFormatter(comment, '*');
        }
        _xblockexpression = super.createCommentReplacer(comment);
        return _xblockexpression;
    }

    public void prependBlockElements(EList<? extends EObject> blockelements, @Extension IFormattableDocument document) {
        int _size = blockelements.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            EObject element = (EObject)blockelements.get(i.intValue());
            if (i == 0) {
                document.prepend(element, newLine);
                continue;
            }
            document.prepend(element, emptyLine);
        }
    }

    protected void _format(ProjectDescription projectDescription, @Extension IFormattableDocument document) {
        document.format((Object)projectDescription.getImports());
        document.format((Object)projectDescription.getProject());
    }

    protected void _format(Import _import, @Extension IFormattableDocument document) {
        boolean _tripleEquals;
        ISemanticRegion _previousSemanticRegion = this.textRegionExtensions.regionForEObject((EObject)_import).getPreviousSemanticRegion();
        boolean bl = _tripleEquals = _previousSemanticRegion == null;
        if (_tripleEquals) {
            boolean _not;
            boolean _containsComment = this.textRegionExtensions.regionForEObject((EObject)_import).getPreviousHiddenRegion().containsComment();
            boolean bl2 = _not = !_containsComment;
            if (_not) {
                document.prepend((EObject)_import, noSpace);
            }
        } else {
            document.prepend((EObject)_import, newLine);
        }
        document.append(this.textRegionExtensions.regionFor((EObject)_import).keyword(this._projectGrammarAccess.getFileImportAccess().getImportKeyword_0()), oneSpace);
    }

    protected void _format(Project project, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)project);
        document.prepend((EObject)project, emptyLine);
        document.append(rFinder.keyword(this._projectGrammarAccess.getProjectAccess().getProjectKeyword_0()), oneSpace);
        Consumer<GeneratorBlock> _function = new Consumer<GeneratorBlock>(){

            @Override
            public void accept(GeneratorBlock it) {
                document.format((Object)it);
            }
        };
        project.getGeneratorBlocks().forEach((Consumer)_function);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getProjectAccess().getLeftCurlyBracketKeyword_2(), this._projectGrammarAccess.getProjectAccess().getRightCurlyBracketKeyword_4(), document);
    }

    protected void _format(CompoundInterfaceBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getCompoundInterfaceBlockAccess().getCompoundKeyword_1()), oneSpace);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getCompoundInterfaceBlockAccess().getInterfacesKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getCompoundInterfaceBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getCompoundInterfaceBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<CompoundInterface> _function = new Consumer<CompoundInterface>(){

            @Override
            public void accept(CompoundInterface it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(TestClientGenerationBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getTestClientGenerationBlockAccess().getTestClientKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getTestClientGenerationBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getTestClientGenerationBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<TestClientGenerationTask> _function = new Consumer<TestClientGenerationTask>(){

            @Override
            public void accept(TestClientGenerationTask it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(TestClientGenerationTask task, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)task);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getTestClientGenerationTaskAccess().getForKeyword_1()), oneSpaceWrap);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getTestClientGenerationTaskAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getTestClientGenerationTaskAccess().getRightCurlyBracketKeyword_6(), document);
        ISemanticRegion _keyword = rFinder.keyword(this._projectGrammarAccess.getTestClientGenerationTaskAccess().getParamsKeyword_4_0());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            _prepend = document.prepend(_keyword, newLine);
        }
        document.append(_prepend, oneSpace);
    }

    protected void _format(ReachabilityGraphGenerationBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getReachabilityGraphGenerationBlockAccess().getReachabilityGraphKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getReachabilityGraphGenerationBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getReachabilityGraphGenerationBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<ReachabilityGraphGenerationTask> _function = new Consumer<ReachabilityGraphGenerationTask>(){

            @Override
            public void accept(ReachabilityGraphGenerationTask it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(ReachabilityGraphGenerationTask task, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)task);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getReachabilityGraphGenerationTaskAccess().getForKeyword_1()), oneSpaceWrap);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getReachabilityGraphGenerationTaskAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getReachabilityGraphGenerationTaskAccess().getRightCurlyBracketKeyword_5(), document);
        ISemanticRegion _keyword = rFinder.keyword(this._projectGrammarAccess.getReachabilityGraphGenerationTaskAccess().getMaxDepthKeyword_4_0_0());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            _prepend = document.prepend(_keyword, newLine);
        }
        document.append(_prepend, oneSpace);
        ISemanticRegion _keyword_1 = rFinder.keyword(this._projectGrammarAccess.getReachabilityGraphGenerationTaskAccess().getParamsKeyword_4_1_0());
        ISemanticRegion _prepend_1 = null;
        if (_keyword_1 != null) {
            _prepend_1 = document.prepend(_keyword_1, newLine);
        }
        document.append(_prepend_1, oneSpace);
    }

    protected void _format(CompoundInterface compound, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)compound);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getCompoundInterfaceAccess().getVersionKeyword_2()), newLine);
        document.prepend(rFinder.assignment(this._projectGrammarAccess.getCompoundInterfaceAccess().getVersionAssignment_3()), newLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getCompoundInterfaceAccess().getDescriptionKeyword_4()), emptyLine);
        document.prepend(rFinder.assignment(this._projectGrammarAccess.getCompoundInterfaceAccess().getDescriptionAssignment_5()), newLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getCompoundInterfaceAccess().getInterfacesKeyword_6()), emptyLine);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getCompoundInterfaceAccess().getLeftCurlyBracketKeyword_1(), this._projectGrammarAccess.getCompoundInterfaceAccess().getRightCurlyBracketKeyword_8(), document);
        Consumer<InterfaceModel> _function = new Consumer<InterfaceModel>(){

            @Override
            public void accept(InterfaceModel it) {
                document.format((Object)((InterfaceModel)document.prepend((EObject)it, newLine)));
            }
        };
        compound.getInterfaces().forEach((Consumer)_function);
    }

    protected void _format(TestCasesGenerationBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getTestCasesGenerationBlockAccess().getTestCasesKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getTestCasesGenerationBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getTestCasesGenerationBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<TestCasesGenerationTask> _function = new Consumer<TestCasesGenerationTask>(){

            @Override
            public void accept(TestCasesGenerationTask it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(TestCasesGenerationTask task, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)task);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getTestCasesGenerationTaskAccess().getForKeyword_1()), oneSpaceWrap);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getTestCasesGenerationTaskAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getTestCasesGenerationTaskAccess().getRightCurlyBracketKeyword_5(), document);
        ISemanticRegion _keyword = rFinder.keyword(this._projectGrammarAccess.getTestCasesGenerationTaskAccess().getTemplateKeyword_4_0_0());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            _prepend = document.prepend(_keyword, newLine);
        }
        document.append(_prepend, oneSpace);
        ISemanticRegion _keyword_1 = rFinder.keyword(this._projectGrammarAccess.getTestCasesGenerationTaskAccess().getOutputFileKeyword_4_1_0());
        ISemanticRegion _prepend_1 = null;
        if (_keyword_1 != null) {
            _prepend_1 = document.prepend(_keyword_1, newLine);
        }
        document.append(_prepend_1, oneSpace);
        ISemanticRegion _keyword_2 = rFinder.keyword(this._projectGrammarAccess.getTestCasesGenerationTaskAccess().getMaxDepthKeyword_4_2_0());
        ISemanticRegion _prepend_2 = null;
        if (_keyword_2 != null) {
            _prepend_2 = document.prepend(_keyword_2, newLine);
        }
        document.append(_prepend_2, oneSpace);
        ISemanticRegion _keyword_3 = rFinder.keyword(this._projectGrammarAccess.getTestCasesGenerationTaskAccess().getParamsKeyword_4_3_0());
        ISemanticRegion _prepend_3 = null;
        if (_keyword_3 != null) {
            _prepend_3 = document.prepend(_keyword_3, newLine);
        }
        document.append(_prepend_3, oneSpace);
    }

    protected void _format(MonitoringBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getMonitoringBlockAccess().getMonitorsKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getMonitoringBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getMonitoringBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<MonitoringTask> _function = new Consumer<MonitoringTask>(){

            @Override
            public void accept(MonitoringTask it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(DocumentationGenerationBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationBlockAccess().getDocumentationsKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getDocumentationGenerationBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getDocumentationGenerationBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<DocumentationGenerationTask> _function = new Consumer<DocumentationGenerationTask>(){

            @Override
            public void accept(DocumentationGenerationTask it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(UMLBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getUMLBlockAccess().getUMLKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getUMLBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getUMLBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<UMLTask> _function = new Consumer<UMLTask>(){

            @Override
            public void accept(UMLTask it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(InterfaceReference iRef, @Extension IFormattableDocument document) {
        document.surround(this.textRegionExtensions.regionFor((EObject)iRef).keyword(this._projectGrammarAccess.getInterfaceReferenceAccess().getInterfaceKeyword_0()), oneSpace);
    }

    protected void _format(TypeMappingsBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getTypeMappingsBlockAccess().getTypeKeyword_1()), oneSpace);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getTypeMappingsBlockAccess().getMappingsKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getTypeMappingsBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getTypeMappingsBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<TypeMappings> _function = new Consumer<TypeMappings>(){

            @Override
            public void accept(TypeMappings it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(SimulatorGenerationBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getSimulatorGenerationBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getSimulatorGenerationBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<SimulatorGenerationTask> _function = new Consumer<SimulatorGenerationTask>(){

            @Override
            public void accept(SimulatorGenerationTask it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(ModelQualityChecksGenerationBlock block, final @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)block);
        document.prepend((EObject)block, emptyLine);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getModelQualityChecksGenerationBlockAccess().getModelQualityChecksKeyword_2()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getModelQualityChecksGenerationBlockAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getModelQualityChecksGenerationBlockAccess().getRightCurlyBracketKeyword_5(), document);
        this.prependBlockElements(block.getTasks(), document);
        Consumer<ModelQualityChecksGenerationTask> _function = new Consumer<ModelQualityChecksGenerationTask>(){

            @Override
            public void accept(ModelQualityChecksGenerationTask it) {
                document.format((Object)it);
            }
        };
        block.getTasks().forEach((Consumer)_function);
    }

    protected void _format(ModelQualityChecksGenerationTask task, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)task);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getModelQualityChecksGenerationTaskAccess().getForKeyword_1()), oneSpaceWrap);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getModelQualityChecksGenerationTaskAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getModelQualityChecksGenerationTaskAccess().getRightCurlyBracketKeyword_5(), document);
        ISemanticRegion _keyword = rFinder.keyword(this._projectGrammarAccess.getModelQualityChecksGenerationTaskAccess().getParamsKeyword_4_0_0());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            _prepend = document.prepend(_keyword, newLine);
        }
        document.append(_prepend, oneSpace);
        ISemanticRegion _keyword_1 = rFinder.keyword(this._projectGrammarAccess.getModelQualityChecksGenerationTaskAccess().getMaxDepthKeyword_4_2_0());
        ISemanticRegion _prepend_1 = null;
        if (_keyword_1 != null) {
            _prepend_1 = document.prepend(_keyword_1, newLine);
        }
        document.append(_prepend_1, oneSpace);
        ISemanticRegion _keyword_2 = rFinder.keyword(this._projectGrammarAccess.getModelQualityChecksGenerationTaskAccess().getHomeStatesKeyword_4_1_0());
        ISemanticRegion _prepend_2 = null;
        if (_keyword_2 != null) {
            _prepend_2 = document.prepend(_keyword_2, newLine);
        }
        document.append(_prepend_2, oneSpace);
    }

    protected void _format(DocumentationGenerationTask task, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)task);
        document.format((Object)task.getSource());
        document.surround(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getForKeyword_1()), oneSpaceWrap);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getRightCurlyBracketKeyword_16(), document);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getTemplateKeyword_4()), newLine);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getEqualsSignKeyword_5()), oneSpace);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getTargetFileKeyword_7()), newLine);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getEqualsSignKeyword_8()), oneSpace);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getAuthorKeyword_10()), newLine);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getEqualsSignKeyword_11()), oneSpace);
        document.prepend(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getRoleKeyword_13()), newLine);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getDocumentationGenerationTaskAccess().getEqualsSignKeyword_14()), oneSpace);
    }

    protected void _format(SimulatorGenerationTask task, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)task);
        document.surround(rFinder.keyword(this._projectGrammarAccess.getSimulatorGenerationTaskAccess().getForKeyword_1()), oneSpaceWrap);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getSimulatorGenerationTaskAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getSimulatorGenerationTaskAccess().getRightCurlyBracketKeyword_5(), document);
        ISemanticRegion _keyword = rFinder.keyword(this._projectGrammarAccess.getSimulatorGenerationTaskAccess().getParamsKeyword_4_0());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            _prepend = document.prepend(_keyword, newLine);
        }
        document.append(_prepend, oneSpace);
    }

    protected void _format(MonitoringTask task, @Extension IFormattableDocument document) {
        boolean _equals_1;
        boolean _equals;
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)task);
        document.format((Object)task.getSource());
        document.surround(rFinder.keyword(this._projectGrammarAccess.getMonitoringTaskAccess().getForKeyword_1()), oneSpaceWrap);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getMonitoringTaskAccess().getLeftCurlyBracketKeyword_3(), this._projectGrammarAccess.getMonitoringTaskAccess().getRightCurlyBracketKeyword_8(), document);
        ISemanticRegion _keyword = rFinder.keyword(this._projectGrammarAccess.getMonitoringTaskAccess().getTraceKeyword_6());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            _prepend = document.prepend(_keyword, newLine);
        }
        document.append(_prepend, oneSpace);
        int _size = task.getTraces().size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            document.prepend((EObject)((TraceSource)task.getTraces().get(0)), oneSpace);
        } else {
            EList<TraceSource> _traces = task.getTraces();
            for (TraceSource trace : _traces) {
                document.prepend((EObject)trace, newLine);
            }
        }
        int _size_1 = task.getTracedirs().size();
        boolean bl2 = _equals_1 = _size_1 == 1;
        if (_equals_1) {
            document.prepend((EObject)((FilePath)task.getTracedirs().get(0)), oneSpace);
        } else {
            EList<FilePath> _tracedirs = task.getTracedirs();
            for (FilePath trace_1 : _tracedirs) {
                document.prepend((EObject)trace_1, newLine);
            }
        }
    }

    protected void _format(Policy policy, final @Extension IFormattableDocument document) {
        ISemanticRegion _keyword_1;
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)policy);
        ISemanticRegion _keyword = rFinder.keyword(this._projectGrammarAccess.getPolicyAccess().getResetKeyword_1_1());
        if (_keyword != null) {
            document.prepend(_keyword, oneSpace);
        }
        if ((_keyword_1 = rFinder.keyword(this._projectGrammarAccess.getPolicyAccess().getFilterKeyword_1_2())) != null) {
            document.prepend(_keyword_1, oneSpace);
        }
        Consumer<ResetCommand> _function = new Consumer<ResetCommand>(){

            @Override
            public void accept(ResetCommand it) {
                document.format((Object)it);
            }
        };
        policy.getResetCommands().forEach((Consumer)_function);
    }

    protected void _format(ResetCommand reset, @Extension IFormattableDocument document) {
        ISemanticRegion _keyword_1;
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)reset);
        ISemanticRegion _keyword = rFinder.keyword(this._projectGrammarAccess.getResetCommandAccess().getElement1Keyword_0());
        if (_keyword != null) {
            document.surround(_keyword, oneSpace);
        }
        if ((_keyword_1 = rFinder.keyword(this._projectGrammarAccess.getResetCommandAccess().getElement2Keyword_2())) != null) {
            document.surround(_keyword_1, oneSpace);
        }
    }

    public void formatSimpleBrackets(ISemanticRegionsFinder rFinder, Keyword open, Keyword close, @Extension IFormattableDocument document) {
        boolean _not;
        List pairs = rFinder.keywordPairs(open, close);
        boolean _isEmpty = pairs.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Pair brackets = (Pair)pairs.get(0);
            document.prepend((ISemanticRegion)brackets.getKey(), oneSpace);
            document.prepend((ISemanticRegion)brackets.getValue(), newLine);
            document.interior(brackets, indent);
        }
    }

    protected void _format(UMLTask task, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)task);
        document.format((Object)task.getSource());
        document.surround(rFinder.keyword(this._projectGrammarAccess.getUMLTaskAccess().getForKeyword_1()), oneSpaceWrap);
    }

    protected void _format(TypeMappings typeMappings, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)typeMappings);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getTypeMappingsAccess().getLeftCurlyBracketKeyword_1(), this._projectGrammarAccess.getTypeMappingsAccess().getRightCurlyBracketKeyword_4(), document);
        EList<TypeMapping> _commonMappings = typeMappings.getCommonMappings();
        for (TypeMapping mapping : _commonMappings) {
            document.prepend((EObject)mapping, newLine);
            document.format((Object)mapping);
        }
        EList<InterfaceMappings> _interfaceMappings = typeMappings.getInterfaceMappings();
        for (InterfaceMappings mapping_1 : _interfaceMappings) {
            document.prepend((EObject)mapping_1, emptyLine);
            document.format((Object)mapping_1);
        }
    }

    protected void _format(InterfaceMappings typeMappings, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)typeMappings);
        document.prepend((EObject)typeMappings, emptyLine);
        document.append(rFinder.keyword(this._projectGrammarAccess.getInterfaceMappingsAccess().getInterfaceKeyword_0()), oneSpace);
        this.formatSimpleBrackets(rFinder, this._projectGrammarAccess.getInterfaceMappingsAccess().getLeftCurlyBracketKeyword_2(), this._projectGrammarAccess.getInterfaceMappingsAccess().getRightCurlyBracketKeyword_4(), document);
        EList<TypeMapping> _mappings = typeMappings.getMappings();
        for (TypeMapping mapping : _mappings) {
            document.prepend((EObject)mapping, newLine);
            document.format((Object)mapping);
        }
    }

    protected void _format(TypeMapping mapping, @Extension IFormattableDocument document) {
        document.surround(this.textRegionExtensions.regionFor((EObject)mapping).keyword(this._projectGrammarAccess.getTypeMappingAccess().getHyphenMinusGreaterThanSignKeyword_1()), oneSpace);
    }

    public void format(Object block, IFormattableDocument document) {
        if (block instanceof XtextResource) {
            this._format((XtextResource)block, document);
            return;
        }
        if (block instanceof CompoundInterfaceBlock) {
            this._format((CompoundInterfaceBlock)block, document);
            return;
        }
        if (block instanceof DocumentationGenerationBlock) {
            this._format((DocumentationGenerationBlock)block, document);
            return;
        }
        if (block instanceof DocumentationGenerationTask) {
            this._format((DocumentationGenerationTask)block, document);
            return;
        }
        if (block instanceof InterfaceReference) {
            this._format((InterfaceReference)block, document);
            return;
        }
        if (block instanceof ModelQualityChecksGenerationBlock) {
            this._format((ModelQualityChecksGenerationBlock)block, document);
            return;
        }
        if (block instanceof ModelQualityChecksGenerationTask) {
            this._format((ModelQualityChecksGenerationTask)block, document);
            return;
        }
        if (block instanceof MonitoringBlock) {
            this._format((MonitoringBlock)block, document);
            return;
        }
        if (block instanceof MonitoringTask) {
            this._format((MonitoringTask)block, document);
            return;
        }
        if (block instanceof ProjectDescription) {
            this._format((ProjectDescription)block, document);
            return;
        }
        if (block instanceof ReachabilityGraphGenerationBlock) {
            this._format((ReachabilityGraphGenerationBlock)block, document);
            return;
        }
        if (block instanceof ReachabilityGraphGenerationTask) {
            this._format((ReachabilityGraphGenerationTask)block, document);
            return;
        }
        if (block instanceof SimulatorGenerationBlock) {
            this._format((SimulatorGenerationBlock)block, document);
            return;
        }
        if (block instanceof SimulatorGenerationTask) {
            this._format((SimulatorGenerationTask)block, document);
            return;
        }
        if (block instanceof TestCasesGenerationBlock) {
            this._format((TestCasesGenerationBlock)block, document);
            return;
        }
        if (block instanceof TestCasesGenerationTask) {
            this._format((TestCasesGenerationTask)block, document);
            return;
        }
        if (block instanceof TestClientGenerationBlock) {
            this._format((TestClientGenerationBlock)block, document);
            return;
        }
        if (block instanceof TestClientGenerationTask) {
            this._format((TestClientGenerationTask)block, document);
            return;
        }
        if (block instanceof TypeMappingsBlock) {
            this._format((TypeMappingsBlock)block, document);
            return;
        }
        if (block instanceof UMLBlock) {
            this._format((UMLBlock)block, document);
            return;
        }
        if (block instanceof UMLTask) {
            this._format((UMLTask)block, document);
            return;
        }
        if (block instanceof CompoundInterface) {
            this._format((CompoundInterface)block, document);
            return;
        }
        if (block instanceof InterfaceMappings) {
            this._format((InterfaceMappings)block, document);
            return;
        }
        if (block instanceof Policy) {
            this._format((Policy)block, document);
            return;
        }
        if (block instanceof Project) {
            this._format((Project)block, document);
            return;
        }
        if (block instanceof ResetCommand) {
            this._format((ResetCommand)block, document);
            return;
        }
        if (block instanceof TypeMapping) {
            this._format((TypeMapping)block, document);
            return;
        }
        if (block instanceof TypeMappings) {
            this._format((TypeMappings)block, document);
            return;
        }
        if (block instanceof Import) {
            this._format((Import)block, document);
            return;
        }
        if (block instanceof EObject) {
            this._format((EObject)block, document);
            return;
        }
        if (block == null) {
            this._format(null, document);
            return;
        }
        if (block != null) {
            this._format(block, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(block, document).toString());
    }
}

