/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.reachabilitygraph;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.reachabilitygraph.BuilderDebugLog;
import org.eclipse.comma.reachabilitygraph.Edge;
import org.eclipse.comma.reachabilitygraph.GsonHelper;
import org.eclipse.comma.reachabilitygraph.Node;
import org.eclipse.comma.reachabilitygraph.ReachabilityGraphBuilder;
import org.eclipse.xtext.scoping.IScopeProvider;

public class ReachabilityGraph {
    public BuilderDebugLog builderDebugLog;
    public final List<Edge> edges = new ArrayList<Edge>();
    public final LinkedHashMap<String, Node> nodes = new LinkedHashMap();
    Node initial;
    int maxDepth;
    int depth;
    int totalStates;
    int coveredStates;
    int totalClauses;
    int coveredClauses;

    ReachabilityGraph() {
    }

    public Node getOrCreateNode(String name, String state, String trigger) {
        Node node = this.getNode(name);
        if (node == null) {
            node = this.createNode(name, state, trigger);
        }
        return node;
    }

    public Edge createEdge(Node source, Node target) {
        Edge edge = new Edge(source, target);
        this.edges.add(edge);
        return edge;
    }

    public Optional<Edge> getEdge(Node source, Node target) {
        return this.edges.stream().filter(e -> e.source == source && e.target == target).findFirst();
    }

    public Node createNode(String name, String state, String trigger) {
        if (this.hasNode(name)) {
            throw new RuntimeException(String.format("Node with name \"%s\" already exists", name));
        }
        Node node = new Node(name, state, trigger);
        this.nodes.put(name, node);
        return node;
    }

    public boolean hasNode(String name) {
        return this.nodes.containsKey(name);
    }

    public Node getNode(String name) {
        return this.nodes.get(name);
    }

    public String toHTML() {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("reachability_graph.html");
        String html = ((Stream)new BufferedReader(new InputStreamReader(in)).lines().parallel()).collect(Collectors.joining("\n"));
        html = html.replace("\"%JSON_REACHABILITY_GRAPH%\"", this.toJSON(false));
        return html;
    }

    public String toJSON(boolean pretty) {
        return GsonHelper.toJSON(this, pretty);
    }

    public static ReachabilityGraph fromInterface(Interface itf, int maxDepth, List<Parameters> parametersInputSpecification) {
        ReachabilityGraphBuilder builder = new ReachabilityGraphBuilder(itf, maxDepth, parametersInputSpecification);
        return builder.build();
    }

    public static ReachabilityGraph fromComponent(Component component, int maxDepth, List<Parameters> parametersInputSpecifications, IScopeProvider scopeProvider, List<EConnection> connections) {
        if (connections == null) {
            connections = new ArrayList<EConnection>();
            for (Port port : component.getPorts()) {
                if (!(port instanceof ProvidedPort)) continue;
                connections.add(new EConnection(port.getName(), "id1"));
            }
        }
        ReachabilityGraphBuilder builder = new ReachabilityGraphBuilder(component, maxDepth, parametersInputSpecifications, scopeProvider, connections);
        return builder.build();
    }

    public static ReachabilityGraph fromJSON(String json) {
        return GsonHelper.fromJSON(json);
    }

    public static String fsaOutputDirectory(String name) {
        return "reachabilityGraph/" + name;
    }

    public static String fsaOutputPath(String name) {
        return String.valueOf(ReachabilityGraph.fsaOutputDirectory(name)) + "/reachability_graph.json";
    }
}

