/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.MutableObjectIntMapFactory;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.impl.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableObjectIntMapFactoryImpl implements MutableObjectIntMapFactory
{
    INSTANCE;


    @Override
    public <K> MutableObjectIntMap<K> empty() {
        return new ObjectIntHashMap(0);
    }

    @Override
    public <K> MutableObjectIntMap<K> of() {
        return this.empty();
    }

    @Override
    public <K> MutableObjectIntMap<K> with() {
        return this.empty();
    }

    @Override
    public <K> MutableObjectIntMap<K> ofAll(ObjectIntMap<? extends K> map) {
        return this.withAll(map);
    }

    @Override
    public <K> MutableObjectIntMap<K> withAll(ObjectIntMap<? extends K> map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new ObjectIntHashMap<K>(map);
    }

    @Override
    public <T, K> MutableObjectIntMap<K> from(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, IntFunction<? super T> valueFunction) {
        MutableObjectIntMap map = ObjectIntMaps.mutable.empty();
        Iterate.forEach(iterable, each -> map.put(keyFunction.valueOf(each), valueFunction.intValueOf(each)));
        return map;
    }
}

