/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.views.PlantUmlView;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.ConnectionQuery;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.IArtifactUnpacker;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.helpers.SelectionSupportHelper;
import org.eclipse.capra.ui.plantuml.VisualizationHelper;
import org.eclipse.capra.ui.plantuml.handlers.DisplayInternalLinksHandler;
import org.eclipse.capra.ui.plantuml.handlers.ReverseLinkDirectionHandler;
import org.eclipse.capra.ui.plantuml.handlers.SelectRelationshipTypesHandler;
import org.eclipse.capra.ui.plantuml.handlers.ToggleDisplayGraphHandler;
import org.eclipse.capra.ui.plantuml.handlers.ToggleTransitivityHandler;
import org.eclipse.capra.ui.plantuml.handlers.TransitivityDepthHandler;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class CapraDiagramTextProvider
implements DiagramTextProvider {
    private EObject artifactModel = null;
    private String currentDiagramText = null;

    private boolean isLockDiagram() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.plantuml.lockDiagram");
        return preferences.node("lockDiagram").getBoolean("option", false);
    }

    public String getDiagramText(IEditorPart editor, ISelection input) {
        return this.getDiagramText((IWorkbenchPart)editor);
    }

    public String getDiagramText(IViewPart view, ISelection input) {
        return this.getDiagramText((IWorkbenchPart)view);
    }

    public String getDiagramText(IWorkbenchPart part) {
        ArrayList<Object> selectedModels = new ArrayList<Object>();
        if (part.getSite().getSelectionProvider() != null) {
            selectedModels.addAll(SelectionSupportHelper.extractSelectedElements((ISelection)part.getSite().getSelectionProvider().getSelection(), (IWorkbenchPart)part));
        }
        return this.getDiagramText(selectedModels, Optional.of(part));
    }

    public String getDiagramText(List<Object> selectedModels, Optional<IWorkbenchPart> part) {
        if (this.isLockDiagram()) {
            return this.currentDiagramText;
        }
        if (selectedModels == null || selectedModels.isEmpty() && this.currentDiagramText == null) {
            this.currentDiagramText = VisualizationHelper.createMatrix(null, this.artifactModel, null, null, true);
            return this.currentDiagramText;
        }
        if (selectedModels == null || selectedModels.isEmpty()) {
            return this.currentDiagramText;
        }
        ArrayList<Connection> traces = new ArrayList<Connection>();
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        EObject traceModel = null;
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        ITraceabilityInformationModelAdapter metamodelAdapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().orElseThrow();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        this.artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        if (!selectedModels.isEmpty()) {
            EObject selectedObject;
            ArtifactHelper artifactHelper = new ArtifactHelper(this.artifactModel);
            selectedModels.stream().forEach(obj -> {
                IArtifactHandler handler = artifactHelper.getHandler(obj).orElse(null);
                if (handler != null) {
                    Object unpackedElement = null;
                    unpackedElement = handler instanceof IArtifactUnpacker ? ((IArtifactUnpacker)IArtifactUnpacker.class.cast(handler)).unpack(obj) : obj;
                    if (ToggleTransitivityHandler.isTraceViewTransitive()) {
                        selectedEObjects.addAll(EMFHelper.linearize((Object)handler.createWrapper(unpackedElement, this.artifactModel)));
                    } else {
                        selectedEObjects.add(handler.createWrapper(unpackedElement, this.artifactModel));
                    }
                }
            });
            EObject eObject = selectedObject = !selectedEObjects.isEmpty() ? (EObject)selectedEObjects.get(0) : null;
            if (selectedObject != null && selectedObject.eResource() != null) {
                traceModel = persistenceAdapter.getTraceModel(resourceSet);
                List<String> selectedRelationshipTypes = SelectRelationshipTypesHandler.getSelectedRelationshipTypes();
                for (EObject obj2 : selectedEObjects) {
                    traces.addAll(this.getViewableTraceLinks(obj2, traceModel, metamodelAdapter, selectedRelationshipTypes));
                }
                if (selectedModels.size() == 1) {
                    this.currentDiagramText = VisualizationHelper.createNeighboursView(traces, EMFHelper.linearize((Object)selectedObject), this.artifactModel);
                    return this.currentDiagramText;
                }
                if (ToggleDisplayGraphHandler.isDisplayGraph()) {
                    this.currentDiagramText = this.renderMultiSelectionGraph(traces, selectedEObjects, artifactHelper);
                    return this.currentDiagramText;
                }
            }
        }
        this.currentDiagramText = VisualizationHelper.createMatrix(traceModel, this.artifactModel, selectedEObjects, selectedEObjects, DisplayInternalLinksHandler.areInternalLinksShown());
        return this.currentDiagramText;
    }

    protected String renderMultiSelectionGraph(List<Connection> traces, List<EObject> selectedEObjects, ArtifactHelper artifactHelper) {
        ArrayList<Connection> relevantTraces = new ArrayList<Connection>();
        ArrayList<EObject> wrappers = new ArrayList<EObject>();
        for (Connection connection : traces) {
            if (!selectedEObjects.containsAll(connection.getOrigins())) continue;
            if (!selectedEObjects.stream().anyMatch(connection.getTargets()::contains)) continue;
            Connection newConnection = new Connection(connection.getOrigins(), connection.getTargets().stream().filter(selectedEObjects::contains).collect(Collectors.toList()), connection.getTlink());
            relevantTraces.add(newConnection);
            connection.getOrigins().stream().filter(selectedEObjects::contains).forEach(o -> {
                IArtifactHandler originHandler = (IArtifactHandler)artifactHelper.getHandler(o).orElseThrow();
                wrappers.add(originHandler.createWrapper(o, this.artifactModel));
            });
            connection.getTargets().stream().filter(selectedEObjects::contains).forEach(t -> {
                IArtifactHandler targetHandler = (IArtifactHandler)artifactHelper.getHandler(t).orElseThrow();
                wrappers.add(targetHandler.createWrapper(t, this.artifactModel));
            });
        }
        return VisualizationHelper.createNeighboursView(relevantTraces, wrappers, this.artifactModel);
    }

    protected List<Connection> getViewableTraceLinks(EObject selectedObject, EObject traceModel, ITraceabilityInformationModelAdapter metamodelAdapter, List<String> selectedRelationshipTypes) {
        ConnectionQuery query = ConnectionQuery.of((EObject)traceModel, (EObject)selectedObject).setReverseDirection(ReverseLinkDirectionHandler.isReverseLinkDirection()).setSelectedRelationshipTypes(selectedRelationshipTypes).setTraverseTransitiveLinks(ToggleTransitivityHandler.isTraceViewTransitive()).setTransitivityDepth(Integer.parseInt(TransitivityDepthHandler.getTransitivityDepth())).setIncludeInternalLinks(DisplayInternalLinksHandler.areInternalLinksShown()).build();
        List traces = metamodelAdapter.getConnections(query);
        this.updateSelectableRelationshipTypes(selectedObject, traces);
        return traces;
    }

    private void updateSelectableRelationshipTypes(EObject selectedObject, List<Connection> traces) {
        String currentElementName;
        String previousElementName;
        List<EObject> links = CapraDiagramTextProvider.extractLinksFromTraces(traces);
        EObject previousElement = SelectRelationshipTypesHandler.getCurrentElement();
        if (previousElement != null && !(previousElementName = EMFHelper.getNameAttribute((EObject)previousElement)).equals(currentElementName = EMFHelper.getNameAttribute((EObject)selectedObject))) {
            SelectRelationshipTypesHandler.clearPossibleRelationsForSelection();
            SelectRelationshipTypesHandler.emptySelectedRelationshipTypes();
        }
        SelectRelationshipTypesHandler.setCurrentElement(selectedObject);
        SelectRelationshipTypesHandler.addToPossibleRelationsForSelection(links);
    }

    public boolean supportsEditor(IEditorPart editor) {
        return !this.isLockDiagram();
    }

    public boolean supportsView(IViewPart part) {
        if (this.isLockDiagram()) {
            return false;
        }
        return !(part instanceof PlantUmlView);
    }

    public boolean supportsSelection(ISelection selection) {
        return !this.isLockDiagram();
    }

    private static List<EObject> extractLinksFromTraces(List<Connection> traces) {
        ArrayList<EObject> links = new ArrayList<EObject>();
        for (Connection trace : traces) {
            if (links.contains(trace.getTlink())) continue;
            links.add(trace.getTlink());
        }
        return links;
    }
}

