/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.asciidoc.internal;

import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.outline.ItemType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import org.eclipse.capra.core.helpers.ArtifactStatus;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.asciidoc.AsciiDocArtifact;
import org.eclipse.capra.ui.asciidoc.IAsciiDocApiAccess;
import org.eclipse.core.runtime.FileLocator;

public class AsciiDocArtifactExistenceChecker {
    private static final String ASCII_DOCTOR_API_ACCESS_ID = "org.eclipse.capra.ui.asciidoctor.apiaccess";
    private static final String ASCII_DOCTOR_API_ACCESS_CONFIG = "class";

    public static ArtifactStatus getAsciiDocArtifactStatus(AsciiDocArtifact artifact) {
        ArtifactStatus artifactStatus = new ArtifactStatus(ArtifactStatus.Status.UNKNOWN);
        try {
            URL asciiDocUrl = FileLocator.toFileURL((URL)URI.create(artifact.getUri()).toURL());
            URLConnection urlConnection = asciiDocUrl.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            String asciiDocText = AsciiDocArtifactExistenceChecker.readFromInputStream(inputStream);
            Optional<IAsciiDocApiAccess> asciiDocApiAccessOpt = AsciiDocArtifactExistenceChecker.getAsciiDoctorAccess();
            if (asciiDocApiAccessOpt.isPresent()) {
                IAsciiDocApiAccess apiAccess = asciiDocApiAccessOpt.get();
                Item item = null;
                item = artifact.getItem().getItemType() == ItemType.INLINE_ANCHOR ? apiAccess.getItemById(artifact.getItem().getId(), asciiDocText) : apiAccess.getItemFromAsciiDocText(artifact.getItem().getOffset(), asciiDocText);
                artifactStatus = item == null ? new ArtifactStatus(ArtifactStatus.Status.REMOVED) : (!item.getName().equals(artifact.getItem().getName()) ? new ArtifactStatus(ArtifactStatus.Status.RENAMED, artifact.getItem().getName(), item.getName()) : new ArtifactStatus(ArtifactStatus.Status.NORMAL));
            }
        }
        catch (IOException e) {
            artifactStatus = new ArtifactStatus(ArtifactStatus.Status.REMOVED);
        }
        return artifactStatus;
    }

    private static Optional<IAsciiDocApiAccess> getAsciiDoctorAccess() {
        try {
            Object extension = ExtensionPointHelper.getExtensions((String)ASCII_DOCTOR_API_ACCESS_ID, (String)ASCII_DOCTOR_API_ACCESS_CONFIG).get(0);
            return Optional.of((IAsciiDocApiAccess)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder resultStringBuilder = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return resultStringBuilder.toString();
    }
}

